/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.event.module.ModuleRegisterEvent;
import com.ghostchu.peerbanhelper.event.module.ModuleUnregisterEvent;
import com.ghostchu.peerbanhelper.module.FeatureModule;
import com.ghostchu.peerbanhelper.module.ModuleManager;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public final class ModuleManagerImpl
implements ModuleManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModuleManagerImpl.class);
    private final List<FeatureModule> modules = new ArrayList<FeatureModule>();
    @Autowired
    private ApplicationContext context;

    @Override
    public void register(@NotNull Class<? extends FeatureModule> moduleClass) {
        FeatureModule module = (FeatureModule)this.context.getBean(moduleClass);
        this.attemptRegister(module);
    }

    @Override
    public void register(@NotNull FeatureModule module, String beanName) {
        this.attemptRegister(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptRegister(FeatureModule module) {
        List<FeatureModule> list = this.modules;
        synchronized (list) {
            if (!this.modules.contains(module)) {
                this.modules.add(module);
            }
            if (module.isModuleEnabled()) {
                ModuleRegisterEvent moduleRegisterEvent = new ModuleRegisterEvent(module);
                Main.getEventBus().post((Object)moduleRegisterEvent);
                if (moduleRegisterEvent.isCancelled()) {
                    log.debug("Module {} registration cancelled: {}", (Object)module.getName(), (Object)moduleRegisterEvent.getCancelReason());
                    return;
                }
                module.enable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(@NotNull FeatureModule module) {
        List<FeatureModule> list = this.modules;
        synchronized (list) {
            ModuleUnregisterEvent moduleUnregisterEvent = new ModuleUnregisterEvent(module);
            Main.getEventBus().post((Object)moduleUnregisterEvent);
            module.disable();
            return this.modules.remove(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(@NotNull Class<FeatureModule> module) {
        List<FeatureModule> list = this.modules;
        synchronized (list) {
            ArrayList<FeatureModule> moduleList = new ArrayList<FeatureModule>();
            for (FeatureModule featureModule : this.modules) {
                if (!featureModule.getClass().equals(module)) continue;
                moduleList.add(featureModule);
            }
            moduleList.forEach(unregisteringModule -> {
                ModuleUnregisterEvent moduleUnregisterEvent = new ModuleUnregisterEvent((FeatureModule)unregisteringModule);
                Main.getEventBus().post((Object)moduleUnregisterEvent);
                this.unregister((FeatureModule)unregisteringModule);
            });
        }
    }

    @Override
    public void unregisterAll() {
        List.copyOf(this.modules).forEach(unregisteringModule -> {
            ModuleUnregisterEvent moduleUnregisterEvent = new ModuleUnregisterEvent((FeatureModule)unregisteringModule);
            Main.getEventBus().post((Object)moduleUnregisterEvent);
            this.unregister((FeatureModule)unregisteringModule);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<FeatureModule> getModules() {
        List<FeatureModule> list = this.modules;
        synchronized (list) {
            return this.modules.stream().filter(FeatureModule::isActuallyEnabled).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadModuleStates() {
        ArrayList<FeatureModule> modulesCopy;
        log.info("Reloading module states based on configuration...");
        List<FeatureModule> list = this.modules;
        synchronized (list) {
            modulesCopy = new ArrayList<FeatureModule>(this.modules);
        }
        for (FeatureModule module : modulesCopy) {
            boolean shouldBeEnabled = module.isModuleEnabled();
            boolean isCurrentlyEnabled = module.isActuallyEnabled();
            if (shouldBeEnabled && !isCurrentlyEnabled) {
                log.info("Enabling module {} due to configuration change", (Object)module.getName());
                ModuleRegisterEvent moduleRegisterEvent = new ModuleRegisterEvent(module);
                Main.getEventBus().post((Object)moduleRegisterEvent);
                if (moduleRegisterEvent.isCancelled()) {
                    log.debug("Module {} registration cancelled: {}", (Object)module.getName(), (Object)moduleRegisterEvent.getCancelReason());
                    continue;
                }
                module.enable();
                continue;
            }
            if (shouldBeEnabled || !isCurrentlyEnabled) continue;
            log.info("Disabling module {} due to configuration change", (Object)module.getName());
            ModuleUnregisterEvent moduleUnregisterEvent = new ModuleUnregisterEvent(module);
            Main.getEventBus().post((Object)moduleUnregisterEvent);
            module.disable();
        }
        log.info("Module states reloaded successfully");
    }

    @Override
    public void loadPlugin() {
    }
}

