/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.rule.Rule;
import com.ghostchu.peerbanhelper.util.rule.RuleMatchResult;
import com.ghostchu.peerbanhelper.util.rule.RuleParser;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ClientNameBlacklist
extends AbstractRuleFeatureModule
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientNameBlacklist.class);
    private List<Rule> bannedPeers;
    @Autowired
    private JavalinWebContainer webContainer;
    private long banDuration;

    @Override
    @NotNull
    public String getName() {
        return "ClientName Blacklist";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "client-name-blacklist";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        this.webContainer.javalin().get("/api/modules/" + this.getConfigName(), this::handleWebAPI, new RouteRole[]{Role.USER_READ});
        Main.getReloadManager().register((Reloadable)this);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    private void handleWebAPI(Context ctx) {
        String locale = this.locale(ctx);
        ctx.json((Object)new StdResp(true, null, Map.of("clientName", this.bannedPeers.stream().map(r -> r.toPrintableText(locale)).toList())));
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void reloadConfig() {
        this.bannedPeers = RuleParser.parse(this.getConfig().getStringList("banned-client-name"));
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.getCache().invalidateAll();
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        if (this.isHandShaking(peer) && (peer.getClientName() == null || peer.getClientName().isBlank())) {
            return this.handshaking();
        }
        RuleMatchResult matchResult = RuleParser.matchRule(this.bannedPeers, peer.getClientName());
        if (matchResult.hit()) {
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, matchResult.rule().matcherName(), new TranslationComponent(Lang.MODULE_CNB_MATCH_CLIENT_NAME, matchResult.comment()), StructuredData.create().add("rule", matchResult.rule().metadata()));
        }
        return this.pass();
    }

    @Generated
    public List<Rule> getBannedPeers() {
        return this.bannedPeers;
    }

    @Generated
    public JavalinWebContainer getWebContainer() {
        return this.webContainer;
    }

    @Generated
    public long getBanDuration() {
        return this.banDuration;
    }
}

