/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.module.AbstractWebSocketFeatureModule;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.asynctask.AsyncTask;
import com.ghostchu.peerbanhelper.util.asynctask.AsyncTaskLoggerListener;
import com.ghostchu.peerbanhelper.util.asynctask.AsyncTaskManager;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.web.wrapper.StdWsAction;
import com.ghostchu.peerbanhelper.web.wrapper.StdWsAlertDTO;
import com.ghostchu.peerbanhelper.web.wrapper.StdWsMessage;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import io.javalin.websocket.WsCloseStatus;
import io.javalin.websocket.WsConfig;
import io.javalin.websocket.WsContext;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.event.Level;
import org.springframework.stereotype.Component;

@Component
public class PBHAsyncTaskController
extends AbstractWebSocketFeatureModule {
    private final JavalinWebContainer javalinWebContainer;

    public PBHAsyncTaskController(JavalinWebContainer javalinWebContainer) {
        this.javalinWebContainer = javalinWebContainer;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - BgTask Controller";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-bgtask";
    }

    @Override
    public void onEnable() {
        ((Javalin)this.javalinWebContainer.javalin().get("/api/asyncTask/list", this::handleTaskLists, new RouteRole[]{Role.USER_READ})).ws("/api/asyncTask/{taskId}/stream", this::handleStream, new RouteRole[]{Role.USER_READ});
        Main.getEventBus().register((Object)this);
    }

    private void handleStream(WsConfig wsConfig) {
        this.acceptWebSocket(wsConfig, ctx -> {
            String taskId = ctx.pathParam("taskId");
            AsyncTask task = AsyncTaskManager.getTaskById(taskId);
            if (task == null) {
                ctx.send((Object)new StdWsMessage(false, StdWsAction.ALERT, new StdWsAlertDTO(Level.ERROR, TextManager.tlUI(Lang.BGTASK_WEBSOCKET_TASK_NOT_FOUND, new Object[0]))));
                return;
            }
            task.getLogs().forEach(log -> ctx.send((Object)new StdWsMessage(true, StdWsAction.BUSINESS, log)));
            task.addLoggerListener(new AsyncTaskLoggerListener(){
                final /* synthetic */ WsContext val$ctx;
                {
                    this.val$ctx = wsContext;
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void onLog(AsyncTask task, String log) {
                    this.val$ctx.send((Object)new StdWsMessage(true, StdWsAction.BUSINESS, log));
                }

                @Override
                public void onTaskClose(AsyncTask task) {
                    this.val$ctx.closeSession(WsCloseStatus.NORMAL_CLOSURE);
                }
            });
            if (task.isClosed()) {
                ctx.closeSession(WsCloseStatus.NORMAL_CLOSURE);
            }
        });
    }

    private void handleTaskLists(@NotNull Context context) {
        context.json((Object)new StdResp(true, null, AsyncTaskManager.getTasks().stream().map(bgTask -> new BgTaskDTO(bgTask.getTaskId(), TextManager.tl(this.locale(context), bgTask.getTitle()), TextManager.tl(this.locale(context), bgTask.getDescription()), bgTask.getProgress())).toList()));
    }

    @Override
    public void onDisable() {
    }

    @NotNull
    public static class BgTaskDTO {
        private String taskId;
        private String taskTitle;
        private String taskDescription;
        private double taskProgress;

        @Generated
        public BgTaskDTO(String taskId, String taskTitle, String taskDescription, double taskProgress) {
            this.taskId = taskId;
            this.taskTitle = taskTitle;
            this.taskDescription = taskDescription;
            this.taskProgress = taskProgress;
        }

        @Generated
        public String getTaskId() {
            return this.taskId;
        }

        @Generated
        public String getTaskTitle() {
            return this.taskTitle;
        }

        @Generated
        public String getTaskDescription() {
            return this.taskDescription;
        }

        @Generated
        public double getTaskProgress() {
            return this.taskProgress;
        }

        @Generated
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Generated
        public void setTaskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
        }

        @Generated
        public void setTaskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
        }

        @Generated
        public void setTaskProgress(double taskProgress) {
            this.taskProgress = taskProgress;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BgTaskDTO)) {
                return false;
            }
            BgTaskDTO other = (BgTaskDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getTaskProgress(), other.getTaskProgress()) != 0) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
                return false;
            }
            String this$taskTitle = this.getTaskTitle();
            String other$taskTitle = other.getTaskTitle();
            if (this$taskTitle == null ? other$taskTitle != null : !this$taskTitle.equals(other$taskTitle)) {
                return false;
            }
            String this$taskDescription = this.getTaskDescription();
            String other$taskDescription = other.getTaskDescription();
            return !(this$taskDescription == null ? other$taskDescription != null : !this$taskDescription.equals(other$taskDescription));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BgTaskDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $taskProgress = Double.doubleToLongBits(this.getTaskProgress());
            result = result * 59 + (int)($taskProgress >>> 32 ^ $taskProgress);
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            String $taskTitle = this.getTaskTitle();
            result = result * 59 + ($taskTitle == null ? 43 : $taskTitle.hashCode());
            String $taskDescription = this.getTaskDescription();
            result = result * 59 + ($taskDescription == null ? 43 : $taskDescription.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PBHAsyncTaskController.BgTaskDTO(taskId=" + this.getTaskId() + ", taskTitle=" + this.getTaskTitle() + ", taskDescription=" + this.getTaskDescription() + ", taskProgress=" + this.getTaskProgress() + ")";
        }
    }
}

