/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.asynctask.wrap;

import com.ghostchu.peerbanhelper.util.asynctask.AsyncTask;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

public class AsyncTaskWrappedSpliterator<T>
implements Spliterator<T>,
AutoCloseable {
    private final Spliterator<T> underlying;
    private final AsyncTask asyncTask;
    private final Set<Spliterator<T>> openChildren;

    public AsyncTaskWrappedSpliterator(Spliterator<T> underlying, AsyncTask asyncTask) {
        this(underlying, asyncTask, Collections.synchronizedSet(new HashSet()));
    }

    private AsyncTaskWrappedSpliterator(Spliterator<T> underlying, AsyncTask asyncTask, Set<Spliterator<T>> openChildren) {
        this.underlying = underlying;
        this.asyncTask = asyncTask;
        this.openChildren = openChildren;
        this.openChildren.add(this);
    }

    public AsyncTask getBgTask() {
        return this.asyncTask;
    }

    @Override
    public void close() {
        this.asyncTask.close();
    }

    private void registerChild(Spliterator<T> child) {
        this.openChildren.add(child);
    }

    private void removeThis() {
        this.openChildren.remove(this);
        if (this.openChildren.isEmpty()) {
            this.close();
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean r = this.underlying.tryAdvance(action);
        if (r) {
            this.asyncTask.increment();
        } else {
            this.removeThis();
        }
        return r;
    }

    @Override
    public Spliterator<T> trySplit() {
        Spliterator<T> u = this.underlying.trySplit();
        if (u != null) {
            AsyncTaskWrappedSpliterator<T> child = new AsyncTaskWrappedSpliterator<T>(u, this.asyncTask, this.openChildren);
            this.registerChild(child);
            return child;
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.underlying.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.underlying.characteristics();
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.underlying.getComparator();
    }
}

