/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.btn.ping.legacy.LegacyBtnPeerHistory;
import com.ghostchu.peerbanhelper.btn.ping.legacy.LegacyBtnPeerHistoryPing;
import com.ghostchu.peerbanhelper.database.dao.impl.MetadataDao;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilitySubmitHistory
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilitySubmitHistory.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final String endpoint;
    private final long randomInitialDelay;
    private final Lock lock = new ReentrantLock();
    private final boolean powCaptcha;
    private final MetadataDao metadataDao;

    public BtnAbilitySubmitHistory(BtnNetwork btnNetwork, MetadataDao metadataDao, JsonObject ability) {
        this.btnNetwork = btnNetwork;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
        this.powCaptcha = ability.has("pow_captcha") && ability.get("pow_captcha").getAsBoolean();
        this.metadataDao = metadataDao;
        if (metadataDao.get("btn.submithistory.timestamp") == null) {
            this.writeLastSubmitAtTimestamp(System.currentTimeMillis());
        }
    }

    private void writeLastSubmitAtTimestamp(long timestamp) {
        this.metadataDao.set("btn.submithistory.timestamp", String.valueOf(timestamp));
    }

    private long getLastSubmitAtTimestamp() {
        try {
            long time = Long.parseLong(this.metadataDao.getOrDefault("btn.submithistory.timestamp", "0"));
            if (time < System.currentTimeMillis() - 2592000000L) {
                return System.currentTimeMillis();
            }
            return time;
        }
        catch (Exception e) {
            log.error("Unable to read timestamp from file", (Throwable)e);
            this.writeLastSubmitAtTimestamp(System.currentTimeMillis());
            return System.currentTimeMillis();
        }
    }

    @Override
    public String getName() {
        return "BtnAbilitySubmitHistory (Legacy)";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_SUBMIT_HISTORY);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_ABILITY_SUBMIT_HISTORY_DESCRIPTION);
    }

    @Override
    public void load() {
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_NO_CONTENT_REPORTED_YET));
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::submit, ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void submit() {
        if (!this.lock.tryLock()) {
            return;
        }
        try {
            log.info(TextManager.tlUI(Lang.BTN_SUBMITTING_HISTORIES, new Object[0]));
            AtomicLong lastSubmitAt = new AtomicLong(this.getLastSubmitAtTimestamp());
            List<LegacyBtnPeerHistory> btnPeers = this.generatePing(lastSubmitAt.get());
            while (!btnPeers.isEmpty()) {
                LegacyBtnPeerHistoryPing ping = new LegacyBtnPeerHistoryPing(System.currentTimeMillis(), btnPeers);
                byte[] jsonBytes = JsonUtil.getGson().toJson((Object)ping).getBytes(StandardCharsets.UTF_8);
                RequestBody body = this.createGzipRequestBody(jsonBytes);
                Request.Builder request = new Request.Builder().url(this.endpoint).post(body).header("Content-Encoding", "gzip");
                if (this.powCaptcha) {
                    this.btnNetwork.gatherAndSolveCaptchaBlocking(request, "submit_history");
                }
                try {
                    Response response;
                    block23: {
                        response = this.btnNetwork.getHttpClient().newCall(request.build()).execute();
                        if (response.isSuccessful()) break block23;
                        String responseBody = response.body().string();
                        log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, response.code() + " - " + responseBody));
                        this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, response.code(), responseBody));
                        if (response == null) return;
                        response.close();
                        return;
                    }
                    try {
                        log.info(TextManager.tlUI(Lang.BTN_SUBMITTED_HISTORIES, ping.getPeers().size()));
                        this.setLastStatus(true, new TranslationComponent(Lang.BTN_REPORTED_DATA, ping.getPeers().size()));
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Exception e) {
                    log.warn(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, new Object[0]), (Throwable)e);
                    this.setLastStatus(false, new TranslationComponent(e.getClass().getName() + ": " + e.getMessage()));
                    this.lock.unlock();
                    return;
                }
                long lastRecordAt = btnPeers.getLast().getLastTimeSeen().getTime();
                if (lastRecordAt >= lastSubmitAt.get()) {
                    if (lastRecordAt == lastSubmitAt.get()) {
                        ++lastRecordAt;
                    }
                    lastSubmitAt.set(lastRecordAt);
                    this.writeLastSubmitAtTimestamp(lastRecordAt);
                } else {
                    lastSubmitAt.set(System.currentTimeMillis());
                    this.writeLastSubmitAtTimestamp(System.currentTimeMillis());
                }
                btnPeers = this.generatePing(lastSubmitAt.get());
            }
            return;
        }
        catch (Throwable e) {
            log.error("Unable to submit peer histories", e);
            this.setLastStatus(false, new TranslationComponent("Unknown Error: " + e.getClass().getName() + ": " + e.getMessage()));
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<LegacyBtnPeerHistory> generatePing(long lastSubmitAt) {
        Pageable pageable = new Pageable(0L, 5000L);
        return this.btnNetwork.getPeerRecordDao().getPendingSubmitPeerRecords(pageable, new Timestamp(lastSubmitAt)).getResults().stream().map(LegacyBtnPeerHistory::from).collect(Collectors.toList());
    }

    @Override
    public void unload() {
    }

    private RequestBody createGzipRequestBody(final byte[] data) {
        return new RequestBody(this){
            {
                Objects.requireNonNull(this$0);
            }

            public MediaType contentType() {
                return MediaType.get((String)"application/json");
            }

            public void writeTo(@NotNull BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                gzipSink.write(data);
                gzipSink.close();
            }
        };
    }
}

