/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.configuration.pf4j;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.pf4j.AbstractPluginManager;
import org.pf4j.CompoundPluginDescriptorFinder;
import org.pf4j.CompoundPluginLoader;
import org.pf4j.CompoundPluginRepository;
import org.pf4j.DefaultExtensionFactory;
import org.pf4j.DefaultExtensionFinder;
import org.pf4j.DefaultPluginFactory;
import org.pf4j.DefaultPluginLoader;
import org.pf4j.DefaultPluginRepository;
import org.pf4j.DefaultPluginStatusProvider;
import org.pf4j.DefaultVersionManager;
import org.pf4j.DevelopmentPluginLoader;
import org.pf4j.DevelopmentPluginRepository;
import org.pf4j.ExtensionFactory;
import org.pf4j.ExtensionFinder;
import org.pf4j.JarPluginLoader;
import org.pf4j.JarPluginRepository;
import org.pf4j.LoggingPluginStateListener;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginFactory;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.PluginRepository;
import org.pf4j.PluginStateListener;
import org.pf4j.PluginStatusProvider;
import org.pf4j.PluginWrapper;
import org.pf4j.PropertiesPluginDescriptorFinder;
import org.pf4j.VersionManager;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PBHPluginManager
extends AbstractPluginManager {
    private static final Logger log = LoggerFactory.getLogger(PBHPluginManager.class);
    public static final String PLUGINS_DIR_CONFIG_PROPERTY_NAME = "pf4j.pluginsConfigDir";

    public PBHPluginManager() {
    }

    public PBHPluginManager(Path ... pluginsRoots) {
        super(pluginsRoots);
    }

    public PBHPluginManager(List<Path> pluginsRoots) {
        super(pluginsRoots);
    }

    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        return new CompoundPluginDescriptorFinder().add((PluginDescriptorFinder)new PropertiesPluginDescriptorFinder()).add((PluginDescriptorFinder)new ManifestPluginDescriptorFinder());
    }

    protected ExtensionFinder createExtensionFinder() {
        DefaultExtensionFinder extensionFinder = new DefaultExtensionFinder((PluginManager)this);
        this.addPluginStateListener((PluginStateListener)extensionFinder);
        return extensionFinder;
    }

    protected PluginFactory createPluginFactory() {
        return new DefaultPluginFactory();
    }

    protected ExtensionFactory createExtensionFactory() {
        return new DefaultExtensionFactory();
    }

    protected PluginStatusProvider createPluginStatusProvider() {
        String configDir = System.getProperty(PLUGINS_DIR_CONFIG_PROPERTY_NAME);
        Path configPath = configDir != null ? Paths.get(configDir, new String[0]) : (Path)this.getPluginsRoots().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No pluginsRoot configured"));
        return new DefaultPluginStatusProvider(configPath);
    }

    protected PluginRepository createPluginRepository() {
        return new CompoundPluginRepository().add((PluginRepository)new DevelopmentPluginRepository(this.getPluginsRoots()), () -> ((PBHPluginManager)this).isDevelopment()).add((PluginRepository)new JarPluginRepository(this.getPluginsRoots()), () -> ((PBHPluginManager)this).isNotDevelopment()).add((PluginRepository)new DefaultPluginRepository(this.getPluginsRoots()), () -> ((PBHPluginManager)this).isNotDevelopment());
    }

    protected PluginLoader createPluginLoader() {
        return new CompoundPluginLoader().add((PluginLoader)new DevelopmentPluginLoader((PluginManager)this), () -> ((PBHPluginManager)this).isDevelopment()).add((PluginLoader)new JarPluginLoader((PluginManager)this), () -> ((PBHPluginManager)this).isNotDevelopment()).add((PluginLoader)new DefaultPluginLoader((PluginManager)this), () -> ((PBHPluginManager)this).isNotDevelopment());
    }

    protected VersionManager createVersionManager() {
        return new DefaultVersionManager();
    }

    protected void initialize() {
        super.initialize();
        if (this.isDevelopment()) {
            this.addPluginStateListener((PluginStateListener)new LoggingPluginStateListener());
        }
        log.info("PF4J version {} in '{}' mode", (Object)this.getVersion(), (Object)this.getRuntimeMode());
    }

    protected PluginWrapper loadPluginFromPath(Path pluginPath) {
        try {
            pluginPath = FileUtils.expandIfZip((Path)pluginPath);
        }
        catch (Exception e) {
            log.warn("Failed to unzip " + String.valueOf(pluginPath), (Throwable)e);
            return null;
        }
        return super.loadPluginFromPath(pluginPath);
    }
}

