/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.PeerBanHelper;
import com.ghostchu.peerbanhelper.module.FeatureModule;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.WebUtil;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import io.javalin.http.Context;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractFeatureModule
implements FeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractFeatureModule.class);
    private final ReentrantLock lock = new ReentrantLock();
    @Autowired
    private PeerBanHelper server;
    private boolean register;
    private boolean actuallyEnabled = false;
    @Autowired
    JavalinWebContainer javalinWebContainer;
    private final List<ScheduledFuture<?>> scheduledTasks = new ArrayList();

    @Override
    public boolean isModuleEnabled() {
        try {
            return !this.isConfigurable() || this.getConfig().getBoolean("enabled");
        }
        catch (Exception e) {
            log.warn(TextManager.tlUI(Lang.CONFIGURATION_OUTDATED_MODULE_DISABLED, this.getName()));
            return false;
        }
    }

    @Override
    public ReentrantLock getThreadLock() {
        return this.lock;
    }

    public abstract boolean isConfigurable();

    @Override
    public ConfigurationSection getConfig() {
        if (!this.isConfigurable()) {
            return null;
        }
        ConfigurationSection section = Objects.requireNonNull(Main.getProfileConfig().getConfigurationSection("module")).getConfigurationSection(this.getConfigName());
        if (section == null) {
            log.warn(TextManager.tlUI(Lang.CONFIGURATION_OUTDATED_MODULE_DISABLED, this.getName()));
            YamlConfiguration configuration = new YamlConfiguration();
            configuration.set("enabled", (Object)false);
            return configuration;
        }
        return section;
    }

    @Override
    public void disable() {
        if (this.register) {
            this.actuallyEnabled = false;
            this.onDisable();
            this.cancelAllScheduledTasks();
            Main.getEventBus().unregister((Object)this);
            log.info(TextManager.tlUI(Lang.MODULE_UNREGISTER, this.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScheduledFuture<?> registerScheduledTask(Runnable task, long initialDelay, long period, TimeUnit unit) {
        ScheduledFuture<?> future = CommonUtil.getScheduler().scheduleWithFixedDelay(task, initialDelay, period, unit);
        List<ScheduledFuture<?>> list = this.scheduledTasks;
        synchronized (list) {
            this.scheduledTasks.add(future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelScheduledTask(ScheduledFuture<?> future) {
        if (future != null && !future.isCancelled()) {
            boolean cancelled = future.cancel(false);
            List<ScheduledFuture<?>> list = this.scheduledTasks;
            synchronized (list) {
                this.scheduledTasks.remove(future);
            }
            return cancelled;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelAllScheduledTasks() {
        List<ScheduledFuture<?>> list = this.scheduledTasks;
        synchronized (list) {
            for (ScheduledFuture<?> task : this.scheduledTasks) {
                if (task == null || task.isCancelled()) continue;
                task.cancel(false);
            }
            this.scheduledTasks.clear();
        }
    }

    @Override
    public void enable() {
        this.register = true;
        this.actuallyEnabled = true;
        this.onEnable();
        log.info(TextManager.tlUI(Lang.MODULE_REGISTER, this.getName()));
    }

    @Override
    public void saveConfig() throws IOException {
        if (!this.isConfigurable()) {
            return;
        }
        Main.getProfileConfig().set("module." + this.getConfigName(), (Object)this.getConfig());
        Main.getProfileConfig().save(new File(Main.getConfigDirectory(), "profile.yml"));
    }

    public String locale(Context ctx) {
        return this.javalinWebContainer.reqLocale(ctx);
    }

    public TimeZone timezone(Context ctx) {
        TimeZone tz = TimeZone.getDefault();
        if (ctx.header("X-Timezone") != null) {
            tz = TimeZone.getTimeZone(ctx.header("X-Timezone"));
        }
        return tz;
    }

    public String userIp(Context context) {
        return WebUtil.userIp(context);
    }

    @Generated
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Generated
    public PeerBanHelper getServer() {
        return this.server;
    }

    @Generated
    public boolean isRegister() {
        return this.register;
    }

    @Override
    @Generated
    public boolean isActuallyEnabled() {
        return this.actuallyEnabled;
    }
}

