/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.rule.matcher;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.rule.AbstractJsonMatcher;
import com.ghostchu.peerbanhelper.util.rule.MatchResult;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.google.gson.JsonObject;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class StringRegexMatcher
extends AbstractJsonMatcher {
    private final Pattern rule;
    private MatchResult hit;
    private MatchResult miss;

    public StringRegexMatcher(JsonObject syntax) {
        super(syntax);
        this.rule = Pattern.compile(syntax.get("content").getAsString());
        this.hit = new MatchResult(MatchResultEnum.TRUE, new TranslationComponent(Lang.MATCH_STRING_REGEX, this.rule));
        this.miss = new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent(Lang.MATCH_STRING_REGEX, this.rule));
        if (syntax.has("hit")) {
            this.hit = new MatchResult(MatchResultEnum.valueOf(syntax.get("hit").getAsString()), new TranslationComponent(Lang.MATCH_STRING_REGEX, "Hit=" + this.rule.pattern()));
        }
        if (syntax.has("miss")) {
            this.miss = new MatchResult(MatchResultEnum.valueOf(syntax.get("miss").getAsString()), new TranslationComponent(Lang.MATCH_STRING_REGEX, "Miss=" + this.rule.pattern()));
        }
    }

    @Override
    @NotNull
    public MatchResult match0(@NotNull String content) {
        if (this.rule.matcher(content).matches()) {
            return this.hit;
        }
        return this.miss;
    }

    @Override
    public String matcherIdentifier() {
        return "peerbanhelper:stringregexmatcher";
    }

    @Override
    public TranslationComponent matcherName() {
        return new TranslationComponent(Lang.MATCH_STRING_REGEX, this.rule);
    }

    @Override
    public String metadata() {
        return this.rule.pattern();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringRegexMatcher)) {
            return false;
        }
        StringRegexMatcher other = (StringRegexMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Pattern this$rule = this.rule;
        Pattern other$rule = other.rule;
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        MatchResult this$hit = this.hit;
        MatchResult other$hit = other.hit;
        if (this$hit == null ? other$hit != null : !((Object)this$hit).equals(other$hit)) {
            return false;
        }
        MatchResult this$miss = this.miss;
        MatchResult other$miss = other.miss;
        return !(this$miss == null ? other$miss != null : !((Object)this$miss).equals(other$miss));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringRegexMatcher;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Pattern $rule = this.rule;
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        MatchResult $hit = this.hit;
        result = result * 59 + ($hit == null ? 43 : ((Object)$hit).hashCode());
        MatchResult $miss = this.miss;
        result = result * 59 + ($miss == null ? 43 : ((Object)$miss).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "StringRegexMatcher(super=" + super.toString() + ", rule=" + String.valueOf(this.rule) + ", hit=" + String.valueOf(this.hit) + ", miss=" + String.valueOf(this.miss) + ")";
    }
}

