export declare const hashCodeInit = 17;
export declare function hashString(str: string): number;
export declare function addHashCode(acc: number, h: number): number;
export declare function withDefault<T>(x: T | undefined, theDefault: T): T;
export declare function definedMap<T, U>(x: T | undefined, f: (x: T) => U): U | undefined;
export declare function definedMapWithDefault<T, U>(x: T | undefined, theDefault: U, f: (x: T) => U): U;
export declare function hasOwnProperty<T extends string>(obj: unknown, name: T): obj is {
    [P in T]: unknown;
};
export declare function iterableFind<T>(it: Iterable<T>, p: (v: T) => boolean): T | undefined;
export declare function iterableEvery<T>(it: Iterable<T>, p: (v: T) => boolean): boolean;
export declare function iterableSome<T>(it: Iterable<T>, p: (v: T) => boolean): boolean;
export declare function iterableFirst<T>(it: Iterable<T>): T | undefined;
export declare function iterableMax(it: Iterable<number>): number | undefined;
export declare function iterableMinBy<T>(it: Iterable<T>, key: (v: T) => number): T | undefined;
export declare function iterableReduce<R, V>(it: Iterable<V>, unit: R, reducer: (r: R, v: V) => R): R;
export declare function iterableEnumerate<T>(it: Iterable<T>): IterableIterator<[number, T]>;
export declare function iterableSkip<T>(it: Iterable<T>, n: number): IterableIterator<T>;
/** n === 1 will give the last element. */
export declare function arrayGetFromEnd<T>(arr: ReadonlyArray<T>, i: number): T | undefined;
export declare function arrayLast<T>(arr: ReadonlyArray<T>): T | undefined;
export declare function arrayPop<T>(arr: ReadonlyArray<T>): T[];
export declare function arrayIntercalate<T>(separator: T, items: Iterable<T>): T[];
export declare function arrayMapSync<T, U>(set: Iterable<T>, f: (v: T, i: number) => Promise<U>): Promise<U[]>;
export declare function arraySortByInto<T>(arr: T[], sortKey: (v: T) => number | string): T[];
export declare function toReadonlyArray<T>(it: Iterable<T>): ReadonlyArray<T>;
export declare function mapMap<K, V, W>(m: Iterable<[K, V]>, f: (v: V, k: K) => W): Map<K, W>;
export declare function mapFirst<K, V>(m: ReadonlyMap<K, V>): V | undefined;
export declare function mapContains<K, V>(m: ReadonlyMap<K, V>, valueToFind: V): boolean;
export declare function mapSome<K, V>(m: Iterable<[K, V]>, p: (v: V, k: K) => boolean): boolean;
export declare function mapMergeInto<K, V>(dest: Map<K, V>, src: Iterable<[K, V]>): Map<K, V>;
export declare function mapMerge<K, V>(ma: Iterable<[K, V]>, mb: Iterable<[K, V]>): Map<K, V>;
export declare function mapMergeWithInto<K, V>(ma: Map<K, V>, merger: (va: V, vb: V, k: K) => V, mb: Iterable<[K, V]>): Map<K, V>;
export declare function mapMergeWith<K, V>(ma: Iterable<[K, V]>, merger: (va: V, vb: V, k: K) => V, mb: Iterable<[K, V]>): Map<K, V>;
export declare function mapFilter<K, V>(m: Iterable<[K, V]>, p: (v: V, k: K) => boolean): Map<K, V>;
export declare function mapFilterMap<K, V, W>(m: Iterable<[K, V]>, f: (v: V, k: K) => W | undefined): Map<K, W>;
export declare function mapSortToArray<K, V>(m: Iterable<[K, V]>, sortKey: (v: V, k: K) => number | string): [K, V][];
export declare function mapSortBy<K, V>(m: Iterable<[K, V]>, sortKey: (v: V, k: K) => number | string): Map<K, V>;
export declare function mapSortByKey<K extends number | string, V>(m: Iterable<[K, V]>): Map<K, V>;
export declare function mapMapEntries<K, L, V, W>(m: Iterable<[K, V]>, f: (v: V, k: K) => [L, W]): Map<L, W>;
export declare function mapUpdateInto<K, V>(m: Map<K, V>, k: K, updater: (v: V | undefined) => V): Map<K, V>;
export declare function mapFromObject<V>(obj: {
    [k: string]: V;
}): Map<string, V>;
export declare function mapToObject<V>(m: Map<string, V>): {
    [k: string]: V;
};
export declare function mapFromIterable<K, V>(it: Iterable<K>, valueForKey: (k: K) => V): Map<K, V>;
export declare function mapFind<K, V>(it: Iterable<[K, V]>, p: (v: V, k: K) => boolean): V | undefined;
export declare function mapTranspose<K, V>(maps: ReadonlyMap<K, V>[]): Map<K, V[]>;
export declare function mapMapSync<K, V, W>(m: Iterable<[K, V]>, f: (v: V, k: K) => Promise<W>): Promise<Map<K, W>>;
export declare function setIsSuperset<T>(set: ReadonlySet<T>, subset: ReadonlySet<T>): boolean;
export declare function setUnionManyInto<T>(dest: Set<T>, srcs: Iterable<Iterable<T>>): Set<T>;
export declare function setUnionInto<T>(dest: Set<T>, ...srcs: Iterable<T>[]): Set<T>;
export declare function setIntersect<T>(s1: Iterable<T>, s2: ReadonlySet<T>): Set<T>;
export declare function setSubtract<T>(src: Iterable<T>, diff: Iterable<T>): Set<T>;
export declare function setUnion<T>(...sets: Iterable<T>[]): Set<T>;
export declare function setMap<T, U>(set: Iterable<T>, f: (v: T) => U): Set<U>;
export declare function setFilter<T>(set: Iterable<T>, p: (v: T) => boolean): Set<T>;
export declare function setFilterMap<T, U>(set: Iterable<T>, f: (v: T) => U | undefined): Set<U>;
export declare function setSortBy<T>(it: Iterable<T>, sortKey: (v: T) => number | string): Set<T>;
export declare function setGroupBy<T, G>(it: Iterable<T>, grouper: (v: T) => G): Map<G, Set<T>>;
export declare function toReadonlySet<T>(it: Iterable<T>): ReadonlySet<T>;
export declare class EqualityMap<K, V> {
    private readonly _map;
    set(k: K, v: V): void;
    get(k: K): V | undefined;
    has(k: K): boolean;
    values(): IterableIterator<V>;
}
export declare function areEqual(a: unknown, b: unknown): boolean;
export declare function hashCodeOf(x: unknown): number;
