import { ConvenienceRenderer, type ForbiddenWordsInfo } from "../../ConvenienceRenderer";
import { type Name, type Namer } from "../../Naming";
import type { RenderContext } from "../../Renderer";
import type { OptionValues } from "../../RendererOptions";
import { type Sourcelike } from "../../Source";
import type { TargetLanguage } from "../../TargetLanguage";
import { ArrayType, type ClassType, type EnumType, MapType, type ObjectType, type PrimitiveType, type Type, type UnionType } from "../../Type";
import type { kotlinOptions } from "./language";
export declare class KotlinRenderer extends ConvenienceRenderer {
    protected readonly _kotlinOptions: OptionValues<typeof kotlinOptions>;
    constructor(targetLanguage: TargetLanguage, renderContext: RenderContext, _kotlinOptions: OptionValues<typeof kotlinOptions>);
    protected forbiddenNamesForGlobalNamespace(): readonly string[];
    protected forbiddenForObjectProperties(_o: ObjectType, _classNamed: Name): ForbiddenWordsInfo;
    protected forbiddenForEnumCases(_e: EnumType, _enumName: Name): ForbiddenWordsInfo;
    protected forbiddenForUnionMembers(_u: UnionType, _unionName: Name): ForbiddenWordsInfo;
    protected topLevelNameStyle(rawName: string): string;
    protected makeNamedTypeNamer(): Namer;
    protected namerForObjectProperty(): Namer;
    protected makeUnionMemberNamer(): Namer;
    protected makeEnumCaseNamer(): Namer;
    protected emitDescriptionBlock(lines: Sourcelike[]): void;
    protected emitBlock(line: Sourcelike, f: () => void, delimiter?: "curly" | "paren" | "lambda"): void;
    protected anySourceType(optional: string): Sourcelike;
    protected arrayType(arrayType: ArrayType, withIssues?: boolean, _noOptional?: boolean): Sourcelike;
    protected mapType(mapType: MapType, withIssues?: boolean, _noOptional?: boolean): Sourcelike;
    protected kotlinType(t: Type, withIssues?: boolean, noOptional?: boolean): Sourcelike;
    protected emitUsageHeader(): void;
    protected emitHeader(): void;
    protected emitTopLevelPrimitive(t: PrimitiveType, name: Name): void;
    protected emitTopLevelArray(t: ArrayType, name: Name): void;
    protected emitTopLevelMap(t: MapType, name: Name): void;
    protected emitEmptyClassDefinition(c: ClassType, className: Name): void;
    protected emitClassDefinition(c: ClassType, className: Name): void;
    protected emitClassDefinitionMethods(_c: ClassType, _className: Name): void;
    protected emitClassAnnotations(_c: Type, _className: Name): void;
    protected renameAttribute(_name: Name, _jsonName: string, _required: boolean, _meta: Array<() => void>): void;
    protected emitEnumDefinition(e: EnumType, enumName: Name): void;
    protected emitUnionDefinition(u: UnionType, unionName: Name): void;
    protected emitUnionDefinitionMethods(_u: UnionType, _nonNulls: ReadonlySet<Type>, _maybeNull: PrimitiveType | null, _unionName: Name): void;
    protected emitSourceStructure(): void;
}
