export type NamingStyle = "pascal" | "camel" | "underscore" | "upper-underscore" | "pascal-upper-acronyms" | "camel-upper-acronyms";
type CodePointPredicate = (codePoint: number) => boolean;
export declare function utf16ConcatMap(mapper: (utf16Unit: number) => string): (s: string) => string;
export declare function utf32ConcatMap(mapper: (codePoint: number) => string): (s: string) => string;
export declare function utf16LegalizeCharacters(isLegal: (utf16Unit: number) => boolean): (s: string) => string;
export declare function legalizeCharacters(isLegal: (codePoint: number) => boolean): (s: string) => string;
export declare function repeatString(s: string, n: number): string;
export declare function intToHex(i: number, width: number): string;
export declare function standardUnicodeHexEscape(codePoint: number): string;
export declare function escapeNonPrintableMapper(printablePredicate: (codePoint: number) => boolean, escaper: (codePoint: number) => string): (u: number) => string;
export declare const utf16StringEscape: (s: string) => string;
export declare const stringEscape: (s: string) => string;
export declare function isPrintable(codePoint: number): boolean;
export declare function isAscii(codePoint: number): boolean;
export declare function isLetter(codePoint: number): boolean;
export declare function isDigit(codePoint: number): boolean;
export declare function isNumeric(codePoint: number): boolean;
export declare function isLetterOrDigit(codePoint: number): boolean;
export declare function isLetterOrUnderscore(codePoint: number): boolean;
export declare function isLetterOrUnderscoreOrDigit(codePoint: number): boolean;
export declare function isWordCharacter(codePoint: number): boolean;
export declare function trimEnd(str: string): string;
export declare function capitalize(str: string): string;
export declare function decapitalize(str: string): string;
export declare function pascalCase(str: string): string;
export declare function camelCase(str: string): string;
export declare function snakeCase(str: string): string;
export declare function startWithLetter(isAllowedStart: (codePoint: number) => boolean, // FIXME: technically, this operates on UTF16 units
upper: boolean, str: string): string;
export interface WordInName {
    isAcronym: boolean;
    word: string;
}
export declare const fastIsUpperCase: CodePointPredicate;
export declare function splitIntoWords(s: string): WordInName[];
export type WordStyle = (word: string) => string;
export declare function firstUpperWordStyle(s: string): string;
export declare function allUpperWordStyle(s: string): string;
export declare function originalWord(s: string): string;
export declare function allLowerWordStyle(s: string): string;
export declare function combineWords(words: WordInName[], removeInvalidCharacters: (s: string) => string, firstWordStyle: WordStyle, restWordStyle: WordStyle, firstWordAcronymStyle: WordStyle, restAcronymStyle: WordStyle, separator: string, isStartCharacter: (codePoint: number) => boolean): string;
export declare function addPrefixIfNecessary(prefix: string, name: string): string;
export declare function makeNameStyle(namingStyle: NamingStyle, legalizeName: (name: string) => string, prefix?: string): (rawName: string) => string;
export {};
