"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  DefaultMap: () => DefaultMap,
  assert: () => assert,
  assertNever: () => assertNever,
  brandString: () => brandString,
  defined: () => defined,
  definedMap: () => definedMap,
  dontAwait: () => dontAwait,
  exceptionToError: () => exceptionToError,
  exceptionToString: () => exceptionToString,
  filterUndefined: () => filterUndefined,
  hasOwnProperty: () => hasOwnProperty,
  isArray: () => isArray,
  isEnumValue: () => isEnumValue,
  makeBrandString: () => makeBrandString,
  mapFilterUndefined: () => mapFilterUndefined,
  mapRecord: () => mapRecord,
  mapRecordFilterUndefined: () => mapRecordFilterUndefined,
  panic: () => panic,
  proveNever: () => proveNever,
  proveType: () => proveType,
  reduceTwo: () => reduceTwo,
  sleep: () => sleep
});
module.exports = __toCommonJS(index_exports);

// src/default-map.ts
var DefaultMap = class extends Map {
  /**
   *
   * @param _defaultFunc Must return the default value for key `k`.  Will only be called when necessary.
   * @param initKVPs An array of [key, value] arrays to initialize the map with.
   */
  constructor(_defaultFunc, initKVPs) {
    super(initKVPs);
    this._defaultFunc = _defaultFunc;
  }
  /**
   * Returns the value for `k`.  If `k` is not present, creates
   * the default value via [[_defaultFunc]], sets that default
   * as the value for `k` and returns it.
   */
  get(k) {
    let v = super.get(k);
    if (v === void 0) {
      if (this.has(k)) return v;
      v = this._defaultFunc(k);
      this.set(k, v);
    }
    return v;
  }
  /**
   * Sets the value for `k` to `f(v)` where `v` is the previous
   * value for `k`, or the default if not present.  Returns the new
   * value.
   *
   * These two lines are equivalent:
   *
   * ```
   * m.set("foo", m.get("foo") + 1);
   * m.update("foo", x => x + 1);
   * ```
   */
  update(k, f) {
    const v = f(this.get(k));
    this.set(k, v);
    return v;
  }
};

// src/branded-strings.ts
function brandString(s) {
  return s;
}
function makeBrandString() {
  return brandString;
}

// src/index.ts
function proveType(_val) {
}
function proveNever(_never, message, result) {
  console.trace(message);
  return result;
}
function panic(message = "This should not happen") {
  console.trace(message);
  throw new Error(message);
}
function assert(fact, message = "Assertion failed") {
  if (fact) return;
  return panic(message);
}
function assertNever(_never, message = "`never` happened") {
  return panic(message);
}
function defined(v, reason) {
  if (v === void 0) {
    return panic("Value was undefined but should be defined" + (reason !== void 0 ? ` because: ${reason}` : ""));
  }
  return v;
}
function dontAwait(p) {
  if (!(p instanceof Promise)) return;
  p.catch((e) => {
    console.trace("Unhandled error from unawaited promise", e);
    throw e;
  });
}
function sleep(ms) {
  return new Promise((resolve) => {
    setTimeout(resolve, ms);
  });
}
function reduceTwo(a, b, f) {
  if (a === void 0) return b;
  if (b === void 0) return a;
  return f(a, b);
}
function definedMap(x, f) {
  if (x === void 0) return void 0;
  return f(x);
}
function isEnumValue(e, x) {
  return Object.keys(e).map((k) => e[k]).some((v) => v === x);
}
function isArray(x) {
  return Array.isArray(x);
}
function hasOwnProperty(obj, name) {
  if (obj === void 0 || obj === null) return false;
  return Object.prototype.hasOwnProperty.call(obj, name);
}
function mapFilterUndefined(iterable, f) {
  const result = [];
  let i = 0;
  for (const x of iterable) {
    const y = f(x, i);
    i += 1;
    if (y === void 0) continue;
    result.push(y);
  }
  return result;
}
function filterUndefined(arr) {
  const result = [];
  for (const x of arr) {
    if (x !== void 0) {
      result.push(x);
    }
  }
  return result;
}
function mapRecord(r, f) {
  const result = {};
  for (const [name, value] of Object.entries(r)) {
    result[name] = f(value, name);
  }
  return result;
}
function mapRecordFilterUndefined(r, f) {
  const result = {};
  for (const [name, value] of Object.entries(r)) {
    const o = f(value, name);
    if (o === void 0) continue;
    result[name] = o;
  }
  return result;
}
function exceptionToString(e) {
  if (e === void 0) return "";
  if (hasOwnProperty(e, "message") && typeof e.message === "string") {
    return e.message;
  }
  try {
    return e.toString();
  } catch (f) {
    try {
      return `Exception can't be stringified: ${exceptionToString(f)}`;
    } catch (e2) {
      return "Exception can't be stringified";
    }
  }
}
function exceptionToError(e) {
  if (e instanceof Error) {
    return e;
  } else {
    return new Error(exceptionToString(e));
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DefaultMap,
  assert,
  assertNever,
  brandString,
  defined,
  definedMap,
  dontAwait,
  exceptionToError,
  exceptionToString,
  filterUndefined,
  hasOwnProperty,
  isArray,
  isEnumValue,
  makeBrandString,
  mapFilterUndefined,
  mapRecord,
  mapRecordFilterUndefined,
  panic,
  proveNever,
  proveType,
  reduceTwo,
  sleep
});
