"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.hashCodeInit = 17;
// This function based on Java's string hashing.
function hashString(str) {
    let hash = 0;
    for (let i = 0; i < str.length; i++) {
        const chr = str.charCodeAt(i);
        hash = (hash << 5) - hash + chr;
        hash = hash & hash; // Convert to 32bit integer
    }
    return hash;
}
exports.hashString = hashString;
function addHashCode(acc, h) {
    return (acc * 31 + (h | 0)) | 0;
}
exports.addHashCode = addHashCode;
function withDefault(x, theDefault) {
    if (x !== undefined) {
        return x;
    }
    return theDefault;
}
exports.withDefault = withDefault;
function definedMap(x, f) {
    if (x === undefined)
        return undefined;
    return f(x);
}
exports.definedMap = definedMap;
function definedMapWithDefault(x, theDefault, f) {
    return withDefault(definedMap(x, f), theDefault);
}
exports.definedMapWithDefault = definedMapWithDefault;
function hasOwnProperty(obj, name) {
    if (obj === undefined || obj === null)
        return false;
    return Object.prototype.hasOwnProperty.call(obj, name);
}
exports.hasOwnProperty = hasOwnProperty;
function iterableFind(it, p) {
    for (const v of it) {
        if (p(v)) {
            return v;
        }
    }
    return undefined;
}
exports.iterableFind = iterableFind;
function iterableEvery(it, p) {
    for (const v of it) {
        if (!p(v)) {
            return false;
        }
    }
    return true;
}
exports.iterableEvery = iterableEvery;
function iterableSome(it, p) {
    for (const v of it) {
        if (p(v)) {
            return true;
        }
    }
    return false;
}
exports.iterableSome = iterableSome;
function iterableFirst(it) {
    for (const v of it) {
        return v;
    }
    return undefined;
}
exports.iterableFirst = iterableFirst;
function iterableMax(it) {
    let max = undefined;
    for (const v of it) {
        if (max === undefined || v > max) {
            max = v;
        }
    }
    return max;
}
exports.iterableMax = iterableMax;
function iterableMinBy(it, key) {
    let min = undefined;
    let minValue = undefined;
    for (const v of it) {
        const k = key(v);
        if (min === undefined || k < min) {
            min = k;
            minValue = v;
        }
    }
    return minValue;
}
exports.iterableMinBy = iterableMinBy;
function iterableReduce(it, unit, reducer) {
    let result = unit;
    for (const v of it) {
        result = reducer(result, v);
    }
    return result;
}
exports.iterableReduce = iterableReduce;
function* iterableEnumerate(it) {
    let i = 0;
    for (const v of it) {
        yield [i, v];
        i += 1;
    }
}
exports.iterableEnumerate = iterableEnumerate;
function* iterableSkip(it, n) {
    let i = 0;
    for (const v of it) {
        if (i >= n) {
            yield v;
        }
        else {
            i += 1;
        }
    }
}
exports.iterableSkip = iterableSkip;
/** n === 1 will give the last element. */
function arrayGetFromEnd(arr, i) {
    const l = arr.length;
    if (i > l)
        return undefined;
    return arr[l - i];
}
exports.arrayGetFromEnd = arrayGetFromEnd;
function arrayLast(arr) {
    return arrayGetFromEnd(arr, 1);
}
exports.arrayLast = arrayLast;
function arrayPop(arr) {
    const l = arr.length;
    if (l === 0) {
        throw new Error("Cannot pop empty array");
    }
    return arr.slice(0, l - 1);
}
exports.arrayPop = arrayPop;
function arrayIntercalate(separator, items) {
    const acc = [];
    for (const x of items) {
        if (acc.length > 0)
            acc.push(separator);
        acc.push(x);
    }
    return acc;
}
exports.arrayIntercalate = arrayIntercalate;
function arrayMapSync(set, f) {
    return __awaiter(this, void 0, void 0, function* () {
        const result = [];
        let i = 0;
        for (const v of set) {
            result.push(yield f(v, i));
            i += 1;
        }
        return result;
    });
}
exports.arrayMapSync = arrayMapSync;
function compareKeys(sa, sb) {
    if (sa < sb)
        return -1;
    if (sa > sb)
        return 1;
    return 0;
}
function arraySortByInto(arr, sortKey) {
    return arr.sort((a, b) => compareKeys(sortKey(a), sortKey(b)));
}
exports.arraySortByInto = arraySortByInto;
function toReadonlyArray(it) {
    if (Array.isArray(it))
        return it;
    return Array.from(it);
}
exports.toReadonlyArray = toReadonlyArray;
function mapMap(m, f) {
    const result = new Map();
    for (const [k, v] of m) {
        result.set(k, f(v, k));
    }
    return result;
}
exports.mapMap = mapMap;
function mapFirst(m) {
    for (const v of m.values()) {
        return v;
    }
    return undefined;
}
exports.mapFirst = mapFirst;
function mapContains(m, valueToFind) {
    for (const v of m.values()) {
        if (v === valueToFind) {
            return true;
        }
    }
    return false;
}
exports.mapContains = mapContains;
function mapSome(m, p) {
    for (const [k, v] of m) {
        if (p(v, k)) {
            return true;
        }
    }
    return false;
}
exports.mapSome = mapSome;
function mapMergeInto(dest, src) {
    for (const [k, v] of src) {
        dest.set(k, v);
    }
    return dest;
}
exports.mapMergeInto = mapMergeInto;
function mapMerge(ma, mb) {
    const result = new Map(ma);
    mapMergeInto(result, mb);
    return result;
}
exports.mapMerge = mapMerge;
function mapMergeWithInto(ma, merger, mb) {
    for (const [k, vb] of mb) {
        const va = ma.get(k);
        const v = va === undefined ? vb : merger(va, vb, k);
        ma.set(k, v);
    }
    return ma;
}
exports.mapMergeWithInto = mapMergeWithInto;
function mapMergeWith(ma, merger, mb) {
    const result = new Map(ma);
    mapMergeWithInto(result, merger, mb);
    return result;
}
exports.mapMergeWith = mapMergeWith;
function mapFilter(m, p) {
    const result = new Map();
    for (const [k, v] of m) {
        if (p(v, k)) {
            result.set(k, v);
        }
    }
    return result;
}
exports.mapFilter = mapFilter;
function mapFilterMap(m, f) {
    const result = new Map();
    for (const [k, v] of m) {
        const w = f(v, k);
        if (w !== undefined) {
            result.set(k, w);
        }
    }
    return result;
}
exports.mapFilterMap = mapFilterMap;
function mapSortToArray(m, sortKey) {
    return arraySortByInto(Array.from(m), ([k, v]) => sortKey(v, k));
}
exports.mapSortToArray = mapSortToArray;
function mapSortBy(m, sortKey) {
    return new Map(mapSortToArray(m, sortKey));
}
exports.mapSortBy = mapSortBy;
function mapSortByKey(m) {
    return mapSortBy(m, (_, k) => k);
}
exports.mapSortByKey = mapSortByKey;
function mapMapEntries(m, f) {
    const result = new Map();
    for (const [k, v] of m) {
        const [l, w] = f(v, k);
        result.set(l, w);
    }
    return result;
}
exports.mapMapEntries = mapMapEntries;
function mapUpdateInto(m, k, updater) {
    m.set(k, updater(m.get(k)));
    return m;
}
exports.mapUpdateInto = mapUpdateInto;
function mapFromObject(obj) {
    const result = new Map();
    for (const k of Object.getOwnPropertyNames(obj)) {
        result.set(k, obj[k]);
    }
    return result;
}
exports.mapFromObject = mapFromObject;
function mapToObject(m) {
    const result = {};
    for (const [k, v] of m) {
        result[k] = v;
    }
    return result;
}
exports.mapToObject = mapToObject;
function mapFromIterable(it, valueForKey) {
    const result = new Map();
    for (const k of it) {
        result.set(k, valueForKey(k));
    }
    return result;
}
exports.mapFromIterable = mapFromIterable;
function mapFind(it, p) {
    for (const [k, v] of it) {
        if (p(v, k)) {
            return v;
        }
    }
    return undefined;
}
exports.mapFind = mapFind;
function mapTranspose(maps) {
    const result = new Map();
    for (const m of maps) {
        for (const [k, v] of m) {
            let arr = result.get(k);
            if (arr === undefined) {
                arr = [];
                result.set(k, arr);
            }
            arr.push(v);
        }
    }
    return result;
}
exports.mapTranspose = mapTranspose;
function mapMapSync(m, f) {
    return __awaiter(this, void 0, void 0, function* () {
        const result = new Map();
        for (const [k, v] of m) {
            result.set(k, yield f(v, k));
        }
        return result;
    });
}
exports.mapMapSync = mapMapSync;
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Set
function setIsSuperset(set, subset) {
    for (const elem of subset) {
        if (!set.has(elem))
            return false;
    }
    return true;
}
exports.setIsSuperset = setIsSuperset;
function setUnionManyInto(dest, srcs) {
    for (const src of srcs) {
        for (const v of src) {
            dest.add(v);
        }
    }
    return dest;
}
exports.setUnionManyInto = setUnionManyInto;
function setUnionInto(dest, ...srcs) {
    return setUnionManyInto(dest, srcs);
}
exports.setUnionInto = setUnionInto;
function setIntersect(s1, s2) {
    const result = new Set();
    for (const v of s1) {
        if (s2.has(v)) {
            result.add(v);
        }
    }
    return result;
}
exports.setIntersect = setIntersect;
function setSubtract(src, diff) {
    const result = new Set(src);
    for (const v of diff) {
        result.delete(v);
    }
    return result;
}
exports.setSubtract = setSubtract;
function setUnion(...sets) {
    const result = new Set();
    setUnionInto(result, ...sets);
    return result;
}
exports.setUnion = setUnion;
function setMap(set, f) {
    const result = new Set();
    for (const v of set) {
        result.add(f(v));
    }
    return result;
}
exports.setMap = setMap;
function setFilter(set, p) {
    const result = new Set();
    for (const v of set) {
        if (p(v)) {
            result.add(v);
        }
    }
    return result;
}
exports.setFilter = setFilter;
function setFilterMap(set, f) {
    const result = new Set();
    for (const v of set) {
        const u = f(v);
        if (u !== undefined) {
            result.add(u);
        }
    }
    return result;
}
exports.setFilterMap = setFilterMap;
function setSortBy(it, sortKey) {
    return new Set(arraySortByInto(Array.from(it), sortKey));
}
exports.setSortBy = setSortBy;
function setGroupBy(it, grouper) {
    const result = new Map();
    for (const v of it) {
        const g = grouper(v);
        let group = result.get(g);
        if (group === undefined) {
            group = new Set();
            result.set(g, group);
        }
        group.add(v);
    }
    return result;
}
exports.setGroupBy = setGroupBy;
function toReadonlySet(it) {
    if (it instanceof Set)
        return it;
    return new Set(it);
}
exports.toReadonlySet = toReadonlySet;
class EqualityMap {
    constructor() {
        this._map = new Map();
    }
    set(k, v) {
        let h = hashCodeOf(k) | 0;
        for (;;) {
            const kvp = this._map.get(h);
            if (kvp === undefined) {
                this._map.set(h, [k, v]);
                return;
            }
            if (areEqual(k, kvp[0])) {
                kvp[1] = v;
                return;
            }
            h = (h + 1) | 0;
        }
    }
    get(k) {
        let h = hashCodeOf(k) | 0;
        for (;;) {
            const kvp = this._map.get(h);
            if (kvp === undefined) {
                return undefined;
            }
            if (areEqual(k, kvp[0])) {
                return kvp[1];
            }
            h = (h + 1) | 0;
        }
    }
    has(k) {
        return this.get(k) !== undefined;
    }
    *values() {
        for (const [, [, v]] of this._map) {
            yield v;
        }
    }
}
exports.EqualityMap = EqualityMap;
function areEqual(a, b) {
    if (a === b) {
        return true;
    }
    if (a === undefined || b === undefined || a === null || b === null) {
        return false;
    }
    if (typeof a.equals === "function" &&
        typeof b.equals === "function") {
        return a.equals(b);
    }
    if (a instanceof Set && b instanceof Set) {
        if (a.size !== b.size)
            return false;
        for (const x of a) {
            if (!b.has(x))
                return false;
        }
        return true;
    }
    if (a instanceof Map && b instanceof Map) {
        if (a.size !== b.size)
            return false;
        for (const [k, v] of a) {
            const w = b.get(k);
            if (!areEqual(v, w))
                return false;
        }
        return true;
    }
    if (Array.isArray(a) && Array.isArray(b)) {
        const n = a.length;
        if (n !== b.length)
            return false;
        for (let i = 0; i < n; i++) {
            if (!areEqual(a[i], b[i]))
                return false;
        }
        return true;
    }
    return false;
}
exports.areEqual = areEqual;
function hashCodeOf(x) {
    if (typeof x === "number")
        return x | 0;
    if (typeof x === "string")
        return hashString(x);
    let h = exports.hashCodeInit;
    if (x === undefined)
        return h;
    if (x === true)
        return (h + 1) | 0;
    if (x === false)
        return (h + 2) | 0;
    if (x === null)
        return (h + 3) | 0;
    if (typeof x.hashCode === "function") {
        return x.hashCode();
    }
    if (x instanceof Set) {
        for (const y of x) {
            h += hashCodeOf(y);
        }
        return h;
    }
    if (x instanceof Map) {
        let g = exports.hashCodeInit;
        for (const [k, v] of x) {
            g += hashCodeOf(k);
            h += hashCodeOf(v);
        }
        return addHashCode(g, h);
    }
    if (Array.isArray(x)) {
        for (const y of x) {
            h = addHashCode(h, hashCodeOf(y));
        }
        return h;
    }
    throw new Error(`Cannot hash ${x}`);
}
exports.hashCodeOf = hashCodeOf;
//# sourceMappingURL=index.js.map