import { ConvenienceRenderer, type ForbiddenWordsInfo } from "../../ConvenienceRenderer";
import type { Name, Namer } from "../../Naming";
import type { RenderContext } from "../../Renderer";
import type { OptionValues } from "../../RendererOptions";
import { type Sourcelike } from "../../Source";
import type { TargetLanguage } from "../../TargetLanguage";
import type { ClassProperty, ClassType, Type, UnionType } from "../../Type";
import type { cSharpOptions } from "./language";
import { AccessModifier } from "./utils";
export declare class CSharpRenderer extends ConvenienceRenderer {
    private readonly _csOptions;
    constructor(targetLanguage: TargetLanguage, renderContext: RenderContext, _csOptions: OptionValues<typeof cSharpOptions>);
    protected forbiddenNamesForGlobalNamespace(): string[];
    protected forbiddenForObjectProperties(_: ClassType, classNamed: Name): ForbiddenWordsInfo;
    protected forbiddenForUnionMembers(_: UnionType, unionNamed: Name): ForbiddenWordsInfo;
    protected makeNamedTypeNamer(): Namer;
    protected namerForObjectProperty(): Namer;
    protected makeUnionMemberNamer(): Namer;
    protected makeEnumCaseNamer(): Namer;
    protected unionNeedsName(u: UnionType): boolean;
    protected namedTypeToNameForTopLevel(type: Type): Type | undefined;
    protected emitBlock(f: () => void, semicolon?: boolean): void;
    protected get doubleType(): string;
    protected csType(t: Type, follow?: (t: Type) => Type, withIssues?: boolean): Sourcelike;
    protected nullableCSType(t: Type, follow?: (t: Type) => Type, withIssues?: boolean): Sourcelike;
    protected baseclassForType(_t: Type): Sourcelike | undefined;
    protected emitType(description: string[] | undefined, accessModifier: AccessModifier, declaration: Sourcelike, name: Sourcelike, baseclass: Sourcelike | undefined, emitter: () => void): void;
    protected attributesForProperty(_property: ClassProperty, _name: Name, _c: ClassType, _jsonName: string): Sourcelike[] | undefined;
    protected propertyDefinition(property: ClassProperty, name: Name, _c: ClassType, _jsonName: string): Sourcelike;
    protected emitDescriptionBlock(lines: Sourcelike[]): void;
    protected blankLinesBetweenAttributes(): boolean;
    private emitClassDefinition;
    private emitUnionDefinition;
    private emitEnumDefinition;
    protected emitExpressionMember(declare: Sourcelike, define: Sourcelike, isProperty?: boolean): void;
    protected emitTypeSwitch<T extends Sourcelike>(types: Iterable<T>, condition: (t: T) => Sourcelike, withBlock: boolean, withReturn: boolean, f: (t: T) => void): void;
    protected emitUsing(ns: Sourcelike): void;
    protected emitUsings(): void;
    protected emitRequiredHelpers(): void;
    private emitTypesAndSupport;
    protected emitDefaultLeadingComments(): void;
    protected emitDefaultFollowingComments(): void;
    protected needNamespace(): boolean;
    protected emitSourceStructure(): void;
    protected emitDependencyUsings(): void;
}
