import { ConvenienceRenderer, type ForbiddenWordsInfo } from "../../ConvenienceRenderer";
import { type Name, type Namer } from "../../Naming";
import type { RenderContext } from "../../Renderer";
import type { OptionValues } from "../../RendererOptions";
import { type Sourcelike } from "../../Source";
import type { TargetLanguage } from "../../TargetLanguage";
import { type ClassProperty, ClassType, EnumType, type Type } from "../../Type";
import type { pythonOptions } from "./language";
export declare class PythonRenderer extends ConvenienceRenderer {
    protected readonly pyOptions: OptionValues<typeof pythonOptions>;
    private readonly imports;
    private readonly declaredTypes;
    constructor(targetLanguage: TargetLanguage, renderContext: RenderContext, pyOptions: OptionValues<typeof pythonOptions>);
    protected forbiddenNamesForGlobalNamespace(): readonly string[];
    protected forbiddenForObjectProperties(_: ClassType, _classNamed: Name): ForbiddenWordsInfo;
    protected makeNamedTypeNamer(): Namer;
    protected namerForObjectProperty(): Namer;
    protected makeUnionMemberNamer(): null;
    protected makeEnumCaseNamer(): Namer;
    protected get commentLineStart(): string;
    protected emitDescriptionBlock(lines: Sourcelike[]): void;
    protected get needsTypeDeclarationBeforeUse(): boolean;
    protected canBeForwardDeclared(t: Type): boolean;
    protected emitBlock(line: Sourcelike, f: () => void): void;
    protected string(s: string): Sourcelike;
    protected withImport(module: string, name: string): Sourcelike;
    protected withTyping(name: string): Sourcelike;
    protected namedType(t: Type): Sourcelike;
    protected pythonType(t: Type, _isRootTypeDef?: boolean): Sourcelike;
    protected declarationLine(t: Type): Sourcelike;
    protected declareType<T extends Type>(t: T, emitter: () => void): void;
    protected emitClassMembers(t: ClassType): void;
    protected typeHint(...sl: Sourcelike[]): Sourcelike;
    protected typingDecl(name: Sourcelike, type: string): Sourcelike;
    protected typingReturn(type: string): Sourcelike;
    protected sortClassProperties(properties: ReadonlyMap<string, ClassProperty>, propertyNames: ReadonlyMap<string, Name>): ReadonlyMap<string, ClassProperty>;
    protected emitClass(t: ClassType): void;
    protected emitEnum(t: EnumType): void;
    protected emitImports(): void;
    protected emitSupportCode(): void;
    protected emitClosingCode(): void;
    protected emitSourceStructure(_givenOutputFilename: string): void;
}
