"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonTargetLanguage = exports.pythonLanguageConfig = exports.pythonOptions = void 0;
const collection_utils_1 = require("collection-utils");
const RendererOptions_1 = require("../../RendererOptions");
const TargetLanguage_1 = require("../../TargetLanguage");
const Type_1 = require("../../Type");
const JSONPythonRenderer_1 = require("./JSONPythonRenderer");
const PythonRenderer_1 = require("./PythonRenderer");
exports.pythonOptions = {
    features: new RendererOptions_1.EnumOption("python-version", "Python version", {
        "3.5": { typeHints: false, dataClasses: false },
        "3.6": { typeHints: true, dataClasses: false },
        "3.7": { typeHints: true, dataClasses: true },
    }, "3.6"),
    justTypes: new RendererOptions_1.BooleanOption("just-types", "Classes only", false),
    nicePropertyNames: new RendererOptions_1.BooleanOption("nice-property-names", "Transform property names to be Pythonic", true),
    pydanticBaseModel: new RendererOptions_1.BooleanOption("pydantic-base-model", "Uses pydantic BaseModel", false),
};
exports.pythonLanguageConfig = {
    displayName: "Python",
    names: ["python", "py"],
    extension: "py",
};
class PythonTargetLanguage extends TargetLanguage_1.TargetLanguage {
    constructor() {
        super(exports.pythonLanguageConfig);
    }
    getOptions() {
        return exports.pythonOptions;
    }
    get stringTypeMapping() {
        const mapping = new Map();
        const dateTimeType = "date-time";
        mapping.set("date", dateTimeType);
        mapping.set("time", dateTimeType);
        mapping.set("date-time", dateTimeType);
        mapping.set("uuid", "uuid");
        mapping.set("integer-string", "integer-string");
        mapping.set("bool-string", "bool-string");
        return mapping;
    }
    get supportsUnionsWithBothNumberTypes() {
        return true;
    }
    get supportsOptionalClassProperties() {
        return false;
    }
    needsTransformerForType(t) {
        if (t instanceof Type_1.UnionType) {
            return (0, collection_utils_1.iterableSome)(t.members, (m) => this.needsTransformerForType(m));
        }
        return t.kind === "integer-string" || t.kind === "bool-string";
    }
    makeRenderer(renderContext, untypedOptionValues) {
        const options = (0, RendererOptions_1.getOptionValues)(exports.pythonOptions, untypedOptionValues);
        if (options.justTypes) {
            return new PythonRenderer_1.PythonRenderer(this, renderContext, options);
        }
        return new JSONPythonRenderer_1.JSONPythonRenderer(this, renderContext, options);
    }
}
exports.PythonTargetLanguage = PythonTargetLanguage;
