"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeBrandString = exports.brandString = exports.DefaultMap = exports.exceptionToError = exports.exceptionToString = exports.filterUndefined = exports.mapFilterUndefined = exports.hasOwnProperty = exports.isArray = exports.isEnumValue = exports.definedMap = exports.reduceTwo = exports.sleep = exports.dontAwait = exports.defined = exports.assertNever = exports.assert = exports.panic = exports.proveNever = exports.proveType = void 0;
/**
 * Do nothing, but only compile if `_val` is of type `T`.
 */
function proveType(_val) {
    // do nothing, just prove the compiler thinks the types match
}
exports.proveType = proveType;
/**
 * Only compile if `_never` has type `never`.  If run, trace the
 * `message` and return `result`.
 */
function proveNever(_never, message, result) {
    console.trace(message);
    return result;
}
exports.proveNever = proveNever;
/**
 * Throw an `Error` and trace `message`.
 */
function panic(message = "This should not happen") {
    console.trace(message);
    debugger;
    throw new Error(message);
}
exports.panic = panic;
/**
 * Assert that `fact` is `true`.  If the assertion fails, [[panic]]
 * with `message`.
 */
function assert(fact, message = "Assertion failed") {
    if (fact)
        return;
    return panic(message);
}
exports.assert = assert;
/**
 * Only compile if `_never` has the type `never`.  If run, [[panic]]
 * with `message`.
 */
function assertNever(_never, message = "`never` happened") {
    return panic(message);
}
exports.assertNever = assertNever;
/**
 * If `v` is not `undefined`, return `v`.  Otherwise, [[panic]] with
 * a message including `reason`.
 */
function defined(v, reason) {
    if (v === undefined) {
        return panic("Value was undefined but should be defined" + (reason !== undefined ? ` because: ${reason}` : ""));
    }
    return v;
}
exports.defined = defined;
/**
 * The only thing this function does is to trace if the promise
 * `p` rejects.  It is useful to explain to ESLint that `p` is
 * intentionally not `await`ed.
 *
 * @deprecated Instead of `dontAwait(x)` use `void x`.
 */
function dontAwait(p) {
    if (!(p instanceof Promise))
        return;
    p.catch(e => {
        console.trace("Unhandled error from unawaited promise", e);
        throw e;
    });
}
exports.dontAwait = dontAwait;
/**
 * A promise that resolves after `ms` milliseconds.
 */
function sleep(ms) {
    return new Promise(resolve => {
        setTimeout(resolve, ms);
    });
}
exports.sleep = sleep;
/**
 * If both `a` and `b` are `undefined`, return `undefined`.
 * If exactly one of the two is `undefined`, return the other.
 * If both are not `undefined`, return `f(a, b)`.
 */
function reduceTwo(a, b, f) {
    if (a === undefined)
        return b;
    if (b === undefined)
        return a;
    return f(a, b);
}
exports.reduceTwo = reduceTwo;
/**
 * If `x` is undefined, return `undefined`.  Otherwise, return `f(x)`.
 */
function definedMap(x, f) {
    if (x === undefined)
        return undefined;
    return f(x);
}
exports.definedMap = definedMap;
/**
 * If `x` belongs to the enum `e`, return `true`.  Otherwise, return `false`.
 */
function isEnumValue(e, x) {
    return Object.keys(e).map(k => e[k]).some(v => v === x);
}
exports.isEnumValue = isEnumValue;
function isArray(x) {
    return Array.isArray(x);
}
exports.isArray = isArray;
/**
 * Returns whether `obj` has `name` as its own property.
 */
function hasOwnProperty(obj, name) {
    if (obj === undefined || obj === null)
        return false;
    return Object.prototype.hasOwnProperty.call(obj, name);
}
exports.hasOwnProperty = hasOwnProperty;
/**
 * Map `f` over `iterable`, and return an array of all results
 * that are not `undefined`.
 */
function mapFilterUndefined(iterable, f) {
    const result = [];
    let i = 0;
    for (const x of iterable) {
        const y = f(x, i);
        i += 1;
        if (y === undefined)
            continue;
        result.push(y);
    }
    return result;
}
exports.mapFilterUndefined = mapFilterUndefined;
/**
 * Filters out all elements in `arr` that are `undefined`.
 */
function filterUndefined(arr) {
    const result = [];
    for (const x of arr) {
        if (x !== undefined) {
            result.push(x);
        }
    }
    return result;
}
exports.filterUndefined = filterUndefined;
/**
 * Returns a string representation of `e`, which is supposed to be an
 * exception.
 */
function exceptionToString(e) {
    if (e === undefined)
        return "";
    try {
        return e.toString();
    }
    catch (f) {
        try {
            return `Exception can't be stringified: ${exceptionToString(f)}`;
        }
        catch (_a) {
            return "Exception can't be stringified";
        }
    }
}
exports.exceptionToString = exceptionToString;
/**
 * Returns the exception `e` as an instance of `Error`.  If `e` is already an
 * `Error`, it just returns `e`, otherwise it returns an error with
 * `exceptionToString(e)`.
 */
function exceptionToError(e) {
    if (e instanceof Error) {
        return e;
    }
    else {
        return new Error(exceptionToString(e));
    }
}
exports.exceptionToError = exceptionToError;
var default_map_1 = require("./default-map");
Object.defineProperty(exports, "DefaultMap", { enumerable: true, get: function () { return default_map_1.DefaultMap; } });
var branded_strings_1 = require("./branded-strings");
Object.defineProperty(exports, "brandString", { enumerable: true, get: function () { return branded_strings_1.brandString; } });
Object.defineProperty(exports, "makeBrandString", { enumerable: true, get: function () { return branded_strings_1.makeBrandString; } });
//# sourceMappingURL=index.js.map