# I.Ming ( I.明體 / 一點明體 / 一点明朝 / 一点明体 ) 

## 說明

「I.明體（I.Ming）」乃係一套依照傳承字形標準化文件《傳承字形部件檢校表》的推薦字形標準，並以TrueType格式封裝、依照Unicode編碼的OpenType字型。

我們希望「I.明體」可以作爲實際示範，讓大家明白製作字型時，可以採用依照傳承字形標準化文件推薦字形，同時仍然依照Unicode編碼、符合OpenType技術，並期待各字型廠商、字型製作者都能仿效，推出更多開源或商業市場上的傳承字形字型，以收拋磚引玉之效。

「I.明體」這字型名稱裏的「I」是羅馬數字「一」，「I.」唸作「一點（[粵]Jat1 dim2、[中古]Qit temq、[客]Jit7 diam3、[北]Yī diǎn、[日]いちてん、[英]One-dot）」，象徵筆畫的基本：點與線。

使用「I.明體」時，請遵從「[IPA開放字型授權協議 1.0版](IPA_Font_License_Agreement_v1.0_chi.md)（[IPA Open Font License v1.0](IPA_Font_License_Agreement_v1.0.md#ipa-font-license-agreement-v10)，[IPAフォントライセンスv1.0](IPA_Font_License_Agreement_v1.0.md)）」之規定。

但凡有任何人使用、複製、修改、分發本字型，或對本字型進行任何符合「IPA開放字型授權協議 1.0版」規定的行爲，使用、下載或行使合約規定權利之接受方，亦視爲同意遵守「IPA開放字型授權協議 1.0版」的一切規定。

「IPA字型（IPA Font，IPAフォント）」爲日本「獨立行政法人情報処理推進機構」（簡稱「IPA」）的註冊商標。

## 信念

漢字，在當今語文中，地位無可取代。它是唯一廣泛通行的意音文字（logogram），每個構字有其字理依據，可上追字源，追蹤每個漢字背後的故事。由龜甲獸骨、鐘鼎禮器上圖形味甚重的漢字，發展至今天，漢字展現了多變的外貌。

現在，進入了資訊爆炸的社會，漢字仍不失其生命力。今天大家使用的漢字，主要有兩大類：一是手寫體，由前人的楷書、行書書法演變而來，講求靈活的變化，展示執筆者的修爲，營造行間的氣韻；二是印刷體，亦活躍於各種電子屏幕，上宗中國蓬勃且領先全球的印刷術裏，所使用的彫版及活字造形，講求其清晰、理性，結構穩重而明目，筆畫井然且有理。

按類別不同，兩種字在筆畫表現上，一向有所差異。手寫求活，有些筆畫趨於書寫時的便易；印刷求精，筆畫大多保留傳統理性。因此，印刷體的傳承文字，本以致力保留字理爲正道。

「I.明體」依照傳承字形標準化文件《傳承字形部件檢校表》的推薦字形標準製作，力求遵從字理，展現傳承漢字構字的科學系統。同時，我們另備「I.明體異體」，呈現傳統印版字中常見的異體。

## 字型檔案

目前「I.明體」已發展至8.10版，發佈日期爲2024年4月20日，共有以下字型檔案：

* [「一點明體」（I.Ming）](I.Ming-8.10.ttf)：收錄力求遵從字理的傳承字形。
* [「一點明體CP」（I.MingCP）](I.MingCP-8.10.ttf)：與「一點明體」一樣，唯全形標點置中。
* [「一點明體異體」（I.MingVar）](I.MingVar-8.10.ttf)：部份漢字改爲收錄一些也常見，但字理上未必比上者佔優的傳承字形。
* [「一點明體異體CP」（I.MingVarCP）](I.MingVarCP-8.10.ttf)：與「一點明體異體」一樣，唯全形標點置中。
* [「新一細明體」（PMingI.U）](PMingI.U-8.10.ttf)：與「一點明體CP」一樣，唯行高修改至跟Windows系統細明體相同。
* [「新一細明體異體」（PMingI.UVar）](PMingI.UVar-8.10.ttf)：與「一點明體異體CP」一樣，唯行高修改至跟Windows系統細明體相同。

此外，在[「I.明體」8.10版的文件夾](https://github.com/ichitenfont/I.Ming/tree/master/8.10)內，尚有「I.明體」計劃的說明檔、字型功能的說明檔、版權授權條款檔、字型歷次變更的詳細紀錄檔。

## 主要貢獻者

* 主製作：[內木一郎](https://github.com/SyaoranHinata)、[李爾樅](https://github.com/Zonz-Ly)
* 聯合製作：[陳輝恒](https://github.com/hfhchan)、李擎宇、伍梓豪、鯤逰白圭
* 製作協助：鍾啟堯、陳志泓、[佟藍歌](https://github.com/aikahiiragi)、[Extc](https://github.com/extc)、[落霞孤鶩](https://github.com/lxgw)
* 其他協助：李任之、許瀚文、譚樊馬克、葉俊麟、Sanggo、Gary Yau、堂木千代、蓋艾倫、伍梓豪、陳柏逸、夜煞之樂
* 過往貢獻者：林隆男、TypeBank、[Halasjack](https://github.com/hlsj)、[趙瑾昀](https://github.com/kunki)

## 歷史

「I.明體」經過許多人的努力才誕生。其前身是「IPA字型」。

2009年，日本[「IPA」](http://www.ipa.go.jp/)以符合「開放原始碼促進會（Open Source Initiative）」開源定義的「IPA開放字型授權條款」，發佈兩款「IPA字型」，分別爲[「IPA明體（IPA明朝）」及「IPA黑體（IPAゴシック）」](http://ipafont.ipa.go.jp/old/ipafont/download.html)。字型衍生自林隆男（Takao Hayashi）所設計的兩款字形：[TypeBank公司](https://www.typebank.co.jp/)的「TB明體」和「TB黑體」。字型包含了日本常用的字元，以供日本人使用。

後來，經過多年的持續修補及修訂，「IPA明體」擴充成[「IPAex明體」](http://ipafont.ipa.go.jp/)、[「IPAmj明體」](http://mojikiban.ipa.go.jp/)。在「IPAmj明體」裏，正體漢字部份已補完得頗齊全，只是仍有少數常用字缺字。預設顯示的寫法仍以日文爲主，字型同時收錄了許多異體寫法，惟須採用特定程式方能顯示。其2013年11月的版本，收錄了CJK基本漢字18072個，擴展A漢字5765個，擴展B漢字25320個，擴展C漢字380個，擴展D漢字108個，未映射的異體等漢字9065個。

2013年底，Halasjack公開釋出「IPA明體補字」，在「IPAmj明體」的基礎上，修改了部份日文寫法爲中文寫法，把異體字裏符合中文原體寫法，改爲預設顯示的字元。他又用正體字替代缺少的簡化字。當中「一簡對多正」的字，如「发」、「历」等，Halasjack增補了字元，不用某個正體字代替，以免出現別字。此外，Halasjack又自造了百餘個GB2312的缺字，使字型能夠完全顯示GB2312漢字，雖然部份簡化字顯示作正體字，但已能滿足大陸使用者的一般需要。字型並含有部份A區和B區漢字。

2014年年中，「I.字坊」（一點字坊）處理人內木一郎開始以「IPA明體補字」爲基礎，增補、修改及整理字元，製作成「I.明體」，以應付正體（繁體）中文的需求。後來，幸得陳輝恒、李爾樅加入，大家一起傾力製作及修改字型檔案。同時，又得Extc、鍾啟堯、陳志泓、佟藍歌等仝寅提供各方面的支援，李擎宇、伍梓豪、鯤逰白圭、夜煞之樂、落霞孤鶩等協助製作簡化漢字，使「I.明體」字型日趨成熟。目前，「I.字坊」各仝寅已補完了所有Big5漢字、GB2312漢字、IICore漢字、《通用規範漢字表》漢字，以及[《常用香港外字表》第1.8版](https://github.com/ichitenfont/suppchara)中所有字元、[「再會豆腐字」《本土語言外字表》2020年版](https://tauhu.tw/)所有字元、《康熙字典》所有字頭、[jf 7000 當務字集](https://justfont.com/jf7000)所有漢字，此外還製作了部首及補充部首、筆畫、注音符號及注音符號擴展、蘇州碼子、麻雀牌、中國象棋、中國算籌、中式「正」字計數符號、八卦、易經六十四卦、太玄經八十一卦等字符、多種常見漢語族語言拼音所需的字符，覆蓋絕大部份正體（繁體）中文文本所使用的字元，滿足香港和臺灣使用者的一般需求。「I.字坊」仝寅亦進一步修改漢字寫法，依據[傳承字形標準化文件](https://github.com/ichitenfont/inheritedglyphs)，以傳承下來的原體寫法（一般來說，日本地區通稱「康熙字典體」，大陸地區俗稱「舊字形」）爲依歸。這種寫法最能保留漢字字理，亦符合正體地區人士多年的閱讀習慣，更能使字元設計得較美觀。

我們維護及更新字型時，除了字坊各人的互相協助、扶持外，有幸得到熱愛漢字的各方好友相助，才可以解決當中的技術問題，以及修繕字元。特別是李任之先生、許瀚文先生、譚樊馬克先生、葉俊麟先生、Sanggo先生、Gary Yau先生、堂木千代先生、蓋艾倫先生、陳柏逸先生、小林劍先生、趙瑾昀先生等賢兄達人，幫忙解決直排問題、多國語言代碼頁問題，亦協助修繕部份字元，提供字樣意見，或在其他方面鼎力襄助。此外，還有一位不希望公開名字的朋友提供許多珍貴的舊字形資料，協助研究字形。一郎謹代表「I.字坊」仝寅，在此由衷鳴謝。

## 網址
https://github.com/ichitenfont
