/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.unciv.Constants;
import com.unciv.logic.MultiFilter;
import com.unciv.logic.map.mapunit.MapUnitCache;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueComplianceError;
import com.unciv.models.ruleset.unique.UniqueFlag;
import com.unciv.models.ruleset.unique.UniqueParameterType;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unique.expressions.Expressions;
import com.unciv.models.ruleset.unique.expressions.Parser;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.TextSimilarityKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 ?2\u00020\u0001:\u0001?B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0014J&\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eJ*\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u000eH\u0007J\u0018\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\nH\u0003J\"\u0010(\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020#H\u0003J2\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u000eH\u0003J*\u0010.\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u000eH\u0003J\"\u0010/\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010-\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0003J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020&012\u0006\u0010\"\u001a\u00020#H\u0003J\u001a\u00109\u001a\u0004\u0018\u0001052\u0006\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020\nH\u0003J2\u0010<\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010-\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u000eH\u0003J\u0018\u0010=\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u000eH\u0003J\"\u0010>\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010-\u001a\u00020\nH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u00102\u001a^\u0012\u0004\u0012\u000204\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010503j\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u000105`603j.\u0012\u0004\u0012\u000204\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010503j\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u000105`6`68\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b7\u00108\u00a8\u0006@\u00b2\u0006\n\u0010-\u001a\u00020\nX\u008a\u0084\u0002"}, d2={"Lcom/unciv/models/ruleset/validation/UniqueValidator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;)V", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "allNonTypedUniques", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "allUniqueParameters", "anyAncientRuins", "", "getAnyAncientRuins", "()Z", "anyAncientRuins$delegate", "Lkotlin/Lazy;", "addToHashsets", "", "uniqueHolder", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "populateFilteringUniqueHashsets", "checkUniques", "uniqueContainer", "lines", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "reportRulesetSpecificErrors", "tryFixUnknownUniques", "performanceHeavyConditionals", "", "Lcom/unciv/models/ruleset/unique/UniqueType;", "checkUnique", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "addPossibleMisspellings", "complianceError", "Lcom/unciv/models/ruleset/unique/UniqueComplianceError;", "text", "getExpressionParseErrors", "resourceUniques", "resourceConditionals", "getModifierErrors", "modifier", "prefix", "getUniqueTypeSpecificErrors", "getDeprecationAnnotationErrors", "getComplianceErrors", "", "paramTypeErrorSeverityCache", "Ljava/util/HashMap;", "Lcom/unciv/models/ruleset/unique/UniqueParameterType;", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "Lkotlin/collections/HashMap;", "getParamTypeErrorSeverityCache$annotations", "()V", "getParamTypeErrorSeverityCached", "uniqueParameterType", "param", "checkUntypedUnique", "isFilteringUniqueAllowed", "tryFixUnknownUnique", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUniqueValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueValidator.kt\ncom/unciv/models/ruleset/validation/UniqueValidator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,487:1\n1321#2,2:488\n1255#2,2:572\n774#3:490\n865#3,2:491\n543#3,6:493\n295#3,2:499\n1761#3,3:501\n1374#3:504\n1460#3,5:505\n774#3:510\n865#3,2:511\n774#3:513\n865#3,2:514\n2746#3,3:516\n2746#3,3:519\n774#3:522\n865#3,2:523\n1563#3:525\n1634#3,3:526\n1617#3,9:529\n1869#3:538\n1870#3:540\n1626#3:541\n1563#3:542\n1634#3,3:543\n1761#3,3:546\n2423#3,14:549\n774#3:566\n865#3,2:567\n774#3:569\n865#3,2:570\n1#4:539\n1104#5,3:563\n*S KotlinDebug\n*F\n+ 1 UniqueValidator.kt\ncom/unciv/models/ruleset/validation/UniqueValidator\n*L\n46#1:488,2\n33#1:572,2\n114#1:490\n114#1:491,2\n116#1:493,6\n117#1:499,2\n127#1:501,3\n153#1:504\n153#1:505,5\n153#1:510\n153#1:511,2\n227#1:513\n227#1:514,2\n242#1:516,3\n249#1:519,3\n341#1:522\n341#1:523,2\n342#1:525\n342#1:526,3\n343#1:529,9\n343#1:538\n343#1:540\n343#1:541\n375#1:542\n375#1:543,3\n376#1:546,3\n381#1:549,14\n444#1:566\n444#1:567,2\n451#1:569\n451#1:570,2\n343#1:539\n412#1:563,3\n*E\n"})
public final class UniqueValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final HashSet<String> allNonTypedUniques;
    @NotNull
    private final HashSet<String> allUniqueParameters;
    @NotNull
    private final Lazy anyAncientRuins$delegate;
    @NotNull
    private final Set<UniqueType> performanceHeavyConditionals;
    @NotNull
    private final Set<UniqueType> resourceUniques;
    @NotNull
    private final Set<UniqueType> resourceConditionals;
    @NotNull
    private final HashMap<UniqueParameterType, HashMap<String, UniqueType.UniqueParameterErrorSeverity>> paramTypeErrorSeverityCache;
    @NotNull
    public static final String whichDoesNotFitParameterType = "which does not fit parameter type";

    public UniqueValidator(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.ruleset = ruleset;
        this.allNonTypedUniques = new HashSet();
        this.allUniqueParameters = new HashSet();
        this.anyAncientRuins$delegate = LazyKt.lazy(() -> UniqueValidator.anyAncientRuins_delegate$lambda$0(this));
        UniqueType[] uniqueTypeArray = new UniqueType[]{UniqueType.ConditionalNeighborTiles, UniqueType.ConditionalAdjacentTo, UniqueType.ConditionalNotAdjacentTo};
        this.performanceHeavyConditionals = SetsKt.setOf(uniqueTypeArray);
        uniqueTypeArray = new UniqueType[]{UniqueType.ProvidesResources, UniqueType.ConsumesResources, UniqueType.PercentResourceProduction, UniqueType.StatPercentFromObjectToResource};
        this.resourceUniques = SetsKt.setOf(uniqueTypeArray);
        uniqueTypeArray = new UniqueType[]{UniqueType.ConditionalWithResource, UniqueType.ConditionalWithoutResource, UniqueType.ConditionalWhenBetweenStatResource, UniqueType.ConditionalWhenAboveAmountStatResource, UniqueType.ConditionalWhenBelowAmountStatResource};
        this.resourceConditionals = SetsKt.setOf(uniqueTypeArray);
        this.paramTypeErrorSeverityCache = new HashMap();
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    private final boolean getAnyAncientRuins() {
        Lazy lazy = this.anyAncientRuins$delegate;
        return (Boolean)lazy.getValue();
    }

    private final void addToHashsets(IHasUniques uniqueHolder) {
        for (Unique unique : uniqueHolder.getUniqueObjects()) {
            boolean bl = unique.getType() == null ? this.allNonTypedUniques.add(unique.getPlaceholderText()) : CollectionsKt.addAll((Collection)this.allUniqueParameters, SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)unique.getAllParams()), UniqueValidator::addToHashsets$lambda$0));
        }
    }

    public final void populateFilteringUniqueHashsets() {
        Sequence<IRulesetObject> $this$forEach$iv = this.ruleset.allRulesetObjects();
        boolean $i$f$forEach = false;
        Iterator<IRulesetObject> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IRulesetObject element$iv;
            IRulesetObject it = element$iv = iterator2.next();
            boolean bl = false;
            this.addToHashsets(it);
        }
    }

    public final void checkUniques(@NotNull IHasUniques uniqueContainer, @NotNull RulesetErrorList lines2, boolean reportRulesetSpecificErrors, boolean tryFixUnknownUniques) {
        Intrinsics.checkNotNullParameter(uniqueContainer, "uniqueContainer");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        for (Unique unique : uniqueContainer.getUniqueObjects()) {
            RulesetErrorList errors = this.checkUnique(unique, tryFixUnknownUniques, uniqueContainer, reportRulesetSpecificErrors);
            lines2.addAll(errors);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final RulesetErrorList checkUnique(@NotNull Unique unique, boolean tryFixUnknownUniques, @Nullable IHasUniques uniqueContainer, boolean reportRulesetSpecificErrors) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(unique, "unique");
        Lazy<String> prefix$delegate = LazyKt.lazy(() -> UniqueValidator.checkUnique$lambda$0(uniqueContainer, unique));
        if (unique.getType() == null) {
            return this.checkUntypedUnique(unique, tryFixUnknownUniques, uniqueContainer, UniqueValidator.checkUnique$lambda$1(prefix$delegate), reportRulesetSpecificErrors);
        }
        RulesetErrorList rulesetErrors = new RulesetErrorList(this.ruleset);
        if (!(uniqueContainer == null || unique.getType().canAcceptUniqueTarget(uniqueContainer.getUniqueTarget()) || unique.hasModifier(UniqueType.ConditionalTimedUnique) && uniqueContainer.getUniqueTarget().canAcceptUniqueTarget(UniqueTarget.Triggerable))) {
            rulesetErrors.add(UniqueValidator.checkUnique$lambda$1(prefix$delegate) + " is not allowed on its target type", RulesetErrorSeverity.Warning, uniqueContainer, unique);
        }
        List<UniqueComplianceError> typeComplianceErrors = this.getComplianceErrors(unique);
        for (UniqueComplianceError complianceError : typeComplianceErrors) {
            if (!reportRulesetSpecificErrors && complianceError.getErrorSeverity() == UniqueType.UniqueParameterErrorSeverity.RulesetSpecific) continue;
            String text2 = UniqueValidator.checkUnique$lambda$1(prefix$delegate) + " contains parameter \"" + complianceError.getParameterName() + "\", which does not fit parameter type " + CollectionsKt.joinToString$default(complianceError.getAcceptableParameterTypes(), " or ", null, null, 0, null, UniqueValidator::checkUnique$lambda$2, 30, null) + " !";
            text2 = this.addPossibleMisspellings(complianceError, text2);
            rulesetErrors.add(text2, complianceError.getErrorSeverity().getRulesetErrorSeverity(), uniqueContainer, unique);
            CollectionsKt.addAll((Collection)rulesetErrors, this.getExpressionParseErrors(complianceError, uniqueContainer, unique));
        }
        for (Unique modifier : unique.getModifiers()) {
            CollectionsKt.addAll((Collection)rulesetErrors, this.getModifierErrors(modifier, UniqueValidator.checkUnique$lambda$1(prefix$delegate), unique, uniqueContainer, reportRulesetSpecificErrors));
        }
        CollectionsKt.addAll((Collection)rulesetErrors, this.getUniqueTypeSpecificErrors(UniqueValidator.checkUnique$lambda$1(prefix$delegate), unique, uniqueContainer, reportRulesetSpecificErrors));
        Iterable $this$filter$iv = unique.getModifiers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Unique it = (Unique)element$iv$iv;
            boolean bl = false;
            UniqueType uniqueType = it.getType();
            boolean bl2 = uniqueType != null ? uniqueType.canAcceptUniqueTarget(UniqueTarget.Conditional) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conditionals = (List)destination$iv$iv;
        if (conditionals.size() > 1) {
            Object v3;
            Unique lastCheapConditional;
            block16: {
                Object v2;
                block15: {
                    List $this$lastOrNull$iv = conditionals;
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        Unique it = (Unique)element$iv;
                        boolean bl = false;
                        if (!(!CollectionsKt.contains((Iterable)this.performanceHeavyConditionals, it.getType()))) continue;
                        v2 = element$iv;
                        break block15;
                    }
                    v2 = null;
                }
                lastCheapConditional = v2;
                Iterable $this$firstOrNull$iv = conditionals;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl = false;
                    if (!CollectionsKt.contains((Iterable)this.performanceHeavyConditionals, it.getType())) continue;
                    v3 = element$iv;
                    break block16;
                }
                v3 = null;
            }
            Unique firstExpensiveConditional = v3;
            if (lastCheapConditional != null && firstExpensiveConditional != null && conditionals.indexOf(lastCheapConditional) > conditionals.indexOf(firstExpensiveConditional)) {
                rulesetErrors.add(UniqueValidator.checkUnique$lambda$1(prefix$delegate) + " contains multiple conditionals, of which \"" + firstExpensiveConditional.getText() + "\" is more expensive to calculate than \"" + lastCheapConditional.getText() + "\". For performance, consider switching their locations.", RulesetErrorSeverity.WarningOptionsOnly, uniqueContainer, unique);
            }
        }
        if (MapUnitCache.Companion.getUnitMovementUniques().contains((Object)unique.getType())) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = unique.getModifiers();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Unique it = (Unique)element$iv;
                        boolean bl3 = false;
                        if (!(it.getType() != UniqueType.ConditionalOurUnit || !Constants.INSTANCE.getAll().contains(it.getParams().get(0)))) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                rulesetErrors.add(UniqueValidator.checkUnique$lambda$1(prefix$delegate) + " contains a conditional on a unit movement unique. Due to performance considerations, this unique is cached on the unit, and the conditional may not always limit the unique correctly.", RulesetErrorSeverity.OK, uniqueContainer, unique);
            }
        }
        if (reportRulesetSpecificErrors) {
            CollectionsKt.addAll((Collection)rulesetErrors, this.getDeprecationAnnotationErrors(unique, UniqueValidator.checkUnique$lambda$1(prefix$delegate), uniqueContainer));
        }
        return rulesetErrors;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final String addPossibleMisspellings(UniqueComplianceError complianceError, String text2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        String toReturn = text2;
        Iterable iterable = complianceError.getAcceptableParameterTypes();
        boolean $i$f$flatMap = false;
        void var7_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (UniqueParameterType)((Object)element$iv$iv);
            boolean bl = false;
            Iterable list$iv$iv = it.getKnownValuesForAutocomplete(this.ruleset);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = TextSimilarityKt.getRelativeTextDistance((String)it, complianceError.getParameterName()) <= RulesetCache.INSTANCE.getUniqueMisspellingThreshold();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List similarParameters = (List)destination$iv$iv;
        if (!((Collection)similarParameters).isEmpty()) {
            toReturn = toReturn + " May be a misspelling of: " + CollectionsKt.joinToString$default(similarParameters, ", ", null, null, 0, null, UniqueValidator::addPossibleMisspellings$lambda$2, 30, null);
        }
        return toReturn;
    }

    @Readonly
    private final RulesetErrorList getExpressionParseErrors(UniqueComplianceError complianceError, IHasUniques uniqueContainer, Unique unique) {
        RulesetErrorList rulesetErrors = new RulesetErrorList(null, 1, null);
        if (!complianceError.getAcceptableParameterTypes().contains((Object)UniqueParameterType.Countable)) {
            return rulesetErrors;
        }
        Parser.ParsingError parseError = Expressions.Companion.getParsingError(complianceError.getParameterName());
        if (parseError != null) {
            String marker = "HERE\u27a1";
            int errorLocation = parseError.getPosition();
            StringBuilder stringBuilder = new StringBuilder();
            String string = complianceError.getParameterName().substring(0, errorLocation);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append(marker);
            String string2 = complianceError.getParameterName().substring(errorLocation);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String parameterWithErrorLocationMarked = stringBuilder2.append(string2).toString();
            String text2 = '\"' + complianceError.getParameterName() + "\" could not be parsed as an expression due to: " + parseError.getMessage() + ". \n" + parameterWithErrorLocationMarked;
            rulesetErrors.add(text2, RulesetErrorSeverity.WarningOptionsOnly, uniqueContainer, unique);
            return rulesetErrors;
        }
        List<String> countableErrors = Expressions.Companion.getCountableErrors(complianceError.getParameterName(), this.ruleset);
        if (!((Collection)countableErrors).isEmpty()) {
            String text3 = '\"' + complianceError.getParameterName() + "\" was parsed as an expression, but has the following errors with this ruleset: " + CollectionsKt.joinToString$default(countableErrors, ", ", null, null, 0, null, null, 62, null);
            rulesetErrors.add(text3, RulesetErrorSeverity.WarningOptionsOnly, uniqueContainer, unique);
        }
        return rulesetErrors;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final RulesetErrorList getModifierErrors(Unique modifier, String prefix, Unique unique, IHasUniques uniqueContainer, boolean reportRulesetSpecificErrors) {
        boolean bl;
        Object $this$none$iv;
        RulesetErrorList rulesetErrors;
        block18: {
            UniqueTarget it;
            Object element$iv;
            Iterator $this$filter$iv2;
            boolean bl2;
            boolean $i$f$none;
            block17: {
                rulesetErrors = new RulesetErrorList(null, 1, null);
                if (unique.hasFlag(UniqueFlag.NoConditionals)) {
                    rulesetErrors.add(prefix + " contains the conditional \"" + modifier.getText() + "\", but the unique does not accept conditionals!", RulesetErrorSeverity.Error, uniqueContainer, unique);
                    return rulesetErrors;
                }
                if (modifier.getType() == null) {
                    void $this$filterTo$iv$iv;
                    String text2 = prefix + " contains the conditional \"" + modifier.getText() + "\", which is of an unknown type!";
                    Iterable $this$filter$iv2 = UniqueType.getEntries();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv2;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        UniqueType it2 = (UniqueType)((Object)element$iv$iv);
                        boolean bl3 = false;
                        boolean bl4 = TextSimilarityKt.getRelativeTextDistance(it2.getPlaceholderText(), modifier.getPlaceholderText()) <= RulesetCache.INSTANCE.getUniqueMisspellingThreshold();
                        if (!bl4) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List similarConditionals = (List)destination$iv$iv;
                    if (!((Collection)similarConditionals).isEmpty()) {
                        text2 = text2 + " May be a misspelling of \"" + CollectionsKt.joinToString$default(similarConditionals, "\", or \"", null, null, 0, null, UniqueValidator::getModifierErrors$lambda$1, 30, null) + '\"';
                    }
                    rulesetErrors.add(text2, RulesetErrorSeverity.Warning, uniqueContainer, unique);
                    return rulesetErrors;
                }
                $this$none$iv = modifier.getType().getTargetTypes();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    $this$filter$iv2 = $this$none$iv.iterator();
                    while ($this$filter$iv2.hasNext()) {
                        element$iv = $this$filter$iv2.next();
                        it = (UniqueTarget)((Object)element$iv);
                        boolean bl5 = false;
                        if (!(it.getModifierType() != UniqueTarget.ModifierType.None)) continue;
                        bl2 = false;
                        break block17;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                rulesetErrors.add(prefix + " contains the modifier \"" + modifier.getText() + "\", which is a Unique that is not a modifier.", RulesetErrorSeverity.Warning, uniqueContainer, unique);
            }
            $this$none$iv = modifier.getType().getTargetTypes();
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                $this$filter$iv2 = $this$none$iv.iterator();
                while ($this$filter$iv2.hasNext()) {
                    element$iv = $this$filter$iv2.next();
                    it = (UniqueTarget)((Object)element$iv);
                    boolean bl6 = false;
                    if (!it.isAcceptableModifierFor(unique)) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            rulesetErrors.add(prefix + " contains the modifier \"" + modifier.getText() + "\", which is not an acceptable modifier for this unique.", RulesetErrorSeverity.Warning, uniqueContainer, unique);
        }
        if (CollectionsKt.contains((Iterable)this.resourceUniques, unique.getType()) && this.resourceConditionals.contains((Object)modifier.getType())) {
            TileResource tileResource = this.ruleset.getTileResources().get(CollectionsKt.last(modifier.getParams()));
            boolean bl7 = tileResource != null ? tileResource.isCityWide() : false;
            if (bl7) {
                rulesetErrors.add(prefix + " contains the conditional \"" + modifier.getText() + "\", which references a citywide resource. This is not a valid conditional for a resource uniques, as it causes a recursive evaluation loop.", RulesetErrorSeverity.Error, uniqueContainer, unique);
            }
        }
        if (CollectionsKt.contains((Iterable)this.resourceUniques, unique.getType())) {
            $this$none$iv = ((Iterable)modifier.getParams()).iterator();
            int n = 0;
            while ($this$none$iv.hasNext()) {
                int index = n++;
                String param = (String)$this$none$iv.next();
                TileResource tileResource = this.ruleset.getTileResources().get(param);
                boolean bl8 = tileResource != null ? tileResource.isCityWide() : false;
                if (!bl8) continue;
                UniqueType uniqueType = unique.getType();
                Intrinsics.checkNotNull((Object)uniqueType);
                List list2 = (List)CollectionsKt.getOrNull((List)uniqueType.getParameterTypeMap(), index);
                boolean bl9 = list2 != null ? list2.contains((Object)UniqueParameterType.Countable) : false;
                if (!bl9) continue;
                rulesetErrors.add(prefix + " contains the modifier \"" + modifier.getText() + "\", which references a citywide resource as a countable. This is not a valid conditional for a resource uniques, as it causes a recursive evaluation loop.", RulesetErrorSeverity.Error, uniqueContainer, unique);
            }
        }
        List<UniqueComplianceError> conditionalComplianceErrors = this.getComplianceErrors(modifier);
        for (UniqueComplianceError complianceError : conditionalComplianceErrors) {
            if (!reportRulesetSpecificErrors && complianceError.getErrorSeverity() == UniqueType.UniqueParameterErrorSeverity.RulesetSpecific) continue;
            String text3 = prefix + " contains modifier \"" + modifier.getText() + "\". This contains the parameter \"" + complianceError.getParameterName() + "\" which does not fit parameter type " + CollectionsKt.joinToString$default(complianceError.getAcceptableParameterTypes(), " or ", null, null, 0, null, UniqueValidator::getModifierErrors$lambda$4, 30, null) + " !";
            text3 = this.addPossibleMisspellings(complianceError, text3);
            rulesetErrors.add(text3, complianceError.getErrorSeverity().getRulesetErrorSeverity(), uniqueContainer, unique);
            CollectionsKt.addAll((Collection)rulesetErrors, this.getExpressionParseErrors(complianceError, uniqueContainer, unique));
        }
        CollectionsKt.addAll((Collection)rulesetErrors, this.getDeprecationAnnotationErrors(modifier, prefix + " contains modifier \"" + modifier.getText() + "\" which", uniqueContainer));
        return rulesetErrors;
    }

    @Pure
    private final RulesetErrorList getUniqueTypeSpecificErrors(String prefix, Unique unique, IHasUniques uniqueContainer, boolean reportRulesetSpecificErrors) {
        RulesetErrorList rulesetErrors = new RulesetErrorList(null, 1, null);
        UniqueType uniqueType = unique.getType();
        if ((uniqueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uniqueType.ordinal()]) == 1 && reportRulesetSpecificErrors && !this.getAnyAncientRuins()) {
            rulesetErrors.add(prefix + " is pointless - there are no ancient ruins", RulesetErrorSeverity.Warning, uniqueContainer, unique);
        }
        return rulesetErrors;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final RulesetErrorList getDeprecationAnnotationErrors(Unique unique, String prefix, IHasUniques uniqueContainer) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        IndexedValue it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object deprecationText;
        RulesetErrorList rulesetErrors = new RulesetErrorList(null, 1, null);
        Deprecated deprecationAnnotation = unique.getDeprecationAnnotation();
        if (deprecationAnnotation != null) {
            String replacementUniqueText = unique.getReplacementText(this.ruleset);
            deprecationText = prefix + " is deprecated " + deprecationAnnotation.message() + (!Intrinsics.areEqual(deprecationAnnotation.replaceWith().expression(), "") ? ", replace with \"" + replacementUniqueText + '\"' : "");
            RulesetErrorSeverity severity = deprecationAnnotation.level() == DeprecationLevel.WARNING ? RulesetErrorSeverity.WarningOptionsOnly : RulesetErrorSeverity.ErrorOptionsOnly;
            rulesetErrors.add((String)deprecationText, severity, uniqueContainer, unique);
        }
        if (unique.getType() == null) {
            return rulesetErrors;
        }
        deprecationText = CollectionsKt.withIndex((Iterable)unique.getType().getParameterTypeMap());
        boolean $i$f$filter = false;
        void var9_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            if (!((List)it.getValue()).contains((Object)UniqueParameterType.Countable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(unique.getParams().get(it.getIndex()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Countables it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if (Countables.Companion.getMatching(it2, this.ruleset) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List countables = (List)destination$iv$iv;
        for (Countables countable : countables) {
            Deprecated deprecation;
            if (countable.getDeprecationAnnotation() == null) continue;
            String replaceExpression = deprecation.replaceWith().expression();
            String text2 = "Countable `" + countable.name() + "` is deprecated " + deprecation.message() + (((CharSequence)replaceExpression).length() == 0 ? "" : ", replace with \"" + replaceExpression + '\"');
            RulesetErrorSeverity severity = deprecation.level() == DeprecationLevel.WARNING ? RulesetErrorSeverity.WarningOptionsOnly : RulesetErrorSeverity.ErrorOptionsOnly;
            rulesetErrors.add(text2, severity, uniqueContainer, unique);
        }
        return rulesetErrors;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final List<UniqueComplianceError> getComplianceErrors(Unique unique) {
        if (unique.getType() == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList errorList = new ArrayList();
        Iterator iterator2 = ((Iterable)unique.getParams()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Object v1;
            boolean bl;
            List errorTypesForAcceptableParameters;
            List<UniqueParameterType> acceptableParamTypes;
            String param;
            block13: {
                Iterator $this$mapTo$iv$iv;
                int index = n++;
                param = (String)iterator2.next();
                if (unique.getType().getParameterTypeMap().size() != unique.getParams().size()) {
                    throw new Exception("Unique " + unique.getText() + " has " + unique.getParams().size() + " parameters, but its type " + (Object)((Object)unique.getType()) + " only " + unique.getType().getParameterTypeMap().size() + " parameters?!");
                }
                Intrinsics.checkNotNullExpressionValue(unique.getType().getParameterTypeMap().get(index), "get(...)");
                if (acceptableParamTypes.size() == 0) continue;
                Iterable $this$map$iv = acceptableParamTypes;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator3.next();
                    UniqueParameterType uniqueParameterType = (UniqueParameterType)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.getParamTypeErrorSeverityCached((UniqueParameterType)it, param));
                }
                errorTypesForAcceptableParameters = (List)destination$iv$iv;
                Iterable $this$any$iv = errorTypesForAcceptableParameters;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    $this$mapTo$iv$iv = $this$any$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Object element$iv = $this$mapTo$iv$iv.next();
                        UniqueType.UniqueParameterErrorSeverity it = (UniqueType.UniqueParameterErrorSeverity)((Object)element$iv);
                        boolean bl3 = false;
                        if (!(it == null)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl || errorTypesForAcceptableParameters.contains((Object)UniqueType.UniqueParameterErrorSeverity.PossibleFilteringUnique) && this.allNonTypedUniques.contains(param)) continue;
            Iterable $this$minByOrNull$iv = errorTypesForAcceptableParameters;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    UniqueType.UniqueParameterErrorSeverity it = (UniqueType.UniqueParameterErrorSeverity)((Object)minElem$iv);
                    boolean bl4 = false;
                    UniqueType.UniqueParameterErrorSeverity uniqueParameterErrorSeverity = it;
                    Intrinsics.checkNotNull((Object)uniqueParameterErrorSeverity);
                    int minValue$iv = uniqueParameterErrorSeverity.ordinal();
                    do {
                        Object e$iv = iterator$iv.next();
                        UniqueType.UniqueParameterErrorSeverity it2 = (UniqueType.UniqueParameterErrorSeverity)((Object)e$iv);
                        $i$a$-minByOrNull-UniqueValidator$getComplianceErrors$leastSevereWarning$1 = false;
                        UniqueType.UniqueParameterErrorSeverity uniqueParameterErrorSeverity2 = it2;
                        Intrinsics.checkNotNull((Object)uniqueParameterErrorSeverity2);
                        int v$iv = uniqueParameterErrorSeverity2.ordinal();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            UniqueType.UniqueParameterErrorSeverity leastSevereWarning = v1;
            if (leastSevereWarning == null) {
                throw new Exception("Unique " + unique.getText() + " from mod " + this.ruleset.getName() + " is acting strangely - please open a bug report");
            }
            ((Collection)errorList).add(new UniqueComplianceError(param, acceptableParamTypes, leastSevereWarning));
        }
        return errorList;
    }

    @Cache
    private static /* synthetic */ void getParamTypeErrorSeverityCache$annotations() {
    }

    @Readonly
    private final UniqueType.UniqueParameterErrorSeverity getParamTypeErrorSeverityCached(UniqueParameterType uniqueParameterType, String param) {
        if (!this.paramTypeErrorSeverityCache.containsKey((Object)uniqueParameterType)) {
            ((Map)this.paramTypeErrorSeverityCache).put(uniqueParameterType, new HashMap());
        }
        HashMap<String, UniqueType.UniqueParameterErrorSeverity> hashMap = this.paramTypeErrorSeverityCache.get((Object)uniqueParameterType);
        Intrinsics.checkNotNull(hashMap);
        HashMap<String, UniqueType.UniqueParameterErrorSeverity> uniqueParamCache = hashMap;
        if (uniqueParamCache.containsKey(param)) {
            return uniqueParamCache.get(param);
        }
        UniqueType.UniqueParameterErrorSeverity severity = uniqueParameterType.getErrorSeverity(param, this.ruleset);
        ((Map)uniqueParamCache).put(param, severity);
        return severity;
    }

    @Readonly
    private final RulesetErrorList checkUntypedUnique(Unique unique, boolean tryFixUnknownUniques, IHasUniques uniqueContainer, String prefix, boolean reportRulesetSpecificErrors) {
        RulesetErrorList fixes;
        char it;
        char element$iv;
        int n;
        CharSequence $this$count$iv = unique.getText();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '<')) continue;
            ++count$iv;
        }
        $this$count$iv = unique.getText();
        int n2 = count$iv;
        $i$f$count = false;
        count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '>')) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        if (n2 != n3) {
            return RulesetErrorList.Companion.of(prefix + " contains mismatched conditional braces!", RulesetErrorSeverity.Warning, this.ruleset, uniqueContainer, unique);
        }
        if (this.isFilteringUniqueAllowed(unique, reportRulesetSpecificErrors)) {
            return new RulesetErrorList(null, 1, null);
        }
        if (tryFixUnknownUniques && !((Collection)(fixes = this.tryFixUnknownUnique(unique, uniqueContainer, prefix))).isEmpty()) {
            return fixes;
        }
        return RulesetErrorList.Companion.of(prefix + " not found in Unciv's unique types, and is not used as a filtering unique.", unique.getParams().isEmpty() ? RulesetErrorSeverity.OK : RulesetErrorSeverity.Warning, this.ruleset, uniqueContainer, unique);
    }

    @Readonly
    private final boolean isFilteringUniqueAllowed(Unique unique, boolean reportRulesetSpecificErrors) {
        if (!((Collection)unique.getModifiers()).isEmpty() || !((Collection)unique.getParams()).isEmpty()) {
            return false;
        }
        if (!reportRulesetSpecificErrors) {
            return true;
        }
        return this.allUniqueParameters.contains(unique.getText());
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final RulesetErrorList tryFixUnknownUnique(Unique unique, IHasUniques uniqueContainer, String prefix) {
        RulesetErrorList rulesetErrorList;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = UniqueType.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            UniqueType it = (UniqueType)((Object)element$iv$iv);
            boolean bl = false;
            boolean bl2 = TextSimilarityKt.getRelativeTextDistance(it.getPlaceholderText(), unique.getPlaceholderText()) <= RulesetCache.INSTANCE.getUniqueMisspellingThreshold();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List similarUniques = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = similarUniques;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UniqueType it = (UniqueType)((Object)element$iv$iv);
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getPlaceholderText(), unique.getPlaceholderText())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List equalUniques = (List)destination$iv$iv2;
        if (!((Collection)equalUniques).isEmpty()) {
            rulesetErrorList = RulesetErrorList.Companion.of(prefix + " looks like it should be fine, but for some reason isn't recognized.", RulesetErrorSeverity.OK, this.ruleset, uniqueContainer, unique);
        } else if (!((Collection)similarUniques).isEmpty()) {
            String text2 = prefix + " looks like it may be a misspelling of:\n" + StringsKt.prependIndent(CollectionsKt.joinToString$default(similarUniques, "\n", null, null, 0, null, arg_0 -> UniqueValidator.tryFixUnknownUnique$lambda$2(unique, arg_0), 30, null), "\t");
            rulesetErrorList = RulesetErrorList.Companion.of(text2, RulesetErrorSeverity.OK, this.ruleset, uniqueContainer, unique);
        } else {
            rulesetErrorList = new RulesetErrorList(null, 1, null);
        }
        return rulesetErrorList;
    }

    private static final boolean anyAncientRuins_delegate$lambda$0(UniqueValidator this$0) {
        boolean bl;
        block1: {
            Collection<TileImprovement> collection = this$0.ruleset.getTileImprovements().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Sequence $this$any$iv = SequencesKt.flatMapIterable(CollectionsKt.asSequence((Iterable)collection), UniqueValidator::anyAncientRuins_delegate$lambda$0$0);
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!(it.getType() == UniqueType.IsAncientRuinsEquivalent)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final Iterable anyAncientRuins_delegate$lambda$0$0(TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUniqueObjects();
    }

    private static final Sequence addToHashsets$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return MultiFilter.INSTANCE.getAllSingleFilters(it);
    }

    private static final String checkUnique$lambda$0(IHasUniques $uniqueContainer, Unique $unique) {
        return Companion.getUniqueContainerPrefix$core($uniqueContainer) + '\"' + $unique.getText() + '\"';
    }

    private static final String checkUnique$lambda$1(Lazy<String> $prefix$delegate) {
        Lazy<String> lazy = $prefix$delegate;
        return lazy.getValue();
    }

    private static final CharSequence checkUnique$lambda$2(UniqueParameterType it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getParameterName();
    }

    private static final CharSequence addPossibleMisspellings$lambda$2(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return '\"' + it + '\"';
    }

    private static final CharSequence getModifierErrors$lambda$1(UniqueType it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getText();
    }

    private static final CharSequence getModifierErrors$lambda$4(UniqueParameterType it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getParameterName();
    }

    private static final CharSequence tryFixUnknownUnique$lambda$2(Unique $unique, UniqueType uniqueType) {
        Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
        String text2 = '\"' + uniqueType.getText();
        if (!((Collection)$unique.getModifiers()).isEmpty()) {
            text2 = text2 + ' ' + CollectionsKt.joinToString$default($unique.getModifiers(), " ", null, null, 0, null, UniqueValidator::tryFixUnknownUnique$lambda$2$0, 30, null);
        }
        text2 = text2 + '\"';
        if (uniqueType.getDeprecationAnnotation() != null) {
            text2 = text2 + " (Deprecated)";
        }
        return text2;
    }

    private static final CharSequence tryFixUnknownUnique$lambda$2$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return '<' + it.getText() + '>';
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0001\u00a2\u0006\u0002\b\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/unciv/models/ruleset/validation/UniqueValidator$Companion;", "", "<init>", "()V", "whichDoesNotFitParameterType", "", "getUniqueContainerPrefix", "uniqueContainer", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "getUniqueContainerPrefix$core", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Readonly
        @NotNull
        public final String getUniqueContainerPrefix$core(@Nullable IHasUniques uniqueContainer) {
            return (uniqueContainer instanceof IRulesetObject ? ((IRulesetObject)uniqueContainer).getOriginRuleset() + ": " : "") + (uniqueContainer == null ? "The" : '(' + uniqueContainer.getUniqueTarget().name() + ") " + uniqueContainer.getName() + "'s") + " unique ";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UniqueType.values().length];
            try {
                nArray[UniqueType.RuinsUpgrade.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

