/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.translations;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\f2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0011`\u0012J-\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\u0018\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0017\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/unciv/models/translations/TranslationFileReader;", "", "<init>", "()V", "templateFileLocation", "", "percentagesFileLocation", "charset", "getCharset", "()Ljava/lang/String;", "read", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "file", "Lcom/badlogic/gdx/files/FileHandle;", "readLanguagePercentages", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "readTemplates", "T", "block", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "core"})
@SourceDebugExtension(value={"SMAP\nTranslationFileReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationFileReader.kt\ncom/unciv/models/translations/TranslationFileReader\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n57#2:60\n1#3:61\n*S KotlinDebug\n*F\n+ 1 TranslationFileReader.kt\ncom/unciv/models/translations/TranslationFileReader\n*L\n56#1:60\n56#1:61\n*E\n"})
public final class TranslationFileReader {
    @NotNull
    public static final TranslationFileReader INSTANCE = new TranslationFileReader();
    @NotNull
    private static final String templateFileLocation = "jsons/translations/template.properties";
    @NotNull
    public static final String percentagesFileLocation = "jsons/translations/completionPercentages.properties";
    @NotNull
    private static final String charset;

    private TranslationFileReader() {
    }

    @NotNull
    public final String getCharset() {
        return charset;
    }

    @NotNull
    public final LinkedHashMap<String, String> read(@NotNull FileHandle file) {
        Intrinsics.checkNotNullParameter(file, "file");
        LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();
        Reader reader2 = file.reader(charset);
        Intrinsics.checkNotNullExpressionValue(reader2, "reader(...)");
        TextStreamsKt.forEachLine(reader2, arg_0 -> TranslationFileReader.read$lambda$0(translations, arg_0));
        return translations;
    }

    @NotNull
    public final HashMap<String, Integer> readLanguagePercentages() {
        HashMap<String, Integer> hashmap = new HashMap<String, Integer>();
        FileHandle percentageFile = Gdx.files.internal(percentagesFileLocation);
        if (!percentageFile.exists()) {
            return hashmap;
        }
        Reader reader2 = percentageFile.reader(charset);
        Intrinsics.checkNotNullExpressionValue(reader2, "reader(...)");
        TextStreamsKt.forEachLine(reader2, arg_0 -> TranslationFileReader.readLanguagePercentages$lambda$0(hashmap, arg_0));
        return hashmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T readTemplates(@NotNull Function1<? super Sequence<String>, ? extends T> block) {
        T t;
        Intrinsics.checkNotNullParameter(block, "block");
        FileHandle templateFile = Gdx.files.internal(templateFileLocation);
        if (!templateFile.exists()) {
            return null;
        }
        Reader reader2 = templateFile.reader(charset);
        Intrinsics.checkNotNullExpressionValue(reader2, "reader(...)");
        Reader $this$useLines$iv = reader2;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            t = block.invoke(TextStreamsKt.lineSequence(it$iv));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return t;
    }

    private static final Unit read$lambda$0(LinkedHashMap $translations, String line) {
        Intrinsics.checkNotNullParameter(line, "line");
        if (!StringsKt.contains$default((CharSequence)line, " = ", false, 2, null)) {
            return Unit.INSTANCE;
        }
        String[] stringArray = new String[]{" = "};
        List splitLine = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
        if (((CharSequence)splitLine.get(1)).length() > 0) {
            String value = StringsKt.replace$default((String)splitLine.get(1), "\\n", "\n", false, 4, null);
            String key = StringsKt.replace$default((String)splitLine.get(0), "\\n", "\n", false, 4, null);
            ((Map)$translations).put(key, value);
        }
        return Unit.INSTANCE;
    }

    private static final Unit readLanguagePercentages$lambda$0(HashMap $hashmap, String line) {
        Intrinsics.checkNotNullParameter(line, "line");
        if (((CharSequence)line).length() == 0 || StringsKt.startsWith$default((CharSequence)line, '#', false, 2, null)) {
            return Unit.INSTANCE;
        }
        String[] stringArray = new String[]{" = "};
        List splitLine = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
        ((Map)$hashmap).put(splitLine.get(0), Integer.parseInt((String)splitLine.get(1)));
        return Unit.INSTANCE;
    }

    static {
        String string = Charsets.UTF_8.name();
        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
        charset = string;
    }
}

