/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.fonts;

import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\r\u0018\u0000 \u001b2\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0007J\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport;", "", "enabled", "", "range", "Lkotlin/ranges/CharRange;", "leftDiacritics", "", "rightDiacritics", "joinerDiacritics", "<init>", "(ZLkotlin/ranges/CharRange;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "charClassMap", "", "", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "getKnownCombinations", "", "isEnabled", "getCharClass", "char", "getReplacementChar", "joined", "createReplacementChar", "remapDiacritics", "value", "TranslationKeys", "Companion", "LineData", "CharClass", "core"})
public final class DiacriticSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enabled;
    @NotNull
    private final Map<Character, CharClass> charClassMap;
    private static final short startingReplacementCodepoint = -1793;
    @NotNull
    private static final Map<CharCategory, CharClass> charCategoryToClass;
    private static final char defaultRangeStart = '!';
    private static final char defaultRangeEnd = '\uffee';
    private static short nextFreeDiacriticReplacementCodepoint;
    @NotNull
    private static final Map<Character, String> fakeAlphabet;
    @NotNull
    private static final Map<String, Character> inverseMap;

    public DiacriticSupport(boolean enabled, @NotNull CharRange range, @NotNull String leftDiacritics, @NotNull String rightDiacritics, @NotNull String joinerDiacritics) {
        Intrinsics.checkNotNullParameter(range, "range");
        Intrinsics.checkNotNullParameter(leftDiacritics, "leftDiacritics");
        Intrinsics.checkNotNullParameter(rightDiacritics, "rightDiacritics");
        Intrinsics.checkNotNullParameter(joinerDiacritics, "joinerDiacritics");
        this.enabled = enabled;
        this.charClassMap = new LinkedHashMap();
        if (this.enabled) {
            int n;
            int rangeEnd;
            char rangeStart = range.isEmpty() ? (char)'!' : (char)range.getFirst();
            char c = rangeStart;
            if (c <= (rangeEnd = range.isEmpty() ? 65518 : (int)range.getLast())) {
                while (true) {
                    Map<Character, CharClass> map2 = this.charClassMap;
                    Character c2 = Character.valueOf(c);
                    if (charCategoryToClass.get((Object)CharsKt.getCategory(c)) != null) {
                        CharClass charClass;
                        map2.put(c2, charClass);
                    }
                    if (c == rangeEnd) break;
                    c = (char)(c + '\u0001');
                }
            }
            int n2 = leftDiacritics.length();
            for (n = 0; n < n2; ++n) {
                char = leftDiacritics.charAt(n);
                this.charClassMap.put(Character.valueOf(char), CharClass.LeftJoiner);
            }
            n2 = rightDiacritics.length();
            for (n = 0; n < n2; ++n) {
                char = rightDiacritics.charAt(n);
                this.charClassMap.put(Character.valueOf(char), CharClass.RightJoiner);
            }
            n2 = joinerDiacritics.length();
            for (n = 0; n < n2; ++n) {
                char = joinerDiacritics.charAt(n);
                this.charClassMap.put(Character.valueOf(char), CharClass.LeftRightJoiner);
            }
        }
    }

    public /* synthetic */ DiacriticSupport(boolean bl, CharRange charRange, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl, charRange, string, string2, string3);
    }

    @VisibleForTesting
    @NotNull
    public final Set<String> getKnownCombinations() {
        return inverseMap.keySet();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    private final CharClass getCharClass(char c) {
        CharClass charClass = this.charClassMap.get(Character.valueOf(c));
        if (charClass == null) {
            charClass = CharClass.None;
        }
        return charClass;
    }

    private final char getReplacementChar(String joined) {
        Character c = inverseMap.get(joined);
        return c != null ? c.charValue() : this.createReplacementChar(joined);
    }

    private final char createReplacementChar(String joined) {
        char c = Companion.getCurrentFreeCode();
        short s = nextFreeDiacriticReplacementCodepoint;
        s = nextFreeDiacriticReplacementCodepoint = UShort.constructor-impl((short)(s + -1));
        int n = UInt.constructor-impl(57344);
        if (Integer.compareUnsigned(UInt.constructor-impl(s & 0xFFFF), n) < 0) {
            throw new IllegalStateException("DiacriticsSupport has exhausted the Unicode private use area");
        }
        fakeAlphabet.put(Character.valueOf(c), joined);
        inverseMap.put(joined, Character.valueOf(c));
        return c;
    }

    @NotNull
    public final String remapDiacritics(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!this.enabled) {
            throw new IllegalStateException("DiacriticSupport not set up properly for translation processing");
        }
        LineData data = new LineData(value.length());
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            this.getCharClass(c).process(data, c);
        }
        return data.result();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(CharCategory.UPPERCASE_LETTER, CharClass.Base), TuplesKt.to(CharCategory.LOWERCASE_LETTER, CharClass.Base), TuplesKt.to(CharCategory.TITLECASE_LETTER, CharClass.Base), TuplesKt.to(CharCategory.OTHER_LETTER, CharClass.Base), TuplesKt.to(CharCategory.MODIFIER_LETTER, CharClass.Base), TuplesKt.to(CharCategory.DECIMAL_DIGIT_NUMBER, CharClass.Base), TuplesKt.to(CharCategory.LETTER_NUMBER, CharClass.Base), TuplesKt.to(CharCategory.OTHER_NUMBER, CharClass.Base), TuplesKt.to(CharCategory.COMBINING_SPACING_MARK, CharClass.LeftJoiner), TuplesKt.to(CharCategory.NON_SPACING_MARK, CharClass.LeftJoiner), TuplesKt.to(CharCategory.ENCLOSING_MARK, CharClass.LeftJoiner), TuplesKt.to(CharCategory.SURROGATE, CharClass.Surrogate)};
        charCategoryToClass = MapsKt.mapOf(pairArray);
        nextFreeDiacriticReplacementCodepoint = (short)-1793;
        fakeAlphabet = new LinkedHashMap();
        inverseMap = new LinkedHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u0015"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "", "expectsRightJoin", "", "<init>", "(Ljava/lang/String;IZ)V", "getExpectsRightJoin", "()Z", "None", "Base", "LeftJoiner", "RightJoiner", "LeftRightJoiner", "Surrogate", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
    private static final abstract class CharClass
    extends Enum<CharClass> {
        private final boolean expectsRightJoin;
        public static final /* enum */ CharClass None = new None("None", 0);
        public static final /* enum */ CharClass Base = new Base("Base", 1);
        public static final /* enum */ CharClass LeftJoiner = new LeftJoiner("LeftJoiner", 2);
        public static final /* enum */ CharClass RightJoiner = new RightJoiner("RightJoiner", 3);
        public static final /* enum */ CharClass LeftRightJoiner = new LeftRightJoiner("LeftRightJoiner", 4);
        public static final /* enum */ CharClass Surrogate = new Surrogate("Surrogate", 5);
        private static final /* synthetic */ CharClass[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CharClass(boolean expectsRightJoin) {
            this.expectsRightJoin = expectsRightJoin;
        }

        /* synthetic */ CharClass(String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getExpectsRightJoin() {
            return this.expectsRightJoin;
        }

        public abstract void process(@NotNull LineData var1, char var2);

        public static CharClass[] values() {
            return (CharClass[])$VALUES.clone();
        }

        public static CharClass valueOf(String value) {
            return Enum.valueOf(CharClass.class, value);
        }

        @NotNull
        public static EnumEntries<CharClass> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ CharClass(String $enum$name, int $enum$ordinal, boolean expectsRightJoin, DefaultConstructorMarker $constructor_marker) {
            this(expectsRightJoin);
        }

        static {
            $VALUES = charClassArray = new CharClass[]{CharClass.None, CharClass.Base, CharClass.LeftJoiner, CharClass.RightJoiner, CharClass.LeftRightJoiner, CharClass.Surrogate};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"com/unciv/ui/components/fonts/DiacriticSupport.CharClass.Base", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class Base
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            Base() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data, char c) {
                Intrinsics.checkNotNullParameter(data, "data");
                data.flushAccumulate(c);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"com/unciv/ui/components/fonts/DiacriticSupport.CharClass.LeftJoiner", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class LeftJoiner
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            LeftJoiner() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data, char c) {
                Intrinsics.checkNotNullParameter(data, "data");
                data.accumulate(c);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"com/unciv/ui/components/fonts/DiacriticSupport.CharClass.LeftRightJoiner", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class LeftRightJoiner
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            LeftRightJoiner() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data, char c) {
                Intrinsics.checkNotNullParameter(data, "data");
                data.accumulate(c);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"com/unciv/ui/components/fonts/DiacriticSupport.CharClass.None", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class None
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            None() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data, char c) {
                Intrinsics.checkNotNullParameter(data, "data");
                data.flushAppend(c);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"com/unciv/ui/components/fonts/DiacriticSupport.CharClass.RightJoiner", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class RightJoiner
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            RightJoiner() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data, char c) {
                Intrinsics.checkNotNullParameter(data, "data");
                data.flushAccumulate(c);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"com/unciv/ui/components/fonts/DiacriticSupport.CharClass.Surrogate", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class Surrogate
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            Surrogate() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data, char c) {
                Intrinsics.checkNotNullParameter(data, "data");
                data.surrogate(c);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010\u0019\u001a\u00020\u001aJ-\u0010\u001b\u001a\u00020\u001c2\"\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u001ej\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011`\u001fH\u0086\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$Companion;", "", "<init>", "()V", "startingReplacementCodepoint", "Lkotlin/UShort;", "S", "charCategoryToClass", "", "Lkotlin/text/CharCategory;", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "defaultRangeStart", "", "defaultRangeEnd", "nextFreeDiacriticReplacementCodepoint", "fakeAlphabet", "", "", "inverseMap", "reset", "", "getStringFor", "char", "freeTranslationData", "getCurrentFreeCode", "isEmpty", "", "invoke", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "translations", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "core"})
    @SourceDebugExtension(value={"SMAP\nDiacriticSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiacriticSupport.kt\ncom/unciv/ui/components/fonts/DiacriticSupport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,253:1\n1491#2:254\n1516#2,3:255\n1519#2,3:265\n382#3,7:258\n*S KotlinDebug\n*F\n+ 1 DiacriticSupport.kt\ncom/unciv/ui/components/fonts/DiacriticSupport$Companion\n*L\n92#1:254\n92#1:255,3\n92#1:265,3\n92#1:258,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void reset() {
            fakeAlphabet.clear();
            this.freeTranslationData();
            nextFreeDiacriticReplacementCodepoint = (short)-1793;
        }

        @NotNull
        public final String getStringFor(char c) {
            String string = (String)fakeAlphabet.get(Character.valueOf(c));
            if (string == null) {
                string = String.valueOf(c);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public final void freeTranslationData() {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = inverseMap.keySet();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                String it = (String)element$iv$iv;
                boolean bl = false;
                Integer key$iv$iv = it.length();
                Map map2 = destination$iv$iv;
                Integer key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            for (Map.Entry entry : ((Map)MapsKt.toSortedMap(destination$iv$iv)).entrySet()) {
                Integer length = (Integer)entry.getKey();
                List examples = (List)entry.getValue();
                Object[] objectArray = new Object[2];
                objectArray[0] = length;
                Intrinsics.checkNotNull(examples);
                objectArray[1] = CollectionsKt.first(examples);
                Log.INSTANCE.debug("Length %d - example %s", objectArray);
            }
            inverseMap.clear();
        }

        public final char getCurrentFreeCode() {
            return (char)(nextFreeDiacriticReplacementCodepoint & 0xFFFF);
        }

        public final boolean isEmpty() {
            return fakeAlphabet.isEmpty();
        }

        @NotNull
        public final DiacriticSupport invoke(@NotNull HashMap<String, String> translations) {
            Intrinsics.checkNotNullParameter(translations, "translations");
            Regex stripCommentRegex = new Regex("^\"?(.*?)\"?(?:\\s*#.*)?$");
            boolean enable = Intrinsics.areEqual(com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("diacritics_support"), stripCommentRegex), "true");
            String rangeStart = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("unicode_block_start_character"), stripCommentRegex);
            String rangeEnd = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("unicode_block_end_character"), stripCommentRegex);
            CharRange range = ((CharSequence)rangeStart).length() == 0 || ((CharSequence)rangeEnd).length() == 0 ? CharRange.Companion.getEMPTY() : new CharRange(StringsKt.minOrThrow(rangeStart), StringsKt.maxOrThrow(rangeEnd));
            String leftDiacritics = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("left_joining_diacritics"), stripCommentRegex);
            String rightDiacritics = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("right_joining_diacritics"), stripCommentRegex);
            String joinerDiacritics = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("left_and_right_joiners"), stripCommentRegex);
            return new DiacriticSupport(enable, range, leftDiacritics, rightDiacritics, joinerDiacritics);
        }

        private static final String invoke$parseDiacriticEntry(String $this$invoke_u24parseDiacriticEntry, Regex stripCommentRegex) {
            CharSequence charSequence = $this$invoke_u24parseDiacriticEntry;
            if (charSequence == null || charSequence.length() == 0) {
                return "";
            }
            MatchResult matchResult = stripCommentRegex.matchEntire($this$invoke_u24parseDiacriticEntry);
            Intrinsics.checkNotNull(matchResult);
            char[] cArray = new char[]{' '};
            List<String> tokens = SequencesKt.toMutableList(SequencesKt.filter(StringsKt.splitToSequence$default((CharSequence)matchResult.getGroupValues().get(1), cArray, false, 0, 6, null), Companion::invoke$parseDiacriticEntry$lambda$0));
            int n = ((Collection)tokens).size();
            for (int index = 0; index < n; ++index) {
                String token2 = tokens.get(index);
                if (token2.length() == 1) continue;
                if (StringsKt.startsWith(token2, "u+", true)) {
                    int n2 = Integer.parseInt(StringsKt.drop(token2, 2), CharsKt.checkRadix(16));
                    if (n2 < 0 || n2 > 65535) {
                        throw new IllegalArgumentException("Invalid Char code: " + n2);
                    }
                    tokens.set(index, String.valueOf((char)n2));
                    continue;
                }
                if (tokens.size() == 1) continue;
                throw new IllegalArgumentException("Invalid diacritic definition: \"" + token2 + "\" is not a single character or unicode codepoint notation");
            }
            return CollectionsKt.joinToString$default(tokens, "", null, null, 0, null, null, 62, null);
        }

        private static final boolean invoke$parseDiacriticEntry$lambda$0(String it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return ((CharSequence)it).length() > 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000eJ\u0006\u0010\u001d\u001a\u00020\u001eR\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u000b\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "", "capacity", "", "<init>", "(Lcom/unciv/ui/components/fonts/DiacriticSupport;I)V", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOutput", "()Ljava/lang/StringBuilder;", "accumulator", "getAccumulator", "waitingHighSurrogate", "", "getWaitingHighSurrogate", "()C", "setWaitingHighSurrogate", "(C)V", "expectsJoin", "", "flush", "", "forbidWaitingHighSurrogate", "accumulate", "char", "flushAccumulate", "flushAppend", "surrogate", "result", "", "core"})
    private final class LineData {
        @NotNull
        private final StringBuilder output;
        @NotNull
        private final StringBuilder accumulator;
        private char waitingHighSurrogate;

        public LineData(int capacity) {
            this.output = new StringBuilder(capacity);
            this.accumulator = new StringBuilder(9);
        }

        @NotNull
        public final StringBuilder getOutput() {
            return this.output;
        }

        @NotNull
        public final StringBuilder getAccumulator() {
            return this.accumulator;
        }

        public final char getWaitingHighSurrogate() {
            return this.waitingHighSurrogate;
        }

        public final void setWaitingHighSurrogate(char c) {
            this.waitingHighSurrogate = c;
        }

        public final boolean expectsJoin() {
            return ((CharSequence)this.accumulator).length() > 0 && DiacriticSupport.this.getCharClass(StringsKt.last(this.accumulator)).getExpectsRightJoin();
        }

        public final void flush() {
            StringBuilder stringBuilder;
            if (this.accumulator.length() <= 1) {
                stringBuilder = this.output.append((CharSequence)this.accumulator);
            } else {
                String string = this.accumulator.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                stringBuilder = this.output.append(DiacriticSupport.this.getReplacementChar(string));
            }
            StringsKt.clear(this.accumulator);
        }

        public final void forbidWaitingHighSurrogate() {
            if (this.waitingHighSurrogate != '\u0000') {
                throw new IllegalArgumentException("Invalid Unicode: High surrogate without low surrogate");
            }
        }

        public final void accumulate(char c) {
            this.forbidWaitingHighSurrogate();
            this.accumulator.append(c);
        }

        public final void flushAccumulate(char c) {
            this.forbidWaitingHighSurrogate();
            if (!this.expectsJoin()) {
                this.flush();
            }
            this.accumulator.append(c);
        }

        public final void flushAppend(char c) {
            this.forbidWaitingHighSurrogate();
            this.flush();
            this.output.append(c);
        }

        public final void surrogate(char c) {
            if (Character.isHighSurrogate(c)) {
                this.forbidWaitingHighSurrogate();
                this.waitingHighSurrogate = c;
            } else {
                if (this.waitingHighSurrogate == '\u0000') {
                    throw new IllegalArgumentException("Invalid Unicode: Low surrogate without high surrogate");
                }
                if (!this.expectsJoin()) {
                    this.flush();
                }
                this.accumulator.append(this.waitingHighSurrogate);
                this.accumulator.append(c);
                this.waitingHighSurrogate = '\u0000';
            }
        }

        @NotNull
        public final String result() {
            this.flush();
            String string = this.output.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$TranslationKeys;", "", "<init>", "()V", "enable", "", "rangeStart", "rangeEnd", "left", "right", "joiner", "core"})
    private static final class TranslationKeys {
        @NotNull
        public static final TranslationKeys INSTANCE = new TranslationKeys();
        @NotNull
        public static final String enable = "diacritics_support";
        @NotNull
        public static final String rangeStart = "unicode_block_start_character";
        @NotNull
        public static final String rangeEnd = "unicode_block_end_character";
        @NotNull
        public static final String left = "left_joining_diacritics";
        @NotNull
        public static final String right = "right_joining_diacritics";
        @NotNull
        public static final String joiner = "left_and_right_joiners";

        private TranslationKeys() {
        }
    }
}

