/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ImmutableColor;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.CityButton;
import com.unciv.ui.components.widgets.BorderedTable;
import com.unciv.ui.images.IconTextButtonKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.DebugUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/components/tilegroups/CityTable;", "Lcom/unciv/ui/components/widgets/BorderedTable;", "city", "Lcom/unciv/logic/city/City;", "forPopup", "", "<init>", "(Lcom/unciv/logic/city/City;Z)V", "addCityPopNumber", "", "addCityGrowthBar", "addCityText", "addCityConstruction", "addCivIcon", "core"})
@SourceDebugExtension(value={"SMAP\nCityButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityButton.kt\ncom/unciv/ui/components/tilegroups/CityTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,626:1\n1#2:627\n*E\n"})
final class CityTable
extends BorderedTable {
    public CityTable(@NotNull City city, boolean forPopup) {
        Color color;
        Intrinsics.checkNotNullParameter(city, "city");
        super("WorldScreen/CityButton/IconTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidBorderShape());
        this.setTransform(false);
        this.setTouchable(Touchable.enabled);
        Civilization selectedCiv = GUI.INSTANCE.getSelectedPlayer();
        Civilization viewingCiv = GUI.INSTANCE.getViewingPlayer();
        this.setBgBorderColor(Intrinsics.areEqual(city.getCiv(), selectedCiv) ? Scene2dExtensionsKt.colorFromRGB(233, 233, 172) : (city.getCiv().isAtWarWith(selectedCiv) ? Scene2dExtensionsKt.colorFromRGB(230, 51, 0) : ImageGetter.INSTANCE.getCHARCOAL()));
        this.setBorderSize(Intrinsics.areEqual(city.getCiv(), selectedCiv) ? 4.0f : (city.getCiv().isAtWarWith(selectedCiv) ? 4.0f : 2.0f));
        Color color2 = color = city.getCiv().getNation().getOuterColor().cpy();
        CityTable cityTable = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.a = 0.9f;
        Color color3 = color;
        Intrinsics.checkNotNullExpressionValue(color3, "apply(...)");
        cityTable.setBgColor(color3);
        this.setBorderOnTop(Intrinsics.areEqual(city.getCiv(), selectedCiv));
        this.pad(0.0f);
        this.defaults().pad(0.0f);
        boolean isShowDetailedInfo = DebugUtils.INSTANCE.getVISIBLE_MAP() || Intrinsics.areEqual(city.getCiv(), selectedCiv) || viewingCiv.isSpectator();
        this.addCityPopNumber(city);
        if (isShowDetailedInfo) {
            this.addCityGrowthBar(city);
        }
        this.addCityText(city, forPopup);
        if (isShowDetailedInfo) {
            this.addCityConstruction(city);
        }
        if (!Intrinsics.areEqual(city.getCiv(), viewingCiv)) {
            this.addCivIcon(city);
        }
        this.getCells().first().padLeft(4.0f);
        Array<Cell> array = this.getCells();
        Intrinsics.checkNotNullExpressionValue(array, "getCells(...)");
        ((Cell)CollectionsKt.last((Iterable)array)).padRight(4.0f);
    }

    public /* synthetic */ CityTable(City city, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(city, bl);
    }

    private final void addCityPopNumber(City city) {
        ImmutableColor textColor = city.getCiv().getNation().getInnerColor();
        Label popLabel = Scene2dExtensionsKt.toLabel$default(TranslationsKt.tr(city.getPopulation().getPopulation()), textColor, 18, 1, false, 8, null);
        this.add((Actor)popLabel).minWidth(26.0f);
    }

    private final void addCityGrowthBar(City city) {
        String turnLabelText;
        Integer turnsToStarvation;
        Integer turnsToGrowth;
        ImmutableColor textColor = city.getCiv().getNation().getInnerColor();
        Table table2 = new Table();
        float growthPercentage = (float)city.getPopulation().getFoodStored() / (float)city.getPopulation().getFoodToNextPopulation();
        if (growthPercentage < 0.0f) {
            growthPercentage = 0.0f;
        }
        if (growthPercentage > 1.0f) {
            growthPercentage = 1.0f;
        }
        float f = city.isStarving() ? 1.0f : growthPercentage;
        Color color = city.isStarving() ? Color.RED : CityButton.Companion.getColorGrowth();
        Intrinsics.checkNotNull(color);
        ImageGetter.ProgressBar growthBar = ImageGetter.INSTANCE.getProgressBarVertical(4.0f, 30.0f, f, color, ImageGetter.INSTANCE.getCHARCOAL(), 1.0f);
        growthBar.getColor().a = 0.8f;
        String string = city.isGrowing() ? ((turnsToGrowth = city.getPopulation().getNumTurnsToNewPopulation()) != null && turnsToGrowth < 100 ? TranslationsKt.tr(turnsToGrowth) : "\u221e") : (city.isStarving() ? ((turnsToStarvation = city.getPopulation().getNumTurnsToStarvation()) != null && turnsToStarvation < 100 ? TranslationsKt.tr(turnsToStarvation) : "\u221e") : (turnLabelText = "-"));
        if (city.isGrowing()) {
            float nextTurnPercentage = (float)(city.foodForNextTurn() + city.getPopulation().getFoodStored()) / (float)city.getPopulation().getFoodToNextPopulation();
            if (nextTurnPercentage < 0.0f) {
                nextTurnPercentage = 0.0f;
            }
            if (nextTurnPercentage > 1.0f) {
                nextTurnPercentage = 1.0f;
            }
            Color color2 = CityButton.Companion.getColorGrowth().cpy();
            Intrinsics.checkNotNullExpressionValue(color2, "cpy(...)");
            growthBar.setSemiProgress(Scene2dExtensionsKt.darken(color2, 0.4f), nextTurnPercentage, 1.0f);
        }
        Label turnLabel = Scene2dExtensionsKt.toLabel$default(turnLabelText, textColor, 13, 0, false, 12, null);
        table2.add((Actor)growthBar).padRight(2.0f);
        table2.add((Actor)turnLabel).expandY().bottom();
        this.add((Actor)table2).minWidth(6.0f).padLeft(2.0f);
    }

    private final void addCityText(City city, boolean forPopup) {
        Religion cityReligion;
        ImmutableColor textColor = city.getCiv().getNation().getInnerColor();
        Table table2 = new Table();
        Actor $this$addCityText_u24lambda_u240 = table2;
        boolean bl = false;
        ((Group)$this$addCityText_u24lambda_u240).setTransform(false);
        Table table3 = table2;
        if (city.isCapital()) {
            Actor actor;
            if (city.getCiv().isCityState()) {
                Actor $this$addCityText_u24lambda_u241 = $this$addCityText_u24lambda_u240 = ImageGetter.INSTANCE.getNationIcon("CityState");
                boolean bl2 = false;
                $this$addCityText_u24lambda_u241.setColor(textColor);
                actor = $this$addCityText_u24lambda_u240;
            } else {
                actor = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Capital", null, 2, null);
            }
            Image capitalIcon = actor;
            table3.add((Actor)capitalIcon).size(20.0f).padRight(5.0f);
        }
        Label cityName = Scene2dExtensionsKt.toLabel$default(city.getName(), textColor, 0, 1, true, 2, null);
        Cell<Actor> cell = table3.add((Actor)cityName).growY().center();
        Intrinsics.checkNotNullExpressionValue(cell, "center(...)");
        IconTextButtonKt.padTopDescent(cell);
        if (!forPopup && (cityReligion = city.getReligion().getMajorityReligion()) != null) {
            Image image;
            Image $this$addCityText_u24lambda_u242 = image = ImageGetter.INSTANCE.getReligionIcon(cityReligion.getIconName());
            boolean bl3 = false;
            $this$addCityText_u24lambda_u242.setColor(textColor);
            Group religionImage = Scene2dExtensionsKt.toGroup(image, 20.0f);
            table3.add((Actor)religionImage).size(20.0f).padLeft(5.0f);
        }
        table3.pack();
        this.add((Actor)table3).minHeight(34.0f).padLeft(10.0f).padRight(10.0f).expandY().center();
    }

    private final void addCityConstruction(City city) {
        ImmutableColor textColor = city.getCiv().getNation().getInnerColor();
        CityConstructions cityConstructions = city.getCityConstructions();
        IConstruction cityCurrentConstruction = cityConstructions.getCurrentConstruction();
        Table progressTable = new Table();
        float nextTurnPercentage = 0.0f;
        float percentage = 0.0f;
        String turns = "-";
        Group icon = null;
        if (((CharSequence)cityConstructions.currentConstructionName()).length() > 0) {
            if (!(cityCurrentConstruction instanceof PerpetualConstruction)) {
                int turnsToConstruction = CityConstructions.turnsToConstruction$default(cityConstructions, cityCurrentConstruction.getName(), false, 2, null);
                if (turnsToConstruction < 100) {
                    turns = TranslationsKt.tr(turnsToConstruction);
                }
                float f = cityConstructions.getWorkDone(cityCurrentConstruction.getName());
                Intrinsics.checkNotNull(cityCurrentConstruction, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
                percentage = f / (float)((INonPerpetualConstruction)cityCurrentConstruction).getProductionCost(cityConstructions.getCity().getCiv(), cityConstructions.getCity());
                nextTurnPercentage = ((float)cityConstructions.getWorkDone(cityCurrentConstruction.getName()) + city.getCityStats().getCurrentCityStats().getProduction()) / (float)((INonPerpetualConstruction)cityCurrentConstruction).getProductionCost(cityConstructions.getCity().getCiv(), cityConstructions.getCity());
                if (nextTurnPercentage > 1.0f) {
                    nextTurnPercentage = 1.0f;
                }
                if (nextTurnPercentage < 0.0f) {
                    nextTurnPercentage = 0.0f;
                }
            } else {
                turns = "\u221e";
            }
            icon = ImageGetter.INSTANCE.getConstructionPortrait(cityCurrentConstruction.getName(), 24.0f);
        }
        ImageGetter.ProgressBar productionBar = ImageGetter.INSTANCE.getProgressBarVertical(4.0f, 30.0f, percentage, CityButton.Companion.getColorConstruction(), ImageGetter.INSTANCE.getCHARCOAL(), 1.0f);
        Color color = CityButton.Companion.getColorConstruction().cpy();
        Intrinsics.checkNotNullExpressionValue(color, "cpy(...)");
        productionBar.setSemiProgress(Scene2dExtensionsKt.darken(color, 0.4f), nextTurnPercentage, 1.0f);
        productionBar.getColor().a = 0.8f;
        progressTable.add((Actor)Scene2dExtensionsKt.toLabel$default(turns, textColor, 13, 0, false, 12, null)).expandY().bottom();
        progressTable.add((Actor)productionBar).padLeft(2.0f);
        this.add((Actor)progressTable).minWidth(6.0f).padRight(2.0f);
        this.add((Actor)icon).minWidth(26.0f);
    }

    private final void addCivIcon(City city) {
        Image icon = city.getCiv().isMajorCiv() ? ImageGetter.INSTANCE.getNationIcon(city.getCiv().getNation().getName()) : ImageGetter.getImage$default(ImageGetter.INSTANCE, "CityStateIcons/" + city.getCiv().getCityStateType().getName(), null, 2, null);
        icon.setColor(city.getCiv().getNation().getInnerColor());
        this.add((Actor)Scene2dExtensionsKt.toGroup(icon, 20.0f)).minWidth(26.0f);
    }
}

