/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.civilopediascreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.Array;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.stats.INamed;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.TutorialController;
import com.unciv.ui.screens.civilopediascreen.CivilopediaCategories;
import com.unciv.ui.screens.civilopediascreen.CivilopediaScreen;
import com.unciv.ui.screens.civilopediascreen.CivilopediaSearchPopup;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.ICivilopediaText;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002'(B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\f\u0010 \u001a\u00020\t*\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\t*\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u00020\t*\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup;", "Lcom/unciv/ui/popups/Popup;", "pediaScreen", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen;", "tutorialController", "Lcom/unciv/ui/screens/basescreen/TutorialController;", "linkAction", "Lkotlin/Function1;", "", "", "<init>", "(Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen;Lcom/unciv/ui/screens/basescreen/TutorialController;Lkotlin/jvm/functions/Function1;)V", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "searchText", "Lcom/unciv/ui/components/widgets/UncivTextField;", "modSelect", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup$ModSelectBox;", "resultExpander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "resultCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "searchButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "searchJob", "Lkotlinx/coroutines/Job;", "checkLine", "", "isSearchRunning", "startSearch", "text", "searchLoop", "Lkotlinx/coroutines/CoroutineScope;", "searchEntry", "entry", "Lcom/unciv/ui/screens/civilopediascreen/ICivilopediaText;", "addResult", "finishSearch", "ModSelectEntry", "ModSelectBox", "core"})
@SourceDebugExtension(value={"SMAP\nCivilopediaSearchPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CivilopediaSearchPopup.kt\ncom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1740#2,3:194\n*S KotlinDebug\n*F\n+ 1 CivilopediaSearchPopup.kt\ncom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup\n*L\n91#1:194,3\n*E\n"})
public final class CivilopediaSearchPopup
extends Popup {
    @NotNull
    private final CivilopediaScreen pediaScreen;
    @NotNull
    private final TutorialController tutorialController;
    @NotNull
    private final Function1<String, Unit> linkAction;
    @NotNull
    private Ruleset ruleset;
    @NotNull
    private final UncivTextField searchText;
    @NotNull
    private final ModSelectBox modSelect;
    private ExpanderTab resultExpander;
    @NotNull
    private final Cell<Actor> resultCell;
    @NotNull
    private final TextButton searchButton;
    @Nullable
    private Job searchJob;
    @NotNull
    private Function1<? super String, Boolean> checkLine;

    public CivilopediaSearchPopup(@NotNull CivilopediaScreen pediaScreen, @NotNull TutorialController tutorialController, @NotNull Function1<? super String, Unit> linkAction) {
        Intrinsics.checkNotNullParameter(pediaScreen, "pediaScreen");
        Intrinsics.checkNotNullParameter(tutorialController, "tutorialController");
        Intrinsics.checkNotNullParameter(linkAction, "linkAction");
        super(pediaScreen, null, 0.0f, 6, null);
        this.pediaScreen = pediaScreen;
        this.tutorialController = tutorialController;
        this.linkAction = linkAction;
        this.ruleset = this.pediaScreen.getRuleset();
        this.searchText = new UncivTextField("", null, null, 6, null);
        this.modSelect = new ModSelectBox();
        this.checkLine = CivilopediaSearchPopup::checkLine$lambda$0;
        this.searchText.setMaxLength(100);
        this.add((Actor)Scene2dExtensionsKt.toLabel("Search text:"));
        this.add((Actor)this.searchText).growX().row();
        this.add((Actor)Scene2dExtensionsKt.toLabel("Mod filter:"));
        this.add((Actor)this.modSelect).growX().row();
        Cell<Actor> cell = this.add().colspan(2).growX();
        Intrinsics.checkNotNullExpressionValue(cell, "growX(...)");
        this.resultCell = cell;
        this.row();
        Object t = Popup.addButton$default((Popup)this, "Search!", KeyCharAndCode.Companion.getRETURN(), null, () -> CivilopediaSearchPopup._init_$lambda$0(this), 4, null).getActor();
        Intrinsics.checkNotNullExpressionValue(t, "getActor(...)");
        this.searchButton = (TextButton)t;
        Popup.addCloseButton$default(this, null, null, null, null, 15, null);
        this.getShowListeners().add(() -> CivilopediaSearchPopup._init_$lambda$1(this));
        this.getCloseListeners().add(() -> CivilopediaSearchPopup._init_$lambda$2(this));
    }

    private final boolean isSearchRunning() {
        Job job2 = this.searchJob;
        return job2 != null ? job2.isActive() : false;
    }

    private final void startSearch(String text2) {
        Scene2dExtensionsKt.disable(this.searchButton);
        Gdx.input.setOnscreenKeyboardVisible(false);
        if (((CharSequence)text2).length() == 0) {
            this.checkLine = CivilopediaSearchPopup::startSearch$lambda$0;
        } else if (StringsKt.contains$default((CharSequence)text2, ".*", false, 2, null) || StringsKt.contains$default((CharSequence)text2, '\\', false, 2, null) || StringsKt.contains$default((CharSequence)text2, '|', false, 2, null)) {
            try {
                Regex regex = new Regex(text2, RegexOption.IGNORE_CASE);
                this.checkLine = arg_0 -> CivilopediaSearchPopup.startSearch$lambda$1(regex, arg_0);
            }
            catch (Exception ex) {
                new ToastPopup("Invalid regular expression", this.pediaScreen, 4000L);
                Scene2dExtensionsKt.enable(this.searchButton);
                return;
            }
        } else {
            char[] cArray = new char[]{' '};
            Set words = CollectionsKt.toSet(StringsKt.split$default((CharSequence)text2, cArray, false, 0, 6, null));
            this.checkLine = arg_0 -> CivilopediaSearchPopup.startSearch$lambda$2(words, arg_0);
        }
        this.ruleset = this.modSelect.selectedRuleset();
        if (this.resultExpander != null) {
            ExpanderTab expanderTab = this.resultExpander;
            if (expanderTab == null) {
                Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
                expanderTab = null;
            }
            expanderTab.getInnerTable().clear();
        } else {
            this.resultExpander = new ExpanderTab("Results", 0, null, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, null, null, CivilopediaSearchPopup::startSearch$lambda$3, 4094, null);
            ExpanderTab expanderTab = this.resultExpander;
            if (expanderTab == null) {
                Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
                expanderTab = null;
            }
            this.resultCell.setActor((Actor)expanderTab);
            ExpanderTab expanderTab2 = this.resultExpander;
            if (expanderTab2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
                expanderTab2 = null;
            }
            expanderTab2.getInnerTable().defaults().growX().pad(2.0f);
        }
        Job job2 = this.searchJob = Concurrency.run$default(Concurrency.INSTANCE, "PediaSearch", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CivilopediaSearchPopup this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        CivilopediaSearchPopup.access$searchLoop(this.this$0, (CoroutineScope)$this$run);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        Intrinsics.checkNotNull(job2);
        job2.invokeOnCompletion(arg_0 -> CivilopediaSearchPopup.startSearch$lambda$4(this, arg_0));
    }

    private final void searchLoop(CoroutineScope $this$searchLoop) {
        GameInfo gameInfo = UncivGame.Companion.getGameInfoOrNull();
        block0: for (CivilopediaCategories category : CivilopediaCategories.getEntries()) {
            if (!CoroutineScopeKt.isActive($this$searchLoop)) break;
            if (!this.ruleset.getModOptions().isBaseRuleset() && category == CivilopediaCategories.Tutorial) continue;
            for (ICivilopediaText entry : category.getGetCategoryIterator().invoke(this.ruleset, this.tutorialController, gameInfo)) {
                if (!CoroutineScopeKt.isActive($this$searchLoop)) continue block0;
                if (!(entry instanceof INamed)) continue;
                if (!this.ruleset.getModOptions().isBaseRuleset()) {
                    int sort = entry.getSortGroup(this.ruleset);
                    if (category == CivilopediaCategories.UnitType && sort < 2 || category == CivilopediaCategories.Belief && sort == 0) continue;
                }
                if (entry instanceof IHasUniques && ((IHasUniques)((Object)entry)).isHiddenFromCivilopedia(gameInfo, this.ruleset)) continue;
                this.searchEntry($this$searchLoop, entry);
            }
        }
    }

    private final void searchEntry(CoroutineScope $this$searchEntry, ICivilopediaText entry) {
        Sequence scope2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>(entry, this, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ICivilopediaText $entry;
            final /* synthetic */ CivilopediaSearchPopup this$0;
            {
                this.$entry = $entry;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        v0 = this.$entry.getCivilopediaTextHeader();
                        if (v0 == null) break;
                        it = v0;
                        $i$a$-let-CivilopediaSearchPopup$searchEntry$scope$1$1 = 0;
                        this.L$0 = $this$sequence;
                        this.L$1 = SpillingKt.nullOutSpilledVariable(it);
                        this.I$0 = $i$a$-let-CivilopediaSearchPopup$searchEntry$scope$1$1;
                        this.label = 1;
                        v1 = $this$sequence.yield(it, this);
                        if (v1 == var5_3) {
                            return var5_3;
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-let-CivilopediaSearchPopup$searchEntry$scope$1$1 = this.I$0;
                        it = (FormattedLine)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        break;
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = null;
                this.label = 2;
                v2 = $this$sequence.yieldAll((Iterable)this.$entry.getCivilopediaText(), (Continuation<? super Unit>)this);
                if (v2 == var5_3) {
                    return var5_3;
                }
                ** GOTO lbl36
                {
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl36:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.label = 3;
                        v3 = $this$sequence.yieldAll((Iterable)this.$entry.getCivilopediaTextLines(CivilopediaSearchPopup.access$getRuleset$p(this.this$0)), (Continuation<? super Unit>)this);
                        if (v3 == var5_3) {
                            return var5_3;
                        }
                        ** GOTO lbl45
                    }
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl45:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super FormattedLine> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        Iterator iterator2 = scope2.iterator();
        while (iterator2.hasNext()) {
            FormattedLine line = (FormattedLine)iterator2.next();
            if (!CoroutineScopeKt.isActive($this$searchEntry)) break;
            String lineText = TranslationsKt.tr$default(line.getText(), true, false, 2, null);
            if (!this.checkLine.invoke(lineText).booleanValue()) continue;
            this.addResult($this$searchEntry, entry);
            break;
        }
    }

    private final void addResult(CoroutineScope $this$addResult, ICivilopediaText entry) {
        ConcurrencyKt.launchOnGLThread$default($this$addResult, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(entry, this, null){
            int label;
            final /* synthetic */ ICivilopediaText $entry;
            final /* synthetic */ CivilopediaSearchPopup this$0;
            {
                this.$entry = $entry;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        Label actor = Scene2dExtensionsKt.toLabel$default(this.$entry.getIconName(), null, 0, 8, false, 11, null);
                        String link = this.$entry.makeLink();
                        ExpanderTab expanderTab = CivilopediaSearchPopup.access$getResultExpander$p(this.this$0);
                        if (expanderTab == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
                            expanderTab = null;
                        }
                        expanderTab.getInnerTable().add((Actor)actor).row();
                        ActivationExtensionsKt.onClick(actor, () -> addResult.1.invokeSuspend$lambda$0(this.this$0, link));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(CivilopediaSearchPopup this$0, String $link) {
                CivilopediaSearchPopup.access$getLinkAction$p(this$0).invoke($link);
                this$0.close();
                return Unit.INSTANCE;
            }
        }, 1, null);
    }

    private final void finishSearch() {
        Scene2dExtensionsKt.enable(this.searchButton);
        ExpanderTab expanderTab = this.resultExpander;
        if (expanderTab == null) {
            Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
            expanderTab = null;
        }
        if (!expanderTab.getInnerTable().getCells().isEmpty()) {
            return;
        }
        Actor nothingFound = FormattedLine.render$default(new FormattedLine("Nothing found!", null, null, null, 0.0f, 0, 3, 0, 0.0f, "#f53", false, false, true, false, 11710, null), 0.0f, null, 2, null);
        ExpanderTab expanderTab2 = this.resultExpander;
        if (expanderTab2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
            expanderTab2 = null;
        }
        expanderTab2.getInnerTable().add(nothingFound);
    }

    private static final boolean checkLine$lambda$0(String string) {
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        return false;
    }

    private static final Unit _init_$lambda$0(CivilopediaSearchPopup this$0) {
        String string = this$0.searchText.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        this$0.startSearch(string);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(CivilopediaSearchPopup this$0) {
        this$0.setKeyboardFocus(this$0.searchText);
        this$0.searchText.selectAll();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(CivilopediaSearchPopup this$0) {
        if (this$0.isSearchRunning()) {
            Job job2 = this$0.searchJob;
            Intrinsics.checkNotNull(job2);
            Job.DefaultImpls.cancel$default(job2, null, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean startSearch$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean startSearch$lambda$1(Regex $regex, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $regex.containsMatchIn(it);
    }

    private static final boolean startSearch$lambda$2(Set $words, String line) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(line, "line");
            Iterable $this$all$iv = $words;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (StringsKt.contains((CharSequence)line, it, true)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final Unit startSearch$lambda$3(Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final Unit startSearch$lambda$4(CivilopediaSearchPopup this$0, Throwable it) {
        this$0.searchJob = null;
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ CivilopediaSearchPopup this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        CivilopediaSearchPopup.access$finishSearch(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$searchLoop(CivilopediaSearchPopup $this, CoroutineScope $receiver) {
        $this.searchLoop($receiver);
    }

    public static final /* synthetic */ Ruleset access$getRuleset$p(CivilopediaSearchPopup $this) {
        return $this.ruleset;
    }

    public static final /* synthetic */ ExpanderTab access$getResultExpander$p(CivilopediaSearchPopup $this) {
        return $this.resultExpander;
    }

    public static final /* synthetic */ Function1 access$getLinkAction$p(CivilopediaSearchPopup $this) {
        return $this.linkAction;
    }

    public static final /* synthetic */ void access$finishSearch(CivilopediaSearchPopup $this) {
        $this.finishSearch();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup$ModSelectBox;", "Lcom/badlogic/gdx/scenes/scene2d/ui/SelectBox;", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup$ModSelectEntry;", "<init>", "(Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup;)V", "selectedRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
    private final class ModSelectBox
    extends SelectBox<ModSelectEntry> {
        public ModSelectBox() {
            super(BaseScreen.Companion.getSkin());
            LinkedHashSet<String> mods = CivilopediaSearchPopup.this.pediaScreen.getRuleset().getMods();
            Array<ModSelectEntry> entries2 = new Array<ModSelectEntry>(mods.size() + 1);
            entries2.add(new ModSelectEntry("-Combined-", true));
            Iterable iterable = mods;
            Set<String> set = RulesetCache.INSTANCE.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            for (String mod : CollectionsKt.intersect(iterable, (Iterable)set)) {
                entries2.add(new ModSelectEntry(mod, false, 2, null));
            }
            this.setItems(entries2);
            this.setSelectedIndex(0);
        }

        @NotNull
        public final Ruleset selectedRuleset() {
            Ruleset ruleset;
            if (this.getSelectedIndex() == 0) {
                ruleset = CivilopediaSearchPopup.this.pediaScreen.getRuleset();
            } else {
                Object object = RulesetCache.INSTANCE.get((Object)((ModSelectEntry)this.getSelected()).getKey());
                Intrinsics.checkNotNull(object);
                ruleset = (Ruleset)object;
            }
            return ruleset;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup$ModSelectEntry;", "", "key", "", "translate", "", "<init>", "(Ljava/lang/String;Z)V", "getKey", "()Ljava/lang/String;", "getTranslate", "()Z", "toString", "core"})
    public static final class ModSelectEntry {
        @NotNull
        private final String key;
        private final boolean translate;

        public ModSelectEntry(@NotNull String key, boolean translate) {
            Intrinsics.checkNotNullParameter(key, "key");
            this.key = key;
            this.translate = translate;
        }

        public /* synthetic */ ModSelectEntry(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(string, bl);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final boolean getTranslate() {
            return this.translate;
        }

        @NotNull
        public String toString() {
            return this.translate ? TranslationsKt.tr$default(this.key, false, false, 3, null) : this.key;
        }
    }
}

