/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.UncivSound;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.overviewscreen.EspionageOverviewScreen;
import com.unciv.ui.screens.pickerscreens.PolicyPickerScreen;
import com.unciv.ui.screens.pickerscreens.TechButton;
import com.unciv.ui.screens.pickerscreens.TechPickerScreen;
import com.unciv.ui.screens.worldscreen.UndoHandler;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020 H\u0002J\b\u0010$\u001a\u00020\u001eH\u0002J\b\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u00020 2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020)H\u0016J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/unciv/ui/screens/worldscreen/TechPolicyDiplomacyButtons;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "fogOfWarButtonHolder", "Lcom/badlogic/gdx/scenes/scene2d/ui/Container;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "fogOfWarButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "techButtonHolder", "pickTechButton", "pickTechLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "policyButtonHolder", "policyScreenButton", "diplomacyButtonHolder", "diplomacyButton", "undoButtonHolder", "undoButton", "espionageButtonHolder", "espionageButton", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "game", "Lcom/unciv/UncivGame;", "update", "", "updateFogOfWarButton", "", "updateTechButton", "updateUndoButton", "updatePolicyButton", "updateDiplomacyButton", "updateEspionageButton", "handleUndo", "act", "delta", "", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "core"})
public final class TechPolicyDiplomacyButtons
extends Table {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final Container<Button> fogOfWarButtonHolder;
    @NotNull
    private final TextButton fogOfWarButton;
    @NotNull
    private final Container<Table> techButtonHolder;
    @NotNull
    private final Table pickTechButton;
    @NotNull
    private final Label pickTechLabel;
    @NotNull
    private final Container<Button> policyButtonHolder;
    @NotNull
    private final Button policyScreenButton;
    @NotNull
    private final Container<Button> diplomacyButtonHolder;
    @NotNull
    private final Button diplomacyButton;
    @NotNull
    private final Container<Button> undoButtonHolder;
    @NotNull
    private final Button undoButton;
    @NotNull
    private final Container<Button> espionageButtonHolder;
    @NotNull
    private final Button espionageButton;
    @NotNull
    private final Civilization viewingCiv;
    @NotNull
    private final UncivGame game;

    public TechPolicyDiplomacyButtons(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.worldScreen = worldScreen;
        this.fogOfWarButtonHolder = new Container();
        this.fogOfWarButton = Scene2dExtensionsKt.toTextButton$default("Fog of War", null, false, 3, null);
        this.techButtonHolder = new Container();
        this.pickTechButton = new Table(this.getSkin());
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.pickTechLabel = Scene2dExtensionsKt.toLabel$default("", color, 30, 0, false, 12, null);
        this.policyButtonHolder = new Container();
        this.policyScreenButton = new Button(this.getSkin());
        this.diplomacyButtonHolder = new Container();
        this.diplomacyButton = new Button(this.getSkin());
        this.undoButtonHolder = new Container();
        this.undoButton = new Button(this.getSkin());
        this.espionageButtonHolder = new Container();
        this.espionageButton = new Button(this.getSkin());
        this.viewingCiv = this.worldScreen.getViewingCiv();
        this.game = this.worldScreen.getGame();
        this.defaults().left();
        this.add((Actor)this.fogOfWarButtonHolder).colspan(4).row();
        this.add((Actor)this.techButtonHolder).colspan(4).row();
        this.add((Actor)this.policyButtonHolder).padTop(10.0f).padRight(10.0f);
        this.add((Actor)this.diplomacyButtonHolder).padTop(10.0f).padRight(10.0f);
        this.add((Actor)this.espionageButtonHolder).padTop(10.0f).padRight(10.0f);
        this.add((Actor)this.undoButtonHolder).padTop(10.0f).padRight(10.0f);
        this.add().growX();
        Label label = this.fogOfWarButton.getLabel();
        Intrinsics.checkNotNullExpressionValue(label, "getLabel(...)");
        Scene2dExtensionsKt.setFontSize(label, 30);
        this.fogOfWarButton.getLabelCell().pad(10.0f);
        this.fogOfWarButton.pack();
        ActivationExtensionsKt.onActivation(this.fogOfWarButtonHolder, UncivSound.Companion.getPaper(), KeyboardBinding.TechnologyTree, () -> TechPolicyDiplomacyButtons._init_$lambda$0(this));
        this.pickTechButton.setBackground(BaseScreen.Companion.getSkinStrings().getUiBackground("WorldScreen/PickTechButton", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), Scene2dExtensionsKt.colorFromRGB(7, 46, 43)));
        this.pickTechButton.defaults().pad(20.0f);
        this.pickTechButton.add((Actor)this.pickTechLabel);
        ActivationExtensionsKt.onActivation(this.techButtonHolder, UncivSound.Companion.getPaper(), KeyboardBinding.TechnologyTree, () -> TechPolicyDiplomacyButtons._init_$lambda$1(this));
        this.undoButton.add((Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Undo", null, 2, null)).size(30.0f).pad(15.0f);
        ActivationExtensionsKt.onActivation$default(this.undoButton, null, KeyboardBinding.Undo, () -> TechPolicyDiplomacyButtons._init_$lambda$2(this), 1, null);
        this.policyScreenButton.add((Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Policies", null, 2, null)).size(30.0f).pad(15.0f);
        ActivationExtensionsKt.onActivation$default(this.policyButtonHolder, null, KeyboardBinding.SocialPolicies, () -> TechPolicyDiplomacyButtons._init_$lambda$3(this), 1, null);
        this.diplomacyButton.add((Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/DiplomacyW", null, 2, null)).size(30.0f).pad(15.0f);
        ActivationExtensionsKt.onActivation$default(this.diplomacyButtonHolder, null, KeyboardBinding.Diplomacy, () -> TechPolicyDiplomacyButtons._init_$lambda$4(this), 1, null);
        GameInfo gameInfo = this.game.getGameInfo();
        Intrinsics.checkNotNull(gameInfo);
        if (gameInfo.isEspionageEnabled()) {
            this.espionageButton.add((Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Espionage", null, 2, null)).size(30.0f).pad(15.0f);
            ActivationExtensionsKt.onActivation$default(this.espionageButtonHolder, null, KeyboardBinding.Espionage, () -> TechPolicyDiplomacyButtons._init_$lambda$5(this), 1, null);
        }
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    public final boolean update() {
        this.updateFogOfWarButton();
        this.updateTechButton();
        this.updateUndoButton();
        this.updatePolicyButton();
        boolean result2 = this.updateDiplomacyButton();
        GameInfo gameInfo = this.game.getGameInfo();
        Intrinsics.checkNotNull(gameInfo);
        if (gameInfo.isEspionageEnabled()) {
            this.updateEspionageButton();
        }
        this.pack();
        this.setPosition(10.0f, this.worldScreen.getTopBar$core().getY() - this.getHeight() - 15.0f);
        return result2;
    }

    private final void updateFogOfWarButton() {
        if (this.viewingCiv.isSpectator()) {
            this.fogOfWarButtonHolder.setActor((Button)((Actor)this.fogOfWarButton));
            this.fogOfWarButtonHolder.setTouchable(Touchable.enabled);
        } else {
            this.fogOfWarButtonHolder.setTouchable(Touchable.disabled);
            this.fogOfWarButtonHolder.setActor(null);
        }
    }

    private final void updateTechButton() {
        this.techButtonHolder.setTouchable(Touchable.disabled);
        this.techButtonHolder.setActor(null);
        if (this.worldScreen.getGameInfo().getRuleset().getTechnologies().isEmpty() || this.viewingCiv.getCities().isEmpty()) {
            return;
        }
        this.techButtonHolder.setTouchable(Touchable.enabled);
        if (this.viewingCiv.getTech().currentTechnology() != null) {
            String string = this.viewingCiv.getTech().currentTechnologyName();
            Intrinsics.checkNotNull(string);
            String currentTech = string;
            TechButton innerButton = new TechButton(currentTech, this.viewingCiv.getTech(), false, 4, null);
            innerButton.setButtonColor(Scene2dExtensionsKt.colorFromRGB(7, 46, 43));
            this.techButtonHolder.setActor((Table)((Actor)innerButton));
            String turnsToTech = this.viewingCiv.getTech().turnsToTech(currentTech);
            innerButton.getText$core().setText(TranslationsKt.tr$default(currentTech, true, false, 2, null));
            innerButton.getTurns$core().setText(turnsToTech + '\u23f3');
        } else {
            boolean canResearch = this.viewingCiv.getTech().canResearchTech();
            if (canResearch || this.viewingCiv.getTech().getResearchedTechnologies().size() != 0) {
                String text2 = canResearch ? "{Pick a tech}!" : "Technologies";
                this.pickTechLabel.setText(TranslationsKt.tr$default(text2, false, false, 3, null));
                this.techButtonHolder.setActor((Table)((Actor)this.pickTechButton));
            }
        }
    }

    private final void updateUndoButton() {
        if (UndoHandler.Companion.canUndo(this.worldScreen)) {
            this.undoButtonHolder.setTouchable(Touchable.enabled);
            this.undoButtonHolder.setActor((Button)((Actor)this.undoButton));
        } else {
            this.undoButtonHolder.setTouchable(Touchable.disabled);
            this.undoButtonHolder.setActor(null);
        }
    }

    private final void updatePolicyButton() {
        if (!((Collection)this.viewingCiv.getPolicies().getAdoptedPolicies$core()).isEmpty() || this.viewingCiv.getPolicies().canAdoptPolicy()) {
            this.policyButtonHolder.setTouchable(Touchable.enabled);
            this.policyButtonHolder.setActor((Button)((Actor)this.policyScreenButton));
        } else {
            this.policyButtonHolder.setTouchable(Touchable.disabled);
            this.policyButtonHolder.setActor(null);
        }
    }

    private final boolean updateDiplomacyButton() {
        boolean bl;
        if (this.viewingCiv.isDefeated() || this.viewingCiv.isSpectator() || SequencesKt.none(SequencesKt.filterNot(this.viewingCiv.getKnownCivs(), arg_0 -> TechPolicyDiplomacyButtons.updateDiplomacyButton$lambda$0(this, arg_0)))) {
            this.diplomacyButtonHolder.setTouchable(Touchable.disabled);
            this.diplomacyButtonHolder.setActor(null);
            bl = false;
        } else {
            this.diplomacyButtonHolder.setTouchable(Touchable.enabled);
            this.diplomacyButtonHolder.setActor((Button)((Actor)this.diplomacyButton));
            bl = true;
        }
        return bl;
    }

    private final void updateEspionageButton() {
        if (this.worldScreen.getSelectedCiv().getEspionageManager().getSpyList().isEmpty()) {
            this.espionageButtonHolder.setTouchable(Touchable.disabled);
            this.espionageButtonHolder.setActor(null);
        } else {
            this.espionageButtonHolder.setTouchable(Touchable.enabled);
            this.espionageButtonHolder.setActor((Button)((Actor)this.espionageButton));
        }
    }

    private final void handleUndo() {
        Scene2dExtensionsKt.disable(this.undoButton);
        UndoHandler.Companion.restoreUndoCheckpoint(this.worldScreen);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return super.hit(x, y, touchable);
    }

    private static final Unit _init_$lambda$0(TechPolicyDiplomacyButtons this$0) {
        this$0.worldScreen.setFogOfWar(!this$0.worldScreen.getFogOfWar());
        this$0.worldScreen.setShouldUpdate(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TechPolicyDiplomacyButtons this$0) {
        this$0.game.pushScreen(new TechPickerScreen(this$0.viewingCiv, null, 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(TechPolicyDiplomacyButtons this$0) {
        this$0.handleUndo();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(TechPolicyDiplomacyButtons this$0) {
        this$0.game.pushScreen(new PolicyPickerScreen(this$0.worldScreen.getSelectedCiv(), this$0.worldScreen.getCanChangeState(), null, 4, null));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(TechPolicyDiplomacyButtons this$0) {
        this$0.game.pushScreen(new DiplomacyScreen(this$0.viewingCiv, null, null, false, 14, null));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(TechPolicyDiplomacyButtons this$0) {
        if (this$0.worldScreen.getBottomUnitTable$core().getSelectedSpy() != null) {
            this$0.worldScreen.getBottomUnitTable$core().selectSpy(null);
        }
        this$0.game.pushScreen(new EspionageOverviewScreen(this$0.worldScreen.getSelectedCiv(), this$0.worldScreen));
        return Unit.INSTANCE;
    }

    private static final boolean updateDiplomacyButton$lambda$0(TechPolicyDiplomacyButtons this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, this$0.viewingCiv) || it.isBarbarian();
    }
}

