/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AaptInvoker;
import brut.androlib.ApktoolProperties;
import brut.androlib.BackgroundWorker;
import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.Framework;
import brut.androlib.res.xml.ResXmlUtils;
import brut.androlib.src.SmaliBuilder;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.directory.ZipUtils;
import brut.util.AaptManager;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;

public class ApkBuilder {
    private static final Logger LOGGER = Logger.getLogger(ApkBuilder.class.getName());
    private final ExtFile mApkDir;
    private final Config mConfig;
    private final AtomicReference<AndrolibException> mBuildError;
    private ApkInfo mApkInfo;
    private int mMinSdkVersion;
    private BackgroundWorker mWorker;

    public ApkBuilder(ExtFile apkDir, Config config) {
        this.mApkDir = apkDir;
        this.mConfig = config;
        this.mBuildError = new AtomicReference<Object>(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(File outApk) throws AndrolibException {
        block26: {
            if (this.mConfig.getJobs() > 1) {
                this.mWorker = new BackgroundWorker(this.mConfig.getJobs() - 1);
            }
            try {
                this.mApkInfo = ApkInfo.load(this.mApkDir);
                String minSdkVersion = this.mApkInfo.getMinSdkVersion();
                if (minSdkVersion != null) {
                    this.mMinSdkVersion = this.mApkInfo.getMinSdkVersionFromAndroidCodename(minSdkVersion);
                }
                if (outApk == null) {
                    String outFileName = this.mApkInfo.apkFileName;
                    if (outFileName == null) {
                        outFileName = "out.apk";
                    }
                    outApk = new File(this.mApkDir, "dist/" + outFileName);
                }
                File outDir = new File(this.mApkDir, "build/apk");
                OS.mkdir(outDir);
                File manifest = new File(this.mApkDir, "AndroidManifest.xml");
                File manifestOrig = new File(this.mApkDir, "AndroidManifest.xml.orig");
                LOGGER.info("Using Apktool " + ApktoolProperties.getVersion() + " on " + outApk.getName() + (this.mWorker != null ? " with " + this.mConfig.getJobs() + " threads" : ""));
                this.buildSources(outDir);
                this.backupManifestFile(manifest, manifestOrig);
                this.buildResources(outDir, manifest);
                if (this.mWorker != null) {
                    this.mWorker.waitForFinish();
                    if (this.mBuildError.get() != null) {
                        throw this.mBuildError.get();
                    }
                }
                if (!this.mConfig.isNoApk()) {
                    if (outApk.exists()) {
                        OS.rmfile(outApk);
                    } else {
                        File parentDir = outApk.getParentFile();
                        if (parentDir != null) {
                            OS.mkdir(parentDir);
                        }
                    }
                    this.copyOriginalFiles(outDir);
                    LOGGER.info("Building apk file...");
                    try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(outApk.toPath(), new OpenOption[0]));){
                        try {
                            ZipUtils.zipDir(outDir, out, this.mApkInfo.doNotCompress);
                        }
                        catch (IOException ex) {
                            throw new AndrolibException(ex);
                        }
                        this.importRawFiles(out);
                        this.importUnknownFiles(out);
                    }
                    catch (IOException ex) {
                        throw new AndrolibException(ex);
                    }
                    LOGGER.info("Built apk into: " + outApk.getPath());
                }
                if (!manifestOrig.isFile()) break block26;
                try {
                    OS.mvfile(manifestOrig, manifest);
                }
                catch (BrutException ex) {
                    throw new AndrolibException(ex);
                }
            }
            finally {
                if (this.mWorker != null) {
                    this.mWorker.shutdownNow();
                }
            }
        }
    }

    private void buildSources(File outDir) throws AndrolibException {
        if (!this.copySourcesRaw(outDir, "classes.dex")) {
            this.buildSourcesSmali(outDir, "smali", "classes.dex");
        }
        try {
            Directory in = this.mApkDir.getDirectory();
            for (String dirName : in.getDirs().keySet()) {
                String fileName;
                if (!dirName.startsWith("smali_") || this.copySourcesRaw(outDir, fileName = dirName.substring(dirName.indexOf("_") + 1) + ".dex")) continue;
                this.buildSourcesSmali(outDir, dirName, fileName);
            }
            for (String fileName : in.getFiles()) {
                if (!fileName.endsWith(".dex") || fileName.equals("classes.dex")) continue;
                this.copySourcesRaw(outDir, fileName);
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean copySourcesRaw(File outDir, String fileName) throws AndrolibException {
        File working = new File(this.mApkDir, fileName);
        if (!working.isFile()) {
            return false;
        }
        File stored = new File(outDir, fileName);
        if (!this.mConfig.isForceBuildAll() && !this.isModified(working, stored)) {
            return true;
        }
        LOGGER.info("Copying raw " + fileName + " file...");
        try {
            BrutIO.copyAndClose(Files.newInputStream(working.toPath(), new OpenOption[0]), Files.newOutputStream(stored.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        return true;
    }

    private void buildSourcesSmali(File outDir, String dirName, String fileName) throws AndrolibException {
        if (this.mWorker != null) {
            this.mWorker.submit(() -> {
                if (this.mBuildError.get() == null) {
                    try {
                        this.buildSourcesSmaliJob(outDir, dirName, fileName);
                    }
                    catch (AndrolibException ex) {
                        this.mBuildError.compareAndSet(null, ex);
                    }
                }
            });
        } else {
            this.buildSourcesSmaliJob(outDir, dirName, fileName);
        }
    }

    private void buildSourcesSmaliJob(File outDir, String dirName, String fileName) throws AndrolibException {
        File smaliDir = new File(this.mApkDir, dirName);
        if (!smaliDir.isDirectory()) {
            return;
        }
        File dex = new File(outDir, fileName);
        if (!this.mConfig.isForceBuildAll()) {
            LOGGER.info("Checking whether sources have changed...");
            if (!this.isModified(smaliDir, dex)) {
                return;
            }
        }
        OS.rmfile(dex);
        LOGGER.info("Smaling " + dirName + " folder into " + fileName + "...");
        int apiLevel = this.mConfig.getApiLevel() > 0 ? this.mConfig.getApiLevel() : this.mMinSdkVersion;
        SmaliBuilder builder = new SmaliBuilder(smaliDir, apiLevel);
        builder.build(dex);
    }

    private void backupManifestFile(File manifest, File manifestOrig) throws AndrolibException {
        if (new File(this.mApkDir, "resources.arsc").isFile()) {
            return;
        }
        if (!manifest.isFile()) {
            return;
        }
        OS.rmfile(manifestOrig);
        try {
            OS.cpfile(manifest, manifestOrig);
            ResXmlUtils.fixingPublicAttrsInProviderAttributes(manifest);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void buildResources(File outDir, File manifest) throws AndrolibException {
        if (!manifest.isFile()) {
            LOGGER.fine("Could not find AndroidManifest.xml");
            return;
        }
        if (new File(this.mApkDir, "resources.arsc").isFile()) {
            this.copyResourcesRaw(outDir, manifest);
        } else if (new File(this.mApkDir, "res").isDirectory()) {
            this.buildResourcesFull(outDir, manifest);
        } else {
            LOGGER.fine("Could not find resources");
            this.buildManifest(outDir, manifest);
        }
    }

    private void copyResourcesRaw(File outDir, File manifest) throws AndrolibException {
        if (!this.mConfig.isForceBuildAll()) {
            LOGGER.info("Checking whether resources have changed...");
            if (!(this.isModified(manifest, new File(outDir, "AndroidManifest.xml")) || this.isModified(new File(this.mApkDir, "resources.arsc"), new File(outDir, "resources.arsc")) || this.isModified(this.newFiles(this.mApkDir, ApkInfo.RESOURCES_DIRNAMES), this.newFiles(outDir, ApkInfo.RESOURCES_DIRNAMES)))) {
                return;
            }
        }
        LOGGER.info("Copying raw resources...");
        try {
            Directory in = this.mApkDir.getDirectory();
            in.copyToDir(outDir, "AndroidManifest.xml");
            in.copyToDir(outDir, "resources.arsc");
            in.copyToDir(outDir, ApkInfo.RESOURCES_DIRNAMES);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void buildResourcesFull(File outDir, File manifest) throws AndrolibException {
        ExtFile tmpFile;
        File resourcesFile = new File(outDir.getParentFile(), "resources.zip");
        if (!this.mConfig.isForceBuildAll()) {
            LOGGER.info("Checking whether resources have changed...");
            if (!(this.isModified(manifest, new File(outDir, "AndroidManifest.xml")) || this.isModified(this.newFiles(this.mApkDir, ApkInfo.RESOURCES_DIRNAMES), this.newFiles(outDir, ApkInfo.RESOURCES_DIRNAMES)) || this.mConfig.getAaptVersion() != 1 && !resourcesFile.isFile())) {
                return;
            }
        }
        OS.rmfile(resourcesFile);
        if (this.mConfig.isDebugMode()) {
            if (this.mConfig.getAaptVersion() == 2) {
                LOGGER.info("Setting 'debuggable' attribute to 'true' in AndroidManifest.xml");
                ResXmlUtils.setApplicationDebugTagTrue(manifest);
            } else {
                ResXmlUtils.removeApplicationDebugTag(manifest);
            }
        }
        if (this.mConfig.isNetSecConf()) {
            String targetSdkVersion = this.mApkInfo.getTargetSdkVersion();
            if (targetSdkVersion != null && Integer.parseInt(targetSdkVersion) < 24) {
                LOGGER.warning("Target SDK version is lower than 24! Network Security Configuration might be ignored!");
            }
            File netSecConfOrig = new File(this.mApkDir, "res/xml/network_security_config.xml");
            ResXmlUtils.modNetworkSecurityConfig(netSecConfOrig);
            ResXmlUtils.setNetworkSecurityConfig(manifest);
            LOGGER.info("Added permissive network security config in manifest");
        }
        try {
            tmpFile = new ExtFile(File.createTempFile("APKTOOL", null));
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        OS.rmfile(tmpFile);
        File resDir = new File(this.mApkDir, "res");
        File ninePatch = new File(this.mApkDir, "9patch");
        if (!ninePatch.isDirectory()) {
            ninePatch = null;
        }
        LOGGER.info("Building resources with " + AaptManager.getAaptName(this.mConfig.getAaptVersion()) + "...");
        try {
            AaptInvoker invoker = new AaptInvoker(this.mApkInfo, this.mConfig);
            invoker.invoke(tmpFile, manifest, resDir, ninePatch, null, this.getIncludeFiles());
            Directory tmpDir = tmpFile.getDirectory();
            tmpDir.copyToDir(outDir, "AndroidManifest.xml");
            tmpDir.copyToDir(outDir, "resources.arsc");
            tmpDir.copyToDir(outDir, ApkInfo.RESOURCES_DIRNAMES);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        finally {
            OS.rmfile(tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildManifest(File outDir, File manifest) throws AndrolibException {
        ExtFile tmpFile;
        if (!this.mConfig.isForceBuildAll()) {
            LOGGER.info("Checking whether AndroidManifest.xml has changed...");
            if (!this.isModified(manifest, new File(outDir, "AndroidManifest.xml"))) {
                return;
            }
        }
        try {
            tmpFile = new ExtFile(File.createTempFile("APKTOOL", null));
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        OS.rmfile(tmpFile);
        File ninePatch = new File(this.mApkDir, "9patch");
        if (!ninePatch.isDirectory()) {
            ninePatch = null;
        }
        LOGGER.info("Building AndroidManifest.xml with " + AaptManager.getAaptName(this.mConfig.getAaptVersion()) + "...");
        try {
            AaptInvoker invoker = new AaptInvoker(this.mApkInfo, this.mConfig);
            invoker.invoke(tmpFile, manifest, null, ninePatch, null, this.getIncludeFiles());
            Directory tmpDir = tmpFile.getDirectory();
            tmpDir.copyToDir(outDir, "AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        catch (AndrolibException ex) {
            LOGGER.warning("Parse AndroidManifest.xml failed, treat it as raw file.");
            this.copyManifestRaw(outDir);
        }
        finally {
            OS.rmfile(tmpFile);
        }
    }

    private void copyManifestRaw(File outDir) throws AndrolibException {
        LOGGER.info("Copying raw manifest...");
        try {
            Directory in = this.mApkDir.getDirectory();
            in.copyToDir(outDir, "AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copyOriginalFiles(File outDir) throws AndrolibException {
        if (!this.mConfig.isCopyOriginalFiles()) {
            return;
        }
        ExtFile originalDir = new ExtFile(this.mApkDir, "original");
        if (!originalDir.isDirectory()) {
            return;
        }
        LOGGER.info("Copying original files...");
        try {
            Directory in = originalDir.getDirectory();
            for (String fileName : in.getFiles(true)) {
                if (!ApkInfo.ORIGINAL_FILENAMES_PATTERN.matcher(fileName).matches()) continue;
                in.copyToDir(outDir, fileName);
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void importRawFiles(ZipOutputStream out) throws AndrolibException {
        for (String dirName : ApkInfo.RAW_DIRNAMES) {
            File rawDir = new File(this.mApkDir, dirName);
            if (!rawDir.isDirectory()) continue;
            LOGGER.info("Importing " + dirName + "...");
            try {
                ZipUtils.zipDir(this.mApkDir, dirName, out, this.mApkInfo.doNotCompress);
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    private void importUnknownFiles(ZipOutputStream out) throws AndrolibException {
        File unknownDir = new File(this.mApkDir, "unknown");
        if (!unknownDir.isDirectory()) {
            return;
        }
        LOGGER.info("Importing unknown files...");
        try {
            ZipUtils.zipDir(unknownDir, out, this.mApkInfo.doNotCompress);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private File[] getIncludeFiles() throws AndrolibException {
        UsesFramework usesFramework = this.mApkInfo.usesFramework;
        if (usesFramework == null) {
            return null;
        }
        List<Integer> ids = usesFramework.ids;
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        Framework framework = new Framework(this.mConfig);
        String tag = usesFramework.tag;
        File[] files = new File[ids.size()];
        int i = 0;
        for (int id : ids) {
            files[i++] = framework.getApkFile(id, tag);
        }
        return files;
    }

    private boolean isModified(File working, File stored) {
        return !stored.exists() || BrutIO.recursiveModifiedTime(working) > BrutIO.recursiveModifiedTime(stored);
    }

    private boolean isModified(File[] working, File[] stored) {
        for (File file : stored) {
            if (file.exists()) continue;
            return true;
        }
        return BrutIO.recursiveModifiedTime(working) > BrutIO.recursiveModifiedTime(stored);
    }

    private File[] newFiles(File dir, String[] names) {
        File[] files = new File[names.length];
        for (int i = 0; i < names.length; ++i) {
            files[i] = new File(dir, names[i]);
        }
        return files;
    }
}

