/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import java.util.logging.Logger;

public class ResConfigFlags {
    private static final Logger LOGGER = Logger.getLogger(ResConfigFlags.class.getName());
    public static final byte SDK_BASE = 1;
    public static final byte SDK_BASE_1_1 = 2;
    public static final byte SDK_CUPCAKE = 3;
    public static final byte SDK_DONUT = 4;
    public static final byte SDK_ECLAIR = 5;
    public static final byte SDK_ECLAIR_0_1 = 6;
    public static final byte SDK_ECLAIR_MR1 = 7;
    public static final byte SDK_FROYO = 8;
    public static final byte SDK_GINGERBREAD = 9;
    public static final byte SDK_GINGERBREAD_MR1 = 10;
    public static final byte SDK_HONEYCOMB = 11;
    public static final byte SDK_HONEYCOMB_MR1 = 12;
    public static final byte SDK_HONEYCOMB_MR2 = 13;
    public static final byte SDK_ICE_CREAM_SANDWICH = 14;
    public static final byte SDK_ICE_CREAM_SANDWICH_MR1 = 15;
    public static final byte SDK_JELLY_BEAN = 16;
    public static final byte SDK_JELLY_BEAN_MR1 = 17;
    public static final byte SDK_JELLY_BEAN_MR2 = 18;
    public static final byte SDK_KITKAT = 19;
    public static final byte SDK_LOLLIPOP = 21;
    public static final byte SDK_LOLLIPOP_MR1 = 22;
    public static final byte SDK_MNC = 23;
    public static final byte SDK_NOUGAT = 24;
    public static final byte SDK_NOUGAT_MR1 = 25;
    public static final byte SDK_OREO = 26;
    public static final byte SDK_OREO_MR1 = 27;
    public static final byte SDK_P = 28;
    public static final byte SDK_Q = 29;
    public static final byte SDK_R = 30;
    public static final byte SDK_S = 31;
    public static final byte SDK_S_V2 = 32;
    public static final byte SDK_TIRAMISU = 33;
    public static final byte SDK_UPSIDEDOWN_CAKE = 34;
    public static final byte SDK_VANILLA_ICE_CREAM = 35;
    public static final byte SDK_BAKLAVA = 36;
    public static final int SDK_DEVELOPMENT = 10000;
    public static final byte ORIENTATION_ANY = 0;
    public static final byte ORIENTATION_PORT = 1;
    public static final byte ORIENTATION_LAND = 2;
    public static final byte ORIENTATION_SQUARE = 3;
    public static final byte TOUCHSCREEN_ANY = 0;
    public static final byte TOUCHSCREEN_NOTOUCH = 1;
    public static final byte TOUCHSCREEN_STYLUS = 2;
    public static final byte TOUCHSCREEN_FINGER = 3;
    public static final int DENSITY_DEFAULT = 0;
    public static final int DENSITY_LOW = 120;
    public static final int DENSITY_MEDIUM = 160;
    public static final int DENSITY_400 = 190;
    public static final int DENSITY_TV = 213;
    public static final int DENSITY_HIGH = 240;
    public static final int DENSITY_XHIGH = 320;
    public static final int DENSITY_XXHIGH = 480;
    public static final int DENSITY_XXXHIGH = 640;
    public static final int DENSITY_ANY = 65534;
    public static final int DENSITY_NONE = 65535;
    public static final int MNC_ZERO = -1;
    public static final short MASK_LAYOUTDIR = 192;
    public static final short SCREENLAYOUT_LAYOUTDIR_ANY = 0;
    public static final short SCREENLAYOUT_LAYOUTDIR_LTR = 64;
    public static final short SCREENLAYOUT_LAYOUTDIR_RTL = 128;
    public static final short SCREENLAYOUT_LAYOUTDIR_SHIFT = 6;
    public static final short MASK_SCREENROUND = 3;
    public static final short SCREENLAYOUT_ROUND_ANY = 0;
    public static final short SCREENLAYOUT_ROUND_NO = 1;
    public static final short SCREENLAYOUT_ROUND_YES = 2;
    public static final byte GRAMMATICAL_GENDER_ANY = 0;
    public static final byte GRAMMATICAL_GENDER_NEUTER = 1;
    public static final byte GRAMMATICAL_GENDER_FEMININE = 2;
    public static final byte GRAMMATICAL_GENDER_MASCULINE = 3;
    public static final byte KEYBOARD_ANY = 0;
    public static final byte KEYBOARD_NOKEYS = 1;
    public static final byte KEYBOARD_QWERTY = 2;
    public static final byte KEYBOARD_12KEY = 3;
    public static final byte NAVIGATION_ANY = 0;
    public static final byte NAVIGATION_NONAV = 1;
    public static final byte NAVIGATION_DPAD = 2;
    public static final byte NAVIGATION_TRACKBALL = 3;
    public static final byte NAVIGATION_WHEEL = 4;
    public static final byte MASK_KEYSHIDDEN = 3;
    public static final byte KEYSHIDDEN_ANY = 0;
    public static final byte KEYSHIDDEN_NO = 1;
    public static final byte KEYSHIDDEN_YES = 2;
    public static final byte KEYSHIDDEN_SOFT = 3;
    public static final byte MASK_NAVHIDDEN = 12;
    public static final byte NAVHIDDEN_ANY = 0;
    public static final byte NAVHIDDEN_NO = 4;
    public static final byte NAVHIDDEN_YES = 8;
    public static final byte MASK_SCREENSIZE = 15;
    public static final byte SCREENSIZE_ANY = 0;
    public static final byte SCREENSIZE_SMALL = 1;
    public static final byte SCREENSIZE_NORMAL = 2;
    public static final byte SCREENSIZE_LARGE = 3;
    public static final byte SCREENSIZE_XLARGE = 4;
    public static final byte MASK_SCREENLONG = 48;
    public static final byte SCREENLONG_ANY = 0;
    public static final byte SCREENLONG_NO = 16;
    public static final byte SCREENLONG_YES = 32;
    public static final byte MASK_UI_MODE_TYPE = 15;
    public static final byte UI_MODE_TYPE_ANY = 0;
    public static final byte UI_MODE_TYPE_NORMAL = 1;
    public static final byte UI_MODE_TYPE_DESK = 2;
    public static final byte UI_MODE_TYPE_CAR = 3;
    public static final byte UI_MODE_TYPE_TELEVISION = 4;
    public static final byte UI_MODE_TYPE_APPLIANCE = 5;
    public static final byte UI_MODE_TYPE_WATCH = 6;
    public static final byte UI_MODE_TYPE_VR_HEADSET = 7;
    public static final byte UI_MODE_TYPE_GODZILLAUI = 11;
    public static final byte UI_MODE_TYPE_SMALLUI = 12;
    public static final byte UI_MODE_TYPE_MEDIUMUI = 13;
    public static final byte UI_MODE_TYPE_LARGEUI = 14;
    public static final byte UI_MODE_TYPE_HUGEUI = 15;
    public static final byte MASK_UI_MODE_NIGHT = 48;
    public static final byte UI_MODE_NIGHT_ANY = 0;
    public static final byte UI_MODE_NIGHT_NO = 16;
    public static final byte UI_MODE_NIGHT_YES = 32;
    public static final byte COLOR_HDR_MASK = 12;
    public static final byte COLOR_HDR_NO = 4;
    public static final byte COLOR_HDR_SHIFT = 2;
    public static final byte COLOR_HDR_UNDEFINED = 0;
    public static final byte COLOR_HDR_YES = 8;
    public static final byte COLOR_UNDEFINED = 0;
    public static final byte COLOR_WIDE_UNDEFINED = 0;
    public static final byte COLOR_WIDE_NO = 1;
    public static final byte COLOR_WIDE_YES = 2;
    public static final byte COLOR_WIDE_MASK = 3;
    private static int sErrCounter = 0;
    private final short mMcc;
    private final short mMnc;
    private final char[] mLanguage;
    private final char[] mRegion;
    private final byte mOrientation;
    private final byte mTouchscreen;
    private final int mDensity;
    private final byte mKeyboard;
    private final byte mNavigation;
    private final byte mInputFlags;
    private final byte mGrammaticalInflection;
    private final short mScreenWidth;
    private final short mScreenHeight;
    private final short mSdkVersion;
    private final byte mScreenLayout;
    private final byte mUiMode;
    private final short mSmallestScreenWidthDp;
    private final short mScreenWidthDp;
    private final short mScreenHeightDp;
    private final char[] mLocaleScript;
    private final char[] mLocaleVariant;
    private final byte mScreenLayout2;
    private final byte mColorMode;
    private final char[] mLocaleNumberingSystem;
    private final int mSize;
    private final boolean mIsInvalid;
    private final String mQualifiers;

    public ResConfigFlags() {
        this.mMcc = 0;
        this.mMnc = 0;
        this.mLanguage = new char[]{'\u0000', '\u0000'};
        this.mRegion = new char[]{'\u0000', '\u0000'};
        this.mOrientation = 0;
        this.mTouchscreen = 0;
        this.mDensity = 0;
        this.mKeyboard = 0;
        this.mNavigation = 0;
        this.mInputFlags = 0;
        this.mGrammaticalInflection = 0;
        this.mScreenWidth = 0;
        this.mScreenHeight = 0;
        this.mSdkVersion = 0;
        this.mScreenLayout = 0;
        this.mUiMode = 0;
        this.mSmallestScreenWidthDp = 0;
        this.mScreenWidthDp = 0;
        this.mScreenHeightDp = 0;
        this.mLocaleScript = null;
        this.mLocaleVariant = null;
        this.mScreenLayout2 = 0;
        this.mColorMode = 0;
        this.mLocaleNumberingSystem = null;
        this.mSize = 0;
        this.mIsInvalid = false;
        this.mQualifiers = "";
    }

    public ResConfigFlags(short mcc, short mnc, char[] language, char[] region, byte orientation, byte touchscreen, int density, byte keyboard, byte navigation, byte inputFlags, byte grammaticalInflection, short screenWidth, short screenHeight, short sdkVersion, byte screenLayout, byte uiMode, short smallestScreenWidthDp, short screenWidthDp, short screenHeightDp, char[] localeScript, char[] localeVariant, byte screenLayout2, byte colorMode, char[] localeNumberingSystem, int size, boolean isInvalid) {
        if (orientation < 0 || orientation > 3) {
            LOGGER.warning("Invalid orientation value: " + orientation);
            orientation = 0;
            isInvalid = true;
        }
        if (touchscreen < 0 || touchscreen > 3) {
            LOGGER.warning("Invalid touchscreen value: " + touchscreen);
            touchscreen = 0;
            isInvalid = true;
        }
        if (density < -1) {
            LOGGER.warning("Invalid density value: " + density);
            density = 0;
            isInvalid = true;
        }
        if (keyboard < 0 || keyboard > 3) {
            LOGGER.warning("Invalid keyboard value: " + keyboard);
            keyboard = 0;
            isInvalid = true;
        }
        if (navigation < 0 || navigation > 4) {
            LOGGER.warning("Invalid navigation value: " + navigation);
            navigation = 0;
            isInvalid = true;
        }
        if (localeScript != null && (localeScript.length == 0 || localeScript[0] == '\u0000')) {
            localeScript = null;
        }
        if (localeVariant != null && (localeVariant.length == 0 || localeVariant[0] == '\u0000')) {
            localeVariant = null;
        }
        this.mMcc = mcc;
        this.mMnc = mnc;
        this.mLanguage = language;
        this.mRegion = region;
        this.mOrientation = orientation;
        this.mTouchscreen = touchscreen;
        this.mDensity = density;
        this.mKeyboard = keyboard;
        this.mNavigation = navigation;
        this.mInputFlags = inputFlags;
        this.mGrammaticalInflection = grammaticalInflection;
        this.mScreenWidth = screenWidth;
        this.mScreenHeight = screenHeight;
        this.mSdkVersion = sdkVersion;
        this.mScreenLayout = screenLayout;
        this.mUiMode = uiMode;
        this.mSmallestScreenWidthDp = smallestScreenWidthDp;
        this.mScreenWidthDp = screenWidthDp;
        this.mScreenHeightDp = screenHeightDp;
        this.mLocaleScript = localeScript;
        this.mLocaleVariant = localeVariant;
        this.mScreenLayout2 = screenLayout2;
        this.mColorMode = colorMode;
        this.mLocaleNumberingSystem = localeNumberingSystem;
        this.mSize = size;
        this.mIsInvalid = isInvalid;
        this.mQualifiers = this.generateQualifiers();
    }

    private String generateQualifiers() {
        StringBuilder sb = new StringBuilder();
        if (this.mMcc != 0) {
            sb.append("-mcc").append(String.format("%03d", this.mMcc));
            if (this.mMnc != -1) {
                if (this.mMnc != 0) {
                    sb.append("-mnc");
                    if (this.mSize <= 32) {
                        if (this.mMnc > 0 && this.mMnc < 10) {
                            sb.append(String.format("%02d", this.mMnc));
                        } else {
                            sb.append(String.format("%03d", this.mMnc));
                        }
                    } else {
                        sb.append(this.mMnc);
                    }
                }
            } else {
                sb.append("-mnc00");
            }
        } else if (this.mMnc != 0) {
            sb.append("-mnc").append(this.mMnc);
        }
        sb.append(this.getLocaleString());
        switch (this.mGrammaticalInflection) {
            case 1: {
                sb.append("-neuter");
                break;
            }
            case 2: {
                sb.append("-feminine");
                break;
            }
            case 3: {
                sb.append("-masculine");
            }
        }
        switch (this.mScreenLayout & 0xC0) {
            case 128: {
                sb.append("-ldrtl");
                break;
            }
            case 64: {
                sb.append("-ldltr");
            }
        }
        if (this.mSmallestScreenWidthDp != 0) {
            sb.append("-sw").append(this.mSmallestScreenWidthDp).append("dp");
        }
        if (this.mScreenWidthDp != 0) {
            sb.append("-w").append(this.mScreenWidthDp).append("dp");
        }
        if (this.mScreenHeightDp != 0) {
            sb.append("-h").append(this.mScreenHeightDp).append("dp");
        }
        switch (this.mScreenLayout & 0xF) {
            case 1: {
                sb.append("-small");
                break;
            }
            case 2: {
                sb.append("-normal");
                break;
            }
            case 3: {
                sb.append("-large");
                break;
            }
            case 4: {
                sb.append("-xlarge");
            }
        }
        switch (this.mScreenLayout & 0x30) {
            case 32: {
                sb.append("-long");
                break;
            }
            case 16: {
                sb.append("-notlong");
            }
        }
        switch (this.mScreenLayout2 & 3) {
            case 1: {
                sb.append("-notround");
                break;
            }
            case 2: {
                sb.append("-round");
            }
        }
        switch (this.mColorMode & 0xC) {
            case 8: {
                sb.append("-highdr");
                break;
            }
            case 4: {
                sb.append("-lowdr");
            }
        }
        switch (this.mColorMode & 3) {
            case 2: {
                sb.append("-widecg");
                break;
            }
            case 1: {
                sb.append("-nowidecg");
            }
        }
        switch (this.mOrientation) {
            case 1: {
                sb.append("-port");
                break;
            }
            case 2: {
                sb.append("-land");
                break;
            }
            case 3: {
                sb.append("-square");
            }
        }
        switch (this.mUiMode & 0xF) {
            case 3: {
                sb.append("-car");
                break;
            }
            case 2: {
                sb.append("-desk");
                break;
            }
            case 4: {
                sb.append("-television");
                break;
            }
            case 12: {
                sb.append("-smallui");
                break;
            }
            case 13: {
                sb.append("-mediumui");
                break;
            }
            case 14: {
                sb.append("-largeui");
                break;
            }
            case 11: {
                sb.append("-godzillaui");
                break;
            }
            case 15: {
                sb.append("-hugeui");
                break;
            }
            case 5: {
                sb.append("-appliance");
                break;
            }
            case 6: {
                sb.append("-watch");
                break;
            }
            case 7: {
                sb.append("-vrheadset");
            }
        }
        switch (this.mUiMode & 0x30) {
            case 32: {
                sb.append("-night");
                break;
            }
            case 16: {
                sb.append("-notnight");
            }
        }
        switch (this.mDensity) {
            case 0: {
                break;
            }
            case 120: {
                sb.append("-ldpi");
                break;
            }
            case 160: {
                sb.append("-mdpi");
                break;
            }
            case 240: {
                sb.append("-hdpi");
                break;
            }
            case 213: {
                sb.append("-tvdpi");
                break;
            }
            case 320: {
                sb.append("-xhdpi");
                break;
            }
            case 480: {
                sb.append("-xxhdpi");
                break;
            }
            case 640: {
                sb.append("-xxxhdpi");
                break;
            }
            case 65534: {
                sb.append("-anydpi");
                break;
            }
            case 65535: {
                sb.append("-nodpi");
                break;
            }
            default: {
                sb.append('-').append(this.mDensity).append("dpi");
            }
        }
        switch (this.mTouchscreen) {
            case 1: {
                sb.append("-notouch");
                break;
            }
            case 2: {
                sb.append("-stylus");
                break;
            }
            case 3: {
                sb.append("-finger");
            }
        }
        switch (this.mInputFlags & 3) {
            case 1: {
                sb.append("-keysexposed");
                break;
            }
            case 2: {
                sb.append("-keyshidden");
                break;
            }
            case 3: {
                sb.append("-keyssoft");
            }
        }
        switch (this.mKeyboard) {
            case 1: {
                sb.append("-nokeys");
                break;
            }
            case 2: {
                sb.append("-qwerty");
                break;
            }
            case 3: {
                sb.append("-12key");
            }
        }
        switch (this.mInputFlags & 0xC) {
            case 4: {
                sb.append("-navexposed");
                break;
            }
            case 8: {
                sb.append("-navhidden");
            }
        }
        switch (this.mNavigation) {
            case 1: {
                sb.append("-nonav");
                break;
            }
            case 2: {
                sb.append("-dpad");
                break;
            }
            case 3: {
                sb.append("-trackball");
                break;
            }
            case 4: {
                sb.append("-wheel");
            }
        }
        if (this.mScreenWidth != 0 && this.mScreenHeight != 0) {
            if (this.mScreenWidth > this.mScreenHeight) {
                sb.append(String.format("-%dx%d", this.mScreenWidth, this.mScreenHeight));
            } else {
                sb.append(String.format("-%dx%d", this.mScreenHeight, this.mScreenWidth));
            }
        }
        if (this.mSdkVersion > 0 && this.mSdkVersion >= this.getNaturalSdkVersionRequirement()) {
            sb.append("-v").append(this.mSdkVersion);
        }
        if (this.mIsInvalid) {
            sb.append("-ERR").append(sErrCounter++);
        }
        return sb.toString();
    }

    private short getNaturalSdkVersionRequirement() {
        if (this.mGrammaticalInflection != 0) {
            return 34;
        }
        if ((this.mUiMode & 0xF) == 7 || (this.mColorMode & 3) != 0 || (this.mColorMode & 0xC) != 0) {
            return 26;
        }
        if ((this.mScreenLayout2 & 3) != 0) {
            return 23;
        }
        if (this.mDensity == 65534) {
            return 21;
        }
        if (this.mSmallestScreenWidthDp != 0 || this.mScreenWidthDp != 0 || this.mScreenHeightDp != 0) {
            return 13;
        }
        if ((this.mUiMode & 0x3F) != 0) {
            return 8;
        }
        if ((this.mScreenLayout & 0x3F) != 0 || this.mDensity != 0) {
            return 4;
        }
        return 0;
    }

    private String getLocaleString() {
        StringBuilder sb = new StringBuilder();
        if (this.mLocaleScript == null && this.mLocaleVariant == null && (this.mRegion[0] != '\u0000' || this.mLanguage[0] != '\u0000') && this.mRegion.length != 3) {
            sb.append("-").append(this.mLanguage);
            if (this.mRegion[0] != '\u0000') {
                sb.append("-r").append(this.mRegion);
            }
        } else {
            if (this.mLanguage[0] == '\u0000' && this.mRegion[0] == '\u0000') {
                return sb.toString();
            }
            sb.append("-b+");
            if (this.mLanguage[0] != '\u0000') {
                sb.append(this.mLanguage);
            }
            if (this.mLocaleScript != null && this.mLocaleScript.length == 4) {
                sb.append("+").append(this.mLocaleScript);
            }
            if ((this.mRegion.length == 2 || this.mRegion.length == 3) && this.mRegion[0] != '\u0000') {
                sb.append("+").append(this.mRegion);
            }
            if (this.mLocaleVariant != null && this.mLocaleVariant.length >= 5) {
                sb.append("+").append(ResConfigFlags.toUpper(this.mLocaleVariant));
            }
            if (this.mLocaleNumberingSystem != null && this.mLocaleNumberingSystem.length > 0) {
                sb.append("+u+nu+").append(this.mLocaleNumberingSystem);
            }
        }
        return sb.toString();
    }

    private static String toUpper(char[] character) {
        StringBuilder sb = new StringBuilder();
        for (char ch : character) {
            sb.append(Character.toUpperCase(ch));
        }
        return sb.toString();
    }

    public boolean isInvalid() {
        return this.mIsInvalid;
    }

    public String getQualifiers() {
        return this.mQualifiers;
    }

    public String toString() {
        return !this.getQualifiers().equals("") ? this.getQualifiers() : "[DEFAULT]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResConfigFlags) {
            ResConfigFlags other = (ResConfigFlags)obj;
            return this.mQualifiers.equals(other.mQualifiers);
        }
        return false;
    }

    public int hashCode() {
        return this.mQualifiers.hashCode();
    }
}

