/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResArrayValue;
import brut.androlib.res.data.value.ResPluralsValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResStyleValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import java.io.IOException;
import org.apache.commons.lang3.tuple.Pair;
import org.xmlpull.v1.XmlSerializer;

public class ResBagValue
extends ResValue
implements ResValuesXmlSerializable {
    protected final ResReferenceValue mParent;
    protected final Config mConfig;

    public ResBagValue(ResReferenceValue parent) {
        this.mParent = parent;
        this.mConfig = parent.getPackage().getConfig();
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
        String type = res.getResSpec().getType().getName();
        if ("style".equals(type)) {
            new ResStyleValue(this.mParent, Pair.emptyArray(), null).serializeToResValuesXml(serializer, res);
            return;
        }
        if ("array".equals(type)) {
            new ResArrayValue(this.mParent, Pair.emptyArray()).serializeToResValuesXml(serializer, res);
            return;
        }
        if ("plurals".equals(type)) {
            new ResPluralsValue(this.mParent, Pair.emptyArray()).serializeToResValuesXml(serializer, res);
            return;
        }
        serializer.startTag(null, "item");
        serializer.attribute(null, "type", type);
        serializer.attribute(null, "name", res.getResSpec().getName());
        serializer.endTag(null, "item");
    }
}

