/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AXmlDecodingException;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.RawXmlEncounteredException;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.xmlpull.XmlPullUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class AndroidManifestPullStreamDecoder
implements ResStreamDecoder {
    private final AXmlResourceParser mParser;
    private final XmlSerializer mSerial;

    public AndroidManifestPullStreamDecoder(AXmlResourceParser parser, XmlSerializer serial) {
        this.mParser = parser;
        this.mSerial = serial;
    }

    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            this.mParser.setInput(in, null);
            this.mSerial.setOutput(out, null);
            XmlPullUtils.copy(this.mParser, this.mSerial, new EventHandler(this.mParser.getResTable()));
        }
        catch (XmlPullParserException ex) {
            throw new AXmlDecodingException("Could not decode XML", ex);
        }
        catch (IOException ex) {
            throw new RawXmlEncounteredException("Could not decode XML", ex);
        }
    }

    private static class EventHandler
    implements XmlPullUtils.EventHandler {
        private final ResTable mResTable;
        private final boolean mHideSdkInfo;

        public EventHandler(ResTable resTable) {
            this.mResTable = resTable;
            this.mHideSdkInfo = !resTable.getConfig().isAnalysisMode();
        }

        @Override
        public boolean onEvent(XmlPullParser in, XmlSerializer out) throws XmlPullParserException {
            String name;
            int type = in.getEventType();
            if (type == 2) {
                String name2 = in.getName();
                if (name2.equals("manifest")) {
                    this.parseManifest(in);
                } else if (name2.equals("uses-sdk")) {
                    this.parseUsesSdk(in);
                    if (this.mHideSdkInfo) {
                        return true;
                    }
                }
            } else if (type == 3 && (name = in.getName()).equals("uses-sdk") && this.mHideSdkInfo) {
                return true;
            }
            return false;
        }

        private void parseManifest(XmlPullParser in) {
            block8: for (int i = 0; i < in.getAttributeCount(); ++i) {
                String ns = in.getAttributeNamespace(i);
                String name = in.getAttributeName(i);
                String value = in.getAttributeValue(i);
                if (value.isEmpty()) continue;
                if (ns.isEmpty()) {
                    if (!name.equals("package")) continue;
                    this.mResTable.setPackageRenamed(value);
                    continue;
                }
                if (!ns.equals("http://schemas.android.com/apk/res/android")) continue;
                switch (name) {
                    case "versionCode": {
                        this.mResTable.setVersionCode(value);
                        continue block8;
                    }
                    case "versionName": {
                        this.mResTable.setVersionName(value);
                    }
                }
            }
        }

        private void parseUsesSdk(XmlPullParser in) {
            for (int i = 0; i < in.getAttributeCount(); ++i) {
                String ns = in.getAttributeNamespace(i);
                String name = in.getAttributeName(i);
                String value = in.getAttributeValue(i);
                if (value.isEmpty() || !ns.equals("http://schemas.android.com/apk/res/android")) continue;
                switch (name) {
                    case "minSdkVersion": 
                    case "targetSdkVersion": 
                    case "maxSdkVersion": 
                    case "compileSdkVersion": {
                        this.mResTable.addSdkInfo(name, value);
                    }
                }
            }
        }
    }
}

