/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.util.ExtDataInput;
import com.google.common.io.CountingInputStream;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class ExtDataInputStream
extends FilterInputStream
implements ExtDataInput {
    private static final Logger LOGGER = Logger.getLogger(ExtDataInputStream.class.getName());
    private final DataInput mDelegate;
    private final CountingInputStream mCountIn;

    public static ExtDataInputStream bigEndian(InputStream in) {
        CountingInputStream countIn = new CountingInputStream(in);
        DataInputStream delegate = new DataInputStream(countIn);
        return new ExtDataInputStream(delegate, countIn);
    }

    public static ExtDataInputStream littleEndian(InputStream in) {
        CountingInputStream countIn = new CountingInputStream(in);
        LittleEndianDataInputStream delegate = new LittleEndianDataInputStream(countIn);
        return new ExtDataInputStream(delegate, countIn);
    }

    private ExtDataInputStream(DataInput delegate, CountingInputStream countIn) {
        super((InputStream)((Object)delegate));
        this.mDelegate = delegate;
        this.mCountIn = countIn;
    }

    public void jumpTo(long expectedPosition) throws IOException {
        long skipped;
        long position = this.position();
        if (position > expectedPosition) {
            throw new IOException(String.format("Jumping backwards from %d to %d", position, expectedPosition));
        }
        if (position < expectedPosition && (skipped = this.skip(expectedPosition - position)) != expectedPosition - position) {
            throw new IOException(String.format("Jump failed: expected %d, got %d", expectedPosition - position, skipped));
        }
    }

    @Override
    public long position() {
        return this.mCountIn.getCount();
    }

    @Override
    public void skipShort() throws IOException {
        this.readShort();
    }

    @Override
    public void skipInt() throws IOException {
        this.readInt();
    }

    @Override
    public void skipCheckShort(short expected) throws IOException {
        short got = this.readShort();
        if (got != expected) {
            throw new IOException(String.format("Expected: 0x%08x, got: 0x%08x", expected, got));
        }
    }

    @Override
    public void skipCheckByte(byte expected) throws IOException {
        byte got = this.readByte();
        if (got != expected) {
            throw new IOException(String.format("Expected: 0x%08x, got: 0x%08x", expected, got));
        }
    }

    @Override
    public int[] readIntArray(int len) throws IOException {
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readInt();
        }
        return arr;
    }

    @Override
    public int[] readSafeIntArray(int len, long maxPosition) throws IOException {
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            if (this.position() >= maxPosition) {
                LOGGER.warning(String.format("Bad string block: string entry is at %d, past end at %d", this.position(), maxPosition));
                return arr;
            }
            arr[i] = this.readInt();
        }
        return arr;
    }

    @Override
    public String readNullEndedString(int len, boolean fixed) throws IOException {
        short ch;
        StringBuilder str = new StringBuilder(16);
        while (len-- != 0 && (ch = this.readShort()) != 0) {
            str.append((char)ch);
        }
        if (fixed) {
            this.skipBytes(len * 2);
        }
        return str.toString();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.mDelegate.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.mDelegate.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int total;
        int cur;
        for (total = 0; total < n && (cur = this.mDelegate.skipBytes(n - total)) > 0; total += cur) {
        }
        return total;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.mDelegate.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.mDelegate.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.mDelegate.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.mDelegate.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.mDelegate.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.mDelegate.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.mDelegate.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.mDelegate.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.mDelegate.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.mDelegate.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.mDelegate.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.mDelegate.readUTF();
    }
}

