/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali;

import com.android.tools.smali.baksmali.ListClassesCommand;
import com.android.tools.smali.baksmali.ListDependenciesCommand;
import com.android.tools.smali.baksmali.ListDexCommand;
import com.android.tools.smali.baksmali.ListFieldOffsetsCommand;
import com.android.tools.smali.baksmali.ListFieldsCommand;
import com.android.tools.smali.baksmali.ListHelpCommand;
import com.android.tools.smali.baksmali.ListMethodsCommand;
import com.android.tools.smali.baksmali.ListStringsCommand;
import com.android.tools.smali.baksmali.ListTypesCommand;
import com.android.tools.smali.baksmali.ListVtablesCommand;
import com.android.tools.smali.util.jcommander.Command;
import com.android.tools.smali.util.jcommander.ExtendedCommands;
import com.android.tools.smali.util.jcommander.ExtendedParameters;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import javax.annotation.Nonnull;

@Parameters(commandDescription="Lists various objects in a dex file.")
@ExtendedParameters(commandName="list", commandAliases={"l"})
public class ListCommand
extends Command {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;

    public ListCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    protected void setupCommand(JCommander jc) {
        List<JCommander> hierarchy = this.getCommandHierarchy();
        ExtendedCommands.addExtendedCommand(jc, new ListStringsCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListMethodsCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListFieldsCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListTypesCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListClassesCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListDexCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListVtablesCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListFieldOffsetsCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListDependenciesCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListHelpCommand(hierarchy));
        ExtendedCommands.addExtendedCommand(jc, new ListHelpCommand.ListHlepCommand(hierarchy));
    }

    @Override
    public void run() {
        JCommander jc = this.getJCommander();
        if (this.help || jc.getParsedCommand() == null) {
            this.usage();
            return;
        }
        Command command = (Command)jc.getCommands().get(jc.getParsedCommand()).getObjects().get(0);
        command.run();
    }
}

