/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.MultiMap;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFAState
extends State {
    public static final int INITIAL_NUM_TRANSITIONS = 4;
    public static final int PREDICTED_ALT_UNSET = -2;
    public DFA dfa;
    protected List<Transition> transitions = new ArrayList<Transition>(4);
    protected int k;
    protected int acceptStateReachable = -2;
    protected boolean resolvedWithPredicates = false;
    public boolean abortedDueToRecursionOverflow = false;
    protected boolean abortedDueToMultipleRecursiveAlts = false;
    protected int cachedHashCode;
    protected int cachedUniquelyPredicatedAlt = -2;
    public int minAltInConfigurations = Integer.MAX_VALUE;
    public boolean atLeastOneConfigurationHasAPredicate = false;
    public OrderedHashSet<NFAConfiguration> nfaConfigurations = new OrderedHashSet();
    public List<NFAConfiguration> configurationsWithLabeledEdges = new ArrayList<NFAConfiguration>();
    protected Set<NFAConfiguration> closureBusy = new HashSet<NFAConfiguration>();
    protected OrderedHashSet<Label> reachableLabels;

    public DFAState(DFA dfa) {
        this.dfa = dfa;
    }

    public void reset() {
        this.configurationsWithLabeledEdges = null;
        this.closureBusy = null;
        this.reachableLabels = null;
    }

    @Override
    public Transition transition(int i) {
        return this.transitions.get(i);
    }

    @Override
    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    @Override
    public void addTransition(Transition t2) {
        this.transitions.add(t2);
    }

    public int addTransition(DFAState target, Label label) {
        this.transitions.add(new Transition(label, (State)target));
        return this.transitions.size() - 1;
    }

    public Transition getTransition(int trans) {
        return this.transitions.get(trans);
    }

    public void removeTransition(int trans) {
        this.transitions.remove(trans);
    }

    public void addNFAConfiguration(NFAState state, NFAConfiguration c) {
        Label label;
        if (this.nfaConfigurations.contains(c)) {
            return;
        }
        this.nfaConfigurations.add(c);
        if (c.alt < this.minAltInConfigurations) {
            this.minAltInConfigurations = c.alt;
        }
        if (c.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
            this.atLeastOneConfigurationHasAPredicate = true;
        }
        this.cachedHashCode += c.state + c.alt;
        if (state.transition[0] != null && !(label = state.transition[0].label).isEpsilon() && !label.isSemanticPredicate()) {
            this.configurationsWithLabeledEdges.add(c);
            if (state.transition[1] == null) {
                c.singleAtomTransitionEmanating = true;
            }
            this.addReachableLabel(label);
        }
    }

    public NFAConfiguration addNFAConfiguration(NFAState state, int alt, NFAContext context, SemanticContext semanticContext) {
        NFAConfiguration c = new NFAConfiguration(state.stateNumber, alt, context, semanticContext);
        this.addNFAConfiguration(state, c);
        return c;
    }

    protected void addReachableLabel(Label label) {
        IntSet t2;
        if (this.reachableLabels == null) {
            this.reachableLabels = new OrderedHashSet();
        }
        if (this.reachableLabels.contains(label)) {
            return;
        }
        IntSet remainder = t2 = label.getSet();
        int n = this.reachableLabels.size();
        for (int i = 0; i < n; ++i) {
            Label rl = this.reachableLabels.get(i);
            if (!Label.intersect(label, rl)) continue;
            IntSet s_i = rl.getSet();
            IntSet intersection = s_i.and(t2);
            this.reachableLabels.set(i, new Label(intersection));
            IntSet existingMinusNewElements = s_i.subtract(t2);
            if (!existingMinusNewElements.isNil()) {
                Label newLabel = new Label(existingMinusNewElements);
                this.reachableLabels.add(newLabel);
            }
            if ((remainder = t2.subtract(s_i)).isNil()) break;
            t2 = remainder;
        }
        if (!remainder.isNil()) {
            Label newLabel = new Label(remainder);
            this.reachableLabels.add(newLabel);
        }
    }

    public OrderedHashSet<Label> getReachableLabels() {
        return this.reachableLabels;
    }

    public void setNFAConfigurations(OrderedHashSet<NFAConfiguration> configs) {
        this.nfaConfigurations = configs;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            return super.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        DFAState other = (DFAState)o;
        return this.nfaConfigurations.equals(other.nfaConfigurations);
    }

    public int getUniquelyPredictedAlt() {
        if (this.cachedUniquelyPredicatedAlt != -2) {
            return this.cachedUniquelyPredicatedAlt;
        }
        int alt = -1;
        int numConfigs = this.nfaConfigurations.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i);
            if (configuration.resolved) continue;
            if (alt == -1) {
                alt = configuration.alt;
                continue;
            }
            if (configuration.alt == alt) continue;
            return -1;
        }
        this.cachedUniquelyPredicatedAlt = alt;
        return alt;
    }

    public int getUniqueAlt() {
        int alt = -1;
        int numConfigs = this.nfaConfigurations.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i);
            if (alt == -1) {
                alt = configuration.alt;
                continue;
            }
            if (configuration.alt == alt) continue;
            return -1;
        }
        return alt;
    }

    public Set<Integer> getDisabledAlternatives() {
        LinkedHashSet<Integer> disabled = new LinkedHashSet<Integer>();
        int numConfigs = this.nfaConfigurations.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i);
            if (!configuration.resolved) continue;
            disabled.add(Utils.integer(configuration.alt));
        }
        return disabled;
    }

    protected Set<Integer> getNonDeterministicAlts() {
        int user_k = this.dfa.getUserMaxLookahead();
        if (user_k > 0 && user_k == this.k) {
            return this.getAltSet();
        }
        if (this.abortedDueToMultipleRecursiveAlts || this.abortedDueToRecursionOverflow) {
            return this.getAltSet();
        }
        return this.getConflictingAlts();
    }

    protected Set<Integer> getConflictingAlts() {
        HashSet<Integer> nondeterministicAlts = new HashSet<Integer>();
        int numConfigs = this.nfaConfigurations.size();
        if (numConfigs <= 1) {
            return null;
        }
        MultiMap<Integer, NFAConfiguration> stateToConfigListMap = new MultiMap<Integer, NFAConfiguration>();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i);
            Integer stateI = Utils.integer(configuration.state);
            stateToConfigListMap.map(stateI, configuration);
        }
        Set states = stateToConfigListMap.keySet();
        int numPotentialConflicts = 0;
        for (Integer stateI : states) {
            boolean thisStateHasPotentialProblem = false;
            List configsForState = (List)stateToConfigListMap.get(stateI);
            int alt = 0;
            int numConfigsForState = configsForState.size();
            for (int i = 0; i < numConfigsForState && numConfigsForState > 1; ++i) {
                NFAConfiguration c = (NFAConfiguration)configsForState.get(i);
                if (alt == 0) {
                    alt = c.alt;
                    continue;
                }
                if (c.alt == alt || this.dfa.nfa.grammar.type == 1 && this.dfa.decisionNFAStartState.enclosingRule.name.equals("Tokens")) continue;
                ++numPotentialConflicts;
                thisStateHasPotentialProblem = true;
            }
            if (thisStateHasPotentialProblem) continue;
            stateToConfigListMap.put(stateI, null);
        }
        if (numPotentialConflicts == 0) {
            return null;
        }
        for (Integer stateI : states) {
            List configsForState = (List)stateToConfigListMap.get(stateI);
            int numConfigsForState = 0;
            if (configsForState != null) {
                numConfigsForState = configsForState.size();
            }
            for (int i = 0; i < numConfigsForState; ++i) {
                NFAConfiguration s2 = (NFAConfiguration)configsForState.get(i);
                for (int j = i + 1; j < numConfigsForState; ++j) {
                    NFAConfiguration t2 = (NFAConfiguration)configsForState.get(j);
                    if (s2.alt == t2.alt || !s2.context.conflictsWith(t2.context)) continue;
                    nondeterministicAlts.add(Utils.integer(s2.alt));
                    nondeterministicAlts.add(Utils.integer(t2.alt));
                }
            }
        }
        if (nondeterministicAlts.isEmpty()) {
            return null;
        }
        return nondeterministicAlts;
    }

    public Set<Integer> getAltSet() {
        int numConfigs = this.nfaConfigurations.size();
        HashSet<Integer> alts = new HashSet<Integer>();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i);
            alts.add(Utils.integer(configuration.alt));
        }
        if (alts.isEmpty()) {
            return null;
        }
        return alts;
    }

    public Set<? extends SemanticContext> getGatedSyntacticPredicatesInNFAConfigurations() {
        int numConfigs = this.nfaConfigurations.size();
        HashSet<SemanticContext> synpreds = new HashSet<SemanticContext>();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i);
            SemanticContext gatedPredExpr = configuration.semanticContext.getGatedPredicateContext();
            if (gatedPredExpr == null || !configuration.semanticContext.isSyntacticPredicate()) continue;
            synpreds.add(configuration.semanticContext);
        }
        if (synpreds.isEmpty()) {
            return null;
        }
        return synpreds;
    }

    public SemanticContext getGatedPredicatesInNFAConfigurations() {
        SemanticContext unionOfPredicatesFromAllAlts = null;
        int numConfigs = this.nfaConfigurations.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i);
            SemanticContext gatedPredExpr = configuration.semanticContext.getGatedPredicateContext();
            if (gatedPredExpr == null) {
                return null;
            }
            if (!this.acceptState && configuration.semanticContext.isSyntacticPredicate()) continue;
            unionOfPredicatesFromAllAlts = unionOfPredicatesFromAllAlts == null ? gatedPredExpr : SemanticContext.or(unionOfPredicatesFromAllAlts, gatedPredExpr);
        }
        if (unionOfPredicatesFromAllAlts instanceof SemanticContext.TruePredicate) {
            return null;
        }
        return unionOfPredicatesFromAllAlts;
    }

    public int getAcceptStateReachable() {
        return this.acceptStateReachable;
    }

    public void setAcceptStateReachable(int acceptStateReachable) {
        this.acceptStateReachable = acceptStateReachable;
    }

    public boolean isResolvedWithPredicates() {
        return this.resolvedWithPredicates;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.stateNumber).append(":{");
        for (int i = 0; i < this.nfaConfigurations.size(); ++i) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i);
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(configuration);
        }
        buf.append("}");
        return buf.toString();
    }

    public int getLookaheadDepth() {
        return this.k;
    }

    public void setLookaheadDepth(int k) {
        this.k = k;
        if (k > this.dfa.max_k) {
            this.dfa.max_k = k;
        }
    }
}

