/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;

public abstract class BaseTreeAdaptor
implements TreeAdaptor {
    protected Map<Object, Integer> treeToUniqueIDMap;
    protected int uniqueNodeID = 1;

    public Object nil() {
        return this.create(null);
    }

    public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
        CommonErrorNode t2 = new CommonErrorNode(input, start, stop, e);
        return t2;
    }

    public boolean isNil(Object tree) {
        return ((Tree)tree).isNil();
    }

    public Object dupTree(Object tree) {
        return this.dupTree(tree, null);
    }

    public Object dupTree(Object t2, Object parent) {
        if (t2 == null) {
            return null;
        }
        Object newTree = this.dupNode(t2);
        this.setChildIndex(newTree, this.getChildIndex(t2));
        this.setParent(newTree, parent);
        int n = this.getChildCount(t2);
        for (int i = 0; i < n; ++i) {
            Object child = this.getChild(t2, i);
            Object newSubTree = this.dupTree(child, t2);
            this.addChild(newTree, newSubTree);
        }
        return newTree;
    }

    public void addChild(Object t2, Object child) {
        if (t2 != null && child != null) {
            ((Tree)t2).addChild((Tree)child);
        }
    }

    public Object becomeRoot(Object newRoot, Object oldRoot) {
        Tree newRootTree = (Tree)newRoot;
        Tree oldRootTree = (Tree)oldRoot;
        if (oldRoot == null) {
            return newRoot;
        }
        if (newRootTree.isNil()) {
            int nc = newRootTree.getChildCount();
            if (nc == 1) {
                newRootTree = newRootTree.getChild(0);
            } else if (nc > 1) {
                throw new RuntimeException("more than one node as root (TODO: make exception hierarchy)");
            }
        }
        newRootTree.addChild(oldRootTree);
        return newRootTree;
    }

    public Object rulePostProcessing(Object root) {
        Tree r = (Tree)root;
        if (r != null && r.isNil()) {
            if (r.getChildCount() == 0) {
                r = null;
            } else if (r.getChildCount() == 1) {
                r = r.getChild(0);
                r.setParent(null);
                r.setChildIndex(-1);
            }
        }
        return r;
    }

    public Object becomeRoot(Token newRoot, Object oldRoot) {
        return this.becomeRoot(this.create(newRoot), oldRoot);
    }

    public Object create(int tokenType, Token fromToken) {
        fromToken = this.createToken(fromToken);
        fromToken.setType(tokenType);
        Tree t2 = (Tree)this.create(fromToken);
        return t2;
    }

    public Object create(int tokenType, Token fromToken, String text) {
        if (fromToken == null) {
            return this.create(tokenType, text);
        }
        fromToken = this.createToken(fromToken);
        fromToken.setType(tokenType);
        fromToken.setText(text);
        Tree t2 = (Tree)this.create(fromToken);
        return t2;
    }

    public Object create(int tokenType, String text) {
        Token fromToken = this.createToken(tokenType, text);
        Tree t2 = (Tree)this.create(fromToken);
        return t2;
    }

    public int getType(Object t2) {
        return ((Tree)t2).getType();
    }

    public void setType(Object t2, int type) {
        throw new NoSuchMethodError("don't know enough about Tree node");
    }

    public String getText(Object t2) {
        return ((Tree)t2).getText();
    }

    public void setText(Object t2, String text) {
        throw new NoSuchMethodError("don't know enough about Tree node");
    }

    public Object getChild(Object t2, int i) {
        return ((Tree)t2).getChild(i);
    }

    public void setChild(Object t2, int i, Object child) {
        ((Tree)t2).setChild(i, (Tree)child);
    }

    public Object deleteChild(Object t2, int i) {
        return ((Tree)t2).deleteChild(i);
    }

    public int getChildCount(Object t2) {
        return ((Tree)t2).getChildCount();
    }

    public int getUniqueID(Object node) {
        Integer prevID;
        if (this.treeToUniqueIDMap == null) {
            this.treeToUniqueIDMap = new HashMap<Object, Integer>();
        }
        if ((prevID = this.treeToUniqueIDMap.get(node)) != null) {
            return prevID;
        }
        int ID = this.uniqueNodeID++;
        this.treeToUniqueIDMap.put(node, ID);
        return ID;
    }

    public abstract Token createToken(int var1, String var2);

    public abstract Token createToken(Token var1);
}

