/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.CommandAPDU;
import apdu4j.core.ResponseAPDU;
import java.util.EnumSet;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPSession;

abstract class SecureChannelWrapper {
    protected final int blockSize;
    protected byte[] encKey;
    protected byte[] macKey;
    protected byte[] rmacKey;
    protected boolean mac = true;
    protected boolean enc;
    protected boolean rmac;
    protected boolean renc;

    protected SecureChannelWrapper(byte[] enc, byte[] mac, byte[] rmac, int bs) {
        this.encKey = (byte[])enc.clone();
        this.macKey = (byte[])mac.clone();
        if (rmac != null) {
            this.rmacKey = (byte[])rmac.clone();
        }
        this.blockSize = bs;
    }

    protected int getBlockSize() {
        int res = this.blockSize;
        if (this.mac) {
            res -= 8;
        }
        if (this.enc) {
            res -= 8;
        }
        return res;
    }

    abstract CommandAPDU wrap(CommandAPDU var1) throws GPException;

    abstract ResponseAPDU unwrap(ResponseAPDU var1) throws GPException;

    void setSecurityLevel(EnumSet<GPSession.APDUMode> securityLevel) {
        this.mac = securityLevel.contains((Object)GPSession.APDUMode.MAC);
        this.enc = securityLevel.contains((Object)GPSession.APDUMode.ENC);
        this.rmac = securityLevel.contains((Object)GPSession.APDUMode.RMAC);
        this.renc = securityLevel.contains((Object)GPSession.APDUMode.RENC);
    }
}

