# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: efs
using AWS.Compat
using AWS.UUIDs

"""
    create_access_point(client_token, file_system_id)
    create_access_point(client_token, file_system_id, params::Dict{String,<:Any})

Creates an EFS access point. An access point is an application-specific view into an EFS
file system that applies an operating system user and group, and a file system path, to any
file system request made through the access point. The operating system user and group
override any identity information provided by the NFS client. The file system path is
exposed as the access point's root directory. Applications using the access point can only
access data in the application's own directory and any subdirectories. To learn more, see
Mounting a file system using EFS access points.  If multiple requests to create access
points on the same file system are sent in quick succession, and the file system is near
the limit of 1,000 access points, you may experience a throttling response for these
requests. This is to ensure that the file system does not exceed the stated access point
limit.  This operation requires permissions for the elasticfilesystem:CreateAccessPoint
action. Access points can be tagged on creation. If tags are specified in the creation
action, IAM performs additional authorization on the elasticfilesystem:TagResource action
to verify if users have permissions to create tags. Therefore, you must grant explicit
permissions to use the elasticfilesystem:TagResource action. For more information, see
Granting permissions to tag resources during creation.

# Arguments
- `client_token`: A string of up to 64 ASCII characters that Amazon EFS uses to ensure
  idempotent creation.
- `file_system_id`: The ID of the EFS file system that the access point provides access to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PosixUser"`: The operating system user and group applied to all file system requests
  made using the access point.
- `"RootDirectory"`: Specifies the directory on the EFS file system that the access point
  exposes as the root directory of your file system to NFS clients using the access point.
  The clients using the access point can only access the root directory and below. If the
  RootDirectory &gt; Path specified does not exist, Amazon EFS creates it and applies the
  CreationInfo settings when a client connects to an access point. When specifying a
  RootDirectory, you must provide the Path, and the CreationInfo. Amazon EFS creates a root
  directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions for
  the directory. If you do not provide this information, Amazon EFS does not create the root
  directory. If the root directory does not exist, attempts to mount using the access point
  will fail.
- `"Tags"`: Creates tags associated with the access point. Each tag is a key-value pair,
  each key must be unique. For more information, see Tagging Amazon Web Services resources in
  the Amazon Web Services General Reference Guide.
"""
function create_access_point(
    ClientToken, FileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "POST",
        "/2015-02-01/access-points",
        Dict{String,Any}("ClientToken" => ClientToken, "FileSystemId" => FileSystemId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_access_point(
    ClientToken,
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "POST",
        "/2015-02-01/access-points",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken, "FileSystemId" => FileSystemId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_file_system(creation_token)
    create_file_system(creation_token, params::Dict{String,<:Any})

Creates a new, empty file system. The operation requires a creation token in the request
that Amazon EFS uses to ensure idempotent creation (calling the operation with same
creation token has no effect). If a file system does not currently exist that is owned by
the caller's Amazon Web Services account with the specified creation token, this operation
does the following:   Creates a new, empty file system. The file system will have an Amazon
EFS assigned ID, and an initial lifecycle state creating.   Returns with the description of
the created file system.   Otherwise, this operation returns a FileSystemAlreadyExists
error with the ID of the existing file system.  For basic use cases, you can use a randomly
generated UUID for the creation token.  The idempotent operation allows you to retry a
CreateFileSystem call without risk of creating an extra file system. This can happen when
an initial call fails in a way that leaves it uncertain whether or not a file system was
actually created. An example might be that a transport level timeout occurred or your
connection was reset. As long as you use the same creation token, if the initial call had
succeeded in creating a file system, the client can learn of its existence from the
FileSystemAlreadyExists error. For more information, see Creating a file system in the
Amazon EFS User Guide.  The CreateFileSystem call returns while the file system's lifecycle
state is still creating. You can check the file system creation status by calling the
DescribeFileSystems operation, which among other things returns the file system state.
This operation accepts an optional PerformanceMode parameter that you choose for your file
system. We recommend generalPurpose performance mode for all file systems. File systems
using the maxIO mode is a previous generation performance type that is designed for highly
parallelized workloads that can tolerate higher latencies than the General Purpose mode.
Max I/O mode is not supported for One Zone file systems or file systems that use Elastic
throughput.  Due to the higher per-operation latencies with Max I/O, we recommend using
General Purpose performance mode for all file systems.  The performance mode can't be
changed after the file system has been created. For more information, see Amazon EFS
performance modes. You can set the throughput mode for the file system using the
ThroughputMode parameter. After the file system is fully created, Amazon EFS sets its
lifecycle state to available, at which point you can create one or more mount targets for
the file system in your VPC. For more information, see CreateMountTarget. You mount your
Amazon EFS file system on an EC2 instances in your VPC by using the mount target. For more
information, see Amazon EFS: How it Works.  This operation requires permissions for the
elasticfilesystem:CreateFileSystem action.  File systems can be tagged on creation. If tags
are specified in the creation action, IAM performs additional authorization on the
elasticfilesystem:TagResource action to verify if users have permissions to create tags.
Therefore, you must grant explicit permissions to use the elasticfilesystem:TagResource
action. For more information, see Granting permissions to tag resources during creation.

# Arguments
- `creation_token`: A string of up to 64 ASCII characters. Amazon EFS uses this to ensure
  idempotent creation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AvailabilityZoneName"`: Used to create a One Zone file system. It specifies the Amazon
  Web Services Availability Zone in which to create the file system. Use the format
  us-east-1a to specify the Availability Zone. For more information about One Zone file
  systems, see Using EFS storage classes in the Amazon EFS User Guide.  One Zone file systems
  are not available in all Availability Zones in Amazon Web Services Regions where Amazon EFS
  is available.
- `"Backup"`: Specifies whether automatic backups are enabled on the file system that you
  are creating. Set the value to true to enable automatic backups. If you are creating a One
  Zone file system, automatic backups are enabled by default. For more information, see
  Automatic backups in the Amazon EFS User Guide. Default is false. However, if you specify
  an AvailabilityZoneName, the default is true.  Backup is not available in all Amazon Web
  Services Regions where Amazon EFS is available.
- `"Encrypted"`: A Boolean value that, if true, creates an encrypted file system. When
  creating an encrypted file system, you have the option of specifying an existing Key
  Management Service key (KMS key). If you don't specify a KMS key, then the default KMS key
  for Amazon EFS, /aws/elasticfilesystem, is used to protect the encrypted file system.
- `"KmsKeyId"`: The ID of the KMS key that you want to use to protect the encrypted file
  system. This parameter is required only if you want to use a non-default KMS key. If this
  parameter is not specified, the default KMS key for Amazon EFS is used. You can specify a
  KMS key ID using the following formats:   Key ID - A unique identifier of the key, for
  example 1234abcd-12ab-34cd-56ef-1234567890ab.   ARN - An Amazon Resource Name (ARN) for the
  key, for example
  arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias -
  A previously created display name for a key, for example alias/projectKey1.   Key alias ARN
  - An ARN for a key alias, for example arn:aws:kms:us-west-2:444455556666:alias/projectKey1.
    If you use KmsKeyId, you must set the CreateFileSystemRequestEncrypted parameter to true.
   EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with Amazon EFS
  file systems.
- `"PerformanceMode"`: The Performance mode of the file system. We recommend generalPurpose
  performance mode for all file systems. File systems using the maxIO performance mode can
  scale to higher levels of aggregate throughput and operations per second with a tradeoff of
  slightly higher latencies for most file operations. The performance mode can't be changed
  after the file system has been created. The maxIO mode is not supported on One Zone file
  systems.  Due to the higher per-operation latencies with Max I/O, we recommend using
  General Purpose performance mode for all file systems.  Default is generalPurpose.
- `"ProvisionedThroughputInMibps"`: The throughput, measured in mebibytes per second
  (MiBps), that you want to provision for a file system that you're creating. Required if
  ThroughputMode is set to provisioned. Valid values are 1-3414 MiBps, with the upper limit
  depending on Region. To increase this limit, contact Amazon Web Services Support. For more
  information, see Amazon EFS quotas that you can increase in the Amazon EFS User Guide.
- `"Tags"`: Use to create one or more tags associated with the file system. Each tag is a
  user-defined key-value pair. Name your file system on creation by including a
  \"Key\":\"Name\",\"Value\":\"{value}\" key-value pair. Each key must be unique. For more
  information, see Tagging Amazon Web Services resources in the Amazon Web Services General
  Reference Guide.
- `"ThroughputMode"`: Specifies the throughput mode for the file system. The mode can be
  bursting, provisioned, or elastic. If you set ThroughputMode to provisioned, you must also
  set a value for ProvisionedThroughputInMibps. After you create the file system, you can
  decrease your file system's Provisioned throughput or change between the throughput modes,
  with certain time restrictions. For more information, see Specifying throughput with
  provisioned mode in the Amazon EFS User Guide.  Default is bursting.
"""
function create_file_system(
    CreationToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "POST",
        "/2015-02-01/file-systems",
        Dict{String,Any}("CreationToken" => CreationToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_file_system(
    CreationToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "POST",
        "/2015-02-01/file-systems",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CreationToken" => CreationToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_mount_target(file_system_id, subnet_id)
    create_mount_target(file_system_id, subnet_id, params::Dict{String,<:Any})

Creates a mount target for a file system. You can then mount the file system on EC2
instances by using the mount target. You can create one mount target in each Availability
Zone in your VPC. All EC2 instances in a VPC within a given Availability Zone share a
single mount target for a given file system. If you have multiple subnets in an
Availability Zone, you create a mount target in one of the subnets. EC2 instances do not
need to be in the same subnet as the mount target in order to access their file system. You
can create only one mount target for a One Zone file system. You must create that mount
target in the same Availability Zone in which the file system is located. Use the
AvailabilityZoneName and AvailabiltyZoneId properties in the DescribeFileSystems response
object to get this information. Use the subnetId associated with the file system's
Availability Zone when creating the mount target. For more information, see Amazon EFS: How
it Works.  To create a mount target for a file system, the file system's lifecycle state
must be available. For more information, see DescribeFileSystems. In the request, provide
the following:   The file system ID for which you are creating the mount target.   A subnet
ID, which determines the following:   The VPC in which Amazon EFS creates the mount target
 The Availability Zone in which Amazon EFS creates the mount target   The IP address range
from which Amazon EFS selects the IP address of the mount target (if you don't specify an
IP address in the request)     After creating the mount target, Amazon EFS returns a
response that includes, a MountTargetId and an IpAddress. You use this IP address when
mounting the file system in an EC2 instance. You can also use the mount target's DNS name
when mounting the file system. The EC2 instance on which you mount the file system by using
the mount target can resolve the mount target's DNS name to its IP address. For more
information, see How it Works: Implementation Overview.  Note that you can create mount
targets for a file system in only one VPC, and there can be only one mount target per
Availability Zone. That is, if the file system already has one or more mount targets
created for it, the subnet specified in the request to add another mount target must meet
the following requirements:   Must belong to the same VPC as the subnets of the existing
mount targets   Must not be in the same Availability Zone as any of the subnets of the
existing mount targets   If the request satisfies the requirements, Amazon EFS does the
following:   Creates a new mount target in the specified subnet.   Also creates a new
network interface in the subnet as follows:   If the request provides an IpAddress, Amazon
EFS assigns that IP address to the network interface. Otherwise, Amazon EFS assigns a free
address in the subnet (in the same way that the Amazon EC2 CreateNetworkInterface call does
when a request does not specify a primary private IP address).   If the request provides
SecurityGroups, this network interface is associated with those security groups. Otherwise,
it belongs to the default security group for the subnet's VPC.   Assigns the description
Mount target fsmt-id for file system fs-id  where  fsmt-id  is the mount target ID, and
fs-id  is the FileSystemId.   Sets the requesterManaged property of the network interface
to true, and the requesterId value to EFS.   Each Amazon EFS mount target has one
corresponding requester-managed EC2 network interface. After the network interface is
created, Amazon EFS sets the NetworkInterfaceId field in the mount target's description to
the network interface ID, and the IpAddress field to its address. If network interface
creation fails, the entire CreateMountTarget operation fails.    The CreateMountTarget call
returns only after creating the network interface, but while the mount target state is
still creating, you can check the mount target creation status by calling the
DescribeMountTargets operation, which among other things returns the mount target state.
We recommend that you create a mount target in each of the Availability Zones. There are
cost considerations for using a file system in an Availability Zone through a mount target
created in another Availability Zone. For more information, see Amazon EFS. In addition, by
always using a mount target local to the instance's Availability Zone, you eliminate a
partial failure scenario. If the Availability Zone in which your mount target is created
goes down, then you can't access your file system through that mount target.  This
operation requires permissions for the following action on the file system:
elasticfilesystem:CreateMountTarget    This operation also requires permissions for the
following Amazon EC2 actions:    ec2:DescribeSubnets     ec2:DescribeNetworkInterfaces
ec2:CreateNetworkInterface

# Arguments
- `file_system_id`: The ID of the file system for which to create the mount target.
- `subnet_id`: The ID of the subnet to add the mount target in. For One Zone file systems,
  use the subnet that is associated with the file system's Availability Zone.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IpAddress"`: Valid IPv4 address within the address range of the specified subnet.
- `"SecurityGroups"`: Up to five VPC security group IDs, of the form sg-xxxxxxxx. These
  must be for the same VPC as subnet specified.
"""
function create_mount_target(
    FileSystemId, SubnetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "POST",
        "/2015-02-01/mount-targets",
        Dict{String,Any}("FileSystemId" => FileSystemId, "SubnetId" => SubnetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_mount_target(
    FileSystemId,
    SubnetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "POST",
        "/2015-02-01/mount-targets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FileSystemId" => FileSystemId, "SubnetId" => SubnetId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_replication_configuration(destinations, source_file_system_id)
    create_replication_configuration(destinations, source_file_system_id, params::Dict{String,<:Any})

Creates a replication configuration that replicates an existing EFS file system to a new,
read-only file system. For more information, see Amazon EFS replication in the Amazon EFS
User Guide. The replication configuration specifies the following:    Source file system
– The EFS file system that you want replicated. The source file system cannot be a
destination file system in an existing replication configuration.    Amazon Web Services
Region – The Amazon Web Services Region in which the destination file system is created.
Amazon EFS replication is available in all Amazon Web Services Regions in which EFS is
available. The Region must be enabled. For more information, see Managing Amazon Web
Services Regions in the Amazon Web Services General Reference Reference Guide.
Destination file system configuration – The configuration of the destination file system
to which the source file system will be replicated. There can only be one destination file
system in a replication configuration.  Parameters for the replication configuration
include:    File system ID – The ID of the destination file system for the replication.
If no ID is provided, then EFS creates a new file system with the default settings. For
existing file systems, the file system's replication overwrite protection must be disabled.
For more information, see  Replicating to an existing file system.    Availability Zone –
If you want the destination file system to use One Zone storage, you must specify the
Availability Zone to create the file system in. For more information, see  EFS file system
types in the Amazon EFS User Guide.    Encryption – All destination file systems are
created with encryption at rest enabled. You can specify the Key Management Service (KMS)
key that is used to encrypt the destination file system. If you don't specify a KMS key,
your service-managed KMS key for Amazon EFS is used.   After the file system is created,
you cannot change the KMS key.       After the file system is created, you cannot change
the KMS key.  For new destination file systems, the following properties are set by
default:    Performance mode - The destination file system's performance mode matches that
of the source file system, unless the destination file system uses EFS One Zone storage. In
that case, the General Purpose performance mode is used. The performance mode cannot be
changed.    Throughput mode - The destination file system's throughput mode matches that of
the source file system. After the file system is created, you can modify the throughput
mode.      Lifecycle management – Lifecycle management is not enabled on the destination
file system. After the destination file system is created, you can enable lifecycle
management.    Automatic backups – Automatic daily backups are enabled on the destination
file system. After the file system is created, you can change this setting.   For more
information, see Amazon EFS replication in the Amazon EFS User Guide.

# Arguments
- `destinations`: An array of destination configuration objects. Only one destination
  configuration object is supported.
- `source_file_system_id`: Specifies the Amazon EFS file system that you want to replicate.
  This file system cannot already be a source or destination file system in another
  replication configuration.

"""
function create_replication_configuration(
    Destinations, SourceFileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "POST",
        "/2015-02-01/file-systems/$(SourceFileSystemId)/replication-configuration",
        Dict{String,Any}("Destinations" => Destinations);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_replication_configuration(
    Destinations,
    SourceFileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "POST",
        "/2015-02-01/file-systems/$(SourceFileSystemId)/replication-configuration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Destinations" => Destinations), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_tags(file_system_id, tags)
    create_tags(file_system_id, tags, params::Dict{String,<:Any})

 DEPRECATED - CreateTags is deprecated and not maintained. To create tags for EFS
resources, use the API action.  Creates or overwrites tags associated with a file system.
Each tag is a key-value pair. If a tag key specified in the request already exists on the
file system, this operation overwrites its value with the value provided in the request. If
you add the Name tag to your file system, Amazon EFS returns it in the response to the
DescribeFileSystems operation.  This operation requires permission for the
elasticfilesystem:CreateTags action.

# Arguments
- `file_system_id`: The ID of the file system whose tags you want to modify (String). This
  operation modifies the tags only, not the file system.
- `tags`: An array of Tag objects to add. Each Tag object is a key-value pair.

"""
function create_tags(FileSystemId, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return efs(
        "POST",
        "/2015-02-01/create-tags/$(FileSystemId)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_tags(
    FileSystemId,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "POST",
        "/2015-02-01/create-tags/$(FileSystemId)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_access_point(access_point_id)
    delete_access_point(access_point_id, params::Dict{String,<:Any})

Deletes the specified access point. After deletion is complete, new clients can no longer
connect to the access points. Clients connected to the access point at the time of deletion
will continue to function until they terminate their connection. This operation requires
permissions for the elasticfilesystem:DeleteAccessPoint action.

# Arguments
- `access_point_id`: The ID of the access point that you want to delete.

"""
function delete_access_point(
    AccessPointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "DELETE",
        "/2015-02-01/access-points/$(AccessPointId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_access_point(
    AccessPointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "DELETE",
        "/2015-02-01/access-points/$(AccessPointId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_file_system(file_system_id)
    delete_file_system(file_system_id, params::Dict{String,<:Any})

Deletes a file system, permanently severing access to its contents. Upon return, the file
system no longer exists and you can't access any contents of the deleted file system. You
need to manually delete mount targets attached to a file system before you can delete an
EFS file system. This step is performed for you when you use the Amazon Web Services
console to delete a file system.  You cannot delete a file system that is part of an EFS
Replication configuration. You need to delete the replication configuration first.   You
can't delete a file system that is in use. That is, if the file system has any mount
targets, you must first delete them. For more information, see DescribeMountTargets and
DeleteMountTarget.   The DeleteFileSystem call returns while the file system state is still
deleting. You can check the file system deletion status by calling the DescribeFileSystems
operation, which returns a list of file systems in your account. If you pass file system ID
or creation token for the deleted file system, the DescribeFileSystems returns a 404
FileSystemNotFound error.  This operation requires permissions for the
elasticfilesystem:DeleteFileSystem action.

# Arguments
- `file_system_id`: The ID of the file system you want to delete.

"""
function delete_file_system(
    FileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "DELETE",
        "/2015-02-01/file-systems/$(FileSystemId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_file_system(
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "DELETE",
        "/2015-02-01/file-systems/$(FileSystemId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_file_system_policy(file_system_id)
    delete_file_system_policy(file_system_id, params::Dict{String,<:Any})

Deletes the FileSystemPolicy for the specified file system. The default FileSystemPolicy
goes into effect once the existing policy is deleted. For more information about the
default file system policy, see Using Resource-based Policies with EFS. This operation
requires permissions for the elasticfilesystem:DeleteFileSystemPolicy action.

# Arguments
- `file_system_id`: Specifies the EFS file system for which to delete the FileSystemPolicy.

"""
function delete_file_system_policy(
    FileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "DELETE",
        "/2015-02-01/file-systems/$(FileSystemId)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_file_system_policy(
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "DELETE",
        "/2015-02-01/file-systems/$(FileSystemId)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_mount_target(mount_target_id)
    delete_mount_target(mount_target_id, params::Dict{String,<:Any})

Deletes the specified mount target. This operation forcibly breaks any mounts of the file
system by using the mount target that is being deleted, which might disrupt instances or
applications using those mounts. To avoid applications getting cut off abruptly, you might
consider unmounting any mounts of the mount target, if feasible. The operation also deletes
the associated network interface. Uncommitted writes might be lost, but breaking a mount
target using this operation does not corrupt the file system itself. The file system you
created remains. You can mount an EC2 instance in your VPC by using another mount target.
This operation requires permissions for the following action on the file system:
elasticfilesystem:DeleteMountTarget     The DeleteMountTarget call returns while the mount
target state is still deleting. You can check the mount target deletion by calling the
DescribeMountTargets operation, which returns a list of mount target descriptions for the
given file system.   The operation also requires permissions for the following Amazon EC2
action on the mount target's network interface:    ec2:DeleteNetworkInterface

# Arguments
- `mount_target_id`: The ID of the mount target to delete (String).

"""
function delete_mount_target(
    MountTargetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "DELETE",
        "/2015-02-01/mount-targets/$(MountTargetId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_mount_target(
    MountTargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "DELETE",
        "/2015-02-01/mount-targets/$(MountTargetId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_replication_configuration(source_file_system_id)
    delete_replication_configuration(source_file_system_id, params::Dict{String,<:Any})

Deletes a replication configuration. Deleting a replication configuration ends the
replication process. After a replication configuration is deleted, the destination file
system becomes Writeable and its replication overwrite protection is re-enabled. For more
information, see Delete a replication configuration. This operation requires permissions
for the elasticfilesystem:DeleteReplicationConfiguration action.

# Arguments
- `source_file_system_id`: The ID of the source file system in the replication
  configuration.

"""
function delete_replication_configuration(
    SourceFileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "DELETE",
        "/2015-02-01/file-systems/$(SourceFileSystemId)/replication-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_replication_configuration(
    SourceFileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "DELETE",
        "/2015-02-01/file-systems/$(SourceFileSystemId)/replication-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tags(file_system_id, tag_keys)
    delete_tags(file_system_id, tag_keys, params::Dict{String,<:Any})

 DEPRECATED - DeleteTags is deprecated and not maintained. To remove tags from EFS
resources, use the API action.  Deletes the specified tags from a file system. If the
DeleteTags request includes a tag key that doesn't exist, Amazon EFS ignores it and doesn't
cause an error. For more information about tags and related restrictions, see Tag
restrictions in the Billing and Cost Management User Guide. This operation requires
permissions for the elasticfilesystem:DeleteTags action.

# Arguments
- `file_system_id`: The ID of the file system whose tags you want to delete (String).
- `tag_keys`: A list of tag keys to delete.

"""
function delete_tags(
    FileSystemId, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "POST",
        "/2015-02-01/delete-tags/$(FileSystemId)",
        Dict{String,Any}("TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tags(
    FileSystemId,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "POST",
        "/2015-02-01/delete-tags/$(FileSystemId)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TagKeys" => TagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_access_points()
    describe_access_points(params::Dict{String,<:Any})

Returns the description of a specific Amazon EFS access point if the AccessPointId is
provided. If you provide an EFS FileSystemId, it returns descriptions of all access points
for that file system. You can provide either an AccessPointId or a FileSystemId in the
request, but not both.  This operation requires permissions for the
elasticfilesystem:DescribeAccessPoints action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessPointId"`: (Optional) Specifies an EFS access point to describe in the response;
  mutually exclusive with FileSystemId.
- `"FileSystemId"`: (Optional) If you provide a FileSystemId, EFS returns all access points
  for that file system; mutually exclusive with AccessPointId.
- `"MaxResults"`: (Optional) When retrieving all access points for a file system, you can
  optionally specify the MaxItems parameter to limit the number of objects returned in a
  response. The default value is 100.
- `"NextToken"`:  NextToken is present if the response is paginated. You can use NextMarker
  in the subsequent request to fetch the next page of access point descriptions.
"""
function describe_access_points(; aws_config::AbstractAWSConfig=current_aws_config())
    return efs(
        "GET",
        "/2015-02-01/access-points";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_access_points(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/access-points",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account_preferences()
    describe_account_preferences(params::Dict{String,<:Any})

Returns the account preferences settings for the Amazon Web Services account associated
with the user making the request, in the current Amazon Web Services Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: (Optional) When retrieving account preferences, you can optionally
  specify the MaxItems parameter to limit the number of objects returned in a response. The
  default value is 100.
- `"NextToken"`: (Optional) You can use NextToken in a subsequent request to fetch the next
  page of Amazon Web Services account preferences if the response payload was paginated.
"""
function describe_account_preferences(; aws_config::AbstractAWSConfig=current_aws_config())
    return efs(
        "GET",
        "/2015-02-01/account-preferences";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_account_preferences(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/account-preferences",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_backup_policy(file_system_id)
    describe_backup_policy(file_system_id, params::Dict{String,<:Any})

Returns the backup policy for the specified EFS file system.

# Arguments
- `file_system_id`: Specifies which EFS file system for which to retrieve the BackupPolicy.

"""
function describe_backup_policy(
    FileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/file-systems/$(FileSystemId)/backup-policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_backup_policy(
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "GET",
        "/2015-02-01/file-systems/$(FileSystemId)/backup-policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_file_system_policy(file_system_id)
    describe_file_system_policy(file_system_id, params::Dict{String,<:Any})

Returns the FileSystemPolicy for the specified EFS file system. This operation requires
permissions for the elasticfilesystem:DescribeFileSystemPolicy action.

# Arguments
- `file_system_id`: Specifies which EFS file system to retrieve the FileSystemPolicy for.

"""
function describe_file_system_policy(
    FileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/file-systems/$(FileSystemId)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_file_system_policy(
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "GET",
        "/2015-02-01/file-systems/$(FileSystemId)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_file_systems()
    describe_file_systems(params::Dict{String,<:Any})

Returns the description of a specific Amazon EFS file system if either the file system
CreationToken or the FileSystemId is provided. Otherwise, it returns descriptions of all
file systems owned by the caller's Amazon Web Services account in the Amazon Web Services
Region of the endpoint that you're calling. When retrieving all file system descriptions,
you can optionally specify the MaxItems parameter to limit the number of descriptions in a
response. This number is automatically set to 100. If more file system descriptions remain,
Amazon EFS returns a NextMarker, an opaque token, in the response. In this case, you should
send a subsequent request with the Marker request parameter set to the value of NextMarker.
 To retrieve a list of your file system descriptions, this operation is used in an
iterative process, where DescribeFileSystems is called first without the Marker and then
the operation continues to call it with the Marker parameter set to the value of the
NextMarker from the previous response until the response has no NextMarker.   The order of
file systems returned in the response of one DescribeFileSystems call and the order of file
systems returned across the responses of a multi-call iteration is unspecified.   This
operation requires permissions for the elasticfilesystem:DescribeFileSystems action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CreationToken"`: (Optional) Restricts the list to the file system with this creation
  token (String). You specify a creation token when you create an Amazon EFS file system.
- `"FileSystemId"`: (Optional) ID of the file system whose description you want to retrieve
  (String).
- `"Marker"`: (Optional) Opaque pagination token returned from a previous
  DescribeFileSystems operation (String). If present, specifies to continue the list from
  where the returning call had left off.
- `"MaxItems"`: (Optional) Specifies the maximum number of file systems to return in the
  response (integer). This number is automatically set to 100. The response is paginated at
  100 per page if you have more than 100 file systems.
"""
function describe_file_systems(; aws_config::AbstractAWSConfig=current_aws_config())
    return efs(
        "GET",
        "/2015-02-01/file-systems";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_file_systems(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/file-systems",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_lifecycle_configuration(file_system_id)
    describe_lifecycle_configuration(file_system_id, params::Dict{String,<:Any})

Returns the current LifecycleConfiguration object for the specified Amazon EFS file system.
Lifecycle management uses the LifecycleConfiguration object to identify when to move files
between storage classes. For a file system without a LifecycleConfiguration object, the
call returns an empty array in the response. This operation requires permissions for the
elasticfilesystem:DescribeLifecycleConfiguration operation.

# Arguments
- `file_system_id`: The ID of the file system whose LifecycleConfiguration object you want
  to retrieve (String).

"""
function describe_lifecycle_configuration(
    FileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/file-systems/$(FileSystemId)/lifecycle-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_lifecycle_configuration(
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "GET",
        "/2015-02-01/file-systems/$(FileSystemId)/lifecycle-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_mount_target_security_groups(mount_target_id)
    describe_mount_target_security_groups(mount_target_id, params::Dict{String,<:Any})

Returns the security groups currently in effect for a mount target. This operation requires
that the network interface of the mount target has been created and the lifecycle state of
the mount target is not deleted. This operation requires permissions for the following
actions:    elasticfilesystem:DescribeMountTargetSecurityGroups action on the mount
target's file system.     ec2:DescribeNetworkInterfaceAttribute action on the mount
target's network interface.

# Arguments
- `mount_target_id`: The ID of the mount target whose security groups you want to retrieve.

"""
function describe_mount_target_security_groups(
    MountTargetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/mount-targets/$(MountTargetId)/security-groups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_mount_target_security_groups(
    MountTargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "GET",
        "/2015-02-01/mount-targets/$(MountTargetId)/security-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_mount_targets()
    describe_mount_targets(params::Dict{String,<:Any})

Returns the descriptions of all the current mount targets, or a specific mount target, for
a file system. When requesting all of the current mount targets, the order of mount targets
returned in the response is unspecified. This operation requires permissions for the
elasticfilesystem:DescribeMountTargets action, on either the file system ID that you
specify in FileSystemId, or on the file system of the mount target that you specify in
MountTargetId.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessPointId"`: (Optional) The ID of the access point whose mount targets that you
  want to list. It must be included in your request if a FileSystemId or MountTargetId is not
  included in your request. Accepts either an access point ID or ARN as input.
- `"FileSystemId"`: (Optional) ID of the file system whose mount targets you want to list
  (String). It must be included in your request if an AccessPointId or MountTargetId is not
  included. Accepts either a file system ID or ARN as input.
- `"Marker"`: (Optional) Opaque pagination token returned from a previous
  DescribeMountTargets operation (String). If present, it specifies to continue the list from
  where the previous returning call left off.
- `"MaxItems"`: (Optional) Maximum number of mount targets to return in the response.
  Currently, this number is automatically set to 10, and other values are ignored. The
  response is paginated at 100 per page if you have more than 100 mount targets.
- `"MountTargetId"`: (Optional) ID of the mount target that you want to have described
  (String). It must be included in your request if FileSystemId is not included. Accepts
  either a mount target ID or ARN as input.
"""
function describe_mount_targets(; aws_config::AbstractAWSConfig=current_aws_config())
    return efs(
        "GET",
        "/2015-02-01/mount-targets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_mount_targets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/mount-targets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_replication_configurations()
    describe_replication_configurations(params::Dict{String,<:Any})

Retrieves the replication configuration for a specific file system. If a file system is not
specified, all of the replication configurations for the Amazon Web Services account in an
Amazon Web Services Region are retrieved.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FileSystemId"`: You can retrieve the replication configuration for a specific file
  system by providing its file system ID.
- `"MaxResults"`: (Optional) To limit the number of objects returned in a response, you can
  specify the MaxItems parameter. The default value is 100.
- `"NextToken"`:  NextToken is present if the response is paginated. You can use NextToken
  in a subsequent request to fetch the next page of output.
"""
function describe_replication_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/file-systems/replication-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_replication_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/file-systems/replication-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_tags(file_system_id)
    describe_tags(file_system_id, params::Dict{String,<:Any})

 DEPRECATED - The DescribeTags action is deprecated and not maintained. To view tags
associated with EFS resources, use the ListTagsForResource API action.  Returns the tags
associated with a file system. The order of tags returned in the response of one
DescribeTags call and the order of tags returned across the responses of a multiple-call
iteration (when using pagination) is unspecified.   This operation requires permissions for
the elasticfilesystem:DescribeTags action.

# Arguments
- `file_system_id`: The ID of the file system whose tag set you want to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: (Optional) An opaque pagination token returned from a previous DescribeTags
  operation (String). If present, it specifies to continue the list from where the previous
  call left off.
- `"MaxItems"`: (Optional) The maximum number of file system tags to return in the
  response. Currently, this number is automatically set to 100, and other values are ignored.
  The response is paginated at 100 per page if you have more than 100 tags.
"""
function describe_tags(FileSystemId; aws_config::AbstractAWSConfig=current_aws_config())
    return efs(
        "GET",
        "/2015-02-01/tags/$(FileSystemId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_tags(
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "GET",
        "/2015-02-01/tags/$(FileSystemId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_id)
    list_tags_for_resource(resource_id, params::Dict{String,<:Any})

Lists all tags for a top-level EFS resource. You must provide the ID of the resource that
you want to retrieve the tags for. This operation requires permissions for the
elasticfilesystem:DescribeAccessPoints action.

# Arguments
- `resource_id`: Specifies the EFS resource you want to retrieve tags for. You can retrieve
  tags for EFS file systems and access points using this API endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: (Optional) Specifies the maximum number of tag objects to return in the
  response. The default value is 100.
- `"NextToken"`: (Optional) You can use NextToken in a subsequent request to fetch the next
  page of access point descriptions if the response payload was paginated.
"""
function list_tags_for_resource(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "GET",
        "/2015-02-01/resource-tags/$(ResourceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "GET",
        "/2015-02-01/resource-tags/$(ResourceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_mount_target_security_groups(mount_target_id)
    modify_mount_target_security_groups(mount_target_id, params::Dict{String,<:Any})

Modifies the set of security groups in effect for a mount target. When you create a mount
target, Amazon EFS also creates a new network interface. For more information, see
CreateMountTarget. This operation replaces the security groups in effect for the network
interface associated with a mount target, with the SecurityGroups provided in the request.
This operation requires that the network interface of the mount target has been created and
the lifecycle state of the mount target is not deleted.  The operation requires permissions
for the following actions:    elasticfilesystem:ModifyMountTargetSecurityGroups action on
the mount target's file system.     ec2:ModifyNetworkInterfaceAttribute action on the mount
target's network interface.

# Arguments
- `mount_target_id`: The ID of the mount target whose security groups you want to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SecurityGroups"`: An array of up to five VPC security group IDs.
"""
function modify_mount_target_security_groups(
    MountTargetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "PUT",
        "/2015-02-01/mount-targets/$(MountTargetId)/security-groups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_mount_target_security_groups(
    MountTargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "PUT",
        "/2015-02-01/mount-targets/$(MountTargetId)/security-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_account_preferences(resource_id_type)
    put_account_preferences(resource_id_type, params::Dict{String,<:Any})

Use this operation to set the account preference in the current Amazon Web Services Region
to use long 17 character (63 bit) or short 8 character (32 bit) resource IDs for new EFS
file system and mount target resources. All existing resource IDs are not affected by any
changes you make. You can set the ID preference during the opt-in period as EFS transitions
to long resource IDs. For more information, see Managing Amazon EFS resource IDs.  Starting
in October, 2021, you will receive an error if you try to set the account preference to use
the short 8 character format resource ID. Contact Amazon Web Services support if you
receive an error and must use short IDs for file system and mount target resources.

# Arguments
- `resource_id_type`: Specifies the EFS resource ID preference to set for the user's Amazon
  Web Services account, in the current Amazon Web Services Region, either LONG_ID (17
  characters), or SHORT_ID (8 characters).  Starting in October, 2021, you will receive an
  error when setting the account preference to SHORT_ID. Contact Amazon Web Services support
  if you receive an error and must use short IDs for file system and mount target resources.

"""
function put_account_preferences(
    ResourceIdType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "PUT",
        "/2015-02-01/account-preferences",
        Dict{String,Any}("ResourceIdType" => ResourceIdType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_account_preferences(
    ResourceIdType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "PUT",
        "/2015-02-01/account-preferences",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceIdType" => ResourceIdType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_backup_policy(backup_policy, file_system_id)
    put_backup_policy(backup_policy, file_system_id, params::Dict{String,<:Any})

Updates the file system's backup policy. Use this action to start or stop automatic backups
of the file system.

# Arguments
- `backup_policy`: The backup policy included in the PutBackupPolicy request.
- `file_system_id`: Specifies which EFS file system to update the backup policy for.

"""
function put_backup_policy(
    BackupPolicy, FileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)/backup-policy",
        Dict{String,Any}("BackupPolicy" => BackupPolicy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_backup_policy(
    BackupPolicy,
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)/backup-policy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("BackupPolicy" => BackupPolicy), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_file_system_policy(file_system_id, policy)
    put_file_system_policy(file_system_id, policy, params::Dict{String,<:Any})

Applies an Amazon EFS FileSystemPolicy to an Amazon EFS file system. A file system policy
is an IAM resource-based policy and can contain multiple policy statements. A file system
always has exactly one file system policy, which can be the default policy or an explicit
policy set or updated using this API operation. EFS file system policies have a 20,000
character limit. When an explicit policy is set, it overrides the default policy. For more
information about the default file system policy, see Default EFS File System Policy.   EFS
file system policies have a 20,000 character limit.  This operation requires permissions
for the elasticfilesystem:PutFileSystemPolicy action.

# Arguments
- `file_system_id`: The ID of the EFS file system that you want to create or update the
  FileSystemPolicy for.
- `policy`: The FileSystemPolicy that you're creating. Accepts a JSON formatted policy
  definition. EFS file system policies have a 20,000 character limit. To find out more about
  the elements that make up a file system policy, see EFS Resource-based Policies.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BypassPolicyLockoutSafetyCheck"`: (Optional) A boolean that specifies whether or not to
  bypass the FileSystemPolicy lockout safety check. The lockout safety check determines
  whether the policy in the request will lock out, or prevent, the IAM principal that is
  making the request from making future PutFileSystemPolicy requests on this file system. Set
  BypassPolicyLockoutSafetyCheck to True only when you intend to prevent the IAM principal
  that is making the request from making subsequent PutFileSystemPolicy requests on this file
  system. The default value is False.
"""
function put_file_system_policy(
    FileSystemId, Policy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)/policy",
        Dict{String,Any}("Policy" => Policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_file_system_policy(
    FileSystemId,
    Policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)/policy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Policy" => Policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_lifecycle_configuration(file_system_id, lifecycle_policies)
    put_lifecycle_configuration(file_system_id, lifecycle_policies, params::Dict{String,<:Any})

Use this action to manage storage for your file system. A LifecycleConfiguration consists
of one or more LifecyclePolicy objects that define the following:     TransitionToIA  –
When to move files in the file system from primary storage (Standard storage class) into
the Infrequent Access (IA) storage.     TransitionToArchive  – When to move files in the
file system from their current storage class (either IA or Standard storage) into the
Archive storage. File systems cannot transition into Archive storage before transitioning
into IA storage. Therefore, TransitionToArchive must either not be set or must be later
than TransitionToIA.   The Archive storage class is available only for file systems that
use the Elastic Throughput mode and the General Purpose Performance mode.
TransitionToPrimaryStorageClass  – Whether to move files in the file system back to
primary storage (Standard storage class) after they are accessed in IA or Archive storage.
 For more information, see  Managing file system storage. Each Amazon EFS file system
supports one lifecycle configuration, which applies to all files in the file system. If a
LifecycleConfiguration object already exists for the specified file system, a
PutLifecycleConfiguration call modifies the existing configuration. A
PutLifecycleConfiguration call with an empty LifecyclePolicies array in the request body
deletes any existing LifecycleConfiguration. In the request, specify the following:    The
ID for the file system for which you are enabling, disabling, or modifying Lifecycle
management.   A LifecyclePolicies array of LifecyclePolicy objects that define when to move
files to IA storage, to Archive storage, and back to primary storage.  Amazon EFS requires
that each LifecyclePolicy object have only have a single transition, so the
LifecyclePolicies array needs to be structured with separate LifecyclePolicy objects. See
the example requests in the following section for more information.    This operation
requires permissions for the elasticfilesystem:PutLifecycleConfiguration operation. To
apply a LifecycleConfiguration object to an encrypted file system, you need the same Key
Management Service permissions as when you created the encrypted file system.

# Arguments
- `file_system_id`: The ID of the file system for which you are creating the
  LifecycleConfiguration object (String).
- `lifecycle_policies`: An array of LifecyclePolicy objects that define the file system's
  LifecycleConfiguration object. A LifecycleConfiguration object informs EFS Lifecycle
  management of the following:     TransitionToIA  – When to move files in the file system
  from primary storage (Standard storage class) into the Infrequent Access (IA) storage.
  TransitionToArchive  – When to move files in the file system from their current storage
  class (either IA or Standard storage) into the Archive storage. File systems cannot
  transition into Archive storage before transitioning into IA storage. Therefore,
  TransitionToArchive must either not be set or must be later than TransitionToIA.   The
  Archive storage class is available only for file systems that use the Elastic Throughput
  mode and the General Purpose Performance mode.       TransitionToPrimaryStorageClass  –
  Whether to move files in the file system back to primary storage (Standard storage class)
  after they are accessed in IA or Archive storage.    When using the
  put-lifecycle-configuration CLI command or the PutLifecycleConfiguration API action, Amazon
  EFS requires that each LifecyclePolicy object have only a single transition. This means
  that in a request body, LifecyclePolicies must be structured as an array of LifecyclePolicy
  objects, one object for each storage transition. See the example requests in the following
  section for more information.

"""
function put_lifecycle_configuration(
    FileSystemId, LifecyclePolicies; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)/lifecycle-configuration",
        Dict{String,Any}("LifecyclePolicies" => LifecyclePolicies);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_lifecycle_configuration(
    FileSystemId,
    LifecyclePolicies,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)/lifecycle-configuration",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("LifecyclePolicies" => LifecyclePolicies), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_id, tags)
    tag_resource(resource_id, tags, params::Dict{String,<:Any})

Creates a tag for an EFS resource. You can create tags for EFS file systems and access
points using this API operation. This operation requires permissions for the
elasticfilesystem:TagResource action.

# Arguments
- `resource_id`: The ID specifying the EFS resource that you want to create a tag for.
- `tags`: An array of Tag objects to add. Each Tag object is a key-value pair.

"""
function tag_resource(ResourceId, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return efs(
        "POST",
        "/2015-02-01/resource-tags/$(ResourceId)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceId,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "POST",
        "/2015-02-01/resource-tags/$(ResourceId)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_id, tag_keys)
    untag_resource(resource_id, tag_keys, params::Dict{String,<:Any})

Removes tags from an EFS resource. You can remove tags from EFS file systems and access
points using this API operation. This operation requires permissions for the
elasticfilesystem:UntagResource action.

# Arguments
- `resource_id`: Specifies the EFS resource that you want to remove tags from.
- `tag_keys`: The keys of the key-value tag pairs that you want to remove from the
  specified EFS resource.

"""
function untag_resource(
    ResourceId, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "DELETE",
        "/2015-02-01/resource-tags/$(ResourceId)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceId,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "DELETE",
        "/2015-02-01/resource-tags/$(ResourceId)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_file_system(file_system_id)
    update_file_system(file_system_id, params::Dict{String,<:Any})

Updates the throughput mode or the amount of provisioned throughput of an existing file
system.

# Arguments
- `file_system_id`: The ID of the file system that you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ProvisionedThroughputInMibps"`: (Optional) The throughput, measured in mebibytes per
  second (MiBps), that you want to provision for a file system that you're creating. Required
  if ThroughputMode is set to provisioned. Valid values are 1-3414 MiBps, with the upper
  limit depending on Region. To increase this limit, contact Amazon Web Services Support. For
  more information, see Amazon EFS quotas that you can increase in the Amazon EFS User Guide.
- `"ThroughputMode"`: (Optional) Updates the file system's throughput mode. If you're not
  updating your throughput mode, you don't need to provide this value in your request. If you
  are changing the ThroughputMode to provisioned, you must also set a value for
  ProvisionedThroughputInMibps.
"""
function update_file_system(
    FileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_file_system(
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_file_system_protection(file_system_id)
    update_file_system_protection(file_system_id, params::Dict{String,<:Any})

Updates protection on the file system. This operation requires permissions for the
elasticfilesystem:UpdateFileSystemProtection action.

# Arguments
- `file_system_id`: The ID of the file system to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ReplicationOverwriteProtection"`: The status of the file system's replication overwrite
  protection.    ENABLED – The file system cannot be used as the destination file system in
  a replication configuration. The file system is writeable. Replication overwrite protection
  is ENABLED by default.     DISABLED – The file system can be used as the destination file
  system in a replication configuration. The file system is read-only and can only be
  modified by EFS replication.    REPLICATING – The file system is being used as the
  destination file system in a replication configuration. The file system is read-only and is
  only modified only by EFS replication.   If the replication configuration is deleted, the
  file system's replication overwrite protection is re-enabled, the file system becomes
  writeable.
"""
function update_file_system_protection(
    FileSystemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)/protection";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_file_system_protection(
    FileSystemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return efs(
        "PUT",
        "/2015-02-01/file-systems/$(FileSystemId)/protection",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
