# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: importexport
using AWS.Compat
using AWS.UUIDs

"""
    cancel_job(job_id)
    cancel_job(job_id, params::Dict{String,<:Any})

This operation cancels a specified job. Only the job owner can cancel it. The operation
fails if the job has already started or is complete.

# Arguments
- `job_id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"APIVersion"`:
"""
function cancel_job(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return importexport(
        "CancelJob",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_job(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return importexport(
        "CancelJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_job(job_type, manifest, validate_only)
    create_job(job_type, manifest, validate_only, params::Dict{String,<:Any})

This operation initiates the process of scheduling an upload or download of your data. You
include in the request a manifest that describes the data transfer specifics. The response
to the request includes a job ID, which you can use in other operations, a signature that
you use to identify your storage device, and the address where you should ship your storage
device.

# Arguments
- `job_type`:
- `manifest`:
- `validate_only`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"APIVersion"`:
- `"ManifestAddendum"`:
"""
function create_job(
    JobType, Manifest, ValidateOnly; aws_config::AbstractAWSConfig=current_aws_config()
)
    return importexport(
        "CreateJob",
        Dict{String,Any}(
            "JobType" => JobType, "Manifest" => Manifest, "ValidateOnly" => ValidateOnly
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_job(
    JobType,
    Manifest,
    ValidateOnly,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return importexport(
        "CreateJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "JobType" => JobType,
                    "Manifest" => Manifest,
                    "ValidateOnly" => ValidateOnly,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_shipping_label(job_ids)
    get_shipping_label(job_ids, params::Dict{String,<:Any})

This operation generates a pre-paid UPS shipping label that you will use to ship your
device to AWS for processing.

# Arguments
- `job_ids`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"APIVersion"`:
- `"city"`:
- `"company"`:
- `"country"`:
- `"name"`:
- `"phoneNumber"`:
- `"postalCode"`:
- `"stateOrProvince"`:
- `"street1"`:
- `"street2"`:
- `"street3"`:
"""
function get_shipping_label(jobIds; aws_config::AbstractAWSConfig=current_aws_config())
    return importexport(
        "GetShippingLabel",
        Dict{String,Any}("jobIds" => jobIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_shipping_label(
    jobIds, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return importexport(
        "GetShippingLabel",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("jobIds" => jobIds), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_status(job_id)
    get_status(job_id, params::Dict{String,<:Any})

This operation returns information about a job, including where the job is in the
processing pipeline, the status of the results, and the signature value associated with the
job. You can only return information about jobs you own.

# Arguments
- `job_id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"APIVersion"`:
"""
function get_status(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return importexport(
        "GetStatus",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_status(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return importexport(
        "GetStatus",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_jobs()
    list_jobs(params::Dict{String,<:Any})

This operation returns the jobs associated with the requester. AWS Import/Export lists the
jobs in reverse chronological order based on the date of creation. For example if Job Test1
was created 2009Dec30 and Test2 was created 2010Feb05, the ListJobs operation would return
Test2 followed by Test1.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"APIVersion"`:
- `"Marker"`:
- `"MaxJobs"`:
"""
function list_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return importexport("ListJobs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return importexport(
        "ListJobs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    update_job(job_id, job_type, manifest, validate_only)
    update_job(job_id, job_type, manifest, validate_only, params::Dict{String,<:Any})

You use this operation to change the parameters specified in the original manifest file by
supplying a new manifest file. The manifest file attached to this request replaces the
original manifest file. You can only use the operation after a CreateJob request but before
the data transfer starts and you can only use it on jobs you own.

# Arguments
- `job_id`:
- `job_type`:
- `manifest`:
- `validate_only`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"APIVersion"`:
"""
function update_job(
    JobId,
    JobType,
    Manifest,
    ValidateOnly;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return importexport(
        "UpdateJob",
        Dict{String,Any}(
            "JobId" => JobId,
            "JobType" => JobType,
            "Manifest" => Manifest,
            "ValidateOnly" => ValidateOnly,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_job(
    JobId,
    JobType,
    Manifest,
    ValidateOnly,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return importexport(
        "UpdateJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "JobId" => JobId,
                    "JobType" => JobType,
                    "Manifest" => Manifest,
                    "ValidateOnly" => ValidateOnly,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
