# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: schemas
using AWS.Compat
using AWS.UUIDs

"""
    create_discoverer(source_arn)
    create_discoverer(source_arn, params::Dict{String,<:Any})

Creates a discoverer.

# Arguments
- `source_arn`: The ARN of the event bus.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CrossAccount"`: Support discovery of schemas in events sent to the bus from another
  account. (default: true).
- `"Description"`: A description for the discoverer.
- `"tags"`: Tags associated with the resource.
"""
function create_discoverer(SourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "POST",
        "/v1/discoverers",
        Dict{String,Any}("SourceArn" => SourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_discoverer(
    SourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "POST",
        "/v1/discoverers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SourceArn" => SourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_registry(registry_name)
    create_registry(registry_name, params::Dict{String,<:Any})

Creates a registry.

# Arguments
- `registry_name`: The name of the registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the registry to be created.
- `"tags"`: Tags to associate with the registry.
"""
function create_registry(registryName; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "POST",
        "/v1/registries/name/$(registryName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_registry(
    registryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "POST",
        "/v1/registries/name/$(registryName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_schema(content, type, registry_name, schema_name)
    create_schema(content, type, registry_name, schema_name, params::Dict{String,<:Any})

Creates a schema definition. Inactive schemas will be deleted after two years.

# Arguments
- `content`: The source of the schema definition.
- `type`: The type of schema.
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the schema.
- `"tags"`: Tags associated with the schema.
"""
function create_schema(
    Content,
    Type,
    registryName,
    schemaName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "POST",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)",
        Dict{String,Any}("Content" => Content, "Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_schema(
    Content,
    Type,
    registryName,
    schemaName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "POST",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Content" => Content, "Type" => Type), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_discoverer(discoverer_id)
    delete_discoverer(discoverer_id, params::Dict{String,<:Any})

Deletes a discoverer.

# Arguments
- `discoverer_id`: The ID of the discoverer.

"""
function delete_discoverer(discovererId; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "DELETE",
        "/v1/discoverers/id/$(discovererId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_discoverer(
    discovererId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "DELETE",
        "/v1/discoverers/id/$(discovererId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_registry(registry_name)
    delete_registry(registry_name, params::Dict{String,<:Any})

Deletes a Registry.

# Arguments
- `registry_name`: The name of the registry.

"""
function delete_registry(registryName; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "DELETE",
        "/v1/registries/name/$(registryName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_registry(
    registryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "DELETE",
        "/v1/registries/name/$(registryName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy()
    delete_resource_policy(params::Dict{String,<:Any})

Delete the resource-based policy attached to the specified registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryName"`: The name of the registry.
"""
function delete_resource_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "DELETE", "/v1/policy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_resource_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "DELETE",
        "/v1/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_schema(registry_name, schema_name)
    delete_schema(registry_name, schema_name, params::Dict{String,<:Any})

Delete a schema definition.

# Arguments
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.

"""
function delete_schema(
    registryName, schemaName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "DELETE",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_schema(
    registryName,
    schemaName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "DELETE",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_schema_version(registry_name, schema_name, schema_version)
    delete_schema_version(registry_name, schema_name, schema_version, params::Dict{String,<:Any})

Delete the schema version definition

# Arguments
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.
- `schema_version`: The version number of the schema

"""
function delete_schema_version(
    registryName,
    schemaName,
    schemaVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "DELETE",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/version/$(schemaVersion)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_schema_version(
    registryName,
    schemaName,
    schemaVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "DELETE",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/version/$(schemaVersion)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_code_binding(language, registry_name, schema_name)
    describe_code_binding(language, registry_name, schema_name, params::Dict{String,<:Any})

Describe the code binding URI.

# Arguments
- `language`: The language of the code binding.
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"schemaVersion"`: Specifying this limits the results to only this schema version.
"""
function describe_code_binding(
    language, registryName, schemaName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/language/$(language)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_code_binding(
    language,
    registryName,
    schemaName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/language/$(language)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_discoverer(discoverer_id)
    describe_discoverer(discoverer_id, params::Dict{String,<:Any})

Describes the discoverer.

# Arguments
- `discoverer_id`: The ID of the discoverer.

"""
function describe_discoverer(
    discovererId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/v1/discoverers/id/$(discovererId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_discoverer(
    discovererId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/v1/discoverers/id/$(discovererId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_registry(registry_name)
    describe_registry(registry_name, params::Dict{String,<:Any})

Describes the registry.

# Arguments
- `registry_name`: The name of the registry.

"""
function describe_registry(registryName; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_registry(
    registryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_schema(registry_name, schema_name)
    describe_schema(registry_name, schema_name, params::Dict{String,<:Any})

Retrieve the schema definition.

# Arguments
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"schemaVersion"`: Specifying this limits the results to only this schema version.
"""
function describe_schema(
    registryName, schemaName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_schema(
    registryName,
    schemaName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_schema(registry_name, schema_name, type)
    export_schema(registry_name, schema_name, type, params::Dict{String,<:Any})



# Arguments
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.
- `type`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"schemaVersion"`: Specifying this limits the results to only this schema version.
"""
function export_schema(
    registryName, schemaName, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/export",
        Dict{String,Any}("type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_schema(
    registryName,
    schemaName,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/export",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("type" => type), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_code_binding_source(language, registry_name, schema_name)
    get_code_binding_source(language, registry_name, schema_name, params::Dict{String,<:Any})

Get the code binding source URI.

# Arguments
- `language`: The language of the code binding.
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"schemaVersion"`: Specifying this limits the results to only this schema version.
"""
function get_code_binding_source(
    language, registryName, schemaName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/language/$(language)/source";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_code_binding_source(
    language,
    registryName,
    schemaName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/language/$(language)/source",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_discovered_schema(events, type)
    get_discovered_schema(events, type, params::Dict{String,<:Any})

Get the discovered schema that was generated based on sampled events.

# Arguments
- `events`: An array of strings where each string is a JSON event. These are the events
  that were used to generate the schema. The array includes a single type of event and has a
  maximum size of 10 events.
- `type`: The type of event.

"""
function get_discovered_schema(
    Events, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "POST",
        "/v1/discover",
        Dict{String,Any}("Events" => Events, "Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_discovered_schema(
    Events,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "POST",
        "/v1/discover",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Events" => Events, "Type" => Type), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_policy()
    get_resource_policy(params::Dict{String,<:Any})

Retrieves the resource-based policy attached to a given registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryName"`: The name of the registry.
"""
function get_resource_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "GET", "/v1/policy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_resource_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET", "/v1/policy", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_discoverers()
    list_discoverers(params::Dict{String,<:Any})

List the discoverers.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"discovererIdPrefix"`: Specifying this limits the results to only those discoverer IDs
  that start with the specified prefix.
- `"limit"`:
- `"nextToken"`: The token that specifies the next page of results to return. To request
  the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be
  shared with other accounts.
- `"sourceArnPrefix"`: Specifying this limits the results to only those ARNs that start
  with the specified prefix.
"""
function list_discoverers(; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "GET", "/v1/discoverers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_discoverers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/v1/discoverers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_registries()
    list_registries(params::Dict{String,<:Any})

List the registries.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`:
- `"nextToken"`: The token that specifies the next page of results to return. To request
  the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be
  shared with other accounts.
- `"registryNamePrefix"`: Specifying this limits the results to only those registry names
  that start with the specified prefix.
- `"scope"`: Can be set to Local or AWS to limit responses to your custom registries, or
  the ones provided by AWS.
"""
function list_registries(; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "GET", "/v1/registries"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_registries(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/v1/registries",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_schema_versions(registry_name, schema_name)
    list_schema_versions(registry_name, schema_name, params::Dict{String,<:Any})

Provides a list of the schema versions and related information.

# Arguments
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`:
- `"nextToken"`: The token that specifies the next page of results to return. To request
  the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be
  shared with other accounts.
"""
function list_schema_versions(
    registryName, schemaName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_schema_versions(
    registryName,
    schemaName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_schemas(registry_name)
    list_schemas(registry_name, params::Dict{String,<:Any})

List the schemas.

# Arguments
- `registry_name`: The name of the registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`:
- `"nextToken"`: The token that specifies the next page of results to return. To request
  the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be
  shared with other accounts.
- `"schemaNamePrefix"`: Specifying this limits the results to only those schema names that
  start with the specified prefix.
"""
function list_schemas(registryName; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_schemas(
    registryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource-arn)
    list_tags_for_resource(resource-arn, params::Dict{String,<:Any})

Get tags for resource.

# Arguments
- `resource-arn`: The ARN of the resource.

"""
function list_tags_for_resource(
    resource_arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/tags/$(resource-arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resource_arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/tags/$(resource-arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_code_binding(language, registry_name, schema_name)
    put_code_binding(language, registry_name, schema_name, params::Dict{String,<:Any})

Put code binding URI

# Arguments
- `language`: The language of the code binding.
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"schemaVersion"`: Specifying this limits the results to only this schema version.
"""
function put_code_binding(
    language, registryName, schemaName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "POST",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/language/$(language)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_code_binding(
    language,
    registryName,
    schemaName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "POST",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)/language/$(language)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy(policy)
    put_resource_policy(policy, params::Dict{String,<:Any})

The name of the policy.

# Arguments
- `policy`: The resource-based policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RevisionId"`: The revision ID of the policy.
- `"registryName"`: The name of the registry.
"""
function put_resource_policy(Policy; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "PUT",
        "/v1/policy",
        Dict{String,Any}("Policy" => Policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    Policy, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "PUT",
        "/v1/policy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Policy" => Policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_schemas(keywords, registry_name)
    search_schemas(keywords, registry_name, params::Dict{String,<:Any})

Search the schemas

# Arguments
- `keywords`: Specifying this limits the results to only schemas that include the provided
  keywords.
- `registry_name`: The name of the registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`:
- `"nextToken"`: The token that specifies the next page of results to return. To request
  the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be
  shared with other accounts.
"""
function search_schemas(
    keywords, registryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/search",
        Dict{String,Any}("keywords" => keywords);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_schemas(
    keywords,
    registryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "GET",
        "/v1/registries/name/$(registryName)/schemas/search",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("keywords" => keywords), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_discoverer(discoverer_id)
    start_discoverer(discoverer_id, params::Dict{String,<:Any})

Starts the discoverer

# Arguments
- `discoverer_id`: The ID of the discoverer.

"""
function start_discoverer(discovererId; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "POST",
        "/v1/discoverers/id/$(discovererId)/start";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_discoverer(
    discovererId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "POST",
        "/v1/discoverers/id/$(discovererId)/start",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_discoverer(discoverer_id)
    stop_discoverer(discoverer_id, params::Dict{String,<:Any})

Stops the discoverer

# Arguments
- `discoverer_id`: The ID of the discoverer.

"""
function stop_discoverer(discovererId; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "POST",
        "/v1/discoverers/id/$(discovererId)/stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_discoverer(
    discovererId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "POST",
        "/v1/discoverers/id/$(discovererId)/stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource-arn, tags)
    tag_resource(resource-arn, tags, params::Dict{String,<:Any})

Add tags to a resource.

# Arguments
- `resource-arn`: The ARN of the resource.
- `tags`: Tags associated with the resource.

"""
function tag_resource(
    resource_arn, tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "POST",
        "/tags/$(resource-arn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resource_arn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "POST",
        "/tags/$(resource-arn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource-arn, tag_keys)
    untag_resource(resource-arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a resource.

# Arguments
- `resource-arn`: The ARN of the resource.
- `tag_keys`: Keys of key-value pairs.

"""
function untag_resource(
    resource_arn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "DELETE",
        "/tags/$(resource-arn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resource_arn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "DELETE",
        "/tags/$(resource-arn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_discoverer(discoverer_id)
    update_discoverer(discoverer_id, params::Dict{String,<:Any})

Updates the discoverer

# Arguments
- `discoverer_id`: The ID of the discoverer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CrossAccount"`: Support discovery of schemas in events sent to the bus from another
  account. (default: true)
- `"Description"`: The description of the discoverer to update.
"""
function update_discoverer(discovererId; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "PUT",
        "/v1/discoverers/id/$(discovererId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_discoverer(
    discovererId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "PUT",
        "/v1/discoverers/id/$(discovererId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_registry(registry_name)
    update_registry(registry_name, params::Dict{String,<:Any})

Updates a registry.

# Arguments
- `registry_name`: The name of the registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the registry to update.
"""
function update_registry(registryName; aws_config::AbstractAWSConfig=current_aws_config())
    return schemas(
        "PUT",
        "/v1/registries/name/$(registryName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_registry(
    registryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "PUT",
        "/v1/registries/name/$(registryName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_schema(registry_name, schema_name)
    update_schema(registry_name, schema_name, params::Dict{String,<:Any})

Updates the schema definition Inactive schemas will be deleted after two years.

# Arguments
- `registry_name`: The name of the registry.
- `schema_name`: The name of the schema.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientTokenId"`: The ID of the client token.
- `"Content"`: The source of the schema definition.
- `"Description"`: The description of the schema.
- `"Type"`: The schema type for the events schema.
"""
function update_schema(
    registryName, schemaName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return schemas(
        "PUT",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)",
        Dict{String,Any}("ClientTokenId" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_schema(
    registryName,
    schemaName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return schemas(
        "PUT",
        "/v1/registries/name/$(registryName)/schemas/name/$(schemaName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientTokenId" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
