# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: supplychain
using AWS.Compat
using AWS.UUIDs

"""
    create_bill_of_materials_import_job(instance_id, s3uri)
    create_bill_of_materials_import_job(instance_id, s3uri, params::Dict{String,<:Any})

CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of Materials
(BOM) entity. For information on the product_bom entity, see the AWS Supply Chain User
Guide. The CSV file must be located in an Amazon S3 location accessible to AWS Supply
Chain. It is recommended to use the same Amazon S3 bucket created during your AWS Supply
Chain instance creation.

# Arguments
- `instance_id`: The AWS Supply Chain instance identifier.
- `s3uri`: The S3 URI of the CSV file to be imported. The bucket must grant permissions for
  AWS Supply Chain to read the file.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: An idempotency token.
"""
function create_bill_of_materials_import_job(
    instanceId, s3uri; aws_config::AbstractAWSConfig=current_aws_config()
)
    return supplychain(
        "POST",
        "/api/configuration/instances/$(instanceId)/bill-of-materials-import-jobs",
        Dict{String,Any}("s3uri" => s3uri, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_bill_of_materials_import_job(
    instanceId,
    s3uri,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return supplychain(
        "POST",
        "/api/configuration/instances/$(instanceId)/bill-of-materials-import-jobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("s3uri" => s3uri, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bill_of_materials_import_job(instance_id, job_id)
    get_bill_of_materials_import_job(instance_id, job_id, params::Dict{String,<:Any})

Get status and details of a BillOfMaterialsImportJob.

# Arguments
- `instance_id`: The AWS Supply Chain instance identifier.
- `job_id`: The BillOfMaterialsImportJob identifier.

"""
function get_bill_of_materials_import_job(
    instanceId, jobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return supplychain(
        "GET",
        "/api/configuration/instances/$(instanceId)/bill-of-materials-import-jobs/$(jobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bill_of_materials_import_job(
    instanceId,
    jobId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return supplychain(
        "GET",
        "/api/configuration/instances/$(instanceId)/bill-of-materials-import-jobs/$(jobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_data_integration_event(data, event_group_id, event_type, instance_id)
    send_data_integration_event(data, event_group_id, event_type, instance_id, params::Dict{String,<:Any})

Send transactional data events with real-time data for analysis or monitoring.

# Arguments
- `data`: The data payload of the event.
- `event_group_id`: Event identifier (for example, orderId for InboundOrder) used for data
  sharing or partitioning.
- `event_type`: The data event type.
- `instance_id`: The AWS Supply Chain instance identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The idempotent client token.
- `"eventTimestamp"`: The event timestamp (in epoch seconds).
"""
function send_data_integration_event(
    data,
    eventGroupId,
    eventType,
    instanceId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return supplychain(
        "POST",
        "/api-data/data-integration/instance/$(instanceId)/data-integration-events",
        Dict{String,Any}(
            "data" => data,
            "eventGroupId" => eventGroupId,
            "eventType" => eventType,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_data_integration_event(
    data,
    eventGroupId,
    eventType,
    instanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return supplychain(
        "POST",
        "/api-data/data-integration/instance/$(instanceId)/data-integration-events",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "data" => data,
                    "eventGroupId" => eventGroupId,
                    "eventType" => eventType,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
