# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: acm
using AWS.Compat
using AWS.UUIDs

"""
    add_tags_to_certificate(certificate_arn, tags)
    add_tags_to_certificate(certificate_arn, tags, params::Dict{String,<:Any})

Adds one or more tags to an ACM certificate. Tags are labels that you can use to identify
and organize your Amazon Web Services resources. Each tag consists of a key and an optional
value. You specify the certificate on input by its Amazon Resource Name (ARN). You specify
the tag by using a key-value pair.  You can apply a tag to just one certificate if you want
to identify a specific characteristic of that certificate, or you can apply the same tag to
multiple certificates if you want to filter for a common relationship among those
certificates. Similarly, you can apply the same tag to multiple resources if you want to
specify a relationship among those resources. For example, you can add the same tag to an
ACM certificate and an Elastic Load Balancing load balancer to indicate that they are both
used by the same website. For more information, see Tagging ACM certificates.  To remove
one or more tags, use the RemoveTagsFromCertificate action. To view all of the tags that
have been applied to the certificate, use the ListTagsForCertificate action.

# Arguments
- `certificate_arn`: String that contains the ARN of the ACM certificate to which the tag
  is to be applied. This must be of the form:
  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more
  information about ARNs, see Amazon Resource Names (ARNs).
- `tags`: The key-value pair that defines the tag. The tag value is optional.

"""
function add_tags_to_certificate(
    CertificateArn, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "AddTagsToCertificate",
        Dict{String,Any}("CertificateArn" => CertificateArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_tags_to_certificate(
    CertificateArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "AddTagsToCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CertificateArn" => CertificateArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_certificate(certificate_arn)
    delete_certificate(certificate_arn, params::Dict{String,<:Any})

Deletes a certificate and its associated private key. If this action succeeds, the
certificate no longer appears in the list that can be displayed by calling the
ListCertificates action or be retrieved by calling the GetCertificate action. The
certificate will not be available for use by Amazon Web Services services integrated with
ACM.   You cannot delete an ACM certificate that is being used by another Amazon Web
Services service. To delete a certificate that is in use, the certificate association must
first be removed.

# Arguments
- `certificate_arn`: String that contains the ARN of the ACM certificate to be deleted.
  This must be of the form:
  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more
  information about ARNs, see Amazon Resource Names (ARNs).

"""
function delete_certificate(
    CertificateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "DeleteCertificate",
        Dict{String,Any}("CertificateArn" => CertificateArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_certificate(
    CertificateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "DeleteCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateArn" => CertificateArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_certificate(certificate_arn)
    describe_certificate(certificate_arn, params::Dict{String,<:Any})

Returns detailed metadata about the specified ACM certificate. If you have just created a
certificate using the RequestCertificate action, there is a delay of several seconds before
you can retrieve information about it.

# Arguments
- `certificate_arn`: The Amazon Resource Name (ARN) of the ACM certificate. The ARN must
  have the following form:
  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more
  information about ARNs, see Amazon Resource Names (ARNs).

"""
function describe_certificate(
    CertificateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "DescribeCertificate",
        Dict{String,Any}("CertificateArn" => CertificateArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_certificate(
    CertificateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "DescribeCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateArn" => CertificateArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_certificate(certificate_arn, passphrase)
    export_certificate(certificate_arn, passphrase, params::Dict{String,<:Any})

Exports a private certificate issued by a private certificate authority (CA) for use
anywhere. The exported file contains the certificate, the certificate chain, and the
encrypted private 2048-bit RSA key associated with the public key that is embedded in the
certificate. For security, you must assign a passphrase for the private key when exporting
it.  For information about exporting and formatting a certificate using the ACM console or
CLI, see Export a Private Certificate.

# Arguments
- `certificate_arn`: An Amazon Resource Name (ARN) of the issued certificate. This must be
  of the form:  arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012
- `passphrase`: Passphrase to associate with the encrypted exported private key.   When
  creating your passphrase, you can use any ASCII character except #, , or %.  If you want to
  later decrypt the private key, you must have the passphrase. You can use the following
  OpenSSL command to decrypt a private key. After entering the command, you are prompted for
  the passphrase.  openssl rsa -in encrypted_key.pem -out decrypted_key.pem

"""
function export_certificate(
    CertificateArn, Passphrase; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "ExportCertificate",
        Dict{String,Any}("CertificateArn" => CertificateArn, "Passphrase" => Passphrase);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_certificate(
    CertificateArn,
    Passphrase,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "ExportCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CertificateArn" => CertificateArn, "Passphrase" => Passphrase
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_configuration()
    get_account_configuration(params::Dict{String,<:Any})

Returns the account configuration options associated with an Amazon Web Services account.

"""
function get_account_configuration(; aws_config::AbstractAWSConfig=current_aws_config())
    return acm(
        "GetAccountConfiguration"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_account_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "GetAccountConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_certificate(certificate_arn)
    get_certificate(certificate_arn, params::Dict{String,<:Any})

Retrieves an Amazon-issued certificate and its certificate chain. The chain consists of the
certificate of the issuing CA and the intermediate certificates of any other subordinate
CAs. All of the certificates are base64 encoded. You can use OpenSSL to decode the
certificates and inspect individual fields.

# Arguments
- `certificate_arn`: String that contains a certificate ARN in the following format:
  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more
  information about ARNs, see Amazon Resource Names (ARNs).

"""
function get_certificate(CertificateArn; aws_config::AbstractAWSConfig=current_aws_config())
    return acm(
        "GetCertificate",
        Dict{String,Any}("CertificateArn" => CertificateArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_certificate(
    CertificateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "GetCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateArn" => CertificateArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_certificate(certificate, private_key)
    import_certificate(certificate, private_key, params::Dict{String,<:Any})

Imports a certificate into Certificate Manager (ACM) to use with services that are
integrated with ACM. Note that integrated services allow only certificate types and keys
they support to be associated with their resources. Further, their support differs
depending on whether the certificate is imported into IAM or into ACM. For more
information, see the documentation for each service. For more information about importing
certificates into ACM, see Importing Certificates in the Certificate Manager User Guide.
ACM does not provide managed renewal for certificates that you import.  Note the following
guidelines when importing third party certificates:   You must enter the private key that
matches the certificate you are importing.   The private key must be unencrypted. You
cannot import a private key that is protected by a password or a passphrase.   The private
key must be no larger than 5 KB (5,120 bytes).   If the certificate you are importing is
not self-signed, you must enter its certificate chain.   If a certificate chain is
included, the issuer must be the subject of one of the certificates in the chain.   The
certificate, private key, and certificate chain must be PEM-encoded.   The current time
must be between the Not Before and Not After certificate fields.   The Issuer field must
not be empty.   The OCSP authority URL, if present, must not exceed 1000 characters.   To
import a new certificate, omit the CertificateArn argument. Include this argument only when
you want to replace a previously imported certificate.   When you import a certificate by
using the CLI, you must specify the certificate, the certificate chain, and the private key
by their file names preceded by fileb://. For example, you can specify a certificate saved
in the C:temp folder as fileb://C:tempcertificate_to_import.pem. If you are making an HTTP
or HTTPS Query request, include these arguments as BLOBs.    When you import a certificate
by using an SDK, you must specify the certificate, the certificate chain, and the private
key files in the manner required by the programming language you're using.    The
cryptographic algorithm of an imported certificate must match the algorithm of the signing
CA. For example, if the signing CA key type is RSA, then the certificate key type must also
be RSA.   This operation returns the Amazon Resource Name (ARN) of the imported certificate.

# Arguments
- `certificate`: The certificate to import.
- `private_key`: The private key that matches the public key in the certificate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateArn"`: The Amazon Resource Name (ARN) of an imported certificate to replace.
  To import a new certificate, omit this field.
- `"CertificateChain"`: The PEM encoded certificate chain.
- `"Tags"`: One or more resource tags to associate with the imported certificate.  Note:
  You cannot apply tags when reimporting a certificate.
"""
function import_certificate(
    Certificate, PrivateKey; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "ImportCertificate",
        Dict{String,Any}("Certificate" => Certificate, "PrivateKey" => PrivateKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_certificate(
    Certificate,
    PrivateKey,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "ImportCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Certificate" => Certificate, "PrivateKey" => PrivateKey),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_certificates()
    list_certificates(params::Dict{String,<:Any})

Retrieves a list of certificate ARNs and domain names. You can request that only
certificates that match a specific status be listed. You can also filter by specific
attributes of the certificate. Default filtering returns only RSA_2048 certificates. For
more information, see Filters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateStatuses"`: Filter the certificate list by status value.
- `"Includes"`: Filter the certificate list. For more information, see the Filters
  structure.
- `"MaxItems"`: Use this parameter when paginating results to specify the maximum number of
  items to return in the response. If additional items exist beyond the number you specify,
  the NextToken element is sent in the response. Use this NextToken value in a subsequent
  request to retrieve additional items.
- `"NextToken"`: Use this parameter only when paginating results and only in a subsequent
  request after you receive a response with truncated results. Set it to the value of
  NextToken from the response you just received.
- `"SortBy"`: Specifies the field to sort results by. If you specify SortBy, you must also
  specify SortOrder.
- `"SortOrder"`: Specifies the order of sorted results. If you specify SortOrder, you must
  also specify SortBy.
"""
function list_certificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return acm("ListCertificates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "ListCertificates", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_certificate(certificate_arn)
    list_tags_for_certificate(certificate_arn, params::Dict{String,<:Any})

Lists the tags that have been applied to the ACM certificate. Use the certificate's Amazon
Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate, use the
AddTagsToCertificate action. To delete a tag, use the RemoveTagsFromCertificate action.

# Arguments
- `certificate_arn`: String that contains the ARN of the ACM certificate for which you want
  to list the tags. This must have the following form:
  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more
  information about ARNs, see Amazon Resource Names (ARNs).

"""
function list_tags_for_certificate(
    CertificateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "ListTagsForCertificate",
        Dict{String,Any}("CertificateArn" => CertificateArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_certificate(
    CertificateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "ListTagsForCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateArn" => CertificateArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_account_configuration(idempotency_token)
    put_account_configuration(idempotency_token, params::Dict{String,<:Any})

Adds or modifies account-level configurations in ACM.  The supported configuration option
is DaysBeforeExpiry. This option specifies the number of days prior to certificate
expiration when ACM starts generating EventBridge events. ACM sends one event per day per
certificate until the certificate expires. By default, accounts receive events starting 45
days before certificate expiration.

# Arguments
- `idempotency_token`: Customer-chosen string used to distinguish between calls to
  PutAccountConfiguration. Idempotency tokens time out after one hour. If you call
  PutAccountConfiguration multiple times with the same unexpired idempotency token, ACM
  treats it as the same request and returns the original result. If you change the
  idempotency token for each call, ACM treats each call as a new request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExpiryEvents"`: Specifies expiration events associated with an account.
"""
function put_account_configuration(
    IdempotencyToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "PutAccountConfiguration",
        Dict{String,Any}("IdempotencyToken" => IdempotencyToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_account_configuration(
    IdempotencyToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "PutAccountConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("IdempotencyToken" => IdempotencyToken), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_tags_from_certificate(certificate_arn, tags)
    remove_tags_from_certificate(certificate_arn, tags, params::Dict{String,<:Any})

Remove one or more tags from an ACM certificate. A tag consists of a key-value pair. If you
do not specify the value portion of the tag when calling this function, the tag will be
removed regardless of value. If you specify a value, the tag is removed only if it is
associated with the specified value.  To add tags to a certificate, use the
AddTagsToCertificate action. To view all of the tags that have been applied to a specific
ACM certificate, use the ListTagsForCertificate action.

# Arguments
- `certificate_arn`: String that contains the ARN of the ACM Certificate with one or more
  tags that you want to remove. This must be of the form:
  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more
  information about ARNs, see Amazon Resource Names (ARNs).
- `tags`: The key-value pair that defines the tag to remove.

"""
function remove_tags_from_certificate(
    CertificateArn, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "RemoveTagsFromCertificate",
        Dict{String,Any}("CertificateArn" => CertificateArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_tags_from_certificate(
    CertificateArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "RemoveTagsFromCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CertificateArn" => CertificateArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    renew_certificate(certificate_arn)
    renew_certificate(certificate_arn, params::Dict{String,<:Any})

Renews an eligible ACM certificate. At this time, only exported private certificates can be
renewed with this operation. In order to renew your Amazon Web Services Private CA
certificates with ACM, you must first grant the ACM service principal permission to do so.
For more information, see Testing Managed Renewal in the ACM User Guide.

# Arguments
- `certificate_arn`: String that contains the ARN of the ACM certificate to be renewed.
  This must be of the form:
  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more
  information about ARNs, see Amazon Resource Names (ARNs).

"""
function renew_certificate(
    CertificateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "RenewCertificate",
        Dict{String,Any}("CertificateArn" => CertificateArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function renew_certificate(
    CertificateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "RenewCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateArn" => CertificateArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    request_certificate(domain_name)
    request_certificate(domain_name, params::Dict{String,<:Any})

Requests an ACM certificate for use with other Amazon Web Services services. To request an
ACM certificate, you must specify a fully qualified domain name (FQDN) in the DomainName
parameter. You can also specify additional FQDNs in the SubjectAlternativeNames parameter.
If you are requesting a private certificate, domain validation is not required. If you are
requesting a public certificate, each domain name that you specify must be validated to
verify that you own or control the domain. You can use DNS validation or email validation.
We recommend that you use DNS validation. ACM issues public certificates after receiving
approval from the domain owner.   ACM behavior differs from the RFC 6125 specification of
the certificate validation process. ACM first checks for a Subject Alternative Name, and,
if it finds one, ignores the common name (CN).  After successful completion of the
RequestCertificate action, there is a delay of several seconds before you can retrieve
information about the new certificate.

# Arguments
- `domain_name`: Fully qualified domain name (FQDN), such as www.example.com, that you want
  to secure with an ACM certificate. Use an asterisk (*) to create a wildcard certificate
  that protects several sites in the same domain. For example, *.example.com protects
  www.example.com, site.example.com, and images.example.com.  In compliance with RFC 5280,
  the length of the domain name (technically, the Common Name) that you provide cannot exceed
  64 octets (characters), including periods. To add a longer domain name, specify it in the
  Subject Alternative Name field, which supports names up to 253 octets in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateAuthorityArn"`: The Amazon Resource Name (ARN) of the private certificate
  authority (CA) that will be used to issue the certificate. If you do not provide an ARN and
  you are trying to request a private certificate, ACM will attempt to issue a public
  certificate. For more information about private CAs, see the Amazon Web Services Private
  Certificate Authority user guide. The ARN must have the following form:
  arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
- `"DomainValidationOptions"`: The domain name that you want ACM to use to send you emails
  so that you can validate domain ownership.
- `"IdempotencyToken"`: Customer chosen string that can be used to distinguish between
  calls to RequestCertificate. Idempotency tokens time out after one hour. Therefore, if you
  call RequestCertificate multiple times with the same idempotency token within one hour, ACM
  recognizes that you are requesting only one certificate and will issue only one. If you
  change the idempotency token for each call, ACM recognizes that you are requesting multiple
  certificates.
- `"KeyAlgorithm"`: Specifies the algorithm of the public and private key pair that your
  certificate uses to encrypt data. RSA is the default key algorithm for ACM certificates.
  Elliptic Curve Digital Signature Algorithm (ECDSA) keys are smaller, offering security
  comparable to RSA keys but with greater computing efficiency. However, ECDSA is not
  supported by all network clients. Some AWS services may require RSA keys, or only support
  ECDSA keys of a particular size, while others allow the use of either RSA and ECDSA keys to
  ensure that compatibility is not broken. Check the requirements for the AWS service where
  you plan to deploy your certificate. Default: RSA_2048
- `"Options"`: Currently, you can use this parameter to specify whether to add the
  certificate to a certificate transparency log. Certificate transparency makes it possible
  to detect SSL/TLS certificates that have been mistakenly or maliciously issued.
  Certificates that have not been logged typically produce an error message in a browser. For
  more information, see Opting Out of Certificate Transparency Logging.
- `"SubjectAlternativeNames"`: Additional FQDNs to be included in the Subject Alternative
  Name extension of the ACM certificate. For example, add the name www.example.net to a
  certificate for which the DomainName field is www.example.com if users can reach your site
  by using either name. The maximum number of domain names that you can add to an ACM
  certificate is 100. However, the initial quota is 10 domain names. If you need more than 10
  names, you must request a quota increase. For more information, see Quotas.  The maximum
  length of a SAN DNS name is 253 octets. The name is made up of multiple labels separated by
  periods. No label can be longer than 63 octets. Consider the following examples:     (63
  octets).(63 octets).(63 octets).(61 octets) is legal because the total length is 253 octets
  (63+1+63+1+63+1+61) and no label exceeds 63 octets.    (64 octets).(63 octets).(63
  octets).(61 octets) is not legal because the total length exceeds 253 octets
  (64+1+63+1+63+1+61) and the first label exceeds 63 octets.    (63 octets).(63 octets).(63
  octets).(62 octets) is not legal because the total length of the DNS name
  (63+1+63+1+63+1+62) exceeds 253 octets.
- `"Tags"`: One or more resource tags to associate with the certificate.
- `"ValidationMethod"`: The method you want to use if you are requesting a public
  certificate to validate that you own or control domain. You can validate with DNS or
  validate with email. We recommend that you use DNS validation.
"""
function request_certificate(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return acm(
        "RequestCertificate",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function request_certificate(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "RequestCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resend_validation_email(certificate_arn, domain, validation_domain)
    resend_validation_email(certificate_arn, domain, validation_domain, params::Dict{String,<:Any})

Resends the email that requests domain ownership validation. The domain owner or an
authorized representative must approve the ACM certificate before it can be issued. The
certificate can be approved by clicking a link in the mail to navigate to the Amazon
certificate approval website and then clicking I Approve. However, the validation email can
be blocked by spam filters. Therefore, if you do not receive the original mail, you can
request that the mail be resent within 72 hours of requesting the ACM certificate. If more
than 72 hours have elapsed since your original request or since your last attempt to resend
validation mail, you must request a new certificate. For more information about setting up
your contact email addresses, see Configure Email for your Domain.

# Arguments
- `certificate_arn`: String that contains the ARN of the requested certificate. The
  certificate ARN is generated and returned by the RequestCertificate action as soon as the
  request is made. By default, using this parameter causes email to be sent to all top-level
  domains you specified in the certificate request. The ARN must be of the form:
  arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
- `domain`: The fully qualified domain name (FQDN) of the certificate that needs to be
  validated.
- `validation_domain`: The base validation domain that will act as the suffix of the email
  addresses that are used to send the emails. This must be the same as the Domain value or a
  superdomain of the Domain value. For example, if you requested a certificate for
  site.subdomain.example.com and specify a ValidationDomain of subdomain.example.com, ACM
  sends email to the domain registrant, technical contact, and administrative contact in
  WHOIS and the following five addresses:   admin@subdomain.example.com
  administrator@subdomain.example.com   hostmaster@subdomain.example.com
  postmaster@subdomain.example.com   webmaster@subdomain.example.com

"""
function resend_validation_email(
    CertificateArn,
    Domain,
    ValidationDomain;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "ResendValidationEmail",
        Dict{String,Any}(
            "CertificateArn" => CertificateArn,
            "Domain" => Domain,
            "ValidationDomain" => ValidationDomain,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resend_validation_email(
    CertificateArn,
    Domain,
    ValidationDomain,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "ResendValidationEmail",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CertificateArn" => CertificateArn,
                    "Domain" => Domain,
                    "ValidationDomain" => ValidationDomain,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_certificate_options(certificate_arn, options)
    update_certificate_options(certificate_arn, options, params::Dict{String,<:Any})

Updates a certificate. Currently, you can use this function to specify whether to opt in to
or out of recording your certificate in a certificate transparency log. For more
information, see  Opting Out of Certificate Transparency Logging.

# Arguments
- `certificate_arn`: ARN of the requested certificate to update. This must be of the form:
  arn:aws:acm:us-east-1:account:certificate/12345678-1234-1234-1234-123456789012
- `options`: Use to update the options for your certificate. Currently, you can specify
  whether to add your certificate to a transparency log. Certificate transparency makes it
  possible to detect SSL/TLS certificates that have been mistakenly or maliciously issued.
  Certificates that have not been logged typically produce an error message in a browser.

"""
function update_certificate_options(
    CertificateArn, Options; aws_config::AbstractAWSConfig=current_aws_config()
)
    return acm(
        "UpdateCertificateOptions",
        Dict{String,Any}("CertificateArn" => CertificateArn, "Options" => Options);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_certificate_options(
    CertificateArn,
    Options,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return acm(
        "UpdateCertificateOptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CertificateArn" => CertificateArn, "Options" => Options),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
