# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: application_auto_scaling
using AWS.Compat
using AWS.UUIDs

"""
    delete_scaling_policy(policy_name, resource_id, scalable_dimension, service_namespace)
    delete_scaling_policy(policy_name, resource_id, scalable_dimension, service_namespace, params::Dict{String,<:Any})

Deletes the specified scaling policy for an Application Auto Scaling scalable target.
Deleting a step scaling policy deletes the underlying alarm action, but does not delete the
CloudWatch alarm associated with the scaling policy, even if it no longer has an associated
action. For more information, see Delete a step scaling policy and Delete a target tracking
scaling policy in the Application Auto Scaling User Guide.

# Arguments
- `policy_name`: The name of the scaling policy.
- `resource_id`: The identifier of the resource associated with the scalable target. This
  string consists of the resource type and unique identifier.   ECS service - The resource
  type is service and the unique identifier is the cluster name and service name. Example:
  service/default/sample-webapp.   Spot Fleet - The resource type is spot-fleet-request and
  the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `scalable_dimension`: The scalable dimension. This string consists of the service
  namespace, resource type, and scaling property.    ecs:service:DesiredCount - The desired
  task count of an ECS service.    elasticmapreduce:instancegroup:InstanceCount - The
  instance count of an EMR Instance Group.    ec2:spot-fleet-request:TargetCapacity - The
  target capacity of a Spot Fleet.    appstream:fleet:DesiredCapacity - The desired capacity
  of an AppStream 2.0 fleet.    dynamodb:table:ReadCapacityUnits - The provisioned read
  capacity for a DynamoDB table.    dynamodb:table:WriteCapacityUnits - The provisioned write
  capacity for a DynamoDB table.    dynamodb:index:ReadCapacityUnits - The provisioned read
  capacity for a DynamoDB global secondary index.    dynamodb:index:WriteCapacityUnits - The
  provisioned write capacity for a DynamoDB global secondary index.
  rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster.
  Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
  sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for a SageMaker model
  endpoint variant.    custom-resource:ResourceType:Property - The scalable dimension for a
  custom resource provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

"""
function delete_scaling_policy(
    PolicyName,
    ResourceId,
    ScalableDimension,
    ServiceNamespace;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DeleteScalingPolicy",
        Dict{String,Any}(
            "PolicyName" => PolicyName,
            "ResourceId" => ResourceId,
            "ScalableDimension" => ScalableDimension,
            "ServiceNamespace" => ServiceNamespace,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_scaling_policy(
    PolicyName,
    ResourceId,
    ScalableDimension,
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DeleteScalingPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyName" => PolicyName,
                    "ResourceId" => ResourceId,
                    "ScalableDimension" => ScalableDimension,
                    "ServiceNamespace" => ServiceNamespace,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_scheduled_action(resource_id, scalable_dimension, scheduled_action_name, service_namespace)
    delete_scheduled_action(resource_id, scalable_dimension, scheduled_action_name, service_namespace, params::Dict{String,<:Any})

Deletes the specified scheduled action for an Application Auto Scaling scalable target. For
more information, see Delete a scheduled action in the Application Auto Scaling User Guide.

# Arguments
- `resource_id`: The identifier of the resource associated with the scheduled action. This
  string consists of the resource type and unique identifier.   ECS service - The resource
  type is service and the unique identifier is the cluster name and service name. Example:
  service/default/sample-webapp.   Spot Fleet - The resource type is spot-fleet-request and
  the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `scalable_dimension`: The scalable dimension. This string consists of the service
  namespace, resource type, and scaling property.    ecs:service:DesiredCount - The desired
  task count of an ECS service.    elasticmapreduce:instancegroup:InstanceCount - The
  instance count of an EMR Instance Group.    ec2:spot-fleet-request:TargetCapacity - The
  target capacity of a Spot Fleet.    appstream:fleet:DesiredCapacity - The desired capacity
  of an AppStream 2.0 fleet.    dynamodb:table:ReadCapacityUnits - The provisioned read
  capacity for a DynamoDB table.    dynamodb:table:WriteCapacityUnits - The provisioned write
  capacity for a DynamoDB table.    dynamodb:index:ReadCapacityUnits - The provisioned read
  capacity for a DynamoDB global secondary index.    dynamodb:index:WriteCapacityUnits - The
  provisioned write capacity for a DynamoDB global secondary index.
  rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster.
  Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
  sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for a SageMaker model
  endpoint variant.    custom-resource:ResourceType:Property - The scalable dimension for a
  custom resource provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
- `scheduled_action_name`: The name of the scheduled action.
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

"""
function delete_scheduled_action(
    ResourceId,
    ScalableDimension,
    ScheduledActionName,
    ServiceNamespace;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DeleteScheduledAction",
        Dict{String,Any}(
            "ResourceId" => ResourceId,
            "ScalableDimension" => ScalableDimension,
            "ScheduledActionName" => ScheduledActionName,
            "ServiceNamespace" => ServiceNamespace,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_scheduled_action(
    ResourceId,
    ScalableDimension,
    ScheduledActionName,
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DeleteScheduledAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId,
                    "ScalableDimension" => ScalableDimension,
                    "ScheduledActionName" => ScheduledActionName,
                    "ServiceNamespace" => ServiceNamespace,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_scalable_target(resource_id, scalable_dimension, service_namespace)
    deregister_scalable_target(resource_id, scalable_dimension, service_namespace, params::Dict{String,<:Any})

Deregisters an Application Auto Scaling scalable target when you have finished using it. To
see which resources have been registered, use DescribeScalableTargets.   Deregistering a
scalable target deletes the scaling policies and the scheduled actions that are associated
with it.

# Arguments
- `resource_id`: The identifier of the resource associated with the scalable target. This
  string consists of the resource type and unique identifier.   ECS service - The resource
  type is service and the unique identifier is the cluster name and service name. Example:
  service/default/sample-webapp.   Spot Fleet - The resource type is spot-fleet-request and
  the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `scalable_dimension`: The scalable dimension associated with the scalable target. This
  string consists of the service namespace, resource type, and scaling property.
  ecs:service:DesiredCount - The desired task count of an ECS service.
  elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
     ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
  appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
  dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
  dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
  dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global
  secondary index.    dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
  a DynamoDB global secondary index.    rds:cluster:ReadReplicaCount - The count of Aurora
  Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora
  PostgreSQL-compatible edition.    sagemaker:variant:DesiredInstanceCount - The number of
  EC2 instances for a SageMaker model endpoint variant.
  custom-resource:ResourceType:Property - The scalable dimension for a custom resource
  provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

"""
function deregister_scalable_target(
    ResourceId,
    ScalableDimension,
    ServiceNamespace;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DeregisterScalableTarget",
        Dict{String,Any}(
            "ResourceId" => ResourceId,
            "ScalableDimension" => ScalableDimension,
            "ServiceNamespace" => ServiceNamespace,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_scalable_target(
    ResourceId,
    ScalableDimension,
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DeregisterScalableTarget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId,
                    "ScalableDimension" => ScalableDimension,
                    "ServiceNamespace" => ServiceNamespace,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_scalable_targets(service_namespace)
    describe_scalable_targets(service_namespace, params::Dict{String,<:Any})

Gets information about the scalable targets in the specified namespace. You can filter the
results using ResourceIds and ScalableDimension.

# Arguments
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of scalable targets. This value can be between 1 and
  50. The default value is 50. If this parameter is used, the operation returns up to
  MaxResults results at a time, along with a NextToken value. To get the next set of results,
  include the NextToken value in a subsequent call. If this parameter is not used, the
  operation returns up to 50 results and a NextToken value, if applicable.
- `"NextToken"`: The token for the next set of results.
- `"ResourceIds"`: The identifier of the resource associated with the scalable target. This
  string consists of the resource type and unique identifier.   ECS service - The resource
  type is service and the unique identifier is the cluster name and service name. Example:
  service/default/sample-webapp.   Spot Fleet - The resource type is spot-fleet-request and
  the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `"ScalableDimension"`: The scalable dimension associated with the scalable target. This
  string consists of the service namespace, resource type, and scaling property. If you
  specify a scalable dimension, you must also specify a resource ID.
  ecs:service:DesiredCount - The desired task count of an ECS service.
  elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
     ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
  appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
  dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
  dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
  dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global
  secondary index.    dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
  a DynamoDB global secondary index.    rds:cluster:ReadReplicaCount - The count of Aurora
  Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora
  PostgreSQL-compatible edition.    sagemaker:variant:DesiredInstanceCount - The number of
  EC2 instances for a SageMaker model endpoint variant.
  custom-resource:ResourceType:Property - The scalable dimension for a custom resource
  provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
"""
function describe_scalable_targets(
    ServiceNamespace; aws_config::AbstractAWSConfig=current_aws_config()
)
    return application_auto_scaling(
        "DescribeScalableTargets",
        Dict{String,Any}("ServiceNamespace" => ServiceNamespace);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_scalable_targets(
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DescribeScalableTargets",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ServiceNamespace" => ServiceNamespace), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_scaling_activities(service_namespace)
    describe_scaling_activities(service_namespace, params::Dict{String,<:Any})

Provides descriptive information about the scaling activities in the specified namespace
from the previous six weeks. You can filter the results using ResourceId and
ScalableDimension. For information about viewing scaling activities using the Amazon Web
Services CLI, see Scaling activities for Application Auto Scaling.

# Arguments
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IncludeNotScaledActivities"`: Specifies whether to include activities that aren't
  scaled (not scaled activities) in the response. Not scaled activities are activities that
  aren't completed or started for various reasons, such as preventing infinite scaling loops.
  For help interpreting the not scaled reason details in the response, see Scaling activities
  for Application Auto Scaling.
- `"MaxResults"`: The maximum number of scalable targets. This value can be between 1 and
  50. The default value is 50. If this parameter is used, the operation returns up to
  MaxResults results at a time, along with a NextToken value. To get the next set of results,
  include the NextToken value in a subsequent call. If this parameter is not used, the
  operation returns up to 50 results and a NextToken value, if applicable.
- `"NextToken"`: The token for the next set of results.
- `"ResourceId"`: The identifier of the resource associated with the scaling activity. This
  string consists of the resource type and unique identifier.   ECS service - The resource
  type is service and the unique identifier is the cluster name and service name. Example:
  service/default/sample-webapp.   Spot Fleet - The resource type is spot-fleet-request and
  the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `"ScalableDimension"`: The scalable dimension. This string consists of the service
  namespace, resource type, and scaling property. If you specify a scalable dimension, you
  must also specify a resource ID.    ecs:service:DesiredCount - The desired task count of an
  ECS service.    elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR
  Instance Group.    ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
  Fleet.    appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
     dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
   dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
   dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global
  secondary index.    dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
  a DynamoDB global secondary index.    rds:cluster:ReadReplicaCount - The count of Aurora
  Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora
  PostgreSQL-compatible edition.    sagemaker:variant:DesiredInstanceCount - The number of
  EC2 instances for a SageMaker model endpoint variant.
  custom-resource:ResourceType:Property - The scalable dimension for a custom resource
  provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
"""
function describe_scaling_activities(
    ServiceNamespace; aws_config::AbstractAWSConfig=current_aws_config()
)
    return application_auto_scaling(
        "DescribeScalingActivities",
        Dict{String,Any}("ServiceNamespace" => ServiceNamespace);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_scaling_activities(
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DescribeScalingActivities",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ServiceNamespace" => ServiceNamespace), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_scaling_policies(service_namespace)
    describe_scaling_policies(service_namespace, params::Dict{String,<:Any})

Describes the Application Auto Scaling scaling policies for the specified service
namespace. You can filter the results using ResourceId, ScalableDimension, and PolicyNames.
For more information, see Target tracking scaling policies and Step scaling policies in the
Application Auto Scaling User Guide.

# Arguments
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of scalable targets. This value can be between 1 and
  10. The default value is 10. If this parameter is used, the operation returns up to
  MaxResults results at a time, along with a NextToken value. To get the next set of results,
  include the NextToken value in a subsequent call. If this parameter is not used, the
  operation returns up to 10 results and a NextToken value, if applicable.
- `"NextToken"`: The token for the next set of results.
- `"PolicyNames"`: The names of the scaling policies to describe.
- `"ResourceId"`: The identifier of the resource associated with the scaling policy. This
  string consists of the resource type and unique identifier.   ECS service - The resource
  type is service and the unique identifier is the cluster name and service name. Example:
  service/default/sample-webapp.   Spot Fleet - The resource type is spot-fleet-request and
  the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `"ScalableDimension"`: The scalable dimension. This string consists of the service
  namespace, resource type, and scaling property. If you specify a scalable dimension, you
  must also specify a resource ID.    ecs:service:DesiredCount - The desired task count of an
  ECS service.    elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR
  Instance Group.    ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
  Fleet.    appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
     dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
   dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
   dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global
  secondary index.    dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
  a DynamoDB global secondary index.    rds:cluster:ReadReplicaCount - The count of Aurora
  Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora
  PostgreSQL-compatible edition.    sagemaker:variant:DesiredInstanceCount - The number of
  EC2 instances for a SageMaker model endpoint variant.
  custom-resource:ResourceType:Property - The scalable dimension for a custom resource
  provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
"""
function describe_scaling_policies(
    ServiceNamespace; aws_config::AbstractAWSConfig=current_aws_config()
)
    return application_auto_scaling(
        "DescribeScalingPolicies",
        Dict{String,Any}("ServiceNamespace" => ServiceNamespace);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_scaling_policies(
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DescribeScalingPolicies",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ServiceNamespace" => ServiceNamespace), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_scheduled_actions(service_namespace)
    describe_scheduled_actions(service_namespace, params::Dict{String,<:Any})

Describes the Application Auto Scaling scheduled actions for the specified service
namespace. You can filter the results using the ResourceId, ScalableDimension, and
ScheduledActionNames parameters. For more information, see Scheduled scaling and Managing
scheduled scaling in the Application Auto Scaling User Guide.

# Arguments
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of scheduled action results. This value can be between
  1 and 50. The default value is 50. If this parameter is used, the operation returns up to
  MaxResults results at a time, along with a NextToken value. To get the next set of results,
  include the NextToken value in a subsequent call. If this parameter is not used, the
  operation returns up to 50 results and a NextToken value, if applicable.
- `"NextToken"`: The token for the next set of results.
- `"ResourceId"`: The identifier of the resource associated with the scheduled action. This
  string consists of the resource type and unique identifier.   ECS service - The resource
  type is service and the unique identifier is the cluster name and service name. Example:
  service/default/sample-webapp.   Spot Fleet - The resource type is spot-fleet-request and
  the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `"ScalableDimension"`: The scalable dimension. This string consists of the service
  namespace, resource type, and scaling property. If you specify a scalable dimension, you
  must also specify a resource ID.    ecs:service:DesiredCount - The desired task count of an
  ECS service.    elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR
  Instance Group.    ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
  Fleet.    appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
     dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
   dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
   dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global
  secondary index.    dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
  a DynamoDB global secondary index.    rds:cluster:ReadReplicaCount - The count of Aurora
  Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora
  PostgreSQL-compatible edition.    sagemaker:variant:DesiredInstanceCount - The number of
  EC2 instances for a SageMaker model endpoint variant.
  custom-resource:ResourceType:Property - The scalable dimension for a custom resource
  provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
- `"ScheduledActionNames"`: The names of the scheduled actions to describe.
"""
function describe_scheduled_actions(
    ServiceNamespace; aws_config::AbstractAWSConfig=current_aws_config()
)
    return application_auto_scaling(
        "DescribeScheduledActions",
        Dict{String,Any}("ServiceNamespace" => ServiceNamespace);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_scheduled_actions(
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "DescribeScheduledActions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ServiceNamespace" => ServiceNamespace), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns all the tags on the specified Application Auto Scaling scalable target. For general
information about tags, including the format and syntax, see Tagging Amazon Web Services
resources in the Amazon Web Services General Reference.

# Arguments
- `resource_arn`: Specify the ARN of the scalable target. For example:
  arn:aws:application-autoscaling:us-east-1:123456789012:scalable-target/1234abcd56ab78cd901ef
  1234567890ab123  To get the ARN for a scalable target, use DescribeScalableTargets.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return application_auto_scaling(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_scaling_policy(policy_name, resource_id, scalable_dimension, service_namespace)
    put_scaling_policy(policy_name, resource_id, scalable_dimension, service_namespace, params::Dict{String,<:Any})

Creates or updates a scaling policy for an Application Auto Scaling scalable target. Each
scalable target is identified by a service namespace, resource ID, and scalable dimension.
A scaling policy applies to the scalable target identified by those three attributes. You
cannot create a scaling policy until you have registered the resource as a scalable target.
Multiple scaling policies can be in force at the same time for the same scalable target.
You can have one or more target tracking scaling policies, one or more step scaling
policies, or both. However, there is a chance that multiple policies could conflict,
instructing the scalable target to scale out or in at the same time. Application Auto
Scaling gives precedence to the policy that provides the largest capacity for both scale
out and scale in. For example, if one policy increases capacity by 3, another policy
increases capacity by 200 percent, and the current capacity is 10, Application Auto Scaling
uses the policy with the highest calculated capacity (200% of 10 = 20) and scales out to
30.  We recommend caution, however, when using target tracking scaling policies with step
scaling policies because conflicts between these policies can cause undesirable behavior.
For example, if the step scaling policy initiates a scale-in activity before the target
tracking policy is ready to scale in, the scale-in activity will not be blocked. After the
scale-in activity completes, the target tracking policy could instruct the scalable target
to scale out again.  For more information, see Target tracking scaling policies and Step
scaling policies in the Application Auto Scaling User Guide.  If a scalable target is
deregistered, the scalable target is no longer available to use scaling policies. Any
scaling policies that were specified for the scalable target are deleted.

# Arguments
- `policy_name`: The name of the scaling policy. You cannot change the name of a scaling
  policy, but you can delete the original scaling policy and create a new scaling policy with
  the same settings and a different name.
- `resource_id`: The identifier of the resource associated with the scaling policy. This
  string consists of the resource type and unique identifier.   ECS service - The resource
  type is service and the unique identifier is the cluster name and service name. Example:
  service/default/sample-webapp.   Spot Fleet - The resource type is spot-fleet-request and
  the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `scalable_dimension`: The scalable dimension. This string consists of the service
  namespace, resource type, and scaling property.    ecs:service:DesiredCount - The desired
  task count of an ECS service.    elasticmapreduce:instancegroup:InstanceCount - The
  instance count of an EMR Instance Group.    ec2:spot-fleet-request:TargetCapacity - The
  target capacity of a Spot Fleet.    appstream:fleet:DesiredCapacity - The desired capacity
  of an AppStream 2.0 fleet.    dynamodb:table:ReadCapacityUnits - The provisioned read
  capacity for a DynamoDB table.    dynamodb:table:WriteCapacityUnits - The provisioned write
  capacity for a DynamoDB table.    dynamodb:index:ReadCapacityUnits - The provisioned read
  capacity for a DynamoDB global secondary index.    dynamodb:index:WriteCapacityUnits - The
  provisioned write capacity for a DynamoDB global secondary index.
  rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster.
  Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
  sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for a SageMaker model
  endpoint variant.    custom-resource:ResourceType:Property - The scalable dimension for a
  custom resource provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PolicyType"`: The scaling policy type. This parameter is required if you are creating a
  scaling policy. The following policy types are supported:   TargetTrackingScaling—Not
  supported for Amazon EMR.  StepScaling—Not supported for DynamoDB, Amazon Comprehend,
  Lambda, Amazon Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune. For more information,
  see Target tracking scaling policies and Step scaling policies in the Application Auto
  Scaling User Guide.
- `"StepScalingPolicyConfiguration"`: A step scaling policy. This parameter is required if
  you are creating a policy and the policy type is StepScaling.
- `"TargetTrackingScalingPolicyConfiguration"`: A target tracking scaling policy. Includes
  support for predefined or customized metrics. This parameter is required if you are
  creating a policy and the policy type is TargetTrackingScaling.
"""
function put_scaling_policy(
    PolicyName,
    ResourceId,
    ScalableDimension,
    ServiceNamespace;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "PutScalingPolicy",
        Dict{String,Any}(
            "PolicyName" => PolicyName,
            "ResourceId" => ResourceId,
            "ScalableDimension" => ScalableDimension,
            "ServiceNamespace" => ServiceNamespace,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_scaling_policy(
    PolicyName,
    ResourceId,
    ScalableDimension,
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "PutScalingPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyName" => PolicyName,
                    "ResourceId" => ResourceId,
                    "ScalableDimension" => ScalableDimension,
                    "ServiceNamespace" => ServiceNamespace,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_scheduled_action(resource_id, scalable_dimension, scheduled_action_name, service_namespace)
    put_scheduled_action(resource_id, scalable_dimension, scheduled_action_name, service_namespace, params::Dict{String,<:Any})

Creates or updates a scheduled action for an Application Auto Scaling scalable target.
Each scalable target is identified by a service namespace, resource ID, and scalable
dimension. A scheduled action applies to the scalable target identified by those three
attributes. You cannot create a scheduled action until you have registered the resource as
a scalable target. When you specify start and end times with a recurring schedule using a
cron expression or rates, they form the boundaries for when the recurring action starts and
stops. To update a scheduled action, specify the parameters that you want to change. If you
don't specify start and end times, the old values are deleted. For more information, see
Scheduled scaling in the Application Auto Scaling User Guide.  If a scalable target is
deregistered, the scalable target is no longer available to run scheduled actions. Any
scheduled actions that were specified for the scalable target are deleted.

# Arguments
- `resource_id`: The identifier of the resource associated with the scheduled action. This
  string consists of the resource type and unique identifier.   ECS service - The resource
  type is service and the unique identifier is the cluster name and service name. Example:
  service/default/sample-webapp.   Spot Fleet - The resource type is spot-fleet-request and
  the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `scalable_dimension`: The scalable dimension. This string consists of the service
  namespace, resource type, and scaling property.    ecs:service:DesiredCount - The desired
  task count of an ECS service.    elasticmapreduce:instancegroup:InstanceCount - The
  instance count of an EMR Instance Group.    ec2:spot-fleet-request:TargetCapacity - The
  target capacity of a Spot Fleet.    appstream:fleet:DesiredCapacity - The desired capacity
  of an AppStream 2.0 fleet.    dynamodb:table:ReadCapacityUnits - The provisioned read
  capacity for a DynamoDB table.    dynamodb:table:WriteCapacityUnits - The provisioned write
  capacity for a DynamoDB table.    dynamodb:index:ReadCapacityUnits - The provisioned read
  capacity for a DynamoDB global secondary index.    dynamodb:index:WriteCapacityUnits - The
  provisioned write capacity for a DynamoDB global secondary index.
  rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster.
  Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
  sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for a SageMaker model
  endpoint variant.    custom-resource:ResourceType:Property - The scalable dimension for a
  custom resource provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
- `scheduled_action_name`: The name of the scheduled action. This name must be unique among
  all other scheduled actions on the specified scalable target.
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EndTime"`: The date and time for the recurring schedule to end, in UTC.
- `"ScalableTargetAction"`: The new minimum and maximum capacity. You can set both values
  or just one. At the scheduled time, if the current capacity is below the minimum capacity,
  Application Auto Scaling scales out to the minimum capacity. If the current capacity is
  above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
- `"Schedule"`: The schedule for this action. The following formats are supported:   At
  expressions - \"at(yyyy-mm-ddThh:mm:ss)\"   Rate expressions - \"rate(value unit)\"   Cron
  expressions - \"cron(fields)\"   At expressions are useful for one-time schedules. Cron
  expressions are useful for scheduled actions that run periodically at a specified date and
  time, and rate expressions are useful for scheduled actions that run at a regular interval.
  At and cron expressions use Universal Coordinated Time (UTC) by default. The cron format
  consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month]
  [Day_of_Week] [Year]. For rate expressions, value is a positive integer and unit is minute
  | minutes | hour | hours | day | days. For more information and examples, see Example
  scheduled actions for Application Auto Scaling in the Application Auto Scaling User Guide.
- `"StartTime"`: The date and time for this scheduled action to start, in UTC.
- `"Timezone"`: Specifies the time zone used when setting a scheduled action by using an at
  or cron expression. If a time zone is not provided, UTC is used by default. Valid values
  are the canonical names of the IANA time zones supported by Joda-Time (such as Etc/GMT+9 or
  Pacific/Tahiti). For more information, see https://www.joda.org/joda-time/timezones.html.
"""
function put_scheduled_action(
    ResourceId,
    ScalableDimension,
    ScheduledActionName,
    ServiceNamespace;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "PutScheduledAction",
        Dict{String,Any}(
            "ResourceId" => ResourceId,
            "ScalableDimension" => ScalableDimension,
            "ScheduledActionName" => ScheduledActionName,
            "ServiceNamespace" => ServiceNamespace,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_scheduled_action(
    ResourceId,
    ScalableDimension,
    ScheduledActionName,
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "PutScheduledAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId,
                    "ScalableDimension" => ScalableDimension,
                    "ScheduledActionName" => ScheduledActionName,
                    "ServiceNamespace" => ServiceNamespace,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_scalable_target(resource_id, scalable_dimension, service_namespace)
    register_scalable_target(resource_id, scalable_dimension, service_namespace, params::Dict{String,<:Any})

Registers or updates a scalable target, which is the resource that you want to scale.
Scalable targets are uniquely identified by the combination of resource ID, scalable
dimension, and namespace, which represents some capacity dimension of the underlying
service. When you register a new scalable target, you must specify values for the minimum
and maximum capacity. If the specified resource is not active in the target service, this
operation does not change the resource's current capacity. Otherwise, it changes the
resource's current capacity to a value that is inside of this range. If you add a scaling
policy, current capacity is adjustable within the specified range when scaling starts.
Application Auto Scaling scaling policies will not scale capacity to values that are
outside of the minimum and maximum range. After you register a scalable target, you do not
need to register it again to use other Application Auto Scaling operations. To see which
resources have been registered, use DescribeScalableTargets. You can also view the scaling
policies for a service namespace by using DescribeScalableTargets. If you no longer need a
scalable target, you can deregister it by using DeregisterScalableTarget. To update a
scalable target, specify the parameters that you want to change. Include the parameters
that identify the scalable target: resource ID, scalable dimension, and namespace. Any
parameters that you don't specify are not changed by this update request.   If you call the
RegisterScalableTarget API operation to create a scalable target, there might be a brief
delay until the operation achieves eventual consistency. You might become aware of this
brief delay if you get unexpected errors when performing sequential operations. The typical
strategy is to retry the request, and some Amazon Web Services SDKs include automatic
backoff and retry logic. If you call the RegisterScalableTarget API operation to update an
existing scalable target, Application Auto Scaling retrieves the current capacity of the
resource. If it's below the minimum capacity or above the maximum capacity, Application
Auto Scaling adjusts the capacity of the scalable target to place it within these bounds,
even if you don't include the MinCapacity or MaxCapacity request parameters.

# Arguments
- `resource_id`: The identifier of the resource that is associated with the scalable
  target. This string consists of the resource type and unique identifier.   ECS service -
  The resource type is service and the unique identifier is the cluster name and service
  name. Example: service/default/sample-webapp.   Spot Fleet - The resource type is
  spot-fleet-request and the unique identifier is the Spot Fleet request ID. Example:
  spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.   EMR cluster - The resource
  type is instancegroup and the unique identifier is the cluster ID and instance group ID.
  Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.   AppStream 2.0 fleet - The
  resource type is fleet and the unique identifier is the fleet name. Example:
  fleet/sample-fleet.   DynamoDB table - The resource type is table and the unique identifier
  is the table name. Example: table/my-table.   DynamoDB global secondary index - The
  resource type is index and the unique identifier is the index name. Example:
  table/my-table/index/my-table-index.   Aurora DB cluster - The resource type is cluster and
  the unique identifier is the cluster name. Example: cluster:my-db-cluster.   SageMaker
  endpoint variant - The resource type is variant and the unique identifier is the resource
  ID. Example: endpoint/my-end-point/variant/KMeansClustering.   Custom resources are not
  supported with a resource type. This parameter must specify the OutputValue from the
  CloudFormation template stack used to access the resources. The unique identifier is
  defined by the service provider. More information is available in our GitHub repository.
  Amazon Comprehend document classification endpoint - The resource type and unique
  identifier are specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.   Amazon
  Comprehend entity recognizer endpoint - The resource type and unique identifier are
  specified using the endpoint ARN. Example:
  arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.   Lambda
  provisioned concurrency - The resource type is function and the unique identifier is the
  function name with a function version or alias name suffix that is not LATEST. Example:
  function:my-function:prod or function:my-function:1.   Amazon Keyspaces table - The
  resource type is table and the unique identifier is the table name. Example:
  keyspace/mykeyspace/table/mytable.   Amazon MSK cluster - The resource type and unique
  identifier are specified using the cluster ARN. Example:
  arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c
  2e31-5.   Amazon ElastiCache replication group - The resource type is replication-group and
  the unique identifier is the replication group name. Example: replication-group/mycluster.
   Neptune cluster - The resource type is cluster and the unique identifier is the cluster
  name. Example: cluster:mycluster.   SageMaker Serverless endpoint - The resource type is
  variant and the unique identifier is the resource ID. Example:
  endpoint/my-end-point/variant/KMeansClustering.   SageMaker inference component - The
  resource type is inference-component and the unique identifier is the resource ID. Example:
  inference-component/my-inference-component.
- `scalable_dimension`: The scalable dimension associated with the scalable target. This
  string consists of the service namespace, resource type, and scaling property.
  ecs:service:DesiredCount - The desired task count of an ECS service.
  elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR Instance Group.
     ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
  appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0 fleet.
  dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
  dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
  dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global
  secondary index.    dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
  a DynamoDB global secondary index.    rds:cluster:ReadReplicaCount - The count of Aurora
  Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora
  PostgreSQL-compatible edition.    sagemaker:variant:DesiredInstanceCount - The number of
  EC2 instances for a SageMaker model endpoint variant.
  custom-resource:ResourceType:Property - The scalable dimension for a custom resource
  provided by your own application or service.
  comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number of inference
  units for an Amazon Comprehend document classification endpoint.
  comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of inference units
  for an Amazon Comprehend entity recognizer endpoint.
  lambda:function:ProvisionedConcurrency - The provisioned concurrency for a Lambda function.
     cassandra:table:ReadCapacityUnits - The provisioned read capacity for an Amazon
  Keyspaces table.    cassandra:table:WriteCapacityUnits - The provisioned write capacity for
  an Amazon Keyspaces table.    kafka:broker-storage:VolumeSize - The provisioned volume size
  (in GiB) for brokers in an Amazon MSK cluster.    elasticache:replication-group:NodeGroups
  - The number of node groups for an Amazon ElastiCache replication group.
  elasticache:replication-group:Replicas - The number of replicas per node group for an
  Amazon ElastiCache replication group.    neptune:cluster:ReadReplicaCount - The count of
  read replicas in an Amazon Neptune DB cluster.
  sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency for a
  SageMaker Serverless endpoint.    sagemaker:inference-component:DesiredCopyCount - The
  number of copies across an endpoint for a SageMaker inference component.
- `service_namespace`: The namespace of the Amazon Web Services service that provides the
  resource. For a resource provided by your own application or service, use custom-resource
  instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxCapacity"`: The maximum value that you plan to scale out to. When a scaling policy
  is in effect, Application Auto Scaling can scale out (expand) as needed to the maximum
  capacity limit in response to changing demand. This property is required when registering a
  new scalable target. Although you can specify a large maximum capacity, note that service
  quotas might impose lower limits. Each service has its own default quotas for the maximum
  capacity of the resource. If you want to specify a higher limit, you can request an
  increase. For more information, consult the documentation for that service. For information
  about the default quotas for each service, see Service endpoints and quotas in the Amazon
  Web Services General Reference.
- `"MinCapacity"`: The minimum value that you plan to scale in to. When a scaling policy is
  in effect, Application Auto Scaling can scale in (contract) as needed to the minimum
  capacity limit in response to changing demand. This property is required when registering a
  new scalable target. For the following resources, the minimum value allowed is 0.
  AppStream 2.0 fleets    Aurora DB clusters   ECS services   EMR clusters   Lambda
  provisioned concurrency   SageMaker endpoint variants   SageMaker Serverless endpoint
  provisioned concurrency   Spot Fleets   custom resources   It's strongly recommended that
  you specify a value greater than 0. A value greater than 0 means that data points are
  continuously reported to CloudWatch that scaling policies can use to scale on a metric like
  average CPU utilization. For all other resources, the minimum allowed value depends on the
  type of resource that you are using. If you provide a value that is lower than what a
  resource can accept, an error occurs. In which case, the error message will provide the
  minimum value that the resource can accept.
- `"RoleARN"`: This parameter is required for services that do not support service-linked
  roles (such as Amazon EMR), and it must specify the ARN of an IAM role that allows
  Application Auto Scaling to modify the scalable target on your behalf.  If the service
  supports service-linked roles, Application Auto Scaling uses a service-linked role, which
  it creates if it does not yet exist. For more information, see Application Auto Scaling IAM
  roles.
- `"SuspendedState"`: An embedded object that contains attributes and attribute values that
  are used to suspend and resume automatic scaling. Setting the value of an attribute to true
  suspends the specified scaling activities. Setting it to false (default) resumes the
  specified scaling activities.   Suspension Outcomes    For DynamicScalingInSuspended, while
  a suspension is in effect, all scale-in activities that are triggered by a scaling policy
  are suspended.   For DynamicScalingOutSuspended, while a suspension is in effect, all
  scale-out activities that are triggered by a scaling policy are suspended.   For
  ScheduledScalingSuspended, while a suspension is in effect, all scaling activities that
  involve scheduled actions are suspended.    For more information, see Suspending and
  resuming scaling in the Application Auto Scaling User Guide.
- `"Tags"`: Assigns one or more tags to the scalable target. Use this parameter to tag the
  scalable target when it is created. To tag an existing scalable target, use the TagResource
  operation. Each tag consists of a tag key and a tag value. Both the tag key and the tag
  value are required. You cannot have more than one tag on a scalable target with the same
  tag key. Use tags to control access to a scalable target. For more information, see Tagging
  support for Application Auto Scaling in the Application Auto Scaling User Guide.
"""
function register_scalable_target(
    ResourceId,
    ScalableDimension,
    ServiceNamespace;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "RegisterScalableTarget",
        Dict{String,Any}(
            "ResourceId" => ResourceId,
            "ScalableDimension" => ScalableDimension,
            "ServiceNamespace" => ServiceNamespace,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_scalable_target(
    ResourceId,
    ScalableDimension,
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "RegisterScalableTarget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId,
                    "ScalableDimension" => ScalableDimension,
                    "ServiceNamespace" => ServiceNamespace,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds or edits tags on an Application Auto Scaling scalable target. Each tag consists of a
tag key and a tag value, which are both case-sensitive strings. To add a tag, specify a new
tag key and a tag value. To edit a tag, specify an existing tag key and a new tag value.
You can use this operation to tag an Application Auto Scaling scalable target, but you
cannot tag a scaling policy or scheduled action. You can also add tags to an Application
Auto Scaling scalable target while creating it (RegisterScalableTarget). For general
information about tags, including the format and syntax, see Tagging Amazon Web Services
resources in the Amazon Web Services General Reference. Use tags to control access to a
scalable target. For more information, see Tagging support for Application Auto Scaling in
the Application Auto Scaling User Guide.

# Arguments
- `resource_arn`: Identifies the Application Auto Scaling scalable target that you want to
  apply tags to. For example:
  arn:aws:application-autoscaling:us-east-1:123456789012:scalable-target/1234abcd56ab78cd901ef
  1234567890ab123  To get the ARN for a scalable target, use DescribeScalableTargets.
- `tags`: The tags assigned to the resource. A tag is a label that you assign to an Amazon
  Web Services resource. Each tag consists of a tag key and a tag value. You cannot have more
  than one tag on an Application Auto Scaling scalable target with the same tag key. If you
  specify an existing tag key with a different tag value, Application Auto Scaling replaces
  the current tag value with the specified one. For information about the rules that apply to
  tag keys and tag values, see User-defined tag restrictions in the Amazon Web Services
  Billing and Cost Management User Guide.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return application_auto_scaling(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Deletes tags from an Application Auto Scaling scalable target. To delete a tag, specify the
tag key and the Application Auto Scaling scalable target.

# Arguments
- `resource_arn`: Identifies the Application Auto Scaling scalable target from which to
  remove tags. For example:
  arn:aws:application-autoscaling:us-east-1:123456789012:scalable-target/1234abcd56ab78cd901ef
  1234567890ab123  To get the ARN for a scalable target, use DescribeScalableTargets.
- `tag_keys`: One or more tag keys. Specify only the tag keys, not the tag values.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return application_auto_scaling(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return application_auto_scaling(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
