# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: backup_gateway
using AWS.Compat
using AWS.UUIDs

"""
    associate_gateway_to_server(gateway_arn, server_arn)
    associate_gateway_to_server(gateway_arn, server_arn, params::Dict{String,<:Any})

Associates a backup gateway with your server. After you complete the association process,
you can back up and restore your VMs through the gateway.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
  operation to return a list of gateways for your account and Amazon Web Services Region.
- `server_arn`: The Amazon Resource Name (ARN) of the server that hosts your virtual
  machines.

"""
function associate_gateway_to_server(
    GatewayArn, ServerArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "AssociateGatewayToServer",
        Dict{String,Any}("GatewayArn" => GatewayArn, "ServerArn" => ServerArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_gateway_to_server(
    GatewayArn,
    ServerArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "AssociateGatewayToServer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GatewayArn" => GatewayArn, "ServerArn" => ServerArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_gateway(activation_key, gateway_display_name, gateway_type)
    create_gateway(activation_key, gateway_display_name, gateway_type, params::Dict{String,<:Any})

Creates a backup gateway. After you create a gateway, you can associate it with a server
using the AssociateGatewayToServer operation.

# Arguments
- `activation_key`: The activation key of the created gateway.
- `gateway_display_name`: The display name of the created gateway.
- `gateway_type`: The type of created gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.
"""
function create_gateway(
    ActivationKey,
    GatewayDisplayName,
    GatewayType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "CreateGateway",
        Dict{String,Any}(
            "ActivationKey" => ActivationKey,
            "GatewayDisplayName" => GatewayDisplayName,
            "GatewayType" => GatewayType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_gateway(
    ActivationKey,
    GatewayDisplayName,
    GatewayType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "CreateGateway",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ActivationKey" => ActivationKey,
                    "GatewayDisplayName" => GatewayDisplayName,
                    "GatewayType" => GatewayType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_gateway(gateway_arn)
    delete_gateway(gateway_arn, params::Dict{String,<:Any})

Deletes a backup gateway.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway to delete.

"""
function delete_gateway(GatewayArn; aws_config::AbstractAWSConfig=current_aws_config())
    return backup_gateway(
        "DeleteGateway",
        Dict{String,Any}("GatewayArn" => GatewayArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_gateway(
    GatewayArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "DeleteGateway",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayArn" => GatewayArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_hypervisor(hypervisor_arn)
    delete_hypervisor(hypervisor_arn, params::Dict{String,<:Any})

Deletes a hypervisor.

# Arguments
- `hypervisor_arn`: The Amazon Resource Name (ARN) of the hypervisor to delete.

"""
function delete_hypervisor(
    HypervisorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "DeleteHypervisor",
        Dict{String,Any}("HypervisorArn" => HypervisorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_hypervisor(
    HypervisorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "DeleteHypervisor",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("HypervisorArn" => HypervisorArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_gateway_from_server(gateway_arn)
    disassociate_gateway_from_server(gateway_arn, params::Dict{String,<:Any})

Disassociates a backup gateway from the specified server. After the disassociation process
finishes, the gateway can no longer access the virtual machines on the server.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway to disassociate.

"""
function disassociate_gateway_from_server(
    GatewayArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "DisassociateGatewayFromServer",
        Dict{String,Any}("GatewayArn" => GatewayArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_gateway_from_server(
    GatewayArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "DisassociateGatewayFromServer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayArn" => GatewayArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bandwidth_rate_limit_schedule(gateway_arn)
    get_bandwidth_rate_limit_schedule(gateway_arn, params::Dict{String,<:Any})

Retrieves the bandwidth rate limit schedule for a specified gateway. By default, gateways
do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in
effect. Use this to get a gateway's bandwidth rate limit schedule.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway. Use the  ListGateways
  operation to return a list of gateways for your account and Amazon Web Services Region.

"""
function get_bandwidth_rate_limit_schedule(
    GatewayArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "GetBandwidthRateLimitSchedule",
        Dict{String,Any}("GatewayArn" => GatewayArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bandwidth_rate_limit_schedule(
    GatewayArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "GetBandwidthRateLimitSchedule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayArn" => GatewayArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_gateway(gateway_arn)
    get_gateway(gateway_arn, params::Dict{String,<:Any})

By providing the ARN (Amazon Resource Name), this API returns the gateway.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway.

"""
function get_gateway(GatewayArn; aws_config::AbstractAWSConfig=current_aws_config())
    return backup_gateway(
        "GetGateway",
        Dict{String,Any}("GatewayArn" => GatewayArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_gateway(
    GatewayArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "GetGateway",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayArn" => GatewayArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_hypervisor(hypervisor_arn)
    get_hypervisor(hypervisor_arn, params::Dict{String,<:Any})

This action requests information about the specified hypervisor to which the gateway will
connect. A hypervisor is hardware, software, or firmware that creates and manages virtual
machines, and allocates resources to them.

# Arguments
- `hypervisor_arn`: The Amazon Resource Name (ARN) of the hypervisor.

"""
function get_hypervisor(HypervisorArn; aws_config::AbstractAWSConfig=current_aws_config())
    return backup_gateway(
        "GetHypervisor",
        Dict{String,Any}("HypervisorArn" => HypervisorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_hypervisor(
    HypervisorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "GetHypervisor",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("HypervisorArn" => HypervisorArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_hypervisor_property_mappings(hypervisor_arn)
    get_hypervisor_property_mappings(hypervisor_arn, params::Dict{String,<:Any})

This action retrieves the property mappings for the specified hypervisor. A hypervisor
property mapping displays the relationship of entity properties available from the
on-premises hypervisor to the properties available in Amazon Web Services.

# Arguments
- `hypervisor_arn`: The Amazon Resource Name (ARN) of the hypervisor.

"""
function get_hypervisor_property_mappings(
    HypervisorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "GetHypervisorPropertyMappings",
        Dict{String,Any}("HypervisorArn" => HypervisorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_hypervisor_property_mappings(
    HypervisorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "GetHypervisorPropertyMappings",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("HypervisorArn" => HypervisorArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_virtual_machine(resource_arn)
    get_virtual_machine(resource_arn, params::Dict{String,<:Any})

By providing the ARN (Amazon Resource Name), this API returns the virtual machine.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the virtual machine.

"""
function get_virtual_machine(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "GetVirtualMachine",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_virtual_machine(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "GetVirtualMachine",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_hypervisor_configuration(host, name)
    import_hypervisor_configuration(host, name, params::Dict{String,<:Any})

Connect to a hypervisor by importing its configuration.

# Arguments
- `host`: The server host of the hypervisor. This can be either an IP address or a
  fully-qualified domain name (FQDN).
- `name`: The name of the hypervisor.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KmsKeyArn"`: The Key Management Service for the hypervisor.
- `"Password"`: The password for the hypervisor.
- `"Tags"`: The tags of the hypervisor configuration to import.
- `"Username"`: The username for the hypervisor.
"""
function import_hypervisor_configuration(
    Host, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "ImportHypervisorConfiguration",
        Dict{String,Any}("Host" => Host, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_hypervisor_configuration(
    Host,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "ImportHypervisorConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Host" => Host, "Name" => Name), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_gateways()
    list_gateways(params::Dict{String,<:Any})

Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services
Region. The returned list is ordered by gateway Amazon Resource Name (ARN).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of gateways to list.
- `"NextToken"`: The next item following a partial list of returned resources. For example,
  if a request is made to return MaxResults number of resources, NextToken allows you to
  return more items in your list starting at the location pointed to by the next token.
"""
function list_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return backup_gateway(
        "ListGateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "ListGateways", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_hypervisors()
    list_hypervisors(params::Dict{String,<:Any})

Lists your hypervisors.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of hypervisors to list.
- `"NextToken"`: The next item following a partial list of returned resources. For example,
  if a request is made to return maxResults number of resources, NextToken allows you to
  return more items in your list starting at the location pointed to by the next token.
"""
function list_hypervisors(; aws_config::AbstractAWSConfig=current_aws_config())
    return backup_gateway(
        "ListHypervisors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_hypervisors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "ListHypervisors", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource's tags to list.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_virtual_machines()
    list_virtual_machines(params::Dict{String,<:Any})

Lists your virtual machines.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HypervisorArn"`: The Amazon Resource Name (ARN) of the hypervisor connected to your
  virtual machine.
- `"MaxResults"`: The maximum number of virtual machines to list.
- `"NextToken"`: The next item following a partial list of returned resources. For example,
  if a request is made to return maxResults number of resources, NextToken allows you to
  return more items in your list starting at the location pointed to by the next token.
"""
function list_virtual_machines(; aws_config::AbstractAWSConfig=current_aws_config())
    return backup_gateway(
        "ListVirtualMachines"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_virtual_machines(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "ListVirtualMachines",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_bandwidth_rate_limit_schedule(bandwidth_rate_limit_intervals, gateway_arn)
    put_bandwidth_rate_limit_schedule(bandwidth_rate_limit_intervals, gateway_arn, params::Dict{String,<:Any})

This action sets the bandwidth rate limit schedule for a specified gateway. By default,
gateways do not have a bandwidth rate limit schedule, which means no bandwidth rate
limiting is in effect. Use this to initiate a gateway's bandwidth rate limit schedule.

# Arguments
- `bandwidth_rate_limit_intervals`: An array containing bandwidth rate limit schedule
  intervals for a gateway. When no bandwidth rate limit intervals have been scheduled, the
  array is empty.
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway. Use the  ListGateways
  operation to return a list of gateways for your account and Amazon Web Services Region.

"""
function put_bandwidth_rate_limit_schedule(
    BandwidthRateLimitIntervals,
    GatewayArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "PutBandwidthRateLimitSchedule",
        Dict{String,Any}(
            "BandwidthRateLimitIntervals" => BandwidthRateLimitIntervals,
            "GatewayArn" => GatewayArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_bandwidth_rate_limit_schedule(
    BandwidthRateLimitIntervals,
    GatewayArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "PutBandwidthRateLimitSchedule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BandwidthRateLimitIntervals" => BandwidthRateLimitIntervals,
                    "GatewayArn" => GatewayArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_hypervisor_property_mappings(hypervisor_arn, iam_role_arn, vmware_to_aws_tag_mappings)
    put_hypervisor_property_mappings(hypervisor_arn, iam_role_arn, vmware_to_aws_tag_mappings, params::Dict{String,<:Any})

This action sets the property mappings for the specified hypervisor. A hypervisor property
mapping displays the relationship of entity properties available from the on-premises
hypervisor to the properties available in Amazon Web Services.

# Arguments
- `hypervisor_arn`: The Amazon Resource Name (ARN) of the hypervisor.
- `iam_role_arn`: The Amazon Resource Name (ARN) of the IAM role.
- `vmware_to_aws_tag_mappings`: This action requests the mappings of on-premises VMware
  tags to the Amazon Web Services tags.

"""
function put_hypervisor_property_mappings(
    HypervisorArn,
    IamRoleArn,
    VmwareToAwsTagMappings;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "PutHypervisorPropertyMappings",
        Dict{String,Any}(
            "HypervisorArn" => HypervisorArn,
            "IamRoleArn" => IamRoleArn,
            "VmwareToAwsTagMappings" => VmwareToAwsTagMappings,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_hypervisor_property_mappings(
    HypervisorArn,
    IamRoleArn,
    VmwareToAwsTagMappings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "PutHypervisorPropertyMappings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "HypervisorArn" => HypervisorArn,
                    "IamRoleArn" => IamRoleArn,
                    "VmwareToAwsTagMappings" => VmwareToAwsTagMappings,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_maintenance_start_time(gateway_arn, hour_of_day, minute_of_hour)
    put_maintenance_start_time(gateway_arn, hour_of_day, minute_of_hour, params::Dict{String,<:Any})

Set the maintenance start time for a gateway.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) for the gateway, used to specify its
  maintenance start time.
- `hour_of_day`: The hour of the day to start maintenance on a gateway.
- `minute_of_hour`: The minute of the hour to start maintenance on a gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DayOfMonth"`: The day of the month start maintenance on a gateway. Valid values range
  from Sunday to Saturday.
- `"DayOfWeek"`: The day of the week to start maintenance on a gateway.
"""
function put_maintenance_start_time(
    GatewayArn, HourOfDay, MinuteOfHour; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "PutMaintenanceStartTime",
        Dict{String,Any}(
            "GatewayArn" => GatewayArn,
            "HourOfDay" => HourOfDay,
            "MinuteOfHour" => MinuteOfHour,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_maintenance_start_time(
    GatewayArn,
    HourOfDay,
    MinuteOfHour,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "PutMaintenanceStartTime",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GatewayArn" => GatewayArn,
                    "HourOfDay" => HourOfDay,
                    "MinuteOfHour" => MinuteOfHour,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_virtual_machines_metadata_sync(hypervisor_arn)
    start_virtual_machines_metadata_sync(hypervisor_arn, params::Dict{String,<:Any})

This action sends a request to sync metadata across the specified virtual machines.

# Arguments
- `hypervisor_arn`: The Amazon Resource Name (ARN) of the hypervisor.

"""
function start_virtual_machines_metadata_sync(
    HypervisorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "StartVirtualMachinesMetadataSync",
        Dict{String,Any}("HypervisorArn" => HypervisorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_virtual_machines_metadata_sync(
    HypervisorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "StartVirtualMachinesMetadataSync",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("HypervisorArn" => HypervisorArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Tag the resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to tag.
- `tags`: A list of tags to assign to the resource.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return backup_gateway(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_hypervisor_configuration(gateway_arn, host)
    test_hypervisor_configuration(gateway_arn, host, params::Dict{String,<:Any})

Tests your hypervisor configuration to validate that backup gateway can connect with the
hypervisor and its resources.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.
- `host`: The server host of the hypervisor. This can be either an IP address or a
  fully-qualified domain name (FQDN).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Password"`: The password for the hypervisor.
- `"Username"`: The username for the hypervisor.
"""
function test_hypervisor_configuration(
    GatewayArn, Host; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "TestHypervisorConfiguration",
        Dict{String,Any}("GatewayArn" => GatewayArn, "Host" => Host);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_hypervisor_configuration(
    GatewayArn,
    Host,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "TestHypervisorConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("GatewayArn" => GatewayArn, "Host" => Host), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from the resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource from which to remove tags.
- `tag_keys`: The list of tag keys specifying which tags to remove.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_gateway_information(gateway_arn)
    update_gateway_information(gateway_arn, params::Dict{String,<:Any})

Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name
(ARN) of the gateway in your request.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GatewayDisplayName"`: The updated display name of the gateway.
"""
function update_gateway_information(
    GatewayArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "UpdateGatewayInformation",
        Dict{String,Any}("GatewayArn" => GatewayArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_gateway_information(
    GatewayArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "UpdateGatewayInformation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayArn" => GatewayArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_gateway_software_now(gateway_arn)
    update_gateway_software_now(gateway_arn, params::Dict{String,<:Any})

Updates the gateway virtual machine (VM) software. The request immediately triggers the
software update.  When you make this request, you get a 200 OK success response
immediately. However, it might take some time for the update to complete.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway to be updated.

"""
function update_gateway_software_now(
    GatewayArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "UpdateGatewaySoftwareNow",
        Dict{String,Any}("GatewayArn" => GatewayArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_gateway_software_now(
    GatewayArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "UpdateGatewaySoftwareNow",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayArn" => GatewayArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_hypervisor(hypervisor_arn)
    update_hypervisor(hypervisor_arn, params::Dict{String,<:Any})

Updates a hypervisor metadata, including its host, username, and password. Specify which
hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.

# Arguments
- `hypervisor_arn`: The Amazon Resource Name (ARN) of the hypervisor to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Host"`: The updated host of the hypervisor. This can be either an IP address or a
  fully-qualified domain name (FQDN).
- `"LogGroupArn"`: The Amazon Resource Name (ARN) of the group of gateways within the
  requested log.
- `"Name"`: The updated name for the hypervisor
- `"Password"`: The updated password for the hypervisor.
- `"Username"`: The updated username for the hypervisor.
"""
function update_hypervisor(
    HypervisorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return backup_gateway(
        "UpdateHypervisor",
        Dict{String,Any}("HypervisorArn" => HypervisorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_hypervisor(
    HypervisorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return backup_gateway(
        "UpdateHypervisor",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("HypervisorArn" => HypervisorArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
