# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: bedrock
using AWS.Compat
using AWS.UUIDs

"""
    create_evaluation_job(evaluation_config, inference_config, job_name, output_data_config, role_arn)
    create_evaluation_job(evaluation_config, inference_config, job_name, output_data_config, role_arn, params::Dict{String,<:Any})

API operation for creating and managing Amazon Bedrock automatic model evaluation jobs and
model evaluation jobs that use human workers. To learn more about the requirements for
creating a model evaluation job see, Model evaluations.

# Arguments
- `evaluation_config`: Specifies whether the model evaluation job is automatic or uses
  human worker.
- `inference_config`: Specify the models you want to use in your model evaluation job.
  Automatic model evaluation jobs support a single model, and model evaluation job that use
  human workers support two models.
- `job_name`: The name of the model evaluation job. Model evaluation job names must unique
  with your AWS account, and your account's AWS region.
- `output_data_config`: An object that defines where the results of model evaluation job
  will be saved in Amazon S3.
- `role_arn`: The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can
  assume to perform tasks on your behalf. The service role must have Amazon Bedrock as the
  service principal, and provide access to any Amazon S3 buckets specified in the
  EvaluationConfig object. To pass this role to Amazon Bedrock, the caller of this API must
  have the iam:PassRole permission. To learn more about the required permissions, see
  Required permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: A unique, case-sensitive identifier to ensure that the API
  request completes no more than one time. If this token matches a previous request, Amazon
  Bedrock ignores the request, but does not return an error. For more information, see
  Ensuring idempotency.
- `"customerEncryptionKeyId"`: Specify your customer managed key ARN that will be used to
  encrypt your model evaluation job.
- `"jobDescription"`: A description of the model evaluation job.
- `"jobTags"`: Tags to attach to the model evaluation job.
"""
function create_evaluation_job(
    evaluationConfig,
    inferenceConfig,
    jobName,
    outputDataConfig,
    roleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/evaluation-jobs",
        Dict{String,Any}(
            "evaluationConfig" => evaluationConfig,
            "inferenceConfig" => inferenceConfig,
            "jobName" => jobName,
            "outputDataConfig" => outputDataConfig,
            "roleArn" => roleArn,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_evaluation_job(
    evaluationConfig,
    inferenceConfig,
    jobName,
    outputDataConfig,
    roleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/evaluation-jobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "evaluationConfig" => evaluationConfig,
                    "inferenceConfig" => inferenceConfig,
                    "jobName" => jobName,
                    "outputDataConfig" => outputDataConfig,
                    "roleArn" => roleArn,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_guardrail(blocked_input_messaging, blocked_outputs_messaging, name)
    create_guardrail(blocked_input_messaging, blocked_outputs_messaging, name, params::Dict{String,<:Any})

Creates a guardrail to block topics and to filter out harmful content.   Specify a name and
optional description.   Specify messages for when the guardrail successfully blocks a
prompt or a model response in the blockedInputMessaging and blockedOutputsMessaging fields.
  Specify topics for the guardrail to deny in the topicPolicyConfig object. Each
GuardrailTopicConfig object in the topicsConfig list pertains to one topic.   Give a name
and description so that the guardrail can properly identify the topic.   Specify DENY in
the type field.   (Optional) Provide up to five prompts that you would categorize as
belonging to the topic in the examples list.     Specify filter strengths for the harmful
categories defined in Amazon Bedrock in the contentPolicyConfig object. Each
GuardrailContentFilterConfig object in the filtersConfig list pertains to a harmful
category. For more information, see Content filters. For more information about the fields
in a content filter, see GuardrailContentFilterConfig.   Specify the category in the type
field.   Specify the strength of the filter for prompts in the inputStrength field and for
model responses in the strength field of the GuardrailContentFilterConfig.     (Optional)
For security, include the ARN of a KMS key in the kmsKeyId field.   (Optional) Attach any
tags to the guardrail in the tags object. For more information, see Tag resources.

# Arguments
- `blocked_input_messaging`: The message to return when the guardrail blocks a prompt.
- `blocked_outputs_messaging`: The message to return when the guardrail blocks a model
  response.
- `name`: The name to give the guardrail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: A unique, case-sensitive identifier to ensure that the API
  request completes no more than once. If this token matches a previous request, Amazon
  Bedrock ignores the request, but does not return an error. For more information, see
  Ensuring idempotency in the Amazon S3 User Guide.
- `"contentPolicyConfig"`: The content filter policies to configure for the guardrail.
- `"description"`: A description of the guardrail.
- `"kmsKeyId"`: The ARN of the KMS key that you use to encrypt the guardrail.
- `"sensitiveInformationPolicyConfig"`: The sensitive information policy to configure for
  the guardrail.
- `"tags"`: The tags that you want to attach to the guardrail.
- `"topicPolicyConfig"`: The topic policies to configure for the guardrail.
- `"wordPolicyConfig"`: The word policy you configure for the guardrail.
"""
function create_guardrail(
    blockedInputMessaging,
    blockedOutputsMessaging,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/guardrails",
        Dict{String,Any}(
            "blockedInputMessaging" => blockedInputMessaging,
            "blockedOutputsMessaging" => blockedOutputsMessaging,
            "name" => name,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_guardrail(
    blockedInputMessaging,
    blockedOutputsMessaging,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/guardrails",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "blockedInputMessaging" => blockedInputMessaging,
                    "blockedOutputsMessaging" => blockedOutputsMessaging,
                    "name" => name,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_guardrail_version(guardrail_identifier)
    create_guardrail_version(guardrail_identifier, params::Dict{String,<:Any})

Creates a version of the guardrail. Use this API to create a snapshot of the guardrail when
you are satisfied with a configuration, or to compare the configuration with another
version.

# Arguments
- `guardrail_identifier`: The unique identifier of the guardrail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: A unique, case-sensitive identifier to ensure that the API
  request completes no more than once. If this token matches a previous request, Amazon
  Bedrock ignores the request, but does not return an error. For more information, see
  Ensuring idempotency in the Amazon S3 User Guide.
- `"description"`: A description of the guardrail version.
"""
function create_guardrail_version(
    guardrailIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "POST",
        "/guardrails/$(guardrailIdentifier)",
        Dict{String,Any}("clientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_guardrail_version(
    guardrailIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/guardrails/$(guardrailIdentifier)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("clientRequestToken" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_model_customization_job(base_model_identifier, custom_model_name, hyper_parameters, job_name, output_data_config, role_arn, training_data_config)
    create_model_customization_job(base_model_identifier, custom_model_name, hyper_parameters, job_name, output_data_config, role_arn, training_data_config, params::Dict{String,<:Any})

Creates a fine-tuning job to customize a base model. You specify the base foundation model
and the location of the training data. After the model-customization job completes
successfully, your custom model resource will be ready to use. Amazon Bedrock returns
validation loss metrics and output generations after the job completes.  For information on
the format of training and validation data, see Prepare the datasets.  Model-customization
jobs are asynchronous and the completion time depends on the base model and the
training/validation data size. To monitor a job, use the GetModelCustomizationJob operation
to retrieve the job status. For more information, see Custom models in the Amazon Bedrock
User Guide.

# Arguments
- `base_model_identifier`: Name of the base model.
- `custom_model_name`: A name for the resulting custom model.
- `hyper_parameters`: Parameters related to tuning the model. For details on the format for
  different models, see Custom model hyperparameters.
- `job_name`: A name for the fine-tuning job.
- `output_data_config`: S3 location for the output data.
- `role_arn`: The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can
  assume to perform tasks on your behalf. For example, during model training, Amazon Bedrock
  needs your permission to read input data from an S3 bucket, write model artifacts to an S3
  bucket. To pass this role to Amazon Bedrock, the caller of this API must have the
  iam:PassRole permission.
- `training_data_config`: Information about the training dataset.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: A unique, case-sensitive identifier to ensure that the API
  request completes no more than one time. If this token matches a previous request, Amazon
  Bedrock ignores the request, but does not return an error. For more information, see
  Ensuring idempotency.
- `"customModelKmsKeyId"`: The custom model is encrypted at rest using this key.
- `"customModelTags"`: Tags to attach to the resulting custom model.
- `"customizationType"`: The customization type.
- `"jobTags"`: Tags to attach to the job.
- `"validationDataConfig"`: Information about the validation dataset.
- `"vpcConfig"`: VPC configuration (optional). Configuration parameters for the private
  Virtual Private Cloud (VPC) that contains the resources you are using for this job.
"""
function create_model_customization_job(
    baseModelIdentifier,
    customModelName,
    hyperParameters,
    jobName,
    outputDataConfig,
    roleArn,
    trainingDataConfig;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/model-customization-jobs",
        Dict{String,Any}(
            "baseModelIdentifier" => baseModelIdentifier,
            "customModelName" => customModelName,
            "hyperParameters" => hyperParameters,
            "jobName" => jobName,
            "outputDataConfig" => outputDataConfig,
            "roleArn" => roleArn,
            "trainingDataConfig" => trainingDataConfig,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_model_customization_job(
    baseModelIdentifier,
    customModelName,
    hyperParameters,
    jobName,
    outputDataConfig,
    roleArn,
    trainingDataConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/model-customization-jobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "baseModelIdentifier" => baseModelIdentifier,
                    "customModelName" => customModelName,
                    "hyperParameters" => hyperParameters,
                    "jobName" => jobName,
                    "outputDataConfig" => outputDataConfig,
                    "roleArn" => roleArn,
                    "trainingDataConfig" => trainingDataConfig,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_provisioned_model_throughput(model_id, model_units, provisioned_model_name)
    create_provisioned_model_throughput(model_id, model_units, provisioned_model_name, params::Dict{String,<:Any})

Creates dedicated throughput for a base or custom model with the model units and for the
duration that you specify. For pricing details, see Amazon Bedrock Pricing. For more
information, see Provisioned Throughput in the Amazon Bedrock User Guide.

# Arguments
- `model_id`: The Amazon Resource Name (ARN) or name of the model to associate with this
  Provisioned Throughput. For a list of models for which you can purchase Provisioned
  Throughput, see Amazon Bedrock model IDs for purchasing Provisioned Throughput in the
  Amazon Bedrock User Guide.
- `model_units`: Number of model units to allocate. A model unit delivers a specific
  throughput level for the specified model. The throughput level of a model unit specifies
  the total number of input and output tokens that it can process and generate within a span
  of one minute. By default, your account has no model units for purchasing Provisioned
  Throughputs with commitment. You must first visit the Amazon Web Services support center to
  request MUs. For model unit quotas, see Provisioned Throughput quotas in the Amazon Bedrock
  User Guide. For more information about what an MU specifies, contact your Amazon Web
  Services account manager.
- `provisioned_model_name`: The name for this Provisioned Throughput.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: A unique, case-sensitive identifier to ensure that the API
  request completes no more than one time. If this token matches a previous request, Amazon
  Bedrock ignores the request, but does not return an error. For more information, see
  Ensuring idempotency in the Amazon S3 User Guide.
- `"commitmentDuration"`: The commitment duration requested for the Provisioned Throughput.
  Billing occurs hourly and is discounted for longer commitment terms. To request a no-commit
  Provisioned Throughput, omit this field. Custom models support all levels of commitment. To
  see which base models support no commitment, see Supported regions and models for
  Provisioned Throughput in the Amazon Bedrock User Guide
- `"tags"`: Tags to associate with this Provisioned Throughput.
"""
function create_provisioned_model_throughput(
    modelId,
    modelUnits,
    provisionedModelName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/provisioned-model-throughput",
        Dict{String,Any}(
            "modelId" => modelId,
            "modelUnits" => modelUnits,
            "provisionedModelName" => provisionedModelName,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_provisioned_model_throughput(
    modelId,
    modelUnits,
    provisionedModelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/provisioned-model-throughput",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "modelId" => modelId,
                    "modelUnits" => modelUnits,
                    "provisionedModelName" => provisionedModelName,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_model(model_identifier)
    delete_custom_model(model_identifier, params::Dict{String,<:Any})

Deletes a custom model that you created earlier. For more information, see Custom models in
the Amazon Bedrock User Guide.

# Arguments
- `model_identifier`: Name of the model to delete.

"""
function delete_custom_model(
    modelIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "DELETE",
        "/custom-models/$(modelIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_model(
    modelIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "DELETE",
        "/custom-models/$(modelIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_guardrail(guardrail_identifier)
    delete_guardrail(guardrail_identifier, params::Dict{String,<:Any})

Deletes a guardrail.   To delete a guardrail, only specify the ARN of the guardrail in the
guardrailIdentifier field. If you delete a guardrail, all of its versions will be deleted.
 To delete a version of a guardrail, specify the ARN of the guardrail in the
guardrailIdentifier field and the version in the guardrailVersion field.

# Arguments
- `guardrail_identifier`: The unique identifier of the guardrail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"guardrailVersion"`: The version of the guardrail.
"""
function delete_guardrail(
    guardrailIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "DELETE",
        "/guardrails/$(guardrailIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_guardrail(
    guardrailIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "DELETE",
        "/guardrails/$(guardrailIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_model_invocation_logging_configuration()
    delete_model_invocation_logging_configuration(params::Dict{String,<:Any})

Delete the invocation logging.

"""
function delete_model_invocation_logging_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "DELETE",
        "/logging/modelinvocations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_model_invocation_logging_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "DELETE",
        "/logging/modelinvocations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_provisioned_model_throughput(provisioned_model_id)
    delete_provisioned_model_throughput(provisioned_model_id, params::Dict{String,<:Any})

Deletes a Provisioned Throughput. You can't delete a Provisioned Throughput before the
commitment term is over. For more information, see Provisioned Throughput in the Amazon
Bedrock User Guide.

# Arguments
- `provisioned_model_id`: The Amazon Resource Name (ARN) or name of the Provisioned
  Throughput.

"""
function delete_provisioned_model_throughput(
    provisionedModelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "DELETE",
        "/provisioned-model-throughput/$(provisionedModelId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_provisioned_model_throughput(
    provisionedModelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "DELETE",
        "/provisioned-model-throughput/$(provisionedModelId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_custom_model(model_identifier)
    get_custom_model(model_identifier, params::Dict{String,<:Any})

Get the properties associated with a Amazon Bedrock custom model that you have created.For
more information, see Custom models in the Amazon Bedrock User Guide.

# Arguments
- `model_identifier`: Name or Amazon Resource Name (ARN) of the custom model.

"""
function get_custom_model(
    modelIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/custom-models/$(modelIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_custom_model(
    modelIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "GET",
        "/custom-models/$(modelIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_evaluation_job(job_identifier)
    get_evaluation_job(job_identifier, params::Dict{String,<:Any})

Retrieves the properties associated with a model evaluation job, including the status of
the job. For more information, see Model evaluations.

# Arguments
- `job_identifier`: The Amazon Resource Name (ARN) of the model evaluation job.

"""
function get_evaluation_job(
    jobIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/evaluation-jobs/$(jobIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_evaluation_job(
    jobIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "GET",
        "/evaluation-jobs/$(jobIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_foundation_model(model_identifier)
    get_foundation_model(model_identifier, params::Dict{String,<:Any})

Get details about a Amazon Bedrock foundation model.

# Arguments
- `model_identifier`: The model identifier.

"""
function get_foundation_model(
    modelIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/foundation-models/$(modelIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_foundation_model(
    modelIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "GET",
        "/foundation-models/$(modelIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_guardrail(guardrail_identifier)
    get_guardrail(guardrail_identifier, params::Dict{String,<:Any})

Gets details about a guardrail. If you don't specify a version, the response returns
details for the DRAFT version.

# Arguments
- `guardrail_identifier`: The unique identifier of the guardrail for which to get details.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"guardrailVersion"`: The version of the guardrail for which to get details. If you don't
  specify a version, the response returns details for the DRAFT version.
"""
function get_guardrail(
    guardrailIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/guardrails/$(guardrailIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_guardrail(
    guardrailIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "GET",
        "/guardrails/$(guardrailIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_model_customization_job(job_identifier)
    get_model_customization_job(job_identifier, params::Dict{String,<:Any})

Retrieves the properties associated with a model-customization job, including the status of
the job. For more information, see Custom models in the Amazon Bedrock User Guide.

# Arguments
- `job_identifier`: Identifier for the customization job.

"""
function get_model_customization_job(
    jobIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/model-customization-jobs/$(jobIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_model_customization_job(
    jobIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "GET",
        "/model-customization-jobs/$(jobIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_model_invocation_logging_configuration()
    get_model_invocation_logging_configuration(params::Dict{String,<:Any})

Get the current configuration values for model invocation logging.

"""
function get_model_invocation_logging_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/logging/modelinvocations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_model_invocation_logging_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/logging/modelinvocations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_provisioned_model_throughput(provisioned_model_id)
    get_provisioned_model_throughput(provisioned_model_id, params::Dict{String,<:Any})

Returns details for a Provisioned Throughput. For more information, see Provisioned
Throughput in the Amazon Bedrock User Guide.

# Arguments
- `provisioned_model_id`: The Amazon Resource Name (ARN) or name of the Provisioned
  Throughput.

"""
function get_provisioned_model_throughput(
    provisionedModelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/provisioned-model-throughput/$(provisionedModelId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_provisioned_model_throughput(
    provisionedModelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "GET",
        "/provisioned-model-throughput/$(provisionedModelId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_custom_models()
    list_custom_models(params::Dict{String,<:Any})

Returns a list of the custom models that you have created with the
CreateModelCustomizationJob operation. For more information, see Custom models in the
Amazon Bedrock User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"baseModelArnEquals"`: Return custom models only if the base model Amazon Resource Name
  (ARN) matches this parameter.
- `"creationTimeAfter"`: Return custom models created after the specified time.
- `"creationTimeBefore"`: Return custom models created before the specified time.
- `"foundationModelArnEquals"`: Return custom models only if the foundation model Amazon
  Resource Name (ARN) matches this parameter.
- `"maxResults"`: Maximum number of results to return in the response.
- `"nameContains"`: Return custom models only if the job name contains these characters.
- `"nextToken"`: Continuation token from the previous response, for Amazon Bedrock to list
  the next set of results.
- `"sortBy"`: The field to sort by in the returned list of models.
- `"sortOrder"`: The sort order of the results.
"""
function list_custom_models(; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock(
        "GET", "/custom-models"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_custom_models(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/custom-models",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_evaluation_jobs()
    list_evaluation_jobs(params::Dict{String,<:Any})

Lists model evaluation jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"creationTimeAfter"`: A filter that includes model evaluation jobs created after the
  time specified.
- `"creationTimeBefore"`: A filter that includes model evaluation jobs created prior to the
  time specified.
- `"maxResults"`: The maximum number of results to return.
- `"nameContains"`: Query parameter string for model evaluation job names.
- `"nextToken"`: Continuation token from the previous response, for Amazon Bedrock to list
  the next set of results.
- `"sortBy"`: Allows you to sort model evaluation jobs by when they were created.
- `"sortOrder"`: How you want the order of jobs sorted.
- `"statusEquals"`: Only return jobs where the status condition is met.
"""
function list_evaluation_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock(
        "GET", "/evaluation-jobs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_evaluation_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/evaluation-jobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_foundation_models()
    list_foundation_models(params::Dict{String,<:Any})

Lists Amazon Bedrock foundation models that you can use. You can filter the results with
the request parameters. For more information, see Foundation models in the Amazon Bedrock
User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"byCustomizationType"`: Return models that support the customization type that you
  specify. For more information, see Custom models in the Amazon Bedrock User Guide.
- `"byInferenceType"`: Return models that support the inference type that you specify. For
  more information, see Provisioned Throughput in the Amazon Bedrock User Guide.
- `"byOutputModality"`: Return models that support the output modality that you specify.
- `"byProvider"`: Return models belonging to the model provider that you specify.
"""
function list_foundation_models(; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock(
        "GET", "/foundation-models"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_foundation_models(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/foundation-models",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_guardrails()
    list_guardrails(params::Dict{String,<:Any})

Lists details about all the guardrails in an account. To list the DRAFT version of all your
guardrails, don't specify the guardrailIdentifier field. To list all versions of a
guardrail, specify the ARN of the guardrail in the guardrailIdentifier field. You can set
the maximum number of results to return in a response in the maxResults field. If there are
more results than the number you set, the response returns a nextToken that you can send in
another ListGuardrails request to see the next batch of results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"guardrailIdentifier"`: The unique identifier of the guardrail.
- `"maxResults"`: The maximum number of results to return in the response.
- `"nextToken"`: If there are more results than were returned in the response, the response
  returns a nextToken that you can send in another ListGuardrails request to see the next
  batch of results.
"""
function list_guardrails(; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock(
        "GET", "/guardrails"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_guardrails(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET", "/guardrails", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_model_customization_jobs()
    list_model_customization_jobs(params::Dict{String,<:Any})

Returns a list of model customization jobs that you have submitted. You can filter the jobs
to return based on one or more criteria. For more information, see Custom models in the
Amazon Bedrock User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"creationTimeAfter"`: Return customization jobs created after the specified time.
- `"creationTimeBefore"`: Return customization jobs created before the specified time.
- `"maxResults"`: Maximum number of results to return in the response.
- `"nameContains"`: Return customization jobs only if the job name contains these
  characters.
- `"nextToken"`: Continuation token from the previous response, for Amazon Bedrock to list
  the next set of results.
- `"sortBy"`: The field to sort by in the returned list of jobs.
- `"sortOrder"`: The sort order of the results.
- `"statusEquals"`: Return customization jobs with the specified status.
"""
function list_model_customization_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock(
        "GET",
        "/model-customization-jobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_model_customization_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/model-customization-jobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_provisioned_model_throughputs()
    list_provisioned_model_throughputs(params::Dict{String,<:Any})

Lists the Provisioned Throughputs in the account. For more information, see Provisioned
Throughput in the Amazon Bedrock User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"creationTimeAfter"`: A filter that returns Provisioned Throughputs created after the
  specified time.
- `"creationTimeBefore"`: A filter that returns Provisioned Throughputs created before the
  specified time.
- `"maxResults"`: THe maximum number of results to return in the response. If there are
  more results than the number you specified, the response returns a nextToken value. To see
  the next batch of results, send the nextToken value in another list request.
- `"modelArnEquals"`: A filter that returns Provisioned Throughputs whose model Amazon
  Resource Name (ARN) is equal to the value that you specify.
- `"nameContains"`: A filter that returns Provisioned Throughputs if their name contains
  the expression that you specify.
- `"nextToken"`: If there are more results than the number you specified in the maxResults
  field, the response returns a nextToken value. To see the next batch of results, specify
  the nextToken value in this field.
- `"sortBy"`: The field by which to sort the returned list of Provisioned Throughputs.
- `"sortOrder"`: The sort order of the results.
- `"statusEquals"`: A filter that returns Provisioned Throughputs if their statuses matches
  the value that you specify.
"""
function list_provisioned_model_throughputs(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/provisioned-model-throughputs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_provisioned_model_throughputs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "GET",
        "/provisioned-model-throughputs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List the tags associated with the specified resource. For more information, see Tagging
resources in the Amazon Bedrock User Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function list_tags_for_resource(
    resourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "POST",
        "/listTagsForResource",
        Dict{String,Any}("resourceARN" => resourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/listTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceARN" => resourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_model_invocation_logging_configuration(logging_config)
    put_model_invocation_logging_configuration(logging_config, params::Dict{String,<:Any})

Set the configuration values for model invocation logging.

# Arguments
- `logging_config`: The logging configuration values to set.

"""
function put_model_invocation_logging_configuration(
    loggingConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "PUT",
        "/logging/modelinvocations",
        Dict{String,Any}("loggingConfig" => loggingConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_model_invocation_logging_configuration(
    loggingConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "PUT",
        "/logging/modelinvocations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("loggingConfig" => loggingConfig), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_evaluation_job(job_identifier)
    stop_evaluation_job(job_identifier, params::Dict{String,<:Any})

Stops an in progress model evaluation job.

# Arguments
- `job_identifier`: The ARN of the model evaluation job you want to stop.

"""
function stop_evaluation_job(
    jobIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "POST",
        "/evaluation-job/$(jobIdentifier)/stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_evaluation_job(
    jobIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/evaluation-job/$(jobIdentifier)/stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_model_customization_job(job_identifier)
    stop_model_customization_job(job_identifier, params::Dict{String,<:Any})

Stops an active model customization job. For more information, see Custom models in the
Amazon Bedrock User Guide.

# Arguments
- `job_identifier`: Job identifier of the job to stop.

"""
function stop_model_customization_job(
    jobIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "POST",
        "/model-customization-jobs/$(jobIdentifier)/stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_model_customization_job(
    jobIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/model-customization-jobs/$(jobIdentifier)/stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Associate tags with a resource. For more information, see Tagging resources in the Amazon
Bedrock User Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to tag.
- `tags`: Tags to associate with the resource.

"""
function tag_resource(resourceARN, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock(
        "POST",
        "/tagResource",
        Dict{String,Any}("resourceARN" => resourceARN, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceARN,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/tagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceARN" => resourceARN, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Remove one or more tags from a resource. For more information, see Tagging resources in the
Amazon Bedrock User Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to untag.
- `tag_keys`: Tag keys of the tags to remove from the resource.

"""
function untag_resource(
    resourceARN, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "POST",
        "/untagResource",
        Dict{String,Any}("resourceARN" => resourceARN, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceARN,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "POST",
        "/untagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceARN" => resourceARN, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_guardrail(blocked_input_messaging, blocked_outputs_messaging, guardrail_identifier, name)
    update_guardrail(blocked_input_messaging, blocked_outputs_messaging, guardrail_identifier, name, params::Dict{String,<:Any})

Updates a guardrail with the values you specify.   Specify a name and optional description.
  Specify messages for when the guardrail successfully blocks a prompt or a model response
in the blockedInputMessaging and blockedOutputsMessaging fields.   Specify topics for the
guardrail to deny in the topicPolicyConfig object. Each GuardrailTopicConfig object in the
topicsConfig list pertains to one topic.   Give a name and description so that the
guardrail can properly identify the topic.   Specify DENY in the type field.   (Optional)
Provide up to five prompts that you would categorize as belonging to the topic in the
examples list.     Specify filter strengths for the harmful categories defined in Amazon
Bedrock in the contentPolicyConfig object. Each GuardrailContentFilterConfig object in the
filtersConfig list pertains to a harmful category. For more information, see Content
filters. For more information about the fields in a content filter, see
GuardrailContentFilterConfig.   Specify the category in the type field.   Specify the
strength of the filter for prompts in the inputStrength field and for model responses in
the strength field of the GuardrailContentFilterConfig.     (Optional) For security,
include the ARN of a KMS key in the kmsKeyId field.   (Optional) Attach any tags to the
guardrail in the tags object. For more information, see Tag resources.

# Arguments
- `blocked_input_messaging`: The message to return when the guardrail blocks a prompt.
- `blocked_outputs_messaging`: The message to return when the guardrail blocks a model
  response.
- `guardrail_identifier`: The unique identifier of the guardrail
- `name`: A name for the guardrail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"contentPolicyConfig"`: The content policy to configure for the guardrail.
- `"description"`: A description of the guardrail.
- `"kmsKeyId"`: The ARN of the KMS key with which to encrypt the guardrail.
- `"sensitiveInformationPolicyConfig"`: The sensitive information policy to configure for
  the guardrail.
- `"topicPolicyConfig"`: The topic policy to configure for the guardrail.
- `"wordPolicyConfig"`: The word policy to configure for the guardrail.
"""
function update_guardrail(
    blockedInputMessaging,
    blockedOutputsMessaging,
    guardrailIdentifier,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "PUT",
        "/guardrails/$(guardrailIdentifier)",
        Dict{String,Any}(
            "blockedInputMessaging" => blockedInputMessaging,
            "blockedOutputsMessaging" => blockedOutputsMessaging,
            "name" => name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_guardrail(
    blockedInputMessaging,
    blockedOutputsMessaging,
    guardrailIdentifier,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "PUT",
        "/guardrails/$(guardrailIdentifier)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "blockedInputMessaging" => blockedInputMessaging,
                    "blockedOutputsMessaging" => blockedOutputsMessaging,
                    "name" => name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_provisioned_model_throughput(provisioned_model_id)
    update_provisioned_model_throughput(provisioned_model_id, params::Dict{String,<:Any})

Updates the name or associated model for a Provisioned Throughput. For more information,
see Provisioned Throughput in the Amazon Bedrock User Guide.

# Arguments
- `provisioned_model_id`: The Amazon Resource Name (ARN) or name of the Provisioned
  Throughput to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"desiredModelId"`: The Amazon Resource Name (ARN) of the new model to associate with
  this Provisioned Throughput. You can't specify this field if this Provisioned Throughput is
  associated with a base model. If this Provisioned Throughput is associated with a custom
  model, you can specify one of the following options:   The base model from which the custom
  model was customized.   Another custom model that was customized from the same base model
  as the custom model.
- `"desiredProvisionedModelName"`: The new name for this Provisioned Throughput.
"""
function update_provisioned_model_throughput(
    provisionedModelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock(
        "PATCH",
        "/provisioned-model-throughput/$(provisionedModelId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_provisioned_model_throughput(
    provisionedModelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock(
        "PATCH",
        "/provisioned-model-throughput/$(provisionedModelId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
