# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: cloudhsm
using AWS.Compat
using AWS.UUIDs

"""
    add_tags_to_resource(resource_arn, tag_list)
    add_tags_to_resource(resource_arn, tag_list, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Adds or overwrites one or
more tags for the specified AWS CloudHSM resource. Each tag consists of a key and a value.
Tag keys must be unique to each resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.
- `tag_list`: One or more tags.

"""
function add_tags_to_resource(
    ResourceArn, TagList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "AddTagsToResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagList" => TagList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_tags_to_resource(
    ResourceArn,
    TagList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "AddTagsToResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagList" => TagList),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_hapg(label)
    create_hapg(label, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Creates a
high-availability partition group. A high-availability partition group is a group of
partitions that spans multiple physical HSMs.

# Arguments
- `label`: The label of the new high-availability partition group.

"""
function create_hapg(Label; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "CreateHapg",
        Dict{String,Any}("Label" => Label);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_hapg(
    Label, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "CreateHapg",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Label" => Label), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_hsm(iam_role_arn, ssh_key, subnet_id, subscription_type)
    create_hsm(iam_role_arn, ssh_key, subnet_id, subscription_type, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Creates an uninitialized
HSM instance. There is an upfront fee charged for each HSM instance that you create with
the CreateHsm operation. If you accidentally provision an HSM and want to request a refund,
delete the instance using the DeleteHsm operation, go to the AWS Support Center, create a
new case, and select Account and Billing Support.  It can take up to 20 minutes to create
and provision an HSM. You can monitor the status of the HSM with the DescribeHsm operation.
The HSM is ready to be initialized when the status changes to RUNNING.

# Arguments
- `iam_role_arn`: The ARN of an IAM role to enable the AWS CloudHSM service to allocate an
  ENI on your behalf.
- `ssh_key`: The SSH public key to install on the HSM.
- `subnet_id`: The identifier of the subnet in your VPC in which to place the HSM.
- `subscription_type`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A user-defined token to ensure idempotence. Subsequent calls to this
  operation with the same token will be ignored.
- `"EniIp"`: The IP address to assign to the HSM's ENI. If an IP address is not specified,
  an IP address will be randomly chosen from the CIDR range of the subnet.
- `"ExternalId"`: The external ID from IamRoleArn, if present.
- `"SyslogIp"`: The IP address for the syslog monitoring server. The AWS CloudHSM service
  only supports one syslog monitoring server.
"""
function create_hsm(
    IamRoleArn,
    SshKey,
    SubnetId,
    SubscriptionType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "CreateHsm",
        Dict{String,Any}(
            "IamRoleArn" => IamRoleArn,
            "SshKey" => SshKey,
            "SubnetId" => SubnetId,
            "SubscriptionType" => SubscriptionType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_hsm(
    IamRoleArn,
    SshKey,
    SubnetId,
    SubscriptionType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "CreateHsm",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IamRoleArn" => IamRoleArn,
                    "SshKey" => SshKey,
                    "SubnetId" => SubnetId,
                    "SubscriptionType" => SubscriptionType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_luna_client(certificate)
    create_luna_client(certificate, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Creates an HSM client.

# Arguments
- `certificate`: The contents of a Base64-Encoded X.509 v3 certificate to be installed on
  the HSMs used by this client.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Label"`: The label for the client.
"""
function create_luna_client(Certificate; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "CreateLunaClient",
        Dict{String,Any}("Certificate" => Certificate);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_luna_client(
    Certificate,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "CreateLunaClient",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Certificate" => Certificate), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_hapg(hapg_arn)
    delete_hapg(hapg_arn, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Deletes a
high-availability partition group.

# Arguments
- `hapg_arn`: The ARN of the high-availability partition group to delete.

"""
function delete_hapg(HapgArn; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "DeleteHapg",
        Dict{String,Any}("HapgArn" => HapgArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_hapg(
    HapgArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "DeleteHapg",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("HapgArn" => HapgArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_hsm(hsm_arn)
    delete_hsm(hsm_arn, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Deletes an HSM. After
completion, this operation cannot be undone and your key material cannot be recovered.

# Arguments
- `hsm_arn`: The ARN of the HSM to delete.

"""
function delete_hsm(HsmArn; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "DeleteHsm",
        Dict{String,Any}("HsmArn" => HsmArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_hsm(
    HsmArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "DeleteHsm",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("HsmArn" => HsmArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_luna_client(client_arn)
    delete_luna_client(client_arn, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Deletes a client.

# Arguments
- `client_arn`: The ARN of the client to delete.

"""
function delete_luna_client(ClientArn; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "DeleteLunaClient",
        Dict{String,Any}("ClientArn" => ClientArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_luna_client(
    ClientArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "DeleteLunaClient",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientArn" => ClientArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_hapg(hapg_arn)
    describe_hapg(hapg_arn, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Retrieves information
about a high-availability partition group.

# Arguments
- `hapg_arn`: The ARN of the high-availability partition group to describe.

"""
function describe_hapg(HapgArn; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "DescribeHapg",
        Dict{String,Any}("HapgArn" => HapgArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_hapg(
    HapgArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "DescribeHapg",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("HapgArn" => HapgArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_hsm()
    describe_hsm(params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Retrieves information
about an HSM. You can identify the HSM by its ARN or its serial number.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HsmArn"`: The ARN of the HSM. Either the HsmArn or the SerialNumber parameter must be
  specified.
- `"HsmSerialNumber"`: The serial number of the HSM. Either the HsmArn or the
  HsmSerialNumber parameter must be specified.
"""
function describe_hsm(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm("DescribeHsm"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_hsm(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "DescribeHsm", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_luna_client()
    describe_luna_client(params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Retrieves information
about an HSM client.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateFingerprint"`: The certificate fingerprint.
- `"ClientArn"`: The ARN of the client.
"""
function describe_luna_client(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "DescribeLunaClient"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_luna_client(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "DescribeLunaClient", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_config(client_arn, client_version, hapg_list)
    get_config(client_arn, client_version, hapg_list, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Gets the configuration
files necessary to connect to all high availability partition groups the client is
associated with.

# Arguments
- `client_arn`: The ARN of the client.
- `client_version`: The client version.
- `hapg_list`: A list of ARNs that identify the high-availability partition groups that are
  associated with the client.

"""
function get_config(
    ClientArn, ClientVersion, HapgList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "GetConfig",
        Dict{String,Any}(
            "ClientArn" => ClientArn,
            "ClientVersion" => ClientVersion,
            "HapgList" => HapgList,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_config(
    ClientArn,
    ClientVersion,
    HapgList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "GetConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientArn" => ClientArn,
                    "ClientVersion" => ClientVersion,
                    "HapgList" => HapgList,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_available_zones()
    list_available_zones(params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Lists the Availability
Zones that have available AWS CloudHSM capacity.

"""
function list_available_zones(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "ListAvailableZones"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_available_zones(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "ListAvailableZones", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_hapgs()
    list_hapgs(params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Lists the
high-availability partition groups for the account. This operation supports pagination with
the use of the NextToken member. If more results are available, the NextToken member of the
response contains a token that you pass in the next call to ListHapgs to retrieve the next
set of items.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: The NextToken value from a previous call to ListHapgs. Pass null if this
  is the first call.
"""
function list_hapgs(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm("ListHapgs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_hapgs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "ListHapgs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_hsms()
    list_hsms(params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Retrieves the identifiers
of all of the HSMs provisioned for the current customer. This operation supports pagination
with the use of the NextToken member. If more results are available, the NextToken member
of the response contains a token that you pass in the next call to ListHsms to retrieve the
next set of items.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: The NextToken value from a previous call to ListHsms. Pass null if this is
  the first call.
"""
function list_hsms(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm("ListHsms"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_hsms(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "ListHsms", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_luna_clients()
    list_luna_clients(params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Lists all of the clients.
This operation supports pagination with the use of the NextToken member. If more results
are available, the NextToken member of the response contains a token that you pass in the
next call to ListLunaClients to retrieve the next set of items.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: The NextToken value from a previous call to ListLunaClients. Pass null if
  this is the first call.
"""
function list_luna_clients(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "ListLunaClients"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_luna_clients(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "ListLunaClients", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Returns a list of all tags
for the specified AWS CloudHSM resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the AWS CloudHSM resource.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_hapg(hapg_arn)
    modify_hapg(hapg_arn, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Modifies an existing
high-availability partition group.

# Arguments
- `hapg_arn`: The ARN of the high-availability partition group to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Label"`: The new label for the high-availability partition group.
- `"PartitionSerialList"`: The list of partition serial numbers to make members of the
  high-availability partition group.
"""
function modify_hapg(HapgArn; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "ModifyHapg",
        Dict{String,Any}("HapgArn" => HapgArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_hapg(
    HapgArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "ModifyHapg",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("HapgArn" => HapgArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_hsm(hsm_arn)
    modify_hsm(hsm_arn, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Modifies an HSM.  This
operation can result in the HSM being offline for up to 15 minutes while the AWS CloudHSM
service is reconfigured. If you are modifying a production HSM, you should ensure that your
AWS CloudHSM service is configured for high availability, and consider executing this
operation during a maintenance window.

# Arguments
- `hsm_arn`: The ARN of the HSM to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EniIp"`: The new IP address for the elastic network interface (ENI) attached to the
  HSM. If the HSM is moved to a different subnet, and an IP address is not specified, an IP
  address will be randomly chosen from the CIDR range of the new subnet.
- `"ExternalId"`: The new external ID.
- `"IamRoleArn"`: The new IAM role ARN.
- `"SubnetId"`: The new identifier of the subnet that the HSM is in. The new subnet must be
  in the same Availability Zone as the current subnet.
- `"SyslogIp"`: The new IP address for the syslog monitoring server. The AWS CloudHSM
  service only supports one syslog monitoring server.
"""
function modify_hsm(HsmArn; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudhsm(
        "ModifyHsm",
        Dict{String,Any}("HsmArn" => HsmArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_hsm(
    HsmArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "ModifyHsm",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("HsmArn" => HsmArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_luna_client(certificate, client_arn)
    modify_luna_client(certificate, client_arn, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Modifies the certificate
used by the client. This action can potentially start a workflow to install the new
certificate on the client's HSMs.

# Arguments
- `certificate`: The new certificate for the client.
- `client_arn`: The ARN of the client.

"""
function modify_luna_client(
    Certificate, ClientArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "ModifyLunaClient",
        Dict{String,Any}("Certificate" => Certificate, "ClientArn" => ClientArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_luna_client(
    Certificate,
    ClientArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "ModifyLunaClient",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Certificate" => Certificate, "ClientArn" => ClientArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_tags_from_resource(resource_arn, tag_key_list)
    remove_tags_from_resource(resource_arn, tag_key_list, params::Dict{String,<:Any})

This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM
Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API
Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM,
the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Removes one or more tags
from the specified AWS CloudHSM resource. To remove a tag, specify only the tag key to
remove (not the value). To overwrite the value for an existing tag, use AddTagsToResource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
- `tag_key_list`: The tag key or keys to remove. Specify only the tag key to remove (not
  the value). To overwrite the value for an existing tag, use AddTagsToResource.

"""
function remove_tags_from_resource(
    ResourceArn, TagKeyList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudhsm(
        "RemoveTagsFromResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeyList" => TagKeyList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_tags_from_resource(
    ResourceArn,
    TagKeyList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudhsm(
        "RemoveTagsFromResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeyList" => TagKeyList),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
