# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: elasticache
using AWS.Compat
using AWS.UUIDs

"""
    add_tags_to_resource(resource_name, tag)
    add_tags_to_resource(resource_name, tag, params::Dict{String,<:Any})

A tag is a key-value pair where the key and value are case-sensitive. You can use tags to
categorize and track all your ElastiCache resources, with the exception of global
replication group. When you add or remove tags on replication groups, those actions will be
replicated to all nodes in the replication group. For more information, see Resource-level
permissions.  For example, you can use cost-allocation tags to your ElastiCache resources,
Amazon generates a cost allocation report as a comma-separated value (CSV) file with your
usage and costs aggregated by your tags. You can apply tags that represent business
categories (such as cost centers, application names, or owners) to organize your costs
across multiple services. For more information, see Using Cost Allocation Tags in Amazon
ElastiCache in the ElastiCache User Guide.

# Arguments
- `resource_name`: The Amazon Resource Name (ARN) of the resource to which the tags are to
  be added, for example arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster or
  arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot. ElastiCache resources are
  cluster and snapshot. For more information about ARNs, see Amazon Resource Names (ARNs) and
  Amazon Service Namespaces.
- `tag`: A list of tags to be added to this resource. A tag is a key-value pair. A tag key
  must be accompanied by a tag value, although null is accepted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tags to be added to this resource. A tag is a key-value pair. A tag
  key must be accompanied by a tag value, although null is accepted.
"""
function add_tags_to_resource(
    ResourceName, Tag; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "AddTagsToResource",
        Dict{String,Any}("ResourceName" => ResourceName, "Tag" => Tag);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_tags_to_resource(
    ResourceName,
    Tag,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "AddTagsToResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceName" => ResourceName, "Tag" => Tag),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_cache_security_group_ingress(cache_security_group_name, ec2_security_group_name, ec2_security_group_owner_id)
    authorize_cache_security_group_ingress(cache_security_group_name, ec2_security_group_name, ec2_security_group_owner_id, params::Dict{String,<:Any})

Allows network ingress to a cache security group. Applications using ElastiCache must be
running on Amazon EC2, and Amazon EC2 security groups are used as the authorization
mechanism.  You cannot authorize ingress from an Amazon EC2 security group in one region to
an ElastiCache cluster in another region.

# Arguments
- `cache_security_group_name`: The cache security group that allows network ingress.
- `ec2_security_group_name`: The Amazon EC2 security group to be authorized for ingress to
  the cache security group.
- `ec2_security_group_owner_id`: The Amazon account number of the Amazon EC2 security group
  owner. Note that this is not the same thing as an Amazon access key ID - you must provide a
  valid Amazon account number for this parameter.

"""
function authorize_cache_security_group_ingress(
    CacheSecurityGroupName,
    EC2SecurityGroupName,
    EC2SecurityGroupOwnerId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "AuthorizeCacheSecurityGroupIngress",
        Dict{String,Any}(
            "CacheSecurityGroupName" => CacheSecurityGroupName,
            "EC2SecurityGroupName" => EC2SecurityGroupName,
            "EC2SecurityGroupOwnerId" => EC2SecurityGroupOwnerId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_cache_security_group_ingress(
    CacheSecurityGroupName,
    EC2SecurityGroupName,
    EC2SecurityGroupOwnerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "AuthorizeCacheSecurityGroupIngress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CacheSecurityGroupName" => CacheSecurityGroupName,
                    "EC2SecurityGroupName" => EC2SecurityGroupName,
                    "EC2SecurityGroupOwnerId" => EC2SecurityGroupOwnerId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_apply_update_action(service_update_name)
    batch_apply_update_action(service_update_name, params::Dict{String,<:Any})

Apply the service update. For more information on service updates and applying them, see
Applying Service Updates.

# Arguments
- `service_update_name`: The unique ID of the service update

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheClusterIds"`: The cache cluster IDs
- `"ReplicationGroupIds"`: The replication group IDs
"""
function batch_apply_update_action(
    ServiceUpdateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "BatchApplyUpdateAction",
        Dict{String,Any}("ServiceUpdateName" => ServiceUpdateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_apply_update_action(
    ServiceUpdateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "BatchApplyUpdateAction",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ServiceUpdateName" => ServiceUpdateName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_stop_update_action(service_update_name)
    batch_stop_update_action(service_update_name, params::Dict{String,<:Any})

Stop the service update. For more information on service updates and stopping them, see
Stopping Service Updates.

# Arguments
- `service_update_name`: The unique ID of the service update

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheClusterIds"`: The cache cluster IDs
- `"ReplicationGroupIds"`: The replication group IDs
"""
function batch_stop_update_action(
    ServiceUpdateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "BatchStopUpdateAction",
        Dict{String,Any}("ServiceUpdateName" => ServiceUpdateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_stop_update_action(
    ServiceUpdateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "BatchStopUpdateAction",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ServiceUpdateName" => ServiceUpdateName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    complete_migration(replication_group_id)
    complete_migration(replication_group_id, params::Dict{String,<:Any})

Complete the migration of data.

# Arguments
- `replication_group_id`: The ID of the replication group to which data is being migrated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Force"`: Forces the migration to stop without ensuring that data is in sync. It is
  recommended to use this option only to abort the migration and not recommended when
  application wants to continue migration to ElastiCache.
"""
function complete_migration(
    ReplicationGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "CompleteMigration",
        Dict{String,Any}("ReplicationGroupId" => ReplicationGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function complete_migration(
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CompleteMigration",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ReplicationGroupId" => ReplicationGroupId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_serverless_cache_snapshot(source_serverless_cache_snapshot_name, target_serverless_cache_snapshot_name)
    copy_serverless_cache_snapshot(source_serverless_cache_snapshot_name, target_serverless_cache_snapshot_name, params::Dict{String,<:Any})

Creates a copy of an existing serverless cache’s snapshot. Available for Redis only.

# Arguments
- `source_serverless_cache_snapshot_name`: The identifier of the existing serverless
  cache’s snapshot to be copied. Available for Redis only.
- `target_serverless_cache_snapshot_name`: The identifier for the snapshot to be created.
  Available for Redis only.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KmsKeyId"`: The identifier of the KMS key used to encrypt the target snapshot.
  Available for Redis only.
- `"Tags"`: A list of tags to be added to the target snapshot resource. A tag is a
  key-value pair. Available for Redis only. Default: NULL
"""
function copy_serverless_cache_snapshot(
    SourceServerlessCacheSnapshotName,
    TargetServerlessCacheSnapshotName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CopyServerlessCacheSnapshot",
        Dict{String,Any}(
            "SourceServerlessCacheSnapshotName" => SourceServerlessCacheSnapshotName,
            "TargetServerlessCacheSnapshotName" => TargetServerlessCacheSnapshotName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_serverless_cache_snapshot(
    SourceServerlessCacheSnapshotName,
    TargetServerlessCacheSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CopyServerlessCacheSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceServerlessCacheSnapshotName" =>
                        SourceServerlessCacheSnapshotName,
                    "TargetServerlessCacheSnapshotName" =>
                        TargetServerlessCacheSnapshotName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_snapshot(source_snapshot_name, target_snapshot_name)
    copy_snapshot(source_snapshot_name, target_snapshot_name, params::Dict{String,<:Any})

Makes a copy of an existing snapshot.  This operation is valid for Redis only.   Users or
groups that have permissions to use the CopySnapshot operation can create their own Amazon
S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy
to control who has the ability to use the CopySnapshot operation. For more information
about using IAM to control the use of ElastiCache operations, see Exporting Snapshots and
Authentication &amp; Access Control.  You could receive the following error messages.
Error Messages     Error Message: The S3 bucket %s is outside of the region.  Solution:
Create an Amazon S3 bucket in the same region as your snapshot. For more information, see
Step 1: Create an Amazon S3 Bucket in the ElastiCache User Guide.    Error Message: The S3
bucket %s does not exist.  Solution: Create an Amazon S3 bucket in the same region as your
snapshot. For more information, see Step 1: Create an Amazon S3 Bucket in the ElastiCache
User Guide.    Error Message: The S3 bucket %s is not owned by the authenticated user.
Solution: Create an Amazon S3 bucket in the same region as your snapshot. For more
information, see Step 1: Create an Amazon S3 Bucket in the ElastiCache User Guide.    Error
Message: The authenticated user does not have sufficient permissions to perform the desired
activity.  Solution: Contact your system administrator to get the needed permissions.
Error Message: The S3 bucket %s already contains an object with key %s.  Solution: Give the
TargetSnapshotName a new and unique value. If exporting a snapshot, you could alternatively
create a new Amazon S3 bucket and use this same value for TargetSnapshotName.    Error
Message:  ElastiCache has not been granted READ permissions %s on the S3 Bucket.  Solution:
Add List and Read permissions on the bucket. For more information, see Step 2: Grant
ElastiCache Access to Your Amazon S3 Bucket in the ElastiCache User Guide.    Error
Message:  ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.
Solution: Add Upload/Delete permissions on the bucket. For more information, see Step 2:
Grant ElastiCache Access to Your Amazon S3 Bucket in the ElastiCache User Guide.    Error
Message:  ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.
Solution: Add View Permissions on the bucket. For more information, see Step 2: Grant
ElastiCache Access to Your Amazon S3 Bucket in the ElastiCache User Guide.

# Arguments
- `source_snapshot_name`: The name of an existing snapshot from which to make a copy.
- `target_snapshot_name`: A name for the snapshot copy. ElastiCache does not permit
  overwriting a snapshot, therefore this name must be unique within its context - ElastiCache
  or an Amazon S3 bucket if exporting.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KmsKeyId"`: The ID of the KMS key used to encrypt the target snapshot.
- `"Tags"`: A list of tags to be added to this resource. A tag is a key-value pair. A tag
  key must be accompanied by a tag value, although null is accepted.
- `"TargetBucket"`: The Amazon S3 bucket to which the snapshot is exported. This parameter
  is used only when exporting a snapshot for external access. When using this parameter to
  export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket.
  For more information, see Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket in the
  Amazon ElastiCache User Guide. For more information, see Exporting a Snapshot in the Amazon
  ElastiCache User Guide.
"""
function copy_snapshot(
    SourceSnapshotName,
    TargetSnapshotName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CopySnapshot",
        Dict{String,Any}(
            "SourceSnapshotName" => SourceSnapshotName,
            "TargetSnapshotName" => TargetSnapshotName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_snapshot(
    SourceSnapshotName,
    TargetSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CopySnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceSnapshotName" => SourceSnapshotName,
                    "TargetSnapshotName" => TargetSnapshotName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cache_cluster(cache_cluster_id)
    create_cache_cluster(cache_cluster_id, params::Dict{String,<:Any})

Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine
software, either Memcached or Redis. This operation is not supported for Redis (cluster
mode enabled) clusters.

# Arguments
- `cache_cluster_id`: The node group (shard) identifier. This parameter is stored as a
  lowercase string.  Constraints:    A name must contain from 1 to 50 alphanumeric characters
  or hyphens.   The first character must be a letter.   A name cannot end with a hyphen or
  contain two consecutive hyphens.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AZMode"`: Specifies whether the nodes in this Memcached cluster are created in a single
  Availability Zone or created across multiple Availability Zones in the cluster's region.
  This parameter is only supported for Memcached clusters. If the AZMode and
  PreferredAvailabilityZones are not specified, ElastiCache assumes single-az mode.
- `"AuthToken"`:  Reserved parameter. The password used to access a password protected
  server. Password constraints:   Must be only printable ASCII characters.   Must be at least
  16 characters and no more than 128 characters in length.   The only permitted printable
  special characters are !, &amp;, #, , ^, &lt;, &gt;, and -. Other printable special
  characters cannot be used in the AUTH token.   For more information, see AUTH password at
  http://redis.io/commands/AUTH.
- `"AutoMinorVersionUpgrade"`:  If you are running Redis engine version 6.0 or later, set
  this parameter to yes if you want to opt-in to the next auto minor version upgrade
  campaign. This parameter is disabled for previous versions.
- `"CacheNodeType"`: The compute and memory capacity of the nodes in the node group
  (shard). The following node types are supported by ElastiCache. Generally speaking, the
  current generation types provide more memory and computational power at lower cost when
  compared to their equivalent previous generation counterparts.   General purpose:   Current
  generation:   M7g node types: cache.m7g.large, cache.m7g.xlarge, cache.m7g.2xlarge,
  cache.m7g.4xlarge, cache.m7g.8xlarge, cache.m7g.12xlarge, cache.m7g.16xlarge   For region
  availability, see Supported Node Types    M6g node types (available only for Redis engine
  version 5.0.6 onward and for Memcached engine version 1.5.16 onward): cache.m6g.large,
  cache.m6g.xlarge, cache.m6g.2xlarge, cache.m6g.4xlarge, cache.m6g.8xlarge,
  cache.m6g.12xlarge, cache.m6g.16xlarge   M5 node types: cache.m5.large, cache.m5.xlarge,
  cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge, cache.m5.24xlarge   M4 node types:
  cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge, cache.m4.4xlarge, cache.m4.10xlarge
  T4g node types (available only for Redis engine version 5.0.6 onward and Memcached engine
  version 1.5.16 onward): cache.t4g.micro, cache.t4g.small, cache.t4g.medium   T3 node types:
  cache.t3.micro, cache.t3.small, cache.t3.medium   T2 node types: cache.t2.micro,
  cache.t2.small, cache.t2.medium    Previous generation: (not recommended. Existing clusters
  are still supported but creation of new clusters is not supported for these types.)  T1
  node types: cache.t1.micro   M1 node types: cache.m1.small, cache.m1.medium,
  cache.m1.large, cache.m1.xlarge   M3 node types: cache.m3.medium, cache.m3.large,
  cache.m3.xlarge, cache.m3.2xlarge      Compute optimized:   Previous generation: (not
  recommended. Existing clusters are still supported but creation of new clusters is not
  supported for these types.)  C1 node types: cache.c1.xlarge      Memory optimized:
  Current generation:   R7g node types: cache.r7g.large, cache.r7g.xlarge, cache.r7g.2xlarge,
  cache.r7g.4xlarge, cache.r7g.8xlarge, cache.r7g.12xlarge, cache.r7g.16xlarge   For region
  availability, see Supported Node Types    R6g node types (available only for Redis engine
  version 5.0.6 onward and for Memcached engine version 1.5.16 onward): cache.r6g.large,
  cache.r6g.xlarge, cache.r6g.2xlarge, cache.r6g.4xlarge, cache.r6g.8xlarge,
  cache.r6g.12xlarge, cache.r6g.16xlarge   R5 node types: cache.r5.large, cache.r5.xlarge,
  cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge, cache.r5.24xlarge   R4 node types:
  cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge, cache.r4.4xlarge, cache.r4.8xlarge,
  cache.r4.16xlarge    Previous generation: (not recommended. Existing clusters are still
  supported but creation of new clusters is not supported for these types.)  M2 node types:
  cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge   R3 node types: cache.r3.large,
  cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge, cache.r3.8xlarge       Additional node
  type info    All current generation instance types are created in Amazon VPC by default.
  Redis append-only files (AOF) are not supported for T1 or T2 instances.   Redis Multi-AZ
  with automatic failover is not supported on T1 instances.   Redis configuration variables
  appendonly and appendfsync are not supported on Redis version 2.8.22 and later.
- `"CacheParameterGroupName"`: The name of the parameter group to associate with this
  cluster. If this argument is omitted, the default parameter group for the specified engine
  is used. You cannot use any parameter group which has cluster-enabled='yes' when creating a
  cluster.
- `"CacheSecurityGroupNames"`: A list of security group names to associate with this
  cluster. Use this parameter only when you are creating a cluster outside of an Amazon
  Virtual Private Cloud (Amazon VPC).
- `"CacheSubnetGroupName"`: The name of the subnet group to be used for the cluster. Use
  this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud
  (Amazon VPC).  If you're going to launch your cluster in an Amazon VPC, you need to create
  a subnet group before you start creating a cluster. For more information, see Subnets and
  Subnet Groups.
- `"Engine"`: The name of the cache engine to be used for this cluster. Valid values for
  this parameter are: memcached | redis
- `"EngineVersion"`: The version number of the cache engine to be used for this cluster. To
  view the supported cache engine versions, use the DescribeCacheEngineVersions operation.
  Important: You can upgrade to a newer engine version (see Selecting a Cache Engine and
  Version), but you cannot downgrade to an earlier engine version. If you want to use an
  earlier engine version, you must delete the existing cluster or replication group and
  create it anew with the earlier engine version.
- `"IpDiscovery"`: The network type you choose when modifying a cluster, either ipv4 |
  ipv6. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
  engine version 1.6.6 on all instances built on the Nitro system.
- `"LogDeliveryConfigurations"`: Specifies the destination, format and type of the logs.
- `"NetworkType"`: Must be either ipv4 | ipv6 | dual_stack. IPv6 is supported for workloads
  using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
  built on the Nitro system.
- `"NotificationTopicArn"`: The Amazon Resource Name (ARN) of the Amazon Simple
  Notification Service (SNS) topic to which notifications are sent.  The Amazon SNS topic
  owner must be the same as the cluster owner.
- `"NumCacheNodes"`: The initial number of cache nodes that the cluster has. For clusters
  running Redis, this value must be 1. For clusters running Memcached, this value must be
  between 1 and 40. If you need more than 40 nodes for your Memcached cluster, please fill
  out the ElastiCache Limit Increase Request form at
  http://aws.amazon.com/contact-us/elasticache-node-limit-request/.
- `"OutpostMode"`: Specifies whether the nodes in the cluster are created in a single
  outpost or across multiple outposts.
- `"Port"`: The port number on which each of the cache nodes accepts connections.
- `"PreferredAvailabilityZone"`: The EC2 Availability Zone in which the cluster is created.
  All nodes belonging to this cluster are placed in the preferred Availability Zone. If you
  want to create your nodes across multiple Availability Zones, use
  PreferredAvailabilityZones. Default: System chosen Availability Zone.
- `"PreferredAvailabilityZones"`: A list of the Availability Zones in which cache nodes are
  created. The order of the zones in the list is not important. This option is only supported
  on Memcached.  If you are creating your cluster in an Amazon VPC (recommended) you can only
  locate nodes in Availability Zones that are associated with the subnets in the selected
  subnet group. The number of Availability Zones listed must equal the value of
  NumCacheNodes.  If you want all the nodes in the same Availability Zone, use
  PreferredAvailabilityZone instead, or repeat the Availability Zone multiple times in the
  list. Default: System chosen Availability Zones.
- `"PreferredMaintenanceWindow"`: Specifies the weekly time range during which maintenance
  on the cluster is performed. It is specified as a range in the format
  ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
  period.
- `"PreferredOutpostArn"`: The outpost ARN in which the cache cluster is created.
- `"PreferredOutpostArns"`: The outpost ARNs in which the cache cluster is created.
- `"ReplicationGroupId"`: The ID of the replication group to which this cluster should
  belong. If this parameter is specified, the cluster is added to the specified replication
  group as a read replica; otherwise, the cluster is a standalone primary that is not part of
  any replication group. If the specified replication group is Multi-AZ enabled and the
  Availability Zone is not specified, the cluster is created in Availability Zones that
  provide the best spread of read replicas across Availability Zones.  This parameter is only
  valid if the Engine parameter is redis.
- `"SecurityGroupIds"`: One or more VPC security groups associated with the cluster. Use
  this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud
  (Amazon VPC).
- `"SnapshotArns"`: A single-element string list containing an Amazon Resource Name (ARN)
  that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file
  is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot
  contain any commas.  This parameter is only valid if the Engine parameter is redis.
  Example of an Amazon S3 ARN: arn:aws:s3:::my_bucket/snapshot1.rdb
- `"SnapshotName"`: The name of a Redis snapshot from which to restore data into the new
  node group (shard). The snapshot status changes to restoring while the new node group
  (shard) is being created.  This parameter is only valid if the Engine parameter is redis.
- `"SnapshotRetentionLimit"`: The number of days for which ElastiCache retains automatic
  snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a
  snapshot taken today is retained for 5 days before being deleted.  This parameter is only
  valid if the Engine parameter is redis.  Default: 0 (i.e., automatic backups are disabled
  for this cache cluster).
- `"SnapshotWindow"`: The daily time range (in UTC) during which ElastiCache begins taking
  a daily snapshot of your node group (shard). Example: 05:00-09:00  If you do not specify
  this parameter, ElastiCache automatically chooses an appropriate time range.  This
  parameter is only valid if the Engine parameter is redis.
- `"Tags"`: A list of tags to be added to this resource.
- `"TransitEncryptionEnabled"`: A flag that enables in-transit encryption when set to true.
"""
function create_cache_cluster(
    CacheClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "CreateCacheCluster",
        Dict{String,Any}("CacheClusterId" => CacheClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cache_cluster(
    CacheClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateCacheCluster",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CacheClusterId" => CacheClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cache_parameter_group(cache_parameter_group_family, cache_parameter_group_name, description)
    create_cache_parameter_group(cache_parameter_group_family, cache_parameter_group_name, description, params::Dict{String,<:Any})

Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter
group is a collection of parameters and their values that are applied to all of the nodes
in any cluster or replication group using the CacheParameterGroup. A newly created
CacheParameterGroup is an exact duplicate of the default parameter group for the
CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can
change the values of specific parameters. For more information, see:
ModifyCacheParameterGroup in the ElastiCache API Reference.    Parameters and Parameter
Groups in the ElastiCache User Guide.

# Arguments
- `cache_parameter_group_family`: The name of the cache parameter group family that the
  cache parameter group can be used with. Valid values are: memcached1.4 | memcached1.5 |
  memcached1.6 | redis2.6 | redis2.8 | redis3.2 | redis4.0 | redis5.0 | redis6.x | redis7
- `cache_parameter_group_name`: A user-specified name for the cache parameter group.
- `description`: A user-specified description for the cache parameter group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tags to be added to this resource. A tag is a key-value pair. A tag
  key must be accompanied by a tag value, although null is accepted.
"""
function create_cache_parameter_group(
    CacheParameterGroupFamily,
    CacheParameterGroupName,
    Description;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateCacheParameterGroup",
        Dict{String,Any}(
            "CacheParameterGroupFamily" => CacheParameterGroupFamily,
            "CacheParameterGroupName" => CacheParameterGroupName,
            "Description" => Description,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cache_parameter_group(
    CacheParameterGroupFamily,
    CacheParameterGroupName,
    Description,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateCacheParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CacheParameterGroupFamily" => CacheParameterGroupFamily,
                    "CacheParameterGroupName" => CacheParameterGroupName,
                    "Description" => Description,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cache_security_group(cache_security_group_name, description)
    create_cache_security_group(cache_security_group_name, description, params::Dict{String,<:Any})

Creates a new cache security group. Use a cache security group to control access to one or
more clusters. Cache security groups are only used when you are creating a cluster outside
of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster inside of a
VPC, use a cache subnet group instead. For more information, see CreateCacheSubnetGroup.

# Arguments
- `cache_security_group_name`: A name for the cache security group. This value is stored as
  a lowercase string. Constraints: Must contain no more than 255 alphanumeric characters.
  Cannot be the word \"Default\". Example: mysecuritygroup
- `description`: A description for the cache security group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tags to be added to this resource. A tag is a key-value pair. A tag
  key must be accompanied by a tag value, although null is accepted.
"""
function create_cache_security_group(
    CacheSecurityGroupName, Description; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "CreateCacheSecurityGroup",
        Dict{String,Any}(
            "CacheSecurityGroupName" => CacheSecurityGroupName, "Description" => Description
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cache_security_group(
    CacheSecurityGroupName,
    Description,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateCacheSecurityGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CacheSecurityGroupName" => CacheSecurityGroupName,
                    "Description" => Description,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cache_subnet_group(cache_subnet_group_description, cache_subnet_group_name, subnet_identifier)
    create_cache_subnet_group(cache_subnet_group_description, cache_subnet_group_name, subnet_identifier, params::Dict{String,<:Any})

Creates a new cache subnet group. Use this parameter only when you are creating a cluster
in an Amazon Virtual Private Cloud (Amazon VPC).

# Arguments
- `cache_subnet_group_description`: A description for the cache subnet group.
- `cache_subnet_group_name`: A name for the cache subnet group. This value is stored as a
  lowercase string. Constraints: Must contain no more than 255 alphanumeric characters or
  hyphens. Example: mysubnetgroup
- `subnet_identifier`: A list of VPC subnet IDs for the cache subnet group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SubnetIds"`: A list of VPC subnet IDs for the cache subnet group.
- `"Tags"`: A list of tags to be added to this resource. A tag is a key-value pair. A tag
  key must be accompanied by a tag value, although null is accepted.
"""
function create_cache_subnet_group(
    CacheSubnetGroupDescription,
    CacheSubnetGroupName,
    SubnetIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateCacheSubnetGroup",
        Dict{String,Any}(
            "CacheSubnetGroupDescription" => CacheSubnetGroupDescription,
            "CacheSubnetGroupName" => CacheSubnetGroupName,
            "SubnetIdentifier" => SubnetIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cache_subnet_group(
    CacheSubnetGroupDescription,
    CacheSubnetGroupName,
    SubnetIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateCacheSubnetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CacheSubnetGroupDescription" => CacheSubnetGroupDescription,
                    "CacheSubnetGroupName" => CacheSubnetGroupName,
                    "SubnetIdentifier" => SubnetIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_global_replication_group(global_replication_group_id_suffix, primary_replication_group_id)
    create_global_replication_group(global_replication_group_id_suffix, primary_replication_group_id, params::Dict{String,<:Any})

Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region
replication. Using Global Datastore for Redis, you can create cross-region read replica
clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across
regions. For more information, see Replication Across Regions Using Global Datastore.
The GlobalReplicationGroupIdSuffix is the name of the Global datastore.   The
PrimaryReplicationGroupId represents the name of the primary cluster that accepts writes
and will replicate updates to the secondary cluster.

# Arguments
- `global_replication_group_id_suffix`: The suffix name of a Global datastore. Amazon
  ElastiCache automatically applies a prefix to the Global datastore ID when it is created.
  Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the
  US-West-1 region will begin with \"dsdfu\" along with the suffix name you provide. The
  suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global
  datastore name across multiple regions.  For a full list of Amazon Regions and their
  respective Global datastore iD prefixes, see Using the Amazon CLI with Global datastores .
- `primary_replication_group_id`: The name of the primary cluster that accepts writes and
  will replicate updates to the secondary cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GlobalReplicationGroupDescription"`: Provides details of the Global datastore
"""
function create_global_replication_group(
    GlobalReplicationGroupIdSuffix,
    PrimaryReplicationGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateGlobalReplicationGroup",
        Dict{String,Any}(
            "GlobalReplicationGroupIdSuffix" => GlobalReplicationGroupIdSuffix,
            "PrimaryReplicationGroupId" => PrimaryReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_global_replication_group(
    GlobalReplicationGroupIdSuffix,
    PrimaryReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateGlobalReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalReplicationGroupIdSuffix" => GlobalReplicationGroupIdSuffix,
                    "PrimaryReplicationGroupId" => PrimaryReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_replication_group(replication_group_description, replication_group_id)
    create_replication_group(replication_group_description, replication_group_id, params::Dict{String,<:Any})

Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication
group. This API can be used to create a standalone regional replication group or a
secondary replication group associated with a Global datastore. A Redis (cluster mode
disabled) replication group is a collection of nodes, where one of the nodes is a
read/write primary and the others are read-only replicas. Writes to the primary are
asynchronously propagated to the replicas. A Redis cluster-mode enabled cluster is
comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a primary node and
up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas
to 15 shards and 5 replicas, which is the maximum number or replicas allowed.  The node or
shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is
5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges
between 83 shards (one primary and 5 replicas per shard) and 500 shards (single primary and
no replicas). Make sure there are enough available IP addresses to accommodate the
increase. Common pitfalls include the subnets in the subnet group have too small a CIDR
range or the subnets are shared and heavily used by other clusters. For more information,
see Creating a Subnet Group. For versions below 5.0.6, the limit is 250 per cluster. To
request a limit increase, see Amazon Service Limits and choose the limit type Nodes per
cluster per instance type.  When a Redis (cluster mode disabled) replication group has been
successfully created, you can add one or more read replicas to it, up to a total of 5 read
replicas. If you need to increase or decrease the number of node groups (console: shards),
you can avail yourself of ElastiCache for Redis' scaling. For more information, see Scaling
ElastiCache for Redis Clusters in the ElastiCache User Guide.  This operation is valid for
Redis only.

# Arguments
- `replication_group_description`: A user-created description for the replication group.
- `replication_group_id`: The replication group identifier. This parameter is stored as a
  lowercase string. Constraints:   A name must contain from 1 to 40 alphanumeric characters
  or hyphens.   The first character must be a letter.   A name cannot end with a hyphen or
  contain two consecutive hyphens.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AtRestEncryptionEnabled"`: A flag that enables encryption at rest when set to true. You
  cannot modify the value of AtRestEncryptionEnabled after the replication group is created.
  To enable encryption at rest on a replication group you must set AtRestEncryptionEnabled to
  true when you create the replication group.   Required: Only available when creating a
  replication group in an Amazon VPC using redis version 3.2.6, 4.x or later. Default: false
- `"AuthToken"`:  Reserved parameter. The password used to access a password protected
  server.  AuthToken can be specified only on replication groups where
  TransitEncryptionEnabled is true.  For HIPAA compliance, you must specify
  TransitEncryptionEnabled as true, an AuthToken, and a CacheSubnetGroup.  Password
  constraints:   Must be only printable ASCII characters.   Must be at least 16 characters
  and no more than 128 characters in length.   The only permitted printable special
  characters are !, &amp;, #, , ^, &lt;, &gt;, and -. Other printable special characters
  cannot be used in the AUTH token.   For more information, see AUTH password at
  http://redis.io/commands/AUTH.
- `"AutoMinorVersionUpgrade"`:  If you are running Redis engine version 6.0 or later, set
  this parameter to yes if you want to opt-in to the next auto minor version upgrade
  campaign. This parameter is disabled for previous versions.
- `"AutomaticFailoverEnabled"`: Specifies whether a read-only replica is automatically
  promoted to read/write primary if the existing primary fails.  AutomaticFailoverEnabled
  must be enabled for Redis (cluster mode enabled) replication groups. Default: false
- `"CacheNodeType"`: The compute and memory capacity of the nodes in the node group
  (shard). The following node types are supported by ElastiCache. Generally speaking, the
  current generation types provide more memory and computational power at lower cost when
  compared to their equivalent previous generation counterparts.   General purpose:   Current
  generation:   M7g node types: cache.m7g.large, cache.m7g.xlarge, cache.m7g.2xlarge,
  cache.m7g.4xlarge, cache.m7g.8xlarge, cache.m7g.12xlarge, cache.m7g.16xlarge   For region
  availability, see Supported Node Types    M6g node types (available only for Redis engine
  version 5.0.6 onward and for Memcached engine version 1.5.16 onward): cache.m6g.large,
  cache.m6g.xlarge, cache.m6g.2xlarge, cache.m6g.4xlarge, cache.m6g.8xlarge,
  cache.m6g.12xlarge, cache.m6g.16xlarge   M5 node types: cache.m5.large, cache.m5.xlarge,
  cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge, cache.m5.24xlarge   M4 node types:
  cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge, cache.m4.4xlarge, cache.m4.10xlarge
  T4g node types (available only for Redis engine version 5.0.6 onward and Memcached engine
  version 1.5.16 onward): cache.t4g.micro, cache.t4g.small, cache.t4g.medium   T3 node types:
  cache.t3.micro, cache.t3.small, cache.t3.medium   T2 node types: cache.t2.micro,
  cache.t2.small, cache.t2.medium    Previous generation: (not recommended. Existing clusters
  are still supported but creation of new clusters is not supported for these types.)  T1
  node types: cache.t1.micro   M1 node types: cache.m1.small, cache.m1.medium,
  cache.m1.large, cache.m1.xlarge   M3 node types: cache.m3.medium, cache.m3.large,
  cache.m3.xlarge, cache.m3.2xlarge      Compute optimized:   Previous generation: (not
  recommended. Existing clusters are still supported but creation of new clusters is not
  supported for these types.)  C1 node types: cache.c1.xlarge      Memory optimized:
  Current generation:   R7g node types: cache.r7g.large, cache.r7g.xlarge, cache.r7g.2xlarge,
  cache.r7g.4xlarge, cache.r7g.8xlarge, cache.r7g.12xlarge, cache.r7g.16xlarge   For region
  availability, see Supported Node Types    R6g node types (available only for Redis engine
  version 5.0.6 onward and for Memcached engine version 1.5.16 onward): cache.r6g.large,
  cache.r6g.xlarge, cache.r6g.2xlarge, cache.r6g.4xlarge, cache.r6g.8xlarge,
  cache.r6g.12xlarge, cache.r6g.16xlarge   R5 node types: cache.r5.large, cache.r5.xlarge,
  cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge, cache.r5.24xlarge   R4 node types:
  cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge, cache.r4.4xlarge, cache.r4.8xlarge,
  cache.r4.16xlarge    Previous generation: (not recommended. Existing clusters are still
  supported but creation of new clusters is not supported for these types.)  M2 node types:
  cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge   R3 node types: cache.r3.large,
  cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge, cache.r3.8xlarge       Additional node
  type info    All current generation instance types are created in Amazon VPC by default.
  Redis append-only files (AOF) are not supported for T1 or T2 instances.   Redis Multi-AZ
  with automatic failover is not supported on T1 instances.   Redis configuration variables
  appendonly and appendfsync are not supported on Redis version 2.8.22 and later.
- `"CacheParameterGroupName"`: The name of the parameter group to associate with this
  replication group. If this argument is omitted, the default cache parameter group for the
  specified engine is used. If you are running Redis version 3.2.4 or later, only one node
  group (shard), and want to use a default parameter group, we recommend that you specify the
  parameter group by name.    To create a Redis (cluster mode disabled) replication group,
  use CacheParameterGroupName=default.redis3.2.   To create a Redis (cluster mode enabled)
  replication group, use CacheParameterGroupName=default.redis3.2.cluster.on.
- `"CacheSecurityGroupNames"`: A list of cache security group names to associate with this
  replication group.
- `"CacheSubnetGroupName"`: The name of the cache subnet group to be used for the
  replication group.  If you're going to launch your cluster in an Amazon VPC, you need to
  create a subnet group before you start creating a cluster. For more information, see
  Subnets and Subnet Groups.
- `"ClusterMode"`: Enabled or Disabled. To modify cluster mode from Disabled to Enabled,
  you must first set the cluster mode to Compatible. Compatible mode allows your Redis
  clients to connect using both cluster mode enabled and cluster mode disabled. After you
  migrate all Redis clients to use cluster mode enabled, you can then complete cluster mode
  configuration and set the cluster mode to Enabled.
- `"DataTieringEnabled"`: Enables data tiering. Data tiering is only supported for
  replication groups using the r6gd node type. This parameter must be set to true when using
  r6gd nodes. For more information, see Data tiering.
- `"Engine"`: The name of the cache engine to be used for the clusters in this replication
  group. The value must be set to Redis.
- `"EngineVersion"`: The version number of the cache engine to be used for the clusters in
  this replication group. To view the supported cache engine versions, use the
  DescribeCacheEngineVersions operation.  Important: You can upgrade to a newer engine
  version (see Selecting a Cache Engine and Version) in the ElastiCache User Guide, but you
  cannot downgrade to an earlier engine version. If you want to use an earlier engine
  version, you must delete the existing cluster or replication group and create it anew with
  the earlier engine version.
- `"GlobalReplicationGroupId"`: The name of the Global datastore
- `"IpDiscovery"`: The network type you choose when creating a replication group, either
  ipv4 | ipv6. IPv6 is supported for workloads using Redis engine version 6.2 onward or
  Memcached engine version 1.6.6 on all instances built on the Nitro system.
- `"KmsKeyId"`: The ID of the KMS key used to encrypt the disk in the cluster.
- `"LogDeliveryConfigurations"`: Specifies the destination, format and type of the logs.
- `"MultiAZEnabled"`: A flag indicating if you have Multi-AZ enabled to enhance fault
  tolerance. For more information, see Minimizing Downtime: Multi-AZ.
- `"NetworkType"`: Must be either ipv4 | ipv6 | dual_stack. IPv6 is supported for workloads
  using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
  built on the Nitro system.
- `"NodeGroupConfiguration"`: A list of node group (shard) configuration options. Each node
  group (shard) configuration has the following members: PrimaryAvailabilityZone,
  ReplicaAvailabilityZones, ReplicaCount, and Slots. If you're creating a Redis (cluster mode
  disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter
  to individually configure each node group (shard), or you can omit this parameter. However,
  it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You
  must configure each node group (shard) using this parameter because you must specify the
  slots for each node group.
- `"NotificationTopicArn"`: The Amazon Resource Name (ARN) of the Amazon Simple
  Notification Service (SNS) topic to which notifications are sent.  The Amazon SNS topic
  owner must be the same as the cluster owner.
- `"NumCacheClusters"`: The number of clusters this replication group initially has. This
  parameter is not used if there is more than one node group (shard). You should use
  ReplicasPerNodeGroup instead. If AutomaticFailoverEnabled is true, the value of this
  parameter must be at least 2. If AutomaticFailoverEnabled is false you can omit this
  parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.
  The maximum permitted value for NumCacheClusters is 6 (1 primary plus 5 replicas).
- `"NumNodeGroups"`: An optional parameter that specifies the number of node groups
  (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode
  disabled) either omit this parameter or set it to 1. Default: 1
- `"Port"`: The port number on which each member of the replication group accepts
  connections.
- `"PreferredCacheClusterAZs"`: A list of EC2 Availability Zones in which the replication
  group's clusters are created. The order of the Availability Zones in the list is the order
  in which clusters are allocated. The primary cluster is created in the first AZ in the
  list. This parameter is not used if there is more than one node group (shard). You should
  use NodeGroupConfiguration instead.  If you are creating your replication group in an
  Amazon VPC (recommended), you can only locate clusters in Availability Zones associated
  with the subnets in the selected subnet group. The number of Availability Zones listed must
  equal the value of NumCacheClusters.  Default: system chosen Availability Zones.
- `"PreferredMaintenanceWindow"`: Specifies the weekly time range during which maintenance
  on the cluster is performed. It is specified as a range in the format
  ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
  period. Valid values for ddd are:    sun     mon     tue     wed     thu     fri     sat
  Example: sun:23:00-mon:01:30
- `"PrimaryClusterId"`: The identifier of the cluster that serves as the primary for this
  replication group. This cluster must already exist and have a status of available. This
  parameter is not required if NumCacheClusters, NumNodeGroups, or ReplicasPerNodeGroup is
  specified.
- `"ReplicasPerNodeGroup"`: An optional parameter that specifies the number of replica
  nodes in each node group (shard). Valid values are 0 to 5.
- `"SecurityGroupIds"`: One or more Amazon VPC security groups associated with this
  replication group. Use this parameter only when you are creating a replication group in an
  Amazon Virtual Private Cloud (Amazon VPC).
- `"ServerlessCacheSnapshotName"`: The name of the snapshot used to create a replication
  group. Available for Redis only.
- `"SnapshotArns"`: A list of Amazon Resource Names (ARN) that uniquely identify the Redis
  RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new
  replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new
  replication group will have the number of node groups (console: shards) specified by the
  parameter NumNodeGroups or the number of node groups configured by NodeGroupConfiguration
  regardless of the number of ARNs specified here. Example of an Amazon S3 ARN:
  arn:aws:s3:::my_bucket/snapshot1.rdb
- `"SnapshotName"`: The name of a snapshot from which to restore data into the new
  replication group. The snapshot status changes to restoring while the new replication group
  is being created.
- `"SnapshotRetentionLimit"`: The number of days for which ElastiCache retains automatic
  snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a
  snapshot that was taken today is retained for 5 days before being deleted. Default: 0
  (i.e., automatic backups are disabled for this cluster).
- `"SnapshotWindow"`: The daily time range (in UTC) during which ElastiCache begins taking
  a daily snapshot of your node group (shard). Example: 05:00-09:00  If you do not specify
  this parameter, ElastiCache automatically chooses an appropriate time range.
- `"Tags"`: A list of tags to be added to this resource. Tags are comma-separated key,value
  pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following:
  Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue. Tags on replication
  groups will be replicated to all nodes.
- `"TransitEncryptionEnabled"`: A flag that enables in-transit encryption when set to true.
  This parameter is valid only if the Engine parameter is redis, the EngineVersion parameter
  is 3.2.6, 4.x or later, and the cluster is being created in an Amazon VPC. If you enable
  in-transit encryption, you must also specify a value for CacheSubnetGroup.  Required: Only
  available when creating a replication group in an Amazon VPC using redis version 3.2.6, 4.x
  or later. Default: false   For HIPAA compliance, you must specify TransitEncryptionEnabled
  as true, an AuthToken, and a CacheSubnetGroup.
- `"TransitEncryptionMode"`: A setting that allows you to migrate your clients to use
  in-transit encryption, with no downtime. When setting TransitEncryptionEnabled to true, you
  can set your TransitEncryptionMode to preferred in the same request, to allow both
  encrypted and unencrypted connections at the same time. Once you migrate all your Redis
  clients to use encrypted connections you can modify the value to required to allow
  encrypted connections only. Setting TransitEncryptionMode to required is a two-step process
  that requires you to first set the TransitEncryptionMode to preferred, after that you can
  set TransitEncryptionMode to required. This process will not trigger the replacement of the
  replication group.
- `"UserGroupIds"`: The user group to associate with the replication group.
"""
function create_replication_group(
    ReplicationGroupDescription,
    ReplicationGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateReplicationGroup",
        Dict{String,Any}(
            "ReplicationGroupDescription" => ReplicationGroupDescription,
            "ReplicationGroupId" => ReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_replication_group(
    ReplicationGroupDescription,
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ReplicationGroupDescription" => ReplicationGroupDescription,
                    "ReplicationGroupId" => ReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_serverless_cache(engine, serverless_cache_name)
    create_serverless_cache(engine, serverless_cache_name, params::Dict{String,<:Any})

Creates a serverless cache.

# Arguments
- `engine`: The name of the cache engine to be used for creating the serverless cache.
- `serverless_cache_name`: User-provided identifier for the serverless cache. This
  parameter is stored as a lowercase string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheUsageLimits"`: Sets the cache usage limits for storage and ElastiCache Processing
  Units for the cache.
- `"DailySnapshotTime"`: The daily time that snapshots will be created from the new
  serverless cache. By default this number is populated with 0, i.e. no snapshots will be
  created on an automatic daily basis. Available for Redis only.
- `"Description"`: User-provided description for the serverless cache. The default is NULL,
  i.e. if no description is provided then an empty string will be returned. The maximum
  length is 255 characters.
- `"KmsKeyId"`: ARN of the customer managed key for encrypting the data at rest. If no KMS
  key is provided, a default service key is used.
- `"MajorEngineVersion"`: The version of the cache engine that will be used to create the
  serverless cache.
- `"SecurityGroupIds"`: A list of the one or more VPC security groups to be associated with
  the serverless cache. The security group will authorize traffic access for the VPC
  end-point (private-link). If no other information is given this will be the VPC’s Default
  Security Group that is associated with the cluster VPC end-point.
- `"SnapshotArnsToRestore"`: The ARN(s) of the snapshot that the new serverless cache will
  be created from. Available for Redis only.
- `"SnapshotRetentionLimit"`: The number of snapshots that will be retained for the
  serverless cache that is being created. As new snapshots beyond this limit are added, the
  oldest snapshots will be deleted on a rolling basis. Available for Redis only.
- `"SubnetIds"`: A list of the identifiers of the subnets where the VPC endpoint for the
  serverless cache will be deployed. All the subnetIds must belong to the same VPC.
- `"Tags"`: The list of tags (key, value) pairs to be added to the serverless cache
  resource. Default is NULL.
- `"UserGroupId"`: The identifier of the UserGroup to be associated with the serverless
  cache. Available for Redis only. Default is NULL.
"""
function create_serverless_cache(
    Engine, ServerlessCacheName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "CreateServerlessCache",
        Dict{String,Any}("Engine" => Engine, "ServerlessCacheName" => ServerlessCacheName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_serverless_cache(
    Engine,
    ServerlessCacheName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateServerlessCache",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Engine" => Engine, "ServerlessCacheName" => ServerlessCacheName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_serverless_cache_snapshot(serverless_cache_name, serverless_cache_snapshot_name)
    create_serverless_cache_snapshot(serverless_cache_name, serverless_cache_snapshot_name, params::Dict{String,<:Any})

This API creates a copy of an entire ServerlessCache at a specific moment in time.
Available for Redis only.

# Arguments
- `serverless_cache_name`: The name of an existing serverless cache. The snapshot is
  created from this cache. Available for Redis only.
- `serverless_cache_snapshot_name`: The name for the snapshot being created. Must be unique
  for the customer account. Available for Redis only. Must be between 1 and 255 characters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KmsKeyId"`: The ID of the KMS key used to encrypt the snapshot. Available for Redis
  only. Default: NULL
- `"Tags"`: A list of tags to be added to the snapshot resource. A tag is a key-value pair.
  Available for Redis only.
"""
function create_serverless_cache_snapshot(
    ServerlessCacheName,
    ServerlessCacheSnapshotName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateServerlessCacheSnapshot",
        Dict{String,Any}(
            "ServerlessCacheName" => ServerlessCacheName,
            "ServerlessCacheSnapshotName" => ServerlessCacheSnapshotName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_serverless_cache_snapshot(
    ServerlessCacheName,
    ServerlessCacheSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateServerlessCacheSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServerlessCacheName" => ServerlessCacheName,
                    "ServerlessCacheSnapshotName" => ServerlessCacheSnapshotName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshot(snapshot_name)
    create_snapshot(snapshot_name, params::Dict{String,<:Any})

Creates a copy of an entire cluster or replication group at a specific moment in time.
This operation is valid for Redis only.

# Arguments
- `snapshot_name`: A name for the snapshot being created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheClusterId"`: The identifier of an existing cluster. The snapshot is created from
  this cluster.
- `"KmsKeyId"`: The ID of the KMS key used to encrypt the snapshot.
- `"ReplicationGroupId"`: The identifier of an existing replication group. The snapshot is
  created from this replication group.
- `"Tags"`: A list of tags to be added to this resource. A tag is a key-value pair. A tag
  key must be accompanied by a tag value, although null is accepted.
"""
function create_snapshot(SnapshotName; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "CreateSnapshot",
        Dict{String,Any}("SnapshotName" => SnapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_snapshot(
    SnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateSnapshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SnapshotName" => SnapshotName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user(access_string, engine, user_id, user_name)
    create_user(access_string, engine, user_id, user_name, params::Dict{String,<:Any})

For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see Using
Role Based Access Control (RBAC).

# Arguments
- `access_string`: Access permissions string used for this user.
- `engine`: The current supported value is Redis.
- `user_id`: The ID of the user.
- `user_name`: The username of the user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthenticationMode"`: Specifies how to authenticate the user.
- `"NoPasswordRequired"`: Indicates a password is not required for this user.
- `"Passwords"`: Passwords used for this user. You can create up to two passwords for each
  user.
- `"Tags"`: A list of tags to be added to this resource. A tag is a key-value pair. A tag
  key must be accompanied by a tag value, although null is accepted.
"""
function create_user(
    AccessString,
    Engine,
    UserId,
    UserName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateUser",
        Dict{String,Any}(
            "AccessString" => AccessString,
            "Engine" => Engine,
            "UserId" => UserId,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user(
    AccessString,
    Engine,
    UserId,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccessString" => AccessString,
                    "Engine" => Engine,
                    "UserId" => UserId,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user_group(engine, user_group_id)
    create_user_group(engine, user_group_id, params::Dict{String,<:Any})

For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see
Using Role Based Access Control (RBAC)

# Arguments
- `engine`: The current supported value is Redis.
- `user_group_id`: The ID of the user group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tags to be added to this resource. A tag is a key-value pair. A tag
  key must be accompanied by a tag value, although null is accepted. Available for Redis only.
- `"UserIds"`: The list of user IDs that belong to the user group.
"""
function create_user_group(
    Engine, UserGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "CreateUserGroup",
        Dict{String,Any}("Engine" => Engine, "UserGroupId" => UserGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user_group(
    Engine,
    UserGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "CreateUserGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Engine" => Engine, "UserGroupId" => UserGroupId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    decrease_node_groups_in_global_replication_group(apply_immediately, global_replication_group_id, node_group_count)
    decrease_node_groups_in_global_replication_group(apply_immediately, global_replication_group_id, node_group_count, params::Dict{String,<:Any})

Decreases the number of node groups in a Global datastore

# Arguments
- `apply_immediately`: Indicates that the shard reconfiguration process begins immediately.
  At present, the only permitted value for this parameter is true.
- `global_replication_group_id`: The name of the Global datastore
- `node_group_count`: The number of node groups (shards) that results from the modification
  of the shard configuration

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GlobalNodeGroupsToRemove"`: If the value of NodeGroupCount is less than the current
  number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is
  required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster.
  ElastiCache for Redis will attempt to remove all node groups listed by
  GlobalNodeGroupsToRemove from the cluster.
- `"GlobalNodeGroupsToRetain"`: If the value of NodeGroupCount is less than the current
  number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is
  required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster.
  ElastiCache for Redis will attempt to retain all node groups listed by
  GlobalNodeGroupsToRetain from the cluster.
"""
function decrease_node_groups_in_global_replication_group(
    ApplyImmediately,
    GlobalReplicationGroupId,
    NodeGroupCount;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DecreaseNodeGroupsInGlobalReplicationGroup",
        Dict{String,Any}(
            "ApplyImmediately" => ApplyImmediately,
            "GlobalReplicationGroupId" => GlobalReplicationGroupId,
            "NodeGroupCount" => NodeGroupCount,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function decrease_node_groups_in_global_replication_group(
    ApplyImmediately,
    GlobalReplicationGroupId,
    NodeGroupCount,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DecreaseNodeGroupsInGlobalReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplyImmediately" => ApplyImmediately,
                    "GlobalReplicationGroupId" => GlobalReplicationGroupId,
                    "NodeGroupCount" => NodeGroupCount,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    decrease_replica_count(apply_immediately, replication_group_id)
    decrease_replica_count(apply_immediately, replication_group_id, params::Dict{String,<:Any})

Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication
group or the number of replica nodes in one or more node groups (shards) of a Redis
(cluster mode enabled) replication group. This operation is performed with no cluster down
time.

# Arguments
- `apply_immediately`: If True, the number of replica nodes is decreased immediately.
  ApplyImmediately=False is not currently supported.
- `replication_group_id`: The id of the replication group from which you want to remove
  replica nodes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NewReplicaCount"`: The number of read replica nodes you want at the completion of this
  operation. For Redis (cluster mode disabled) replication groups, this is the number of
  replica nodes in the replication group. For Redis (cluster mode enabled) replication
  groups, this is the number of replica nodes in each of the replication group's node groups.
  The minimum number of replicas in a shard or replication group is:   Redis (cluster mode
  disabled)   If Multi-AZ is enabled: 1   If Multi-AZ is not enabled: 0     Redis (cluster
  mode enabled): 0 (though you will not be able to failover to a replica if your primary node
  fails)
- `"ReplicaConfiguration"`: A list of ConfigureShard objects that can be used to configure
  each shard in a Redis (cluster mode enabled) replication group. The ConfigureShard has
  three members: NewReplicaCount, NodeGroupId, and PreferredAvailabilityZones.
- `"ReplicasToRemove"`: A list of the node ids to remove from the replication group or node
  group (shard).
"""
function decrease_replica_count(
    ApplyImmediately, ReplicationGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DecreaseReplicaCount",
        Dict{String,Any}(
            "ApplyImmediately" => ApplyImmediately,
            "ReplicationGroupId" => ReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function decrease_replica_count(
    ApplyImmediately,
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DecreaseReplicaCount",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplyImmediately" => ApplyImmediately,
                    "ReplicationGroupId" => ReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cache_cluster(cache_cluster_id)
    delete_cache_cluster(cache_cluster_id, params::Dict{String,<:Any})

Deletes a previously provisioned cluster. DeleteCacheCluster deletes all associated cache
nodes, node endpoints and the cluster itself. When you receive a successful response from
this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot
cancel or revert this operation. This operation is not valid for:   Redis (cluster mode
enabled) clusters   Redis (cluster mode disabled) clusters   A cluster that is the last
read replica of a replication group   A cluster that is the primary node of a replication
group   A node group (shard) that has Multi-AZ mode enabled   A cluster from a Redis
(cluster mode enabled) replication group   A cluster that is not in the available state

# Arguments
- `cache_cluster_id`: The cluster identifier for the cluster to be deleted. This parameter
  is not case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FinalSnapshotIdentifier"`: The user-supplied name of a final cluster snapshot. This is
  the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then
  deletes the cluster immediately afterward.
"""
function delete_cache_cluster(
    CacheClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DeleteCacheCluster",
        Dict{String,Any}("CacheClusterId" => CacheClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cache_cluster(
    CacheClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteCacheCluster",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CacheClusterId" => CacheClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cache_parameter_group(cache_parameter_group_name)
    delete_cache_parameter_group(cache_parameter_group_name, params::Dict{String,<:Any})

Deletes the specified cache parameter group. You cannot delete a cache parameter group if
it is associated with any cache clusters. You cannot delete the default cache parameter
groups in your account.

# Arguments
- `cache_parameter_group_name`: The name of the cache parameter group to delete.  The
  specified cache security group must not be associated with any clusters.

"""
function delete_cache_parameter_group(
    CacheParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DeleteCacheParameterGroup",
        Dict{String,Any}("CacheParameterGroupName" => CacheParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cache_parameter_group(
    CacheParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteCacheParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CacheParameterGroupName" => CacheParameterGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cache_security_group(cache_security_group_name)
    delete_cache_security_group(cache_security_group_name, params::Dict{String,<:Any})

Deletes a cache security group.  You cannot delete a cache security group if it is
associated with any clusters.

# Arguments
- `cache_security_group_name`: The name of the cache security group to delete.  You cannot
  delete the default security group.

"""
function delete_cache_security_group(
    CacheSecurityGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DeleteCacheSecurityGroup",
        Dict{String,Any}("CacheSecurityGroupName" => CacheSecurityGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cache_security_group(
    CacheSecurityGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteCacheSecurityGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CacheSecurityGroupName" => CacheSecurityGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cache_subnet_group(cache_subnet_group_name)
    delete_cache_subnet_group(cache_subnet_group_name, params::Dict{String,<:Any})

Deletes a cache subnet group.  You cannot delete a default cache subnet group or one that
is associated with any clusters.

# Arguments
- `cache_subnet_group_name`: The name of the cache subnet group to delete. Constraints:
  Must contain no more than 255 alphanumeric characters or hyphens.

"""
function delete_cache_subnet_group(
    CacheSubnetGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DeleteCacheSubnetGroup",
        Dict{String,Any}("CacheSubnetGroupName" => CacheSubnetGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cache_subnet_group(
    CacheSubnetGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteCacheSubnetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CacheSubnetGroupName" => CacheSubnetGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_global_replication_group(global_replication_group_id, retain_primary_replication_group)
    delete_global_replication_group(global_replication_group_id, retain_primary_replication_group, params::Dict{String,<:Any})

Deleting a Global datastore is a two-step process:    First, you must
DisassociateGlobalReplicationGroup to remove the secondary clusters in the Global
datastore.   Once the Global datastore contains only the primary cluster, you can use the
DeleteGlobalReplicationGroup API to delete the Global datastore while retainining the
primary cluster using RetainPrimaryReplicationGroup=true.   Since the Global Datastore has
only a primary cluster, you can delete the Global Datastore while retaining the primary by
setting RetainPrimaryReplicationGroup=true. The primary cluster is never deleted when
deleting a Global Datastore. It can only be deleted when it no longer is associated with
any Global Datastore. When you receive a successful response from this operation, Amazon
ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert
this operation.

# Arguments
- `global_replication_group_id`: The name of the Global datastore
- `retain_primary_replication_group`: The primary replication group is retained as a
  standalone replication group.

"""
function delete_global_replication_group(
    GlobalReplicationGroupId,
    RetainPrimaryReplicationGroup;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteGlobalReplicationGroup",
        Dict{String,Any}(
            "GlobalReplicationGroupId" => GlobalReplicationGroupId,
            "RetainPrimaryReplicationGroup" => RetainPrimaryReplicationGroup,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_global_replication_group(
    GlobalReplicationGroupId,
    RetainPrimaryReplicationGroup,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteGlobalReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalReplicationGroupId" => GlobalReplicationGroupId,
                    "RetainPrimaryReplicationGroup" => RetainPrimaryReplicationGroup,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_replication_group(replication_group_id)
    delete_replication_group(replication_group_id, params::Dict{String,<:Any})

Deletes an existing replication group. By default, this operation deletes the entire
replication group, including the primary/primaries and all of the read replicas. If the
replication group has only one primary, you can optionally delete only the read replicas,
while retaining the primary by setting RetainPrimaryCluster=true. When you receive a
successful response from this operation, Amazon ElastiCache immediately begins deleting the
selected resources; you cannot cancel or revert this operation.  This operation is valid
for Redis only.

# Arguments
- `replication_group_id`: The identifier for the cluster to be deleted. This parameter is
  not case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FinalSnapshotIdentifier"`: The name of a final node group (shard) snapshot. ElastiCache
  creates the snapshot from the primary node in the cluster, rather than one of the replicas;
  this is to ensure that it captures the freshest data. After the final snapshot is taken,
  the replication group is immediately deleted.
- `"RetainPrimaryCluster"`: If set to true, all of the read replicas are deleted, but the
  primary node is retained.
"""
function delete_replication_group(
    ReplicationGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DeleteReplicationGroup",
        Dict{String,Any}("ReplicationGroupId" => ReplicationGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_replication_group(
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ReplicationGroupId" => ReplicationGroupId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_serverless_cache(serverless_cache_name)
    delete_serverless_cache(serverless_cache_name, params::Dict{String,<:Any})

Deletes a specified existing serverless cache.

# Arguments
- `serverless_cache_name`: The identifier of the serverless cache to be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FinalSnapshotName"`: Name of the final snapshot to be taken before the serverless cache
  is deleted. Available for Redis only. Default: NULL, i.e. a final snapshot is not taken.
"""
function delete_serverless_cache(
    ServerlessCacheName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DeleteServerlessCache",
        Dict{String,Any}("ServerlessCacheName" => ServerlessCacheName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_serverless_cache(
    ServerlessCacheName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteServerlessCache",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerlessCacheName" => ServerlessCacheName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_serverless_cache_snapshot(serverless_cache_snapshot_name)
    delete_serverless_cache_snapshot(serverless_cache_snapshot_name, params::Dict{String,<:Any})

Deletes an existing serverless cache snapshot. Available for Redis only.

# Arguments
- `serverless_cache_snapshot_name`: Idenfitier of the snapshot to be deleted. Available for
  Redis only.

"""
function delete_serverless_cache_snapshot(
    ServerlessCacheSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DeleteServerlessCacheSnapshot",
        Dict{String,Any}("ServerlessCacheSnapshotName" => ServerlessCacheSnapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_serverless_cache_snapshot(
    ServerlessCacheSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteServerlessCacheSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServerlessCacheSnapshotName" => ServerlessCacheSnapshotName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_snapshot(snapshot_name)
    delete_snapshot(snapshot_name, params::Dict{String,<:Any})

Deletes an existing snapshot. When you receive a successful response from this operation,
ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this
operation.  This operation is valid for Redis only.

# Arguments
- `snapshot_name`: The name of the snapshot to be deleted.

"""
function delete_snapshot(SnapshotName; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DeleteSnapshot",
        Dict{String,Any}("SnapshotName" => SnapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_snapshot(
    SnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteSnapshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SnapshotName" => SnapshotName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user(user_id)
    delete_user(user_id, params::Dict{String,<:Any})

For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all
user groups and in turn removed from all replication groups. For more information, see
Using Role Based Access Control (RBAC).

# Arguments
- `user_id`: The ID of the user.

"""
function delete_user(UserId; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DeleteUser",
        Dict{String,Any}("UserId" => UserId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user(
    UserId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DeleteUser",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("UserId" => UserId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user_group(user_group_id)
    delete_user_group(user_group_id, params::Dict{String,<:Any})

For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be
disassociated from the replication group before it can be deleted. For more information,
see Using Role Based Access Control (RBAC).

# Arguments
- `user_group_id`: The ID of the user group.

"""
function delete_user_group(UserGroupId; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DeleteUserGroup",
        Dict{String,Any}("UserGroupId" => UserGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user_group(
    UserGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DeleteUserGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserGroupId" => UserGroupId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cache_clusters()
    describe_cache_clusters(params::Dict{String,<:Any})

Returns information about all provisioned clusters if no cluster identifier is specified,
or about a specific cache cluster if a cluster identifier is supplied. By default,
abbreviated information about the clusters is returned. You can use the optional
ShowCacheNodeInfo flag to retrieve detailed information about the cache nodes associated
with the clusters. These details include the DNS address and port for the cache node
endpoint. If the cluster is in the creating state, only cluster-level information is
displayed until all of the nodes are successfully provisioned. If the cluster is in the
deleting state, only cluster-level information is displayed. If cache nodes are currently
being added to the cluster, node endpoint information and creation time for the additional
nodes are not displayed until they are completely provisioned. When the cluster state is
available, the cluster is ready for use. If cache nodes are currently being removed from
the cluster, no endpoint information for the removed nodes is displayed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheClusterId"`: The user-supplied cluster identifier. If this parameter is specified,
  only information about that specific cluster is returned. This parameter isn't case
  sensitive.
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
- `"ShowCacheClustersNotInReplicationGroups"`: An optional flag that can be included in the
  DescribeCacheCluster request to show only nodes (API/CLI: clusters) that are not members of
  a replication group. In practice, this mean Memcached and single node Redis clusters.
- `"ShowCacheNodeInfo"`: An optional flag that can be included in the DescribeCacheCluster
  request to retrieve information about the individual cache nodes.
"""
function describe_cache_clusters(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeCacheClusters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_cache_clusters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeCacheClusters",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cache_engine_versions()
    describe_cache_engine_versions(params::Dict{String,<:Any})

Returns a list of the available cache engines and their versions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheParameterGroupFamily"`: The name of a specific cache parameter group family to
  return details for. Valid values are: memcached1.4 | memcached1.5 | memcached1.6 | redis2.6
  | redis2.8 | redis3.2 | redis4.0 | redis5.0 | redis6.x | redis6.2 | redis7  Constraints:
  Must be 1 to 255 alphanumeric characters   First character must be a letter   Cannot end
  with a hyphen or contain two consecutive hyphens
- `"DefaultOnly"`: If true, specifies that only the default version of the specified engine
  or engine and major version combination is to be returned.
- `"Engine"`: The cache engine to return. Valid values: memcached | redis
- `"EngineVersion"`: The cache engine version to return. Example: 1.4.14
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
"""
function describe_cache_engine_versions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeCacheEngineVersions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cache_engine_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeCacheEngineVersions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cache_parameter_groups()
    describe_cache_parameter_groups(params::Dict{String,<:Any})

Returns a list of cache parameter group descriptions. If a cache parameter group name is
specified, the list contains only the descriptions for that group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheParameterGroupName"`: The name of a specific cache parameter group to return
  details for.
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
"""
function describe_cache_parameter_groups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeCacheParameterGroups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cache_parameter_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeCacheParameterGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cache_parameters(cache_parameter_group_name)
    describe_cache_parameters(cache_parameter_group_name, params::Dict{String,<:Any})

Returns the detailed parameter list for a particular cache parameter group.

# Arguments
- `cache_parameter_group_name`: The name of a specific cache parameter group to return
  details for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
- `"Source"`: The parameter types to return. Valid values: user | system | engine-default
"""
function describe_cache_parameters(
    CacheParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeCacheParameters",
        Dict{String,Any}("CacheParameterGroupName" => CacheParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cache_parameters(
    CacheParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DescribeCacheParameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CacheParameterGroupName" => CacheParameterGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cache_security_groups()
    describe_cache_security_groups(params::Dict{String,<:Any})

Returns a list of cache security group descriptions. If a cache security group name is
specified, the list contains only the description of that group. This applicable only when
you have ElastiCache in Classic setup

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheSecurityGroupName"`: The name of the cache security group to return details for.
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
"""
function describe_cache_security_groups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeCacheSecurityGroups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cache_security_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeCacheSecurityGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cache_subnet_groups()
    describe_cache_subnet_groups(params::Dict{String,<:Any})

Returns a list of cache subnet group descriptions. If a subnet group name is specified, the
list contains only the description of that group. This is applicable only when you have
ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheSubnetGroupName"`: The name of the cache subnet group to return details for.
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
"""
function describe_cache_subnet_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeCacheSubnetGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_cache_subnet_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeCacheSubnetGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_engine_default_parameters(cache_parameter_group_family)
    describe_engine_default_parameters(cache_parameter_group_family, params::Dict{String,<:Any})

Returns the default engine and system parameter information for the specified cache engine.

# Arguments
- `cache_parameter_group_family`: The name of the cache parameter group family. Valid
  values are: memcached1.4 | memcached1.5 | memcached1.6 | redis2.6 | redis2.8 | redis3.2 |
  redis4.0 | redis5.0 | redis6.x | redis6.2 | redis7

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
"""
function describe_engine_default_parameters(
    CacheParameterGroupFamily; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeEngineDefaultParameters",
        Dict{String,Any}("CacheParameterGroupFamily" => CacheParameterGroupFamily);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_engine_default_parameters(
    CacheParameterGroupFamily,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DescribeEngineDefaultParameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CacheParameterGroupFamily" => CacheParameterGroupFamily),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_events()
    describe_events(params::Dict{String,<:Any})

Returns events related to clusters, cache security groups, and cache parameter groups. You
can obtain events specific to a particular cluster, cache security group, or cache
parameter group by providing the name as a parameter. By default, only the events occurring
within the last hour are returned; however, you can retrieve up to 14 days' worth of events
if necessary.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Duration"`: The number of minutes worth of events to retrieve.
- `"EndTime"`: The end of the time interval for which to retrieve events, specified in ISO
  8601 format.  Example: 2017-03-30T07:03:49.555Z
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
- `"SourceIdentifier"`: The identifier of the event source for which events are returned.
  If not specified, all sources are included in the response.
- `"SourceType"`: The event source to retrieve events for. If no value is specified, all
  events are returned.
- `"StartTime"`: The beginning of the time interval to retrieve events for, specified in
  ISO 8601 format.  Example: 2017-03-30T07:03:49.555Z
"""
function describe_events(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeEvents"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_events(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeEvents", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_global_replication_groups()
    describe_global_replication_groups(params::Dict{String,<:Any})

Returns information about a particular global replication group. If no identifier is
specified, returns information about all Global datastores.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GlobalReplicationGroupId"`: The name of the Global datastore
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved.
- `"ShowMemberInfo"`: Returns the list of members that comprise the Global datastore.
"""
function describe_global_replication_groups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeGlobalReplicationGroups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_global_replication_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeGlobalReplicationGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_replication_groups()
    describe_replication_groups(params::Dict{String,<:Any})

Returns information about a particular replication group. If no identifier is specified,
DescribeReplicationGroups returns information about all replication groups.  This operation
is valid for Redis only.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
- `"ReplicationGroupId"`: The identifier for the replication group to be described. This
  parameter is not case sensitive. If you do not specify this parameter, information about
  all replication groups is returned.
"""
function describe_replication_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeReplicationGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_replication_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeReplicationGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_cache_nodes()
    describe_reserved_cache_nodes(params::Dict{String,<:Any})

Returns information about reserved cache nodes for this account, or about a specified
reserved cache node.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheNodeType"`: The cache node type filter value. Use this parameter to show only
  those reservations matching the specified cache node type. The following node types are
  supported by ElastiCache. Generally speaking, the current generation types provide more
  memory and computational power at lower cost when compared to their equivalent previous
  generation counterparts.   General purpose:   Current generation:   M7g node types:
  cache.m7g.large, cache.m7g.xlarge, cache.m7g.2xlarge, cache.m7g.4xlarge, cache.m7g.8xlarge,
  cache.m7g.12xlarge, cache.m7g.16xlarge   For region availability, see Supported Node Types
    M6g node types (available only for Redis engine version 5.0.6 onward and for Memcached
  engine version 1.5.16 onward): cache.m6g.large, cache.m6g.xlarge, cache.m6g.2xlarge,
  cache.m6g.4xlarge, cache.m6g.8xlarge, cache.m6g.12xlarge, cache.m6g.16xlarge   M5 node
  types: cache.m5.large, cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge,
  cache.m5.12xlarge, cache.m5.24xlarge   M4 node types: cache.m4.large, cache.m4.xlarge,
  cache.m4.2xlarge, cache.m4.4xlarge, cache.m4.10xlarge   T4g node types (available only for
  Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
  cache.t4g.micro, cache.t4g.small, cache.t4g.medium   T3 node types: cache.t3.micro,
  cache.t3.small, cache.t3.medium   T2 node types: cache.t2.micro, cache.t2.small,
  cache.t2.medium    Previous generation: (not recommended. Existing clusters are still
  supported but creation of new clusters is not supported for these types.)  T1 node types:
  cache.t1.micro   M1 node types: cache.m1.small, cache.m1.medium, cache.m1.large,
  cache.m1.xlarge   M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge,
  cache.m3.2xlarge      Compute optimized:   Previous generation: (not recommended. Existing
  clusters are still supported but creation of new clusters is not supported for these
  types.)  C1 node types: cache.c1.xlarge      Memory optimized:   Current generation:   R7g
  node types: cache.r7g.large, cache.r7g.xlarge, cache.r7g.2xlarge, cache.r7g.4xlarge,
  cache.r7g.8xlarge, cache.r7g.12xlarge, cache.r7g.16xlarge   For region availability, see
  Supported Node Types    R6g node types (available only for Redis engine version 5.0.6
  onward and for Memcached engine version 1.5.16 onward): cache.r6g.large, cache.r6g.xlarge,
  cache.r6g.2xlarge, cache.r6g.4xlarge, cache.r6g.8xlarge, cache.r6g.12xlarge,
  cache.r6g.16xlarge   R5 node types: cache.r5.large, cache.r5.xlarge, cache.r5.2xlarge,
  cache.r5.4xlarge, cache.r5.12xlarge, cache.r5.24xlarge   R4 node types: cache.r4.large,
  cache.r4.xlarge, cache.r4.2xlarge, cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge
  Previous generation: (not recommended. Existing clusters are still supported but creation
  of new clusters is not supported for these types.)  M2 node types: cache.m2.xlarge,
  cache.m2.2xlarge, cache.m2.4xlarge   R3 node types: cache.r3.large, cache.r3.xlarge,
  cache.r3.2xlarge, cache.r3.4xlarge, cache.r3.8xlarge       Additional node type info    All
  current generation instance types are created in Amazon VPC by default.   Redis append-only
  files (AOF) are not supported for T1 or T2 instances.   Redis Multi-AZ with automatic
  failover is not supported on T1 instances.   Redis configuration variables appendonly and
  appendfsync are not supported on Redis version 2.8.22 and later.
- `"Duration"`: The duration filter value, specified in years or seconds. Use this
  parameter to show only reservations for this duration. Valid Values: 1 | 3 | 31536000 |
  94608000
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
- `"OfferingType"`: The offering type filter value. Use this parameter to show only the
  available offerings matching the specified offering type. Valid values: \"Light
  Utilization\"|\"Medium Utilization\"|\"Heavy Utilization\"|\"All Upfront\"|\"Partial
  Upfront\"| \"No Upfront\"
- `"ProductDescription"`: The product description filter value. Use this parameter to show
  only those reservations matching the specified product description.
- `"ReservedCacheNodeId"`: The reserved cache node identifier filter value. Use this
  parameter to show only the reservation that matches the specified reservation ID.
- `"ReservedCacheNodesOfferingId"`: The offering identifier filter value. Use this
  parameter to show only purchased reservations matching the specified offering identifier.
"""
function describe_reserved_cache_nodes(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeReservedCacheNodes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_reserved_cache_nodes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeReservedCacheNodes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_cache_nodes_offerings()
    describe_reserved_cache_nodes_offerings(params::Dict{String,<:Any})

Lists available reserved cache node offerings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheNodeType"`: The cache node type filter value. Use this parameter to show only the
  available offerings matching the specified cache node type. The following node types are
  supported by ElastiCache. Generally speaking, the current generation types provide more
  memory and computational power at lower cost when compared to their equivalent previous
  generation counterparts.   General purpose:   Current generation:   M7g node types:
  cache.m7g.large, cache.m7g.xlarge, cache.m7g.2xlarge, cache.m7g.4xlarge, cache.m7g.8xlarge,
  cache.m7g.12xlarge, cache.m7g.16xlarge   For region availability, see Supported Node Types
    M6g node types (available only for Redis engine version 5.0.6 onward and for Memcached
  engine version 1.5.16 onward): cache.m6g.large, cache.m6g.xlarge, cache.m6g.2xlarge,
  cache.m6g.4xlarge, cache.m6g.8xlarge, cache.m6g.12xlarge, cache.m6g.16xlarge   M5 node
  types: cache.m5.large, cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge,
  cache.m5.12xlarge, cache.m5.24xlarge   M4 node types: cache.m4.large, cache.m4.xlarge,
  cache.m4.2xlarge, cache.m4.4xlarge, cache.m4.10xlarge   T4g node types (available only for
  Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
  cache.t4g.micro, cache.t4g.small, cache.t4g.medium   T3 node types: cache.t3.micro,
  cache.t3.small, cache.t3.medium   T2 node types: cache.t2.micro, cache.t2.small,
  cache.t2.medium    Previous generation: (not recommended. Existing clusters are still
  supported but creation of new clusters is not supported for these types.)  T1 node types:
  cache.t1.micro   M1 node types: cache.m1.small, cache.m1.medium, cache.m1.large,
  cache.m1.xlarge   M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge,
  cache.m3.2xlarge      Compute optimized:   Previous generation: (not recommended. Existing
  clusters are still supported but creation of new clusters is not supported for these
  types.)  C1 node types: cache.c1.xlarge      Memory optimized:   Current generation:   R7g
  node types: cache.r7g.large, cache.r7g.xlarge, cache.r7g.2xlarge, cache.r7g.4xlarge,
  cache.r7g.8xlarge, cache.r7g.12xlarge, cache.r7g.16xlarge   For region availability, see
  Supported Node Types    R6g node types (available only for Redis engine version 5.0.6
  onward and for Memcached engine version 1.5.16 onward): cache.r6g.large, cache.r6g.xlarge,
  cache.r6g.2xlarge, cache.r6g.4xlarge, cache.r6g.8xlarge, cache.r6g.12xlarge,
  cache.r6g.16xlarge   R5 node types: cache.r5.large, cache.r5.xlarge, cache.r5.2xlarge,
  cache.r5.4xlarge, cache.r5.12xlarge, cache.r5.24xlarge   R4 node types: cache.r4.large,
  cache.r4.xlarge, cache.r4.2xlarge, cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge
  Previous generation: (not recommended. Existing clusters are still supported but creation
  of new clusters is not supported for these types.)  M2 node types: cache.m2.xlarge,
  cache.m2.2xlarge, cache.m2.4xlarge   R3 node types: cache.r3.large, cache.r3.xlarge,
  cache.r3.2xlarge, cache.r3.4xlarge, cache.r3.8xlarge       Additional node type info    All
  current generation instance types are created in Amazon VPC by default.   Redis append-only
  files (AOF) are not supported for T1 or T2 instances.   Redis Multi-AZ with automatic
  failover is not supported on T1 instances.   Redis configuration variables appendonly and
  appendfsync are not supported on Redis version 2.8.22 and later.
- `"Duration"`: Duration filter value, specified in years or seconds. Use this parameter to
  show only reservations for a given duration. Valid Values: 1 | 3 | 31536000 | 94608000
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100.
- `"OfferingType"`: The offering type filter value. Use this parameter to show only the
  available offerings matching the specified offering type. Valid Values: \"Light
  Utilization\"|\"Medium Utilization\"|\"Heavy Utilization\" |\"All Upfront\"|\"Partial
  Upfront\"| \"No Upfront\"
- `"ProductDescription"`: The product description filter value. Use this parameter to show
  only the available offerings matching the specified product description.
- `"ReservedCacheNodesOfferingId"`: The offering identifier filter value. Use this
  parameter to show only the available offering that matches the specified reservation
  identifier. Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
"""
function describe_reserved_cache_nodes_offerings(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeReservedCacheNodesOfferings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_cache_nodes_offerings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeReservedCacheNodesOfferings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_serverless_cache_snapshots()
    describe_serverless_cache_snapshots(params::Dict{String,<:Any})

Returns information about serverless cache snapshots. By default, this API lists all of the
customer’s serverless cache snapshots. It can also describe a single serverless cache
snapshot, or the snapshots associated with a particular serverless cache. Available for
Redis only.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of records to include in the response. If more records
  exist than the specified max-results value, a market is included in the response so that
  remaining results can be retrieved. Available for Redis only.The default is 50. The
  Validation Constraints are a maximum of 50.
- `"NextToken"`: An optional marker returned from a prior request to support pagination of
  results from this operation. If this parameter is specified, the response includes only
  records beyond the marker, up to the value specified by max-results. Available for Redis
  only.
- `"ServerlessCacheName"`: The identifier of serverless cache. If this parameter is
  specified, only snapshots associated with that specific serverless cache are described.
  Available for Redis only.
- `"ServerlessCacheSnapshotName"`: The identifier of the serverless cache’s snapshot. If
  this parameter is specified, only this snapshot is described. Available for Redis only.
- `"SnapshotType"`: The type of snapshot that is being described. Available for Redis only.
"""
function describe_serverless_cache_snapshots(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeServerlessCacheSnapshots";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_serverless_cache_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeServerlessCacheSnapshots",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_serverless_caches()
    describe_serverless_caches(params::Dict{String,<:Any})

Returns information about a specific serverless cache. If no identifier is specified, then
the API returns information on all the serverless caches belonging to this Amazon Web
Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of records in the response. If more records exist than
  the specified max-records value, the next token is included in the response so that
  remaining results can be retrieved. The default is 50.
- `"NextToken"`: An optional marker returned from a prior request to support pagination of
  results from this operation. If this parameter is specified, the response includes only
  records beyond the marker, up to the value specified by MaxResults.
- `"ServerlessCacheName"`: The identifier for the serverless cache. If this parameter is
  specified, only information about that specific serverless cache is returned. Default: NULL
"""
function describe_serverless_caches(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeServerlessCaches"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_serverless_caches(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeServerlessCaches",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_service_updates()
    describe_service_updates(params::Dict{String,<:Any})

Returns details of the service updates

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response
- `"ServiceUpdateName"`: The unique ID of the service update
- `"ServiceUpdateStatus"`: The status of the service update
"""
function describe_service_updates(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeServiceUpdates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_service_updates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeServiceUpdates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_snapshots()
    describe_snapshots(params::Dict{String,<:Any})

Returns information about cluster or replication group snapshots. By default,
DescribeSnapshots lists all of your snapshots; it can optionally describe a single
snapshot, or just the snapshots associated with a particular cache cluster.  This operation
is valid for Redis only.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheClusterId"`: A user-supplied cluster identifier. If this parameter is specified,
  only snapshots associated with that specific cluster are described.
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved. Default: 50 Constraints: minimum 20; maximum 50.
- `"ReplicationGroupId"`: A user-supplied replication group identifier. If this parameter
  is specified, only snapshots associated with that specific replication group are described.
- `"ShowNodeGroupConfig"`: A Boolean value which if true, the node group (shard)
  configuration is included in the snapshot description.
- `"SnapshotName"`: A user-supplied name of the snapshot. If this parameter is specified,
  only this snapshot are described.
- `"SnapshotSource"`: If set to system, the output shows snapshots that were automatically
  created by ElastiCache. If set to user the output shows snapshots that were manually
  created. If omitted, the output shows both automatically and manually created snapshots.
"""
function describe_snapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeSnapshots", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_update_actions()
    describe_update_actions(params::Dict{String,<:Any})

Returns details of the update actions

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheClusterIds"`: The cache cluster IDs
- `"Engine"`: The Elasticache engine to which the update applies. Either Redis or Memcached
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response
- `"ReplicationGroupIds"`: The replication group IDs
- `"ServiceUpdateName"`: The unique ID of the service update
- `"ServiceUpdateStatus"`: The status of the service update
- `"ServiceUpdateTimeRange"`: The range of time specified to search for service updates
  that are in available status
- `"ShowNodeLevelUpdateStatus"`: Dictates whether to include node level update status in
  the response
- `"UpdateActionStatus"`: The status of the update action.
"""
function describe_update_actions(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeUpdateActions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_update_actions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeUpdateActions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_user_groups()
    describe_user_groups(params::Dict{String,<:Any})

Returns a list of user groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords. &gt;
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved.
- `"UserGroupId"`: The ID of the user group.
"""
function describe_user_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeUserGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_user_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeUserGroups", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_users()
    describe_users(params::Dict{String,<:Any})

Returns a list of users.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Engine"`: The Redis engine.
- `"Filters"`: Filter to determine the list of User IDs to return.
- `"Marker"`: An optional marker returned from a prior request. Use this marker for
  pagination of results from this operation. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords. &gt;
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a marker is included in the response so that the
  remaining results can be retrieved.
- `"UserId"`: The ID of the user.
"""
function describe_users(; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "DescribeUsers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_users(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "DescribeUsers", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    disassociate_global_replication_group(global_replication_group_id, replication_group_id, replication_group_region)
    disassociate_global_replication_group(global_replication_group_id, replication_group_id, replication_group_region, params::Dict{String,<:Any})

Remove a secondary cluster from the Global datastore using the Global datastore name. The
secondary cluster will no longer receive updates from the primary cluster, but will remain
as a standalone cluster in that Amazon region.

# Arguments
- `global_replication_group_id`: The name of the Global datastore
- `replication_group_id`: The name of the secondary cluster you wish to remove from the
  Global datastore
- `replication_group_region`: The Amazon region of secondary cluster you wish to remove
  from the Global datastore

"""
function disassociate_global_replication_group(
    GlobalReplicationGroupId,
    ReplicationGroupId,
    ReplicationGroupRegion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DisassociateGlobalReplicationGroup",
        Dict{String,Any}(
            "GlobalReplicationGroupId" => GlobalReplicationGroupId,
            "ReplicationGroupId" => ReplicationGroupId,
            "ReplicationGroupRegion" => ReplicationGroupRegion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_global_replication_group(
    GlobalReplicationGroupId,
    ReplicationGroupId,
    ReplicationGroupRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "DisassociateGlobalReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalReplicationGroupId" => GlobalReplicationGroupId,
                    "ReplicationGroupId" => ReplicationGroupId,
                    "ReplicationGroupRegion" => ReplicationGroupRegion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_serverless_cache_snapshot(s3_bucket_name, serverless_cache_snapshot_name)
    export_serverless_cache_snapshot(s3_bucket_name, serverless_cache_snapshot_name, params::Dict{String,<:Any})

Provides the functionality to export the serverless cache snapshot data to Amazon S3.
Available for Redis only.

# Arguments
- `s3_bucket_name`: Name of the Amazon S3 bucket to export the snapshot to. The Amazon S3
  bucket must also be in same region as the snapshot. Available for Redis only.
- `serverless_cache_snapshot_name`: The identifier of the serverless cache snapshot to be
  exported to S3. Available for Redis only.

"""
function export_serverless_cache_snapshot(
    S3BucketName,
    ServerlessCacheSnapshotName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ExportServerlessCacheSnapshot",
        Dict{String,Any}(
            "S3BucketName" => S3BucketName,
            "ServerlessCacheSnapshotName" => ServerlessCacheSnapshotName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_serverless_cache_snapshot(
    S3BucketName,
    ServerlessCacheSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ExportServerlessCacheSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "S3BucketName" => S3BucketName,
                    "ServerlessCacheSnapshotName" => ServerlessCacheSnapshotName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    failover_global_replication_group(global_replication_group_id, primary_region, primary_replication_group_id)
    failover_global_replication_group(global_replication_group_id, primary_region, primary_replication_group_id, params::Dict{String,<:Any})

Used to failover the primary region to a secondary region. The secondary region will become
primary, and all other clusters will become secondary.

# Arguments
- `global_replication_group_id`: The name of the Global datastore
- `primary_region`: The Amazon region of the primary cluster of the Global datastore
- `primary_replication_group_id`: The name of the primary replication group

"""
function failover_global_replication_group(
    GlobalReplicationGroupId,
    PrimaryRegion,
    PrimaryReplicationGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "FailoverGlobalReplicationGroup",
        Dict{String,Any}(
            "GlobalReplicationGroupId" => GlobalReplicationGroupId,
            "PrimaryRegion" => PrimaryRegion,
            "PrimaryReplicationGroupId" => PrimaryReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function failover_global_replication_group(
    GlobalReplicationGroupId,
    PrimaryRegion,
    PrimaryReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "FailoverGlobalReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalReplicationGroupId" => GlobalReplicationGroupId,
                    "PrimaryRegion" => PrimaryRegion,
                    "PrimaryReplicationGroupId" => PrimaryReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    increase_node_groups_in_global_replication_group(apply_immediately, global_replication_group_id, node_group_count)
    increase_node_groups_in_global_replication_group(apply_immediately, global_replication_group_id, node_group_count, params::Dict{String,<:Any})

Increase the number of node groups in the Global datastore

# Arguments
- `apply_immediately`: Indicates that the process begins immediately. At present, the only
  permitted value for this parameter is true.
- `global_replication_group_id`: The name of the Global datastore
- `node_group_count`: Total number of node groups you want

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RegionalConfigurations"`: Describes the replication group IDs, the Amazon regions where
  they are stored and the shard configuration for each that comprise the Global datastore
"""
function increase_node_groups_in_global_replication_group(
    ApplyImmediately,
    GlobalReplicationGroupId,
    NodeGroupCount;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "IncreaseNodeGroupsInGlobalReplicationGroup",
        Dict{String,Any}(
            "ApplyImmediately" => ApplyImmediately,
            "GlobalReplicationGroupId" => GlobalReplicationGroupId,
            "NodeGroupCount" => NodeGroupCount,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function increase_node_groups_in_global_replication_group(
    ApplyImmediately,
    GlobalReplicationGroupId,
    NodeGroupCount,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "IncreaseNodeGroupsInGlobalReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplyImmediately" => ApplyImmediately,
                    "GlobalReplicationGroupId" => GlobalReplicationGroupId,
                    "NodeGroupCount" => NodeGroupCount,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    increase_replica_count(apply_immediately, replication_group_id)
    increase_replica_count(apply_immediately, replication_group_id, params::Dict{String,<:Any})

Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication
group or the number of replica nodes in one or more node groups (shards) of a Redis
(cluster mode enabled) replication group. This operation is performed with no cluster down
time.

# Arguments
- `apply_immediately`: If True, the number of replica nodes is increased immediately.
  ApplyImmediately=False is not currently supported.
- `replication_group_id`: The id of the replication group to which you want to add replica
  nodes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NewReplicaCount"`: The number of read replica nodes you want at the completion of this
  operation. For Redis (cluster mode disabled) replication groups, this is the number of
  replica nodes in the replication group. For Redis (cluster mode enabled) replication
  groups, this is the number of replica nodes in each of the replication group's node groups.
- `"ReplicaConfiguration"`: A list of ConfigureShard objects that can be used to configure
  each shard in a Redis (cluster mode enabled) replication group. The ConfigureShard has
  three members: NewReplicaCount, NodeGroupId, and PreferredAvailabilityZones.
"""
function increase_replica_count(
    ApplyImmediately, ReplicationGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "IncreaseReplicaCount",
        Dict{String,Any}(
            "ApplyImmediately" => ApplyImmediately,
            "ReplicationGroupId" => ReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function increase_replica_count(
    ApplyImmediately,
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "IncreaseReplicaCount",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplyImmediately" => ApplyImmediately,
                    "ReplicationGroupId" => ReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_allowed_node_type_modifications()
    list_allowed_node_type_modifications(params::Dict{String,<:Any})

Lists all available node types that you can scale your Redis cluster's or replication
group's current node type. When you use the ModifyCacheCluster or ModifyReplicationGroup
operations to scale your cluster or replication group, the value of the CacheNodeType
parameter must be one of the node types returned by this operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheClusterId"`: The name of the cluster you want to scale up to a larger node
  instanced type. ElastiCache uses the cluster id to identify the current node type of this
  cluster and from that to create a list of node types you can scale up to.  You must provide
  a value for either the CacheClusterId or the ReplicationGroupId.
- `"ReplicationGroupId"`: The name of the replication group want to scale up to a larger
  node type. ElastiCache uses the replication group id to identify the current node type
  being used by this replication group, and from that to create a list of node types you can
  scale up to.  You must provide a value for either the CacheClusterId or the
  ReplicationGroupId.
"""
function list_allowed_node_type_modifications(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "ListAllowedNodeTypeModifications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_allowed_node_type_modifications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "ListAllowedNodeTypeModifications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_name)
    list_tags_for_resource(resource_name, params::Dict{String,<:Any})

Lists all tags currently on a named resource.  A tag is a key-value pair where the key and
value are case-sensitive. You can use tags to categorize and track all your ElastiCache
resources, with the exception of global replication group. When you add or remove tags on
replication groups, those actions will be replicated to all nodes in the replication group.
For more information, see Resource-level permissions. If the cluster is not in the
available state, ListTagsForResource returns an error.

# Arguments
- `resource_name`: The Amazon Resource Name (ARN) of the resource for which you want the
  list of tags, for example arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster or
  arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot. For more information about
  ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces.

"""
function list_tags_for_resource(
    ResourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "ListTagsForResource",
        Dict{String,Any}("ResourceName" => ResourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceName" => ResourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cache_cluster(cache_cluster_id)
    modify_cache_cluster(cache_cluster_id, params::Dict{String,<:Any})

Modifies the settings for a cluster. You can use this operation to change one or more
cluster configuration parameters by specifying the parameters and the new values.

# Arguments
- `cache_cluster_id`: The cluster identifier. This value is stored as a lowercase string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AZMode"`: Specifies whether the new nodes in this Memcached cluster are all created in
  a single Availability Zone or created across multiple Availability Zones. Valid values:
  single-az | cross-az. This option is only supported for Memcached clusters.  You cannot
  specify single-az if the Memcached cluster already has cache nodes in different
  Availability Zones. If cross-az is specified, existing Memcached nodes remain in their
  current Availability Zone. Only newly created nodes are located in different Availability
  Zones.
- `"ApplyImmediately"`: If true, this parameter causes the modifications in this request
  and any pending modifications to be applied, asynchronously and as soon as possible,
  regardless of the PreferredMaintenanceWindow setting for the cluster. If false, changes to
  the cluster are applied on the next maintenance reboot, or the next failure reboot,
  whichever occurs first.  If you perform a ModifyCacheCluster before a pending modification
  is applied, the pending modification is replaced by the newer modification.  Valid values:
  true | false  Default: false
- `"AuthToken"`: Reserved parameter. The password used to access a password protected
  server. This parameter must be specified with the auth-token-update parameter. Password
  constraints:   Must be only printable ASCII characters   Must be at least 16 characters and
  no more than 128 characters in length   Cannot contain any of the following characters:
  '/', '\"', or '@', '%'    For more information, see AUTH password at AUTH.
- `"AuthTokenUpdateStrategy"`: Specifies the strategy to use to update the AUTH token. This
  parameter must be specified with the auth-token parameter. Possible values:   ROTATE -
  default, if no update strategy is provided   SET - allowed only after ROTATE   DELETE -
  allowed only when transitioning to RBAC    For more information, see Authenticating Users
  with Redis AUTH
- `"AutoMinorVersionUpgrade"`:  If you are running Redis engine version 6.0 or later, set
  this parameter to yes if you want to opt-in to the next auto minor version upgrade
  campaign. This parameter is disabled for previous versions.
- `"CacheNodeIdsToRemove"`: A list of cache node IDs to be removed. A node ID is a numeric
  identifier (0001, 0002, etc.). This parameter is only valid when NumCacheNodes is less than
  the existing number of cache nodes. The number of cache node IDs supplied in this parameter
  must match the difference between the existing number of cache nodes in the cluster or
  pending cache nodes, whichever is greater, and the value of NumCacheNodes in the request.
  For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of
  cache nodes in this ModifyCacheCluster call is 5, you must list 2 (7 - 5) cache node IDs to
  remove.
- `"CacheNodeType"`: A valid cache node type that you want to scale this cluster up to.
- `"CacheParameterGroupName"`: The name of the cache parameter group to apply to this
  cluster. This change is asynchronously applied as soon as possible for parameters when the
  ApplyImmediately parameter is specified as true for this request.
- `"CacheSecurityGroupNames"`: A list of cache security group names to authorize on this
  cluster. This change is asynchronously applied as soon as possible. You can use this
  parameter only with clusters that are created outside of an Amazon Virtual Private Cloud
  (Amazon VPC). Constraints: Must contain no more than 255 alphanumeric characters. Must not
  be \"Default\".
- `"EngineVersion"`: The upgraded version of the cache engine to be run on the cache nodes.
   Important: You can upgrade to a newer engine version (see Selecting a Cache Engine and
  Version), but you cannot downgrade to an earlier engine version. If you want to use an
  earlier engine version, you must delete the existing cluster and create it anew with the
  earlier engine version.
- `"IpDiscovery"`: The network type you choose when modifying a cluster, either ipv4 |
  ipv6. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
  engine version 1.6.6 on all instances built on the Nitro system.
- `"LogDeliveryConfigurations"`: Specifies the destination, format and type of the logs.
- `"NewAvailabilityZones"`:  This option is only supported on Memcached clusters.  The list
  of Availability Zones where the new Memcached cache nodes are created. This parameter is
  only valid when NumCacheNodes in the request is greater than the sum of the number of
  active cache nodes and the number of cache nodes pending creation (which may be zero). The
  number of Availability Zones supplied in this list must match the cache nodes being added
  in this request. Scenarios:    Scenario 1: You have 3 active nodes and wish to add 2 nodes.
  Specify NumCacheNodes=5 (3 + 2) and optionally specify two Availability Zones for the two
  new nodes.    Scenario 2: You have 3 active nodes and 2 nodes pending creation (from the
  scenario 1 call) and want to add 1 more node. Specify NumCacheNodes=6 ((3 + 2) + 1) and
  optionally specify an Availability Zone for the new node.    Scenario 3: You want to cancel
  all pending operations. Specify NumCacheNodes=3 to cancel all pending operations.   The
  Availability Zone placement of nodes pending creation cannot be modified. If you wish to
  cancel any nodes pending creation, add 0 nodes by setting NumCacheNodes to the number of
  current nodes. If cross-az is specified, existing Memcached nodes remain in their current
  Availability Zone. Only newly created nodes can be located in different Availability Zones.
  For guidance on how to move existing Memcached nodes to different Availability Zones, see
  the Availability Zone Considerations section of Cache Node Considerations for Memcached.
  Impact of new add/remove requests upon pending requests    Scenario-1   Pending Action:
  Delete   New Request: Delete   Result: The new delete, pending or immediate, replaces the
  pending delete.     Scenario-2   Pending Action: Delete   New Request: Create   Result: The
  new create, pending or immediate, replaces the pending delete.     Scenario-3   Pending
  Action: Create   New Request: Delete   Result: The new delete, pending or immediate,
  replaces the pending create.     Scenario-4   Pending Action: Create   New Request: Create
   Result: The new create is added to the pending create.   Important: If the new create
  request is Apply Immediately - Yes, all creates are performed immediately. If the new
  create request is Apply Immediately - No, all creates are pending.
- `"NotificationTopicArn"`: The Amazon Resource Name (ARN) of the Amazon SNS topic to which
  notifications are sent.  The Amazon SNS topic owner must be same as the cluster owner.
- `"NotificationTopicStatus"`: The status of the Amazon SNS notification topic.
  Notifications are sent only if the status is active. Valid values: active | inactive
- `"NumCacheNodes"`: The number of cache nodes that the cluster should have. If the value
  for NumCacheNodes is greater than the sum of the number of current cache nodes and the
  number of cache nodes pending creation (which may be zero), more nodes are added. If the
  value is less than the number of existing cache nodes, nodes are removed. If the value is
  equal to the number of current cache nodes, any pending add or remove requests are
  canceled. If you are removing cache nodes, you must use the CacheNodeIdsToRemove parameter
  to provide the IDs of the specific cache nodes to remove. For clusters running Redis, this
  value must be 1. For clusters running Memcached, this value must be between 1 and 40.
  Adding or removing Memcached cache nodes can be applied immediately or as a pending
  operation (see ApplyImmediately). A pending operation to modify the number of cache nodes
  in a cluster during its maintenance window, whether by adding or removing nodes in
  accordance with the scale out architecture, is not queued. The customer's latest request to
  add or remove nodes to the cluster overrides any previous pending operations to modify the
  number of cache nodes in the cluster. For example, a request to remove 2 nodes would
  override a previous pending operation to remove 3 nodes. Similarly, a request to add 2
  nodes would override a previous pending operation to remove 3 nodes and vice versa. As
  Memcached cache nodes may now be provisioned in different Availability Zones with flexible
  cache node placement, a request to add nodes does not automatically override a previous
  pending operation to add nodes. The customer can modify the previous pending operation to
  add more nodes or explicitly cancel the pending request and retry the new request. To
  cancel pending operations to modify the number of cache nodes in a cluster, use the
  ModifyCacheCluster request and set NumCacheNodes equal to the number of cache nodes
  currently in the cluster.
- `"PreferredMaintenanceWindow"`: Specifies the weekly time range during which maintenance
  on the cluster is performed. It is specified as a range in the format
  ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
  period. Valid values for ddd are:    sun     mon     tue     wed     thu     fri     sat
  Example: sun:23:00-mon:01:30
- `"SecurityGroupIds"`: Specifies the VPC Security Groups associated with the cluster. This
  parameter can be used only with clusters that are created in an Amazon Virtual Private
  Cloud (Amazon VPC).
- `"SnapshotRetentionLimit"`: The number of days for which ElastiCache retains automatic
  cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to
  5, a snapshot that was taken today is retained for 5 days before being deleted.  If the
  value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
- `"SnapshotWindow"`: The daily time range (in UTC) during which ElastiCache begins taking
  a daily snapshot of your cluster.
"""
function modify_cache_cluster(
    CacheClusterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "ModifyCacheCluster",
        Dict{String,Any}("CacheClusterId" => CacheClusterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cache_cluster(
    CacheClusterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyCacheCluster",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CacheClusterId" => CacheClusterId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cache_parameter_group(cache_parameter_group_name, parameter_name_value)
    modify_cache_parameter_group(cache_parameter_group_name, parameter_name_value, params::Dict{String,<:Any})

Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a
single request by submitting a list parameter name and value pairs.

# Arguments
- `cache_parameter_group_name`: The name of the cache parameter group to modify.
- `parameter_name_value`: An array of parameter names and values for the parameter update.
  You must supply at least one parameter name and value; subsequent arguments are optional. A
  maximum of 20 parameters may be modified per request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ParameterNameValues"`: An array of parameter names and values for the parameter update.
  You must supply at least one parameter name and value; subsequent arguments are optional. A
  maximum of 20 parameters may be modified per request.
"""
function modify_cache_parameter_group(
    CacheParameterGroupName,
    ParameterNameValue;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyCacheParameterGroup",
        Dict{String,Any}(
            "CacheParameterGroupName" => CacheParameterGroupName,
            "ParameterNameValue" => ParameterNameValue,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cache_parameter_group(
    CacheParameterGroupName,
    ParameterNameValue,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyCacheParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CacheParameterGroupName" => CacheParameterGroupName,
                    "ParameterNameValue" => ParameterNameValue,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_cache_subnet_group(cache_subnet_group_name)
    modify_cache_subnet_group(cache_subnet_group_name, params::Dict{String,<:Any})

Modifies an existing cache subnet group.

# Arguments
- `cache_subnet_group_name`: The name for the cache subnet group. This value is stored as a
  lowercase string. Constraints: Must contain no more than 255 alphanumeric characters or
  hyphens. Example: mysubnetgroup

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheSubnetGroupDescription"`: A description of the cache subnet group.
- `"SubnetIds"`: The EC2 subnet IDs for the cache subnet group.
"""
function modify_cache_subnet_group(
    CacheSubnetGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "ModifyCacheSubnetGroup",
        Dict{String,Any}("CacheSubnetGroupName" => CacheSubnetGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_cache_subnet_group(
    CacheSubnetGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyCacheSubnetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CacheSubnetGroupName" => CacheSubnetGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_global_replication_group(apply_immediately, global_replication_group_id)
    modify_global_replication_group(apply_immediately, global_replication_group_id, params::Dict{String,<:Any})

Modifies the settings for a Global datastore.

# Arguments
- `apply_immediately`: This parameter causes the modifications in this request and any
  pending modifications to be applied, asynchronously and as soon as possible. Modifications
  to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow.
- `global_replication_group_id`: The name of the Global datastore

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AutomaticFailoverEnabled"`: Determines whether a read replica is automatically promoted
  to read/write primary if the existing primary encounters a failure.
- `"CacheNodeType"`: A valid cache node type that you want to scale this Global datastore
  to.
- `"CacheParameterGroupName"`: The name of the cache parameter group to use with the Global
  datastore. It must be compatible with the major engine version used by the Global datastore.
- `"EngineVersion"`: The upgraded version of the cache engine to be run on the clusters in
  the Global datastore.
- `"GlobalReplicationGroupDescription"`: A description of the Global datastore
"""
function modify_global_replication_group(
    ApplyImmediately,
    GlobalReplicationGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyGlobalReplicationGroup",
        Dict{String,Any}(
            "ApplyImmediately" => ApplyImmediately,
            "GlobalReplicationGroupId" => GlobalReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_global_replication_group(
    ApplyImmediately,
    GlobalReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyGlobalReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplyImmediately" => ApplyImmediately,
                    "GlobalReplicationGroupId" => GlobalReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_replication_group(replication_group_id)
    modify_replication_group(replication_group_id, params::Dict{String,<:Any})

Modifies the settings for a replication group. This is limited to Redis 7 and newer.
Scaling for Amazon ElastiCache for Redis (cluster mode enabled) in the ElastiCache User
Guide    ModifyReplicationGroupShardConfiguration in the ElastiCache API Reference    This
operation is valid for Redis only.

# Arguments
- `replication_group_id`: The identifier of the replication group to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplyImmediately"`: If true, this parameter causes the modifications in this request
  and any pending modifications to be applied, asynchronously and as soon as possible,
  regardless of the PreferredMaintenanceWindow setting for the replication group. If false,
  changes to the nodes in the replication group are applied on the next maintenance reboot,
  or the next failure reboot, whichever occurs first. Valid values: true | false  Default:
  false
- `"AuthToken"`: Reserved parameter. The password used to access a password protected
  server. This parameter must be specified with the auth-token-update-strategy  parameter.
  Password constraints:   Must be only printable ASCII characters   Must be at least 16
  characters and no more than 128 characters in length   Cannot contain any of the following
  characters: '/', '\"', or '@', '%'    For more information, see AUTH password at AUTH.
- `"AuthTokenUpdateStrategy"`: Specifies the strategy to use to update the AUTH token. This
  parameter must be specified with the auth-token parameter. Possible values:   ROTATE -
  default, if no update strategy is provided   SET - allowed only after ROTATE   DELETE -
  allowed only when transitioning to RBAC    For more information, see Authenticating Users
  with Redis AUTH
- `"AutoMinorVersionUpgrade"`:  If you are running Redis engine version 6.0 or later, set
  this parameter to yes if you want to opt-in to the next auto minor version upgrade
  campaign. This parameter is disabled for previous versions.
- `"AutomaticFailoverEnabled"`: Determines whether a read replica is automatically promoted
  to read/write primary if the existing primary encounters a failure. Valid values: true |
  false
- `"CacheNodeType"`: A valid cache node type that you want to scale this replication group
  to.
- `"CacheParameterGroupName"`: The name of the cache parameter group to apply to all of the
  clusters in this replication group. This change is asynchronously applied as soon as
  possible for parameters when the ApplyImmediately parameter is specified as true for this
  request.
- `"CacheSecurityGroupNames"`: A list of cache security group names to authorize for the
  clusters in this replication group. This change is asynchronously applied as soon as
  possible. This parameter can be used only with replication group containing clusters
  running outside of an Amazon Virtual Private Cloud (Amazon VPC). Constraints: Must contain
  no more than 255 alphanumeric characters. Must not be Default.
- `"ClusterMode"`: Enabled or Disabled. To modify cluster mode from Disabled to Enabled,
  you must first set the cluster mode to Compatible. Compatible mode allows your Redis
  clients to connect using both cluster mode enabled and cluster mode disabled. After you
  migrate all Redis clients to use cluster mode enabled, you can then complete cluster mode
  configuration and set the cluster mode to Enabled.
- `"EngineVersion"`: The upgraded version of the cache engine to be run on the clusters in
  the replication group.  Important: You can upgrade to a newer engine version (see Selecting
  a Cache Engine and Version), but you cannot downgrade to an earlier engine version. If you
  want to use an earlier engine version, you must delete the existing replication group and
  create it anew with the earlier engine version.
- `"IpDiscovery"`: The network type you choose when modifying a cluster, either ipv4 |
  ipv6. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
  engine version 1.6.6 on all instances built on the Nitro system.
- `"LogDeliveryConfigurations"`: Specifies the destination, format and type of the logs.
- `"MultiAZEnabled"`: A flag to indicate MultiAZ is enabled.
- `"NodeGroupId"`: Deprecated. This parameter is not used.
- `"NotificationTopicArn"`: The Amazon Resource Name (ARN) of the Amazon SNS topic to which
  notifications are sent.  The Amazon SNS topic owner must be same as the replication group
  owner.
- `"NotificationTopicStatus"`: The status of the Amazon SNS notification topic for the
  replication group. Notifications are sent only if the status is active. Valid values:
  active | inactive
- `"PreferredMaintenanceWindow"`: Specifies the weekly time range during which maintenance
  on the cluster is performed. It is specified as a range in the format
  ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
  period. Valid values for ddd are:    sun     mon     tue     wed     thu     fri     sat
  Example: sun:23:00-mon:01:30
- `"PrimaryClusterId"`: For replication groups with a single primary, if this parameter is
  specified, ElastiCache promotes the specified cluster in the specified replication group to
  the primary role. The nodes of all other clusters in the replication group are read
  replicas.
- `"RemoveUserGroups"`: Removes the user group associated with this replication group.
- `"ReplicationGroupDescription"`: A description for the replication group. Maximum length
  is 255 characters.
- `"SecurityGroupIds"`: Specifies the VPC Security Groups associated with the clusters in
  the replication group. This parameter can be used only with replication group containing
  clusters running in an Amazon Virtual Private Cloud (Amazon VPC).
- `"SnapshotRetentionLimit"`: The number of days for which ElastiCache retains automatic
  node group (shard) snapshots before deleting them. For example, if you set
  SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before
  being deleted.  Important If the value of SnapshotRetentionLimit is set to zero (0),
  backups are turned off.
- `"SnapshotWindow"`: The daily time range (in UTC) during which ElastiCache begins taking
  a daily snapshot of the node group (shard) specified by SnapshottingClusterId. Example:
  05:00-09:00  If you do not specify this parameter, ElastiCache automatically chooses an
  appropriate time range.
- `"SnapshottingClusterId"`: The cluster ID that is used as the daily snapshot source for
  the replication group. This parameter cannot be set for Redis (cluster mode enabled)
  replication groups.
- `"TransitEncryptionEnabled"`: A flag that enables in-transit encryption when set to true.
  If you are enabling in-transit encryption for an existing cluster, you must also set
  TransitEncryptionMode to preferred.
- `"TransitEncryptionMode"`: A setting that allows you to migrate your clients to use
  in-transit encryption, with no downtime. You must set TransitEncryptionEnabled to true, for
  your existing cluster, and set TransitEncryptionMode to preferred in the same request to
  allow both encrypted and unencrypted connections at the same time. Once you migrate all
  your Redis clients to use encrypted connections you can set the value to required to allow
  encrypted connections only. Setting TransitEncryptionMode to required is a two-step process
  that requires you to first set the TransitEncryptionMode to preferred, after that you can
  set TransitEncryptionMode to required.
- `"UserGroupIdsToAdd"`: The ID of the user group you are associating with the replication
  group.
- `"UserGroupIdsToRemove"`: The ID of the user group to disassociate from the replication
  group, meaning the users in the group no longer can access the replication group.
"""
function modify_replication_group(
    ReplicationGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "ModifyReplicationGroup",
        Dict{String,Any}("ReplicationGroupId" => ReplicationGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_replication_group(
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ReplicationGroupId" => ReplicationGroupId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_replication_group_shard_configuration(apply_immediately, node_group_count, replication_group_id)
    modify_replication_group_shard_configuration(apply_immediately, node_group_count, replication_group_id, params::Dict{String,<:Any})

Modifies a replication group's shards (node groups) by allowing you to add shards, remove
shards, or rebalance the keyspaces among existing shards.

# Arguments
- `apply_immediately`: Indicates that the shard reconfiguration process begins immediately.
  At present, the only permitted value for this parameter is true. Value: true
- `node_group_count`: The number of node groups (shards) that results from the modification
  of the shard configuration.
- `replication_group_id`: The name of the Redis (cluster mode enabled) cluster (replication
  group) on which the shards are to be configured.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NodeGroupsToRemove"`: If the value of NodeGroupCount is less than the current number of
  node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required.
  NodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for
  Redis will attempt to remove all node groups listed by NodeGroupsToRemove from the cluster.
- `"NodeGroupsToRetain"`: If the value of NodeGroupCount is less than the current number of
  node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required.
  NodeGroupsToRetain is a list of NodeGroupIds to retain in the cluster. ElastiCache for
  Redis will attempt to remove all node groups except those listed by NodeGroupsToRetain from
  the cluster.
- `"ReshardingConfiguration"`: Specifies the preferred availability zones for each node
  group in the cluster. If the value of NodeGroupCount is greater than the current number of
  node groups (shards), you can use this parameter to specify the preferred availability
  zones of the cluster's shards. If you omit this parameter ElastiCache selects availability
  zones for you. You can specify this parameter only if the value of NodeGroupCount is
  greater than the current number of node groups (shards).
"""
function modify_replication_group_shard_configuration(
    ApplyImmediately,
    NodeGroupCount,
    ReplicationGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyReplicationGroupShardConfiguration",
        Dict{String,Any}(
            "ApplyImmediately" => ApplyImmediately,
            "NodeGroupCount" => NodeGroupCount,
            "ReplicationGroupId" => ReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_replication_group_shard_configuration(
    ApplyImmediately,
    NodeGroupCount,
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyReplicationGroupShardConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplyImmediately" => ApplyImmediately,
                    "NodeGroupCount" => NodeGroupCount,
                    "ReplicationGroupId" => ReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_serverless_cache(serverless_cache_name)
    modify_serverless_cache(serverless_cache_name, params::Dict{String,<:Any})

This API modifies the attributes of a serverless cache.

# Arguments
- `serverless_cache_name`: User-provided identifier for the serverless cache to be modified.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheUsageLimits"`: Modify the cache usage limit for the serverless cache.
- `"DailySnapshotTime"`: The daily time during which Elasticache begins taking a daily
  snapshot of the serverless cache. Available for Redis only. The default is NULL, i.e. the
  existing snapshot time configured for the cluster is not removed.
- `"Description"`: User provided description for the serverless cache. Default = NULL, i.e.
  the existing description is not removed/modified. The description has a maximum length of
  255 characters.
- `"RemoveUserGroup"`: The identifier of the UserGroup to be removed from association with
  the Redis serverless cache. Available for Redis only. Default is NULL.
- `"SecurityGroupIds"`: The new list of VPC security groups to be associated with the
  serverless cache. Populating this list means the current VPC security groups will be
  removed. This security group is used to authorize traffic access for the VPC end-point
  (private-link). Default = NULL - the existing list of VPC security groups is not removed.
- `"SnapshotRetentionLimit"`: The number of days for which Elasticache retains automatic
  snapshots before deleting them. Available for Redis only. Default = NULL, i.e. the existing
  snapshot-retention-limit will not be removed or modified. The maximum value allowed is 35
  days.
- `"UserGroupId"`: The identifier of the UserGroup to be associated with the serverless
  cache. Available for Redis only. Default is NULL - the existing UserGroup is not removed.
"""
function modify_serverless_cache(
    ServerlessCacheName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "ModifyServerlessCache",
        Dict{String,Any}("ServerlessCacheName" => ServerlessCacheName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_serverless_cache(
    ServerlessCacheName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyServerlessCache",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerlessCacheName" => ServerlessCacheName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_user(user_id)
    modify_user(user_id, params::Dict{String,<:Any})

Changes user password(s) and/or access string.

# Arguments
- `user_id`: The ID of the user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessString"`: Access permissions string used for this user.
- `"AppendAccessString"`: Adds additional user permissions to the access string.
- `"AuthenticationMode"`: Specifies how to authenticate the user.
- `"NoPasswordRequired"`: Indicates no password is required for the user.
- `"Passwords"`: The passwords belonging to the user. You are allowed up to two.
"""
function modify_user(UserId; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "ModifyUser",
        Dict{String,Any}("UserId" => UserId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_user(
    UserId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "ModifyUser",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("UserId" => UserId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_user_group(user_group_id)
    modify_user_group(user_group_id, params::Dict{String,<:Any})

Changes the list of users that belong to the user group.

# Arguments
- `user_group_id`: The ID of the user group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserIdsToAdd"`: The list of user IDs to add to the user group.
- `"UserIdsToRemove"`: The list of user IDs to remove from the user group.
"""
function modify_user_group(UserGroupId; aws_config::AbstractAWSConfig=current_aws_config())
    return elasticache(
        "ModifyUserGroup",
        Dict{String,Any}("UserGroupId" => UserGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_user_group(
    UserGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ModifyUserGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserGroupId" => UserGroupId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    purchase_reserved_cache_nodes_offering(reserved_cache_nodes_offering_id)
    purchase_reserved_cache_nodes_offering(reserved_cache_nodes_offering_id, params::Dict{String,<:Any})

Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for
cancellation and are non-refundable. For more information, see Managing Costs with Reserved
Nodes for Redis or Managing Costs with Reserved Nodes for Memcached.

# Arguments
- `reserved_cache_nodes_offering_id`: The ID of the reserved cache node offering to
  purchase. Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheNodeCount"`: The number of cache node instances to reserve. Default: 1
- `"ReservedCacheNodeId"`: A customer-specified identifier to track this reservation.  The
  Reserved Cache Node ID is an unique customer-specified identifier to track this
  reservation. If this parameter is not specified, ElastiCache automatically generates an
  identifier for the reservation.  Example: myreservationID
- `"Tags"`: A list of tags to be added to this resource. A tag is a key-value pair. A tag
  key must be accompanied by a tag value, although null is accepted.
"""
function purchase_reserved_cache_nodes_offering(
    ReservedCacheNodesOfferingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "PurchaseReservedCacheNodesOffering",
        Dict{String,Any}("ReservedCacheNodesOfferingId" => ReservedCacheNodesOfferingId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function purchase_reserved_cache_nodes_offering(
    ReservedCacheNodesOfferingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "PurchaseReservedCacheNodesOffering",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ReservedCacheNodesOfferingId" => ReservedCacheNodesOfferingId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    rebalance_slots_in_global_replication_group(apply_immediately, global_replication_group_id)
    rebalance_slots_in_global_replication_group(apply_immediately, global_replication_group_id, params::Dict{String,<:Any})

Redistribute slots to ensure uniform distribution across existing shards in the cluster.

# Arguments
- `apply_immediately`: If True, redistribution is applied immediately.
- `global_replication_group_id`: The name of the Global datastore

"""
function rebalance_slots_in_global_replication_group(
    ApplyImmediately,
    GlobalReplicationGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "RebalanceSlotsInGlobalReplicationGroup",
        Dict{String,Any}(
            "ApplyImmediately" => ApplyImmediately,
            "GlobalReplicationGroupId" => GlobalReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function rebalance_slots_in_global_replication_group(
    ApplyImmediately,
    GlobalReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "RebalanceSlotsInGlobalReplicationGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplyImmediately" => ApplyImmediately,
                    "GlobalReplicationGroupId" => GlobalReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_cache_cluster(cache_cluster_id, cache_node_id)
    reboot_cache_cluster(cache_cluster_id, cache_node_id, params::Dict{String,<:Any})

Reboots some, or all, of the cache nodes within a provisioned cluster. This operation
applies any modified cache parameter groups to the cluster. The reboot operation takes
place as soon as possible, and results in a momentary outage to the cluster. During the
reboot, the cluster status is set to REBOOTING. The reboot causes the contents of the cache
(for each cache node being rebooted) to be lost. When the reboot is complete, a cluster
event is created. Rebooting a cluster is currently supported on Memcached and Redis
(cluster mode disabled) clusters. Rebooting is not supported on Redis (cluster mode
enabled) clusters. If you make changes to parameters that require a Redis (cluster mode
enabled) cluster reboot for the changes to be applied, see Rebooting a Cluster for an
alternate process.

# Arguments
- `cache_cluster_id`: The cluster identifier. This parameter is stored as a lowercase
  string.
- `cache_node_id`: A list of cache node IDs to reboot. A node ID is a numeric identifier
  (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CacheNodeIdsToReboot"`: A list of cache node IDs to reboot. A node ID is a numeric
  identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node
  IDs.
"""
function reboot_cache_cluster(
    CacheClusterId, CacheNodeId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "RebootCacheCluster",
        Dict{String,Any}("CacheClusterId" => CacheClusterId, "CacheNodeId" => CacheNodeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_cache_cluster(
    CacheClusterId,
    CacheNodeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "RebootCacheCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CacheClusterId" => CacheClusterId, "CacheNodeId" => CacheNodeId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_tags_from_resource(resource_name, tag_keys)
    remove_tags_from_resource(resource_name, tag_keys, params::Dict{String,<:Any})

Removes the tags identified by the TagKeys list from the named resource. A tag is a
key-value pair where the key and value are case-sensitive. You can use tags to categorize
and track all your ElastiCache resources, with the exception of global replication group.
When you add or remove tags on replication groups, those actions will be replicated to all
nodes in the replication group. For more information, see Resource-level permissions.

# Arguments
- `resource_name`: The Amazon Resource Name (ARN) of the resource from which you want the
  tags removed, for example arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster or
  arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot. For more information about
  ARNs, see Amazon Resource Names (ARNs) and Amazon Service Namespaces.
- `tag_keys`: A list of TagKeys identifying the tags you want removed from the named
  resource.

"""
function remove_tags_from_resource(
    ResourceName, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "RemoveTagsFromResource",
        Dict{String,Any}("ResourceName" => ResourceName, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_tags_from_resource(
    ResourceName,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "RemoveTagsFromResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceName" => ResourceName, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_cache_parameter_group(cache_parameter_group_name)
    reset_cache_parameter_group(cache_parameter_group_name, params::Dict{String,<:Any})

Modifies the parameters of a cache parameter group to the engine or system default value.
You can reset specific parameters by submitting a list of parameter names. To reset the
entire cache parameter group, specify the ResetAllParameters and CacheParameterGroupName
parameters.

# Arguments
- `cache_parameter_group_name`: The name of the cache parameter group to reset.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ParameterNameValues"`: An array of parameter names to reset to their default values. If
  ResetAllParameters is true, do not use ParameterNameValues. If ResetAllParameters is false,
  you must specify the name of at least one parameter to reset.
- `"ResetAllParameters"`: If true, all parameters in the cache parameter group are reset to
  their default values. If false, only the parameters listed by ParameterNameValues are reset
  to their default values. Valid values: true | false
"""
function reset_cache_parameter_group(
    CacheParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "ResetCacheParameterGroup",
        Dict{String,Any}("CacheParameterGroupName" => CacheParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_cache_parameter_group(
    CacheParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "ResetCacheParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CacheParameterGroupName" => CacheParameterGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_cache_security_group_ingress(cache_security_group_name, ec2_security_group_name, ec2_security_group_owner_id)
    revoke_cache_security_group_ingress(cache_security_group_name, ec2_security_group_name, ec2_security_group_owner_id, params::Dict{String,<:Any})

Revokes ingress from a cache security group. Use this operation to disallow access from an
Amazon EC2 security group that had been previously authorized.

# Arguments
- `cache_security_group_name`: The name of the cache security group to revoke ingress from.
- `ec2_security_group_name`: The name of the Amazon EC2 security group to revoke access
  from.
- `ec2_security_group_owner_id`: The Amazon account number of the Amazon EC2 security group
  owner. Note that this is not the same thing as an Amazon access key ID - you must provide a
  valid Amazon account number for this parameter.

"""
function revoke_cache_security_group_ingress(
    CacheSecurityGroupName,
    EC2SecurityGroupName,
    EC2SecurityGroupOwnerId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "RevokeCacheSecurityGroupIngress",
        Dict{String,Any}(
            "CacheSecurityGroupName" => CacheSecurityGroupName,
            "EC2SecurityGroupName" => EC2SecurityGroupName,
            "EC2SecurityGroupOwnerId" => EC2SecurityGroupOwnerId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function revoke_cache_security_group_ingress(
    CacheSecurityGroupName,
    EC2SecurityGroupName,
    EC2SecurityGroupOwnerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "RevokeCacheSecurityGroupIngress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CacheSecurityGroupName" => CacheSecurityGroupName,
                    "EC2SecurityGroupName" => EC2SecurityGroupName,
                    "EC2SecurityGroupOwnerId" => EC2SecurityGroupOwnerId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_migration(customer_node_endpoint_list, replication_group_id)
    start_migration(customer_node_endpoint_list, replication_group_id, params::Dict{String,<:Any})

Start the migration of data.

# Arguments
- `customer_node_endpoint_list`: List of endpoints from which data should be migrated. For
  Redis (cluster mode disabled), list should have only one element.
- `replication_group_id`: The ID of the replication group to which data should be migrated.

"""
function start_migration(
    CustomerNodeEndpointList,
    ReplicationGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "StartMigration",
        Dict{String,Any}(
            "CustomerNodeEndpointList" => CustomerNodeEndpointList,
            "ReplicationGroupId" => ReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_migration(
    CustomerNodeEndpointList,
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "StartMigration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CustomerNodeEndpointList" => CustomerNodeEndpointList,
                    "ReplicationGroupId" => ReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_failover(node_group_id, replication_group_id)
    test_failover(node_group_id, replication_group_id, params::Dict{String,<:Any})

Represents the input of a TestFailover operation which tests automatic failover on a
specified node group (called shard in the console) in a replication group (called cluster
in the console). This API is designed for testing the behavior of your application in case
of ElastiCache failover. It is not designed to be an operational tool for initiating a
failover to overcome a problem you may have with the cluster. Moreover, in certain
conditions such as large-scale operational events, Amazon may block this API.   Note the
following    A customer can use this operation to test automatic failover on up to 15
shards (called node groups in the ElastiCache API and Amazon CLI) in any rolling 24-hour
period.   If calling this operation on shards in different clusters (called replication
groups in the API and CLI), the calls can be made concurrently.     If calling this
operation multiple times on different shards in the same Redis (cluster mode enabled)
replication group, the first node replacement must complete before a subsequent call can be
made.   To determine whether the node replacement is complete you can check Events using
the Amazon ElastiCache console, the Amazon CLI, or the ElastiCache API. Look for the
following automatic failover related events, listed here in order of occurrance:
Replication group message: Test Failover API called for node group &lt;node-group-id&gt;
Cache cluster message: Failover from primary node &lt;primary-node-id&gt; to replica node
&lt;node-id&gt; completed    Replication group message: Failover from primary node
&lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed    Cache cluster message:
Recovering cache nodes &lt;node-id&gt;    Cache cluster message: Finished recovery for
cache nodes &lt;node-id&gt;    For more information see:    Viewing ElastiCache Events in
the ElastiCache User Guide     DescribeEvents in the ElastiCache API Reference     Also
see, Testing Multi-AZ  in the ElastiCache User Guide.

# Arguments
- `node_group_id`: The name of the node group (called shard in the console) in this
  replication group on which automatic failover is to be tested. You may test automatic
  failover on up to 15 node groups in any rolling 24-hour period.
- `replication_group_id`: The name of the replication group (console: cluster) whose
  automatic failover is being tested by this operation.

"""
function test_failover(
    NodeGroupId, ReplicationGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return elasticache(
        "TestFailover",
        Dict{String,Any}(
            "NodeGroupId" => NodeGroupId, "ReplicationGroupId" => ReplicationGroupId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_failover(
    NodeGroupId,
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "TestFailover",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "NodeGroupId" => NodeGroupId, "ReplicationGroupId" => ReplicationGroupId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_migration(customer_node_endpoint_list, replication_group_id)
    test_migration(customer_node_endpoint_list, replication_group_id, params::Dict{String,<:Any})

 Async API to test connection between source and target replication group.

# Arguments
- `customer_node_endpoint_list`:  List of endpoints from which data should be migrated.
  List should have only one element.
- `replication_group_id`:  The ID of the replication group to which data is to be migrated.

"""
function test_migration(
    CustomerNodeEndpointList,
    ReplicationGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "TestMigration",
        Dict{String,Any}(
            "CustomerNodeEndpointList" => CustomerNodeEndpointList,
            "ReplicationGroupId" => ReplicationGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_migration(
    CustomerNodeEndpointList,
    ReplicationGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return elasticache(
        "TestMigration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CustomerNodeEndpointList" => CustomerNodeEndpointList,
                    "ReplicationGroupId" => ReplicationGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
