# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: m2
using AWS.Compat
using AWS.UUIDs

"""
    cancel_batch_job_execution(application_id, execution_id)
    cancel_batch_job_execution(application_id, execution_id, params::Dict{String,<:Any})

Cancels the running of a specific batch job execution.

# Arguments
- `application_id`: The unique identifier of the application.
- `execution_id`: The unique identifier of the batch job execution.

"""
function cancel_batch_job_execution(
    applicationId, executionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "POST",
        "/applications/$(applicationId)/batch-job-executions/$(executionId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_batch_job_execution(
    applicationId,
    executionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/applications/$(applicationId)/batch-job-executions/$(executionId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_application(definition, engine_type, name)
    create_application(definition, engine_type, name, params::Dict{String,<:Any})

Creates a new application with given parameters. Requires an existing runtime environment
and application definition file.

# Arguments
- `definition`: The application definition for this application. You can specify either
  inline JSON or an S3 bucket location.
- `engine_type`: The type of the target platform for this application.
- `name`: The unique identifier of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier the service generates to ensure the
  idempotency of the request to create an application. The service generates the clientToken
  when the API call is triggered. The token expires after one hour, so if you retry the API
  within this timeframe with the same clientToken, you will get the same response. The
  service also handles deleting the clientToken after it expires.
- `"description"`: The description of the application.
- `"kmsKeyId"`: The identifier of a customer managed key.
- `"roleArn"`: The Amazon Resource Name (ARN) that identifies a role that the application
  uses to access Amazon Web Services resources that are not part of the application or are in
  a different Amazon Web Services account.
- `"tags"`: A list of tags to apply to the application.
"""
function create_application(
    definition, engineType, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "POST",
        "/applications",
        Dict{String,Any}(
            "definition" => definition,
            "engineType" => engineType,
            "name" => name,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application(
    definition,
    engineType,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/applications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "definition" => definition,
                    "engineType" => engineType,
                    "name" => name,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_data_set_import_task(application_id, import_config)
    create_data_set_import_task(application_id, import_config, params::Dict{String,<:Any})

Starts a data set import task for a specific application.

# Arguments
- `application_id`: The unique identifier of the application for which you want to import
  data sets.
- `import_config`: The data set import task configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`:  Unique, case-sensitive identifier you provide to ensure the idempotency
  of the request to create a data set import. The service generates the clientToken when the
  API call is triggered. The token expires after one hour, so if you retry the API within
  this timeframe with the same clientToken, you will get the same response. The service also
  handles deleting the clientToken after it expires.
"""
function create_data_set_import_task(
    applicationId, importConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "POST",
        "/applications/$(applicationId)/dataset-import-task",
        Dict{String,Any}("importConfig" => importConfig, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_data_set_import_task(
    applicationId,
    importConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/applications/$(applicationId)/dataset-import-task",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "importConfig" => importConfig, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_deployment(application_id, application_version, environment_id)
    create_deployment(application_id, application_version, environment_id, params::Dict{String,<:Any})

Creates and starts a deployment to deploy an application into a runtime environment.

# Arguments
- `application_id`: The application identifier.
- `application_version`: The version of the application to deploy.
- `environment_id`: The identifier of the runtime environment where you want to deploy this
  application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier you provide to ensure the idempotency
  of the request to create a deployment. The service generates the clientToken when the API
  call is triggered. The token expires after one hour, so if you retry the API within this
  timeframe with the same clientToken, you will get the same response. The service also
  handles deleting the clientToken after it expires.
"""
function create_deployment(
    applicationId,
    applicationVersion,
    environmentId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/applications/$(applicationId)/deployments",
        Dict{String,Any}(
            "applicationVersion" => applicationVersion,
            "environmentId" => environmentId,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_deployment(
    applicationId,
    applicationVersion,
    environmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/applications/$(applicationId)/deployments",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "applicationVersion" => applicationVersion,
                    "environmentId" => environmentId,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_environment(engine_type, instance_type, name)
    create_environment(engine_type, instance_type, name, params::Dict{String,<:Any})

Creates a runtime environment for a given runtime engine.

# Arguments
- `engine_type`: The engine type for the runtime environment.
- `instance_type`: The type of instance for the runtime environment.
- `name`: The name of the runtime environment. Must be unique within the account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier you provide to ensure the idempotency
  of the request to create an environment. The service generates the clientToken when the API
  call is triggered. The token expires after one hour, so if you retry the API within this
  timeframe with the same clientToken, you will get the same response. The service also
  handles deleting the clientToken after it expires.
- `"description"`: The description of the runtime environment.
- `"engineVersion"`: The version of the engine type for the runtime environment.
- `"highAvailabilityConfig"`: The details of a high availability configuration for this
  runtime environment.
- `"kmsKeyId"`: The identifier of a customer managed key.
- `"preferredMaintenanceWindow"`: Configures the maintenance window that you want for the
  runtime environment. The maintenance window must have the format ddd:hh24:mi-ddd:hh24:mi
  and must be less than 24 hours. The following two examples are valid maintenance windows:
  sun:23:45-mon:00:15 or sat:01:00-sat:03:00.  If you do not provide a value, a random
  system-generated value will be assigned.
- `"publiclyAccessible"`: Specifies whether the runtime environment is publicly accessible.
- `"securityGroupIds"`: The list of security groups for the VPC associated with this
  runtime environment.
- `"storageConfigurations"`: Optional. The storage configurations for this runtime
  environment.
- `"subnetIds"`: The list of subnets associated with the VPC for this runtime environment.
- `"tags"`: The tags for the runtime environment.
"""
function create_environment(
    engineType, instanceType, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "POST",
        "/environments",
        Dict{String,Any}(
            "engineType" => engineType,
            "instanceType" => instanceType,
            "name" => name,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_environment(
    engineType,
    instanceType,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/environments",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "engineType" => engineType,
                    "instanceType" => instanceType,
                    "name" => name,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application(application_id)
    delete_application(application_id, params::Dict{String,<:Any})

Deletes a specific application. You cannot delete a running application.

# Arguments
- `application_id`: The unique identifier of the application you want to delete.

"""
function delete_application(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "DELETE",
        "/applications/$(applicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "DELETE",
        "/applications/$(applicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_from_environment(application_id, environment_id)
    delete_application_from_environment(application_id, environment_id, params::Dict{String,<:Any})

Deletes a specific application from the specific runtime environment where it was
previously deployed. You cannot delete a runtime environment using DeleteEnvironment if any
application has ever been deployed to it. This API removes the association of the
application with the runtime environment so you can delete the environment smoothly.

# Arguments
- `application_id`: The unique identifier of the application you want to delete.
- `environment_id`: The unique identifier of the runtime environment where the application
  was previously deployed.

"""
function delete_application_from_environment(
    applicationId, environmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "DELETE",
        "/applications/$(applicationId)/environment/$(environmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_from_environment(
    applicationId,
    environmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "DELETE",
        "/applications/$(applicationId)/environment/$(environmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_environment(environment_id)
    delete_environment(environment_id, params::Dict{String,<:Any})

Deletes a specific runtime environment. The environment cannot contain deployed
applications. If it does, you must delete those applications before you delete the
environment.

# Arguments
- `environment_id`: The unique identifier of the runtime environment you want to delete.

"""
function delete_environment(
    environmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "DELETE",
        "/environments/$(environmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_environment(
    environmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "DELETE",
        "/environments/$(environmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_application(application_id)
    get_application(application_id, params::Dict{String,<:Any})

Describes the details of a specific application.

# Arguments
- `application_id`: The identifier of the application.

"""
function get_application(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "GET",
        "/applications/$(applicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_application_version(application_id, application_version)
    get_application_version(application_id, application_version, params::Dict{String,<:Any})

Returns details about a specific version of a specific application.

# Arguments
- `application_id`: The unique identifier of the application.
- `application_version`: The specific version of the application.

"""
function get_application_version(
    applicationId, applicationVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/versions/$(applicationVersion)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_application_version(
    applicationId,
    applicationVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/versions/$(applicationVersion)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_batch_job_execution(application_id, execution_id)
    get_batch_job_execution(application_id, execution_id, params::Dict{String,<:Any})

Gets the details of a specific batch job execution for a specific application.

# Arguments
- `application_id`: The identifier of the application.
- `execution_id`: The unique identifier of the batch job execution.

"""
function get_batch_job_execution(
    applicationId, executionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/batch-job-executions/$(executionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_batch_job_execution(
    applicationId,
    executionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/batch-job-executions/$(executionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_set_details(application_id, data_set_name)
    get_data_set_details(application_id, data_set_name, params::Dict{String,<:Any})

Gets the details of a specific data set.

# Arguments
- `application_id`: The unique identifier of the application that this data set is
  associated with.
- `data_set_name`: The name of the data set.

"""
function get_data_set_details(
    applicationId, dataSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/datasets/$(dataSetName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_set_details(
    applicationId,
    dataSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/datasets/$(dataSetName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_set_import_task(application_id, task_id)
    get_data_set_import_task(application_id, task_id, params::Dict{String,<:Any})

Gets the status of a data set import task initiated with the CreateDataSetImportTask
operation.

# Arguments
- `application_id`: The application identifier.
- `task_id`: The task identifier returned by the CreateDataSetImportTask operation.

"""
function get_data_set_import_task(
    applicationId, taskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/dataset-import-tasks/$(taskId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_set_import_task(
    applicationId,
    taskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/dataset-import-tasks/$(taskId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_deployment(application_id, deployment_id)
    get_deployment(application_id, deployment_id, params::Dict{String,<:Any})

Gets details of a specific deployment with a given deployment identifier.

# Arguments
- `application_id`: The unique identifier of the application.
- `deployment_id`: The unique identifier for the deployment.

"""
function get_deployment(
    applicationId, deploymentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/deployments/$(deploymentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_deployment(
    applicationId,
    deploymentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/deployments/$(deploymentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_environment(environment_id)
    get_environment(environment_id, params::Dict{String,<:Any})

Describes a specific runtime environment.

# Arguments
- `environment_id`: The unique identifier of the runtime environment.

"""
function get_environment(environmentId; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "GET",
        "/environments/$(environmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_environment(
    environmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/environments/$(environmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_signed_bluinsights_url()
    get_signed_bluinsights_url(params::Dict{String,<:Any})

Gets a single sign-on URL that can be used to connect to AWS Blu Insights.

"""
function get_signed_bluinsights_url(; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "GET", "/signed-bi-url"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_signed_bluinsights_url(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/signed-bi-url",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_application_versions(application_id)
    list_application_versions(application_id, params::Dict{String,<:Any})

Returns a list of the application versions for a specific application.

# Arguments
- `application_id`: The unique identifier of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of application versions to return.
- `"nextToken"`: A pagination token returned from a previous call to this operation. This
  specifies the next item to return. To return to the beginning of the list, exclude this
  parameter.
"""
function list_application_versions(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_application_versions(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_applications()
    list_applications(params::Dict{String,<:Any})

Lists the applications associated with a specific Amazon Web Services account. You can
provide the unique identifier of a specific runtime environment in a query parameter to see
all applications associated with that environment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"environmentId"`: The unique identifier of the runtime environment where the
  applications are deployed.
- `"maxResults"`: The maximum number of applications to return.
- `"names"`: The names of the applications.
- `"nextToken"`: A pagination token to control the number of applications displayed in the
  list.
"""
function list_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "GET", "/applications"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_batch_job_definitions(application_id)
    list_batch_job_definitions(application_id, params::Dict{String,<:Any})

Lists all the available batch job definitions based on the batch job resources uploaded
during the application creation. You can use the batch job definitions in the list to start
a batch job.

# Arguments
- `application_id`: The identifier of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of batch job definitions to return.
- `"nextToken"`: A pagination token returned from a previous call to this operation. This
  specifies the next item to return. To return to the beginning of the list, exclude this
  parameter.
- `"prefix"`: If the batch job definition is a FileBatchJobDefinition, the prefix allows
  you to search on the file names of FileBatchJobDefinitions.
"""
function list_batch_job_definitions(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/batch-job-definitions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_batch_job_definitions(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/batch-job-definitions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_batch_job_executions(application_id)
    list_batch_job_executions(application_id, params::Dict{String,<:Any})

Lists historical, current, and scheduled batch job executions for a specific application.

# Arguments
- `application_id`: The unique identifier of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"executionIds"`: The unique identifier of each batch job execution.
- `"jobName"`: The name of each batch job execution.
- `"maxResults"`: The maximum number of batch job executions to return.
- `"nextToken"`: A pagination token to control the number of batch job executions displayed
  in the list.
- `"startedAfter"`: The time after which the batch job executions started.
- `"startedBefore"`: The time before the batch job executions started.
- `"status"`: The status of the batch job executions.
"""
function list_batch_job_executions(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/batch-job-executions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_batch_job_executions(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/batch-job-executions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_batch_job_restart_points(application_id, execution_id)
    list_batch_job_restart_points(application_id, execution_id, params::Dict{String,<:Any})

Lists all the job steps for JCL files to restart a batch job. This is only applicable for
Micro Focus engine with versions 8.0.6 and above.

# Arguments
- `application_id`: The unique identifier of the application.
- `execution_id`: The unique identifier of each batch job execution.

"""
function list_batch_job_restart_points(
    applicationId, executionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/batch-job-executions/$(executionId)/steps";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_batch_job_restart_points(
    applicationId,
    executionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/batch-job-executions/$(executionId)/steps",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_data_set_import_history(application_id)
    list_data_set_import_history(application_id, params::Dict{String,<:Any})

Lists the data set imports for the specified application.

# Arguments
- `application_id`: The unique identifier of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of objects to return.
- `"nextToken"`: A pagination token returned from a previous call to this operation. This
  specifies the next item to return. To return to the beginning of the list, exclude this
  parameter.
"""
function list_data_set_import_history(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/applications/$(applicationId)/dataset-import-tasks";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_set_import_history(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/dataset-import-tasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_data_sets(application_id)
    list_data_sets(application_id, params::Dict{String,<:Any})

Lists the data sets imported for a specific application. In Amazon Web Services Mainframe
Modernization, data sets are associated with applications deployed on runtime environments.
This is known as importing data sets. Currently, Amazon Web Services Mainframe
Modernization can import data sets into catalogs using CreateDataSetImportTask.

# Arguments
- `application_id`: The unique identifier of the application for which you want to list the
  associated data sets.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of objects to return.
- `"nameFilter"`: Filter dataset name matching the specified pattern. Can use * and % as
  wild cards.
- `"nextToken"`: A pagination token returned from a previous call to this operation. This
  specifies the next item to return. To return to the beginning of the list, exclude this
  parameter.
- `"prefix"`: The prefix of the data set name, which you can use to filter the list of data
  sets.
"""
function list_data_sets(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "GET",
        "/applications/$(applicationId)/datasets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_sets(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/datasets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_deployments(application_id)
    list_deployments(application_id, params::Dict{String,<:Any})

Returns a list of all deployments of a specific application. A deployment is a combination
of a specific application and a specific version of that application. Each deployment is
mapped to a particular application version.

# Arguments
- `application_id`: The application identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of objects to return.
- `"nextToken"`: A pagination token returned from a previous call to this operation. This
  specifies the next item to return. To return to the beginning of the list, exclude this
  parameter.
"""
function list_deployments(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "GET",
        "/applications/$(applicationId)/deployments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_deployments(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/applications/$(applicationId)/deployments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_engine_versions()
    list_engine_versions(params::Dict{String,<:Any})

Lists the available engine versions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"engineType"`: The type of target platform.
- `"maxResults"`: The maximum number of objects to return.
- `"nextToken"`: A pagination token returned from a previous call to this operation. This
  specifies the next item to return. To return to the beginning of the list, exclude this
  parameter.
"""
function list_engine_versions(; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "GET", "/engine-versions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_engine_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/engine-versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_environments()
    list_environments(params::Dict{String,<:Any})

Lists the runtime environments.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"engineType"`: The engine type for the runtime environment.
- `"maxResults"`: The maximum number of runtime environments to return.
- `"names"`: The names of the runtime environments. Must be unique within the account.
- `"nextToken"`: A pagination token to control the number of runtime environments displayed
  in the list.
"""
function list_environments(; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "GET", "/environments"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_environments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/environments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags for the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_application(application_id)
    start_application(application_id, params::Dict{String,<:Any})

Starts an application that is currently stopped.

# Arguments
- `application_id`: The unique identifier of the application you want to start.

"""
function start_application(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "POST",
        "/applications/$(applicationId)/start";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/applications/$(applicationId)/start",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_batch_job(application_id, batch_job_identifier)
    start_batch_job(application_id, batch_job_identifier, params::Dict{String,<:Any})

Starts a batch job and returns the unique identifier of this execution of the batch job.
The associated application must be running in order to start the batch job.

# Arguments
- `application_id`: The unique identifier of the application associated with this batch job.
- `batch_job_identifier`: The unique identifier of the batch job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"jobParams"`: The collection of batch job parameters. For details about limits for keys
  and values, see Coding variables in JCL.
"""
function start_batch_job(
    applicationId, batchJobIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "POST",
        "/applications/$(applicationId)/batch-job",
        Dict{String,Any}("batchJobIdentifier" => batchJobIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_batch_job(
    applicationId,
    batchJobIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/applications/$(applicationId)/batch-job",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("batchJobIdentifier" => batchJobIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_application(application_id)
    stop_application(application_id, params::Dict{String,<:Any})

Stops a running application.

# Arguments
- `application_id`: The unique identifier of the application you want to stop.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"forceStop"`: Stopping an application process can take a long time. Setting this
  parameter to true lets you force stop the application so you don't need to wait until the
  process finishes to apply another action on the application. The default value is false.
"""
function stop_application(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "POST",
        "/applications/$(applicationId)/stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/applications/$(applicationId)/stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds one or more tags to the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tags`: The tags to add to the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return m2(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tag_keys`: The keys of the tags to remove.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application(application_id, current_application_version)
    update_application(application_id, current_application_version, params::Dict{String,<:Any})

Updates an application and creates a new version.

# Arguments
- `application_id`: The unique identifier of the application you want to update.
- `current_application_version`: The current version of the application to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"definition"`: The application definition for this application. You can specify either
  inline JSON or an S3 bucket location.
- `"description"`: The description of the application to update.
"""
function update_application(
    applicationId,
    currentApplicationVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "PATCH",
        "/applications/$(applicationId)",
        Dict{String,Any}("currentApplicationVersion" => currentApplicationVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application(
    applicationId,
    currentApplicationVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "PATCH",
        "/applications/$(applicationId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("currentApplicationVersion" => currentApplicationVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_environment(environment_id)
    update_environment(environment_id, params::Dict{String,<:Any})

Updates the configuration details for a specific runtime environment.

# Arguments
- `environment_id`: The unique identifier of the runtime environment that you want to
  update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"applyDuringMaintenanceWindow"`: Indicates whether to update the runtime environment
  during the maintenance window. The default is false. Currently, Amazon Web Services
  Mainframe Modernization accepts the engineVersion parameter only if
  applyDuringMaintenanceWindow is true. If any parameter other than engineVersion is provided
  in UpdateEnvironmentRequest, it will fail if applyDuringMaintenanceWindow is set to true.
- `"desiredCapacity"`: The desired capacity for the runtime environment to update. The
  minimum possible value is 0 and the maximum is 100.
- `"engineVersion"`: The version of the runtime engine for the runtime environment.
- `"forceUpdate"`: Forces the updates on the environment. This option is needed if the
  applications in the environment are not stopped or if there are ongoing application-related
  activities in the environment. If you use this option, be aware that it could lead to data
  corruption in the applications, and that you might need to perform repair and recovery
  procedures for the applications. This option is not needed if the attribute being updated
  is preferredMaintenanceWindow.
- `"instanceType"`: The instance type for the runtime environment to update.
- `"preferredMaintenanceWindow"`: Configures the maintenance window that you want for the
  runtime environment. The maintenance window must have the format ddd:hh24:mi-ddd:hh24:mi
  and must be less than 24 hours. The following two examples are valid maintenance windows:
  sun:23:45-mon:00:15 or sat:01:00-sat:03:00.  If you do not provide a value, a random
  system-generated value will be assigned.
"""
function update_environment(
    environmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return m2(
        "PATCH",
        "/environments/$(environmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_environment(
    environmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return m2(
        "PATCH",
        "/environments/$(environmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
