# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: opensearch
using AWS.Compat
using AWS.UUIDs

"""
    accept_inbound_connection(connection_id)
    accept_inbound_connection(connection_id, params::Dict{String,<:Any})

Allows the destination Amazon OpenSearch Service domain owner to accept an inbound
cross-cluster search connection request. For more information, see Cross-cluster search for
Amazon OpenSearch Service.

# Arguments
- `connection_id`: The ID of the inbound connection to accept.

"""
function accept_inbound_connection(
    ConnectionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "PUT",
        "/2021-01-01/opensearch/cc/inboundConnection/$(ConnectionId)/accept";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_inbound_connection(
    ConnectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "PUT",
        "/2021-01-01/opensearch/cc/inboundConnection/$(ConnectionId)/accept",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_data_source(data_source_type, domain_name, name)
    add_data_source(data_source_type, domain_name, name, params::Dict{String,<:Any})

Creates a new direct-query data source to the specified domain. For more information, see
Creating Amazon OpenSearch Service data source integrations with Amazon S3.

# Arguments
- `data_source_type`: The type of data source.
- `domain_name`: The name of the domain to add the data source to.
- `name`: A name for the data source.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the data source.
"""
function add_data_source(
    DataSourceType, DomainName, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource",
        Dict{String,Any}("DataSourceType" => DataSourceType, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_data_source(
    DataSourceType,
    DomainName,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DataSourceType" => DataSourceType, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_tags(arn, tag_list)
    add_tags(arn, tag_list, params::Dict{String,<:Any})

Attaches tags to an existing Amazon OpenSearch Service domain. Tags are a set of
case-sensitive key-value pairs. A domain can have up to 10 tags. For more information, see
Tagging Amazon OpenSearch Service domains.

# Arguments
- `arn`: Amazon Resource Name (ARN) for the OpenSearch Service domain to which you want to
  attach resource tags.
- `tag_list`: List of resource tags.

"""
function add_tags(ARN, TagList; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "POST",
        "/2021-01-01/tags",
        Dict{String,Any}("ARN" => ARN, "TagList" => TagList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_tags(
    ARN,
    TagList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/tags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ARN" => ARN, "TagList" => TagList), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_package(domain_name, package_id)
    associate_package(domain_name, package_id, params::Dict{String,<:Any})

Associates a package with an Amazon OpenSearch Service domain. For more information, see
Custom packages for Amazon OpenSearch Service.

# Arguments
- `domain_name`: Name of the domain to associate the package with.
- `package_id`: Internal ID of the package to associate with a domain. Use DescribePackages
  to find this value.

"""
function associate_package(
    DomainName, PackageID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/packages/associate/$(PackageID)/$(DomainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_package(
    DomainName,
    PackageID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/packages/associate/$(PackageID)/$(DomainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_vpc_endpoint_access(account, domain_name)
    authorize_vpc_endpoint_access(account, domain_name, params::Dict{String,<:Any})

Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC
endpoint.

# Arguments
- `account`: The Amazon Web Services account ID to grant access to.
- `domain_name`: The name of the OpenSearch Service domain to provide access to.

"""
function authorize_vpc_endpoint_access(
    Account, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/authorizeVpcEndpointAccess",
        Dict{String,Any}("Account" => Account);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_vpc_endpoint_access(
    Account,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/authorizeVpcEndpointAccess",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Account" => Account), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_domain_config_change(domain_name)
    cancel_domain_config_change(domain_name, params::Dict{String,<:Any})

Cancels a pending configuration change on an Amazon OpenSearch Service domain.

# Arguments
- `domain_name`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: When set to True, returns the list of change IDs and properties that will be
  cancelled without actually cancelling the change.
"""
function cancel_domain_config_change(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/config/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_domain_config_change(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/config/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_service_software_update(domain_name)
    cancel_service_software_update(domain_name, params::Dict{String,<:Any})

Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You
can only perform this operation before the AutomatedUpdateDate and when the domain's
UpdateStatus is PENDING_UPDATE. For more information, see Service software updates in
Amazon OpenSearch Service.

# Arguments
- `domain_name`: Name of the OpenSearch Service domain that you want to cancel the service
  software update on.

"""
function cancel_service_software_update(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/serviceSoftwareUpdate/cancel",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_service_software_update(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/serviceSoftwareUpdate/cancel",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_domain(domain_name)
    create_domain(domain_name, params::Dict{String,<:Any})

Creates an Amazon OpenSearch Service domain. For more information, see Creating and
managing Amazon OpenSearch Service domains.

# Arguments
- `domain_name`: Name of the OpenSearch Service domain to create. Domain names are unique
  across the domains owned by an account within an Amazon Web Services Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessPolicies"`: Identity and Access Management (IAM) policy document specifying the
  access policies for the new domain.
- `"AdvancedOptions"`: Key-value pairs to specify advanced configuration options. The
  following key-value pairs are supported:    \"rest.action.multi.allow_explicit_index\":
  \"true\" | \"false\" - Note the use of a string rather than a boolean. Specifies whether
  explicit references to indexes are allowed inside the body of HTTP requests. If you want to
  configure access policies for domain sub-resources, such as specific indexes and domain
  APIs, you must disable this property. Default is true.    \"indices.fielddata.cache.size\":
  \"80\"  - Note the use of a string rather than a boolean. Specifies the percentage of heap
  space allocated to field data. Default is unbounded.
  \"indices.query.bool.max_clause_count\": \"1024\" - Note the use of a string rather than a
  boolean. Specifies the maximum number of clauses allowed in a Lucene boolean query. Default
  is 1,024. Queries with more than the permitted number of clauses result in a TooManyClauses
  error.    \"override_main_response_version\": \"true\" | \"false\" - Note the use of a
  string rather than a boolean. Specifies whether the domain reports its version as 7.10 to
  allow Elasticsearch OSS clients and plugins to continue working with it. Default is false
  when creating a domain and true when upgrading a domain.   For more information, see
  Advanced cluster parameters.
- `"AdvancedSecurityOptions"`: Options for fine-grained access control.
- `"AutoTuneOptions"`: Options for Auto-Tune.
- `"ClusterConfig"`: Container for the cluster configuration of a domain.
- `"CognitoOptions"`: Key-value pairs to configure Amazon Cognito authentication. For more
  information, see Configuring Amazon Cognito authentication for OpenSearch Dashboards.
- `"DomainEndpointOptions"`: Additional options for the domain endpoint, such as whether to
  require HTTPS for all traffic.
- `"EBSOptions"`: Container for the parameters required to enable EBS-based storage for an
  OpenSearch Service domain.
- `"EncryptionAtRestOptions"`: Key-value pairs to enable encryption at rest.
- `"EngineVersion"`: String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the
  engine version for the OpenSearch Service domain. For example, OpenSearch_1.0 or
  Elasticsearch_7.9. For more information, see Creating and managing Amazon OpenSearch
  Service domains.
- `"IPAddressType"`: Specify either dual stack or IPv4 as your IP address type. Dual stack
  allows you to share domain resources across IPv4 and IPv6 address types, and is the
  recommended option. If you set your IP address type to dual stack, you can't change your
  address type later.
- `"LogPublishingOptions"`: Key-value pairs to configure log publishing.
- `"NodeToNodeEncryptionOptions"`: Enables node-to-node encryption.
- `"OffPeakWindowOptions"`: Specifies a daily 10-hour time block during which OpenSearch
  Service can perform configuration changes on the domain, including service software updates
  and Auto-Tune enhancements that require a blue/green deployment. If no options are
  specified, the default start time of 10:00 P.M. local time (for the Region that the domain
  is created in) is used.
- `"SnapshotOptions"`: DEPRECATED. Container for the parameters required to configure
  automated snapshots of domain indexes.
- `"SoftwareUpdateOptions"`: Software update options for the domain.
- `"TagList"`: List of tags to add to the domain upon creation.
- `"VPCOptions"`: Container for the values required to configure VPC access domains. If you
  don't specify these values, OpenSearch Service creates the domain with a public endpoint.
  For more information, see Launching your Amazon OpenSearch Service domains using a VPC.
"""
function create_domain(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_outbound_connection(connection_alias, local_domain_info, remote_domain_info)
    create_outbound_connection(connection_alias, local_domain_info, remote_domain_info, params::Dict{String,<:Any})

Creates a new cross-cluster search connection from a source Amazon OpenSearch Service
domain to a destination domain. For more information, see Cross-cluster search for Amazon
OpenSearch Service.

# Arguments
- `connection_alias`: Name of the connection.
- `local_domain_info`: Name and Region of the source (local) domain.
- `remote_domain_info`: Name and Region of the destination (remote) domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectionMode"`: The connection mode.
- `"ConnectionProperties"`: The ConnectionProperties for the outbound connection.
"""
function create_outbound_connection(
    ConnectionAlias,
    LocalDomainInfo,
    RemoteDomainInfo;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/cc/outboundConnection",
        Dict{String,Any}(
            "ConnectionAlias" => ConnectionAlias,
            "LocalDomainInfo" => LocalDomainInfo,
            "RemoteDomainInfo" => RemoteDomainInfo,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_outbound_connection(
    ConnectionAlias,
    LocalDomainInfo,
    RemoteDomainInfo,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/cc/outboundConnection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConnectionAlias" => ConnectionAlias,
                    "LocalDomainInfo" => LocalDomainInfo,
                    "RemoteDomainInfo" => RemoteDomainInfo,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_package(package_name, package_source, package_type)
    create_package(package_name, package_source, package_type, params::Dict{String,<:Any})

Creates a package for use with Amazon OpenSearch Service domains. For more information, see
Custom packages for Amazon OpenSearch Service.

# Arguments
- `package_name`: Unique name for the package.
- `package_source`: The Amazon S3 location from which to import the package.
- `package_type`: The type of package.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PackageDescription"`: Description of the package.
"""
function create_package(
    PackageName,
    PackageSource,
    PackageType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/packages",
        Dict{String,Any}(
            "PackageName" => PackageName,
            "PackageSource" => PackageSource,
            "PackageType" => PackageType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_package(
    PackageName,
    PackageSource,
    PackageType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/packages",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PackageName" => PackageName,
                    "PackageSource" => PackageSource,
                    "PackageType" => PackageType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpc_endpoint(domain_arn, vpc_options)
    create_vpc_endpoint(domain_arn, vpc_options, params::Dict{String,<:Any})

Creates an Amazon OpenSearch Service-managed VPC endpoint.

# Arguments
- `domain_arn`: The Amazon Resource Name (ARN) of the domain to create the endpoint for.
- `vpc_options`: Options to specify the subnets and security groups for the endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier to ensure idempotency of the request.
"""
function create_vpc_endpoint(
    DomainArn, VpcOptions; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/vpcEndpoints",
        Dict{String,Any}("DomainArn" => DomainArn, "VpcOptions" => VpcOptions);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpc_endpoint(
    DomainArn,
    VpcOptions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/vpcEndpoints",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainArn" => DomainArn, "VpcOptions" => VpcOptions),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_data_source(data_source_name, domain_name)
    delete_data_source(data_source_name, domain_name, params::Dict{String,<:Any})

Deletes a direct-query data source. For more information, see Deleting an Amazon OpenSearch
Service data source with Amazon S3.

# Arguments
- `data_source_name`: The name of the data source to delete.
- `domain_name`: The name of the domain.

"""
function delete_data_source(
    DataSourceName, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource/$(DataSourceName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_data_source(
    DataSourceName,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource/$(DataSourceName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_domain(domain_name)
    delete_domain(domain_name, params::Dict{String,<:Any})

Deletes an Amazon OpenSearch Service domain and all of its data. You can't recover a domain
after you delete it.

# Arguments
- `domain_name`: The name of the domain you want to permanently delete.

"""
function delete_domain(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/domain/$(DomainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/domain/$(DomainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_inbound_connection(connection_id)
    delete_inbound_connection(connection_id, params::Dict{String,<:Any})

Allows the destination Amazon OpenSearch Service domain owner to delete an existing inbound
cross-cluster search connection. For more information, see Cross-cluster search for Amazon
OpenSearch Service.

# Arguments
- `connection_id`: The ID of the inbound connection to permanently delete.

"""
function delete_inbound_connection(
    ConnectionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/cc/inboundConnection/$(ConnectionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_inbound_connection(
    ConnectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/cc/inboundConnection/$(ConnectionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_outbound_connection(connection_id)
    delete_outbound_connection(connection_id, params::Dict{String,<:Any})

Allows the source Amazon OpenSearch Service domain owner to delete an existing outbound
cross-cluster search connection. For more information, see Cross-cluster search for Amazon
OpenSearch Service.

# Arguments
- `connection_id`: The ID of the outbound connection you want to permanently delete.

"""
function delete_outbound_connection(
    ConnectionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/cc/outboundConnection/$(ConnectionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_outbound_connection(
    ConnectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/cc/outboundConnection/$(ConnectionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_package(package_id)
    delete_package(package_id, params::Dict{String,<:Any})

Deletes an Amazon OpenSearch Service package. For more information, see Custom packages for
Amazon OpenSearch Service.

# Arguments
- `package_id`: The internal ID of the package you want to delete. Use DescribePackages to
  find this value.

"""
function delete_package(PackageID; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "DELETE",
        "/2021-01-01/packages/$(PackageID)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_package(
    PackageID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "DELETE",
        "/2021-01-01/packages/$(PackageID)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpc_endpoint(vpc_endpoint_id)
    delete_vpc_endpoint(vpc_endpoint_id, params::Dict{String,<:Any})

Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.

# Arguments
- `vpc_endpoint_id`: The unique identifier of the endpoint.

"""
function delete_vpc_endpoint(
    VpcEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/vpcEndpoints/$(VpcEndpointId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpc_endpoint(
    VpcEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "DELETE",
        "/2021-01-01/opensearch/vpcEndpoints/$(VpcEndpointId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain(domain_name)
    describe_domain(domain_name, params::Dict{String,<:Any})

Describes the domain configuration for the specified Amazon OpenSearch Service domain,
including the domain ID, domain service endpoint, and domain ARN.

# Arguments
- `domain_name`: The name of the domain that you want information about.

"""
function describe_domain(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain_auto_tunes(domain_name)
    describe_domain_auto_tunes(domain_name, params::Dict{String,<:Any})

Returns the list of optimizations that Auto-Tune has made to an Amazon OpenSearch Service
domain. For more information, see Auto-Tune for Amazon OpenSearch Service.

# Arguments
- `domain_name`: Name of the domain that you want Auto-Tune details about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"NextToken"`: If your initial DescribeDomainAutoTunes operation returns a nextToken, you
  can include the returned nextToken in subsequent DescribeDomainAutoTunes operations, which
  returns results in the next page.
"""
function describe_domain_auto_tunes(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/autoTunes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain_auto_tunes(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/autoTunes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain_change_progress(domain_name)
    describe_domain_change_progress(domain_name, params::Dict{String,<:Any})

Returns information about the current blue/green deployment happening on an Amazon
OpenSearch Service domain. For more information, see Making configuration changes in Amazon
OpenSearch Service.

# Arguments
- `domain_name`: The name of the domain to get progress information for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"changeid"`: The specific change ID for which you want to get progress information. If
  omitted, the request returns information about the most recent configuration change.
"""
function describe_domain_change_progress(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/progress";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain_change_progress(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/progress",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain_config(domain_name)
    describe_domain_config(domain_name, params::Dict{String,<:Any})

Returns the configuration of an Amazon OpenSearch Service domain.

# Arguments
- `domain_name`: Name of the OpenSearch Service domain configuration that you want to
  describe.

"""
function describe_domain_config(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain_config(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain_health(domain_name)
    describe_domain_health(domain_name, params::Dict{String,<:Any})

Returns information about domain and node health, the standby Availability Zone, number of
nodes per Availability Zone, and shard count per node.

# Arguments
- `domain_name`: The name of the domain.

"""
function describe_domain_health(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/health";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain_health(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/health",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain_nodes(domain_name)
    describe_domain_nodes(domain_name, params::Dict{String,<:Any})

Returns information about domain and nodes, including data nodes, master nodes, ultrawarm
nodes, Availability Zone(s), standby nodes, node configurations, and node states.

# Arguments
- `domain_name`: The name of the domain.

"""
function describe_domain_nodes(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/nodes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain_nodes(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/nodes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domains(domain_names)
    describe_domains(domain_names, params::Dict{String,<:Any})

Returns domain configuration information about the specified Amazon OpenSearch Service
domains.

# Arguments
- `domain_names`: Array of OpenSearch Service domain names that you want information about.
  You must specify at least one domain name.

"""
function describe_domains(DomainNames; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain-info",
        Dict{String,Any}("DomainNames" => DomainNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domains(
    DomainNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain-info",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainNames" => DomainNames), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dry_run_progress(domain_name)
    describe_dry_run_progress(domain_name, params::Dict{String,<:Any})

Describes the progress of a pre-update dry run analysis on an Amazon OpenSearch Service
domain. For more information, see Determining whether a change will cause a blue/green
deployment.

# Arguments
- `domain_name`: The name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRunId"`: The unique identifier of the dry run.
- `"loadDryRunConfig"`: Whether to include the configuration of the dry run in the
  response. The configuration specifies the updates that you're planning to make on the
  domain.
"""
function describe_dry_run_progress(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/dryRun";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dry_run_progress(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/dryRun",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_inbound_connections()
    describe_inbound_connections(params::Dict{String,<:Any})

Lists all the inbound cross-cluster search connections for a destination (remote) Amazon
OpenSearch Service domain. For more information, see Cross-cluster search for Amazon
OpenSearch Service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`:  A list of filters used to match properties for inbound cross-cluster
  connections.
- `"MaxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"NextToken"`: If your initial DescribeInboundConnections operation returns a nextToken,
  you can include the returned nextToken in subsequent DescribeInboundConnections operations,
  which returns results in the next page.
"""
function describe_inbound_connections(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/cc/inboundConnection/search";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_inbound_connections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/cc/inboundConnection/search",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_type_limits(engine_version, instance_type)
    describe_instance_type_limits(engine_version, instance_type, params::Dict{String,<:Any})

Describes the instance count, storage, and master node limits for a given OpenSearch or
Elasticsearch version and instance type.

# Arguments
- `engine_version`: Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y
  or OpenSearch_X.Y. Defaults to the latest version of OpenSearch.
- `instance_type`: The OpenSearch Service instance type for which you need limit
  information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"domainName"`: The name of the domain. Only specify if you need the limits for an
  existing domain.
"""
function describe_instance_type_limits(
    EngineVersion, InstanceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/instanceTypeLimits/$(EngineVersion)/$(InstanceType)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_type_limits(
    EngineVersion,
    InstanceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/instanceTypeLimits/$(EngineVersion)/$(InstanceType)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_outbound_connections()
    describe_outbound_connections(params::Dict{String,<:Any})

Lists all the outbound cross-cluster connections for a local (source) Amazon OpenSearch
Service domain. For more information, see Cross-cluster search for Amazon OpenSearch
Service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: List of filter names and values that you can use for requests.
- `"MaxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"NextToken"`: If your initial DescribeOutboundConnections operation returns a nextToken,
  you can include the returned nextToken in subsequent DescribeOutboundConnections
  operations, which returns results in the next page.
"""
function describe_outbound_connections(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/cc/outboundConnection/search";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_outbound_connections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/cc/outboundConnection/search",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_packages()
    describe_packages(params::Dict{String,<:Any})

Describes all packages available to OpenSearch Service. For more information, see Custom
packages for Amazon OpenSearch Service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Only returns packages that match the DescribePackagesFilterList values.
- `"MaxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"NextToken"`: If your initial DescribePackageFilters operation returns a nextToken, you
  can include the returned nextToken in subsequent DescribePackageFilters operations, which
  returns results in the next page.
"""
function describe_packages(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "POST",
        "/2021-01-01/packages/describe";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_packages(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/packages/describe",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_instance_offerings()
    describe_reserved_instance_offerings(params::Dict{String,<:Any})

Describes the available Amazon OpenSearch Service Reserved Instance offerings for a given
Region. For more information, see Reserved Instances in Amazon OpenSearch Service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial DescribeReservedInstanceOfferings operation returns a
  nextToken, you can include the returned nextToken in subsequent
  DescribeReservedInstanceOfferings operations, which returns results in the next page.
- `"offeringId"`: The Reserved Instance identifier filter value. Use this parameter to show
  only the available instance types that match the specified reservation identifier.
"""
function describe_reserved_instance_offerings(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/reservedInstanceOfferings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_instance_offerings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/reservedInstanceOfferings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_instances()
    describe_reserved_instances(params::Dict{String,<:Any})

Describes the Amazon OpenSearch Service instances that you have reserved in a given Region.
For more information, see Reserved Instances in Amazon OpenSearch Service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial DescribeReservedInstances operation returns a nextToken,
  you can include the returned nextToken in subsequent DescribeReservedInstances operations,
  which returns results in the next page.
- `"reservationId"`: The reserved instance identifier filter value. Use this parameter to
  show only the reservation that matches the specified reserved OpenSearch instance ID.
"""
function describe_reserved_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/reservedInstances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/reservedInstances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_endpoints(vpc_endpoint_ids)
    describe_vpc_endpoints(vpc_endpoint_ids, params::Dict{String,<:Any})

Describes one or more Amazon OpenSearch Service-managed VPC endpoints.

# Arguments
- `vpc_endpoint_ids`: The unique identifiers of the endpoints to get information about.

"""
function describe_vpc_endpoints(
    VpcEndpointIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/vpcEndpoints/describe",
        Dict{String,Any}("VpcEndpointIds" => VpcEndpointIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_endpoints(
    VpcEndpointIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/vpcEndpoints/describe",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VpcEndpointIds" => VpcEndpointIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    dissociate_package(domain_name, package_id)
    dissociate_package(domain_name, package_id, params::Dict{String,<:Any})

Removes a package from the specified Amazon OpenSearch Service domain. The package can't be
in use with any OpenSearch index for the dissociation to succeed. The package is still
available in OpenSearch Service for association later. For more information, see Custom
packages for Amazon OpenSearch Service.

# Arguments
- `domain_name`: Name of the domain to dissociate the package from.
- `package_id`: Internal ID of the package to dissociate from the domain. Use
  ListPackagesForDomain to find this value.

"""
function dissociate_package(
    DomainName, PackageID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/packages/dissociate/$(PackageID)/$(DomainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function dissociate_package(
    DomainName,
    PackageID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/packages/dissociate/$(PackageID)/$(DomainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_compatible_versions()
    get_compatible_versions(params::Dict{String,<:Any})

Returns a map of OpenSearch or Elasticsearch versions and the versions you can upgrade them
to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"domainName"`: The name of an existing domain. Provide this parameter to limit the
  results to a single domain.
"""
function get_compatible_versions(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/compatibleVersions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_compatible_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/compatibleVersions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_source(data_source_name, domain_name)
    get_data_source(data_source_name, domain_name, params::Dict{String,<:Any})

Retrieves information about a direct query data source.

# Arguments
- `data_source_name`: The name of the data source to get information about.
- `domain_name`: The name of the domain.

"""
function get_data_source(
    DataSourceName, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource/$(DataSourceName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_source(
    DataSourceName,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource/$(DataSourceName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_domain_maintenance_status(domain_name, maintenance_id)
    get_domain_maintenance_status(domain_name, maintenance_id, params::Dict{String,<:Any})

The status of the maintenance action.

# Arguments
- `domain_name`: The name of the domain.
- `maintenance_id`: The request ID of the maintenance action.

"""
function get_domain_maintenance_status(
    DomainName, maintenanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/domainMaintenance",
        Dict{String,Any}("maintenanceId" => maintenanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_domain_maintenance_status(
    DomainName,
    maintenanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/domainMaintenance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("maintenanceId" => maintenanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_package_version_history(package_id)
    get_package_version_history(package_id, params::Dict{String,<:Any})

Returns a list of Amazon OpenSearch Service package versions, along with their creation
time, commit message, and plugin properties (if the package is a zip plugin package). For
more information, see Custom packages for Amazon OpenSearch Service.

# Arguments
- `package_id`: The unique identifier of the package.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial GetPackageVersionHistory operation returns a nextToken,
  you can include the returned nextToken in subsequent GetPackageVersionHistory operations,
  which returns results in the next page.
"""
function get_package_version_history(
    PackageID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/packages/$(PackageID)/history";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_package_version_history(
    PackageID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/packages/$(PackageID)/history",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_upgrade_history(domain_name)
    get_upgrade_history(domain_name, params::Dict{String,<:Any})

Retrieves the complete history of the last 10 upgrades performed on an Amazon OpenSearch
Service domain.

# Arguments
- `domain_name`: The name of an existing domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial GetUpgradeHistory operation returns a nextToken, you can
  include the returned nextToken in subsequent GetUpgradeHistory operations, which returns
  results in the next page.
"""
function get_upgrade_history(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/upgradeDomain/$(DomainName)/history";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_upgrade_history(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/upgradeDomain/$(DomainName)/history",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_upgrade_status(domain_name)
    get_upgrade_status(domain_name, params::Dict{String,<:Any})

Returns the most recent status of the last upgrade or upgrade eligibility check performed
on an Amazon OpenSearch Service domain.

# Arguments
- `domain_name`: The domain of the domain to get upgrade status information for.

"""
function get_upgrade_status(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/upgradeDomain/$(DomainName)/status";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_upgrade_status(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/upgradeDomain/$(DomainName)/status",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_data_sources(domain_name)
    list_data_sources(domain_name, params::Dict{String,<:Any})

Lists direct-query data sources for a specific domain. For more information, see For more
information, see Working with Amazon OpenSearch Service direct queries with Amazon S3.

# Arguments
- `domain_name`: The name of the domain.

"""
function list_data_sources(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_sources(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domain_maintenances(domain_name)
    list_domain_maintenances(domain_name, params::Dict{String,<:Any})

A list of maintenance actions for the domain.

# Arguments
- `domain_name`: The name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"action"`: The name of the action.
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial ListDomainMaintenances operation returns a nextToken,
  include the returned nextToken in subsequent ListDomainMaintenances operations, which
  returns results in the next page.
- `"status"`: The status of the action.
"""
function list_domain_maintenances(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/domainMaintenances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_domain_maintenances(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/domainMaintenances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domain_names()
    list_domain_names(params::Dict{String,<:Any})

Returns the names of all Amazon OpenSearch Service domains owned by the current user in the
active Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"engineType"`: Filters the output by domain engine type.
"""
function list_domain_names(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET", "/2021-01-01/domain"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_domain_names(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/domain",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domains_for_package(package_id)
    list_domains_for_package(package_id, params::Dict{String,<:Any})

Lists all Amazon OpenSearch Service domains associated with a given package. For more
information, see Custom packages for Amazon OpenSearch Service.

# Arguments
- `package_id`: The unique identifier of the package for which to list associated domains.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial ListDomainsForPackage operation returns a nextToken, you
  can include the returned nextToken in subsequent ListDomainsForPackage operations, which
  returns results in the next page.
"""
function list_domains_for_package(
    PackageID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/packages/$(PackageID)/domains";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_domains_for_package(
    PackageID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/packages/$(PackageID)/domains",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_instance_type_details(engine_version)
    list_instance_type_details(engine_version, params::Dict{String,<:Any})

Lists all instance types and available features for a given OpenSearch or Elasticsearch
version.

# Arguments
- `engine_version`: The version of OpenSearch or Elasticsearch, in the format
  Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to the latest version of OpenSearch.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"domainName"`: The name of the domain.
- `"instanceType"`: An optional parameter that lists information for a given instance type.
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial ListInstanceTypeDetails operation returns a nextToken, you
  can include the returned nextToken in subsequent ListInstanceTypeDetails operations, which
  returns results in the next page.
- `"retrieveAZs"`: An optional parameter that specifies the Availability Zones for the
  domain.
"""
function list_instance_type_details(
    EngineVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/instanceTypeDetails/$(EngineVersion)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_instance_type_details(
    EngineVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/instanceTypeDetails/$(EngineVersion)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_packages_for_domain(domain_name)
    list_packages_for_domain(domain_name, params::Dict{String,<:Any})

Lists all packages associated with an Amazon OpenSearch Service domain. For more
information, see Custom packages for Amazon OpenSearch Service.

# Arguments
- `domain_name`: The name of the domain for which you want to list associated packages.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial ListPackagesForDomain operation returns a nextToken, you
  can include the returned nextToken in subsequent ListPackagesForDomain operations, which
  returns results in the next page.
"""
function list_packages_for_domain(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/domain/$(DomainName)/packages";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_packages_for_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/domain/$(DomainName)/packages",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_scheduled_actions(domain_name)
    list_scheduled_actions(domain_name, params::Dict{String,<:Any})

Retrieves a list of configuration changes that are scheduled for a domain. These changes
can be service software updates or blue/green Auto-Tune enhancements.

# Arguments
- `domain_name`: The name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial ListScheduledActions operation returns a nextToken, you
  can include the returned nextToken in subsequent ListScheduledActions operations, which
  returns results in the next page.
"""
function list_scheduled_actions(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/scheduledActions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_scheduled_actions(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/scheduledActions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags(arn)
    list_tags(arn, params::Dict{String,<:Any})

Returns all resource tags for an Amazon OpenSearch Service domain. For more information,
see Tagging Amazon OpenSearch Service domains.

# Arguments
- `arn`: Amazon Resource Name (ARN) for the domain to view tags for.

"""
function list_tags(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET",
        "/2021-01-01/tags/",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/tags/",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_versions()
    list_versions(params::Dict{String,<:Any})

Lists all versions of OpenSearch and Elasticsearch that Amazon OpenSearch Service supports.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial ListVersions operation returns a nextToken, you can
  include the returned nextToken in subsequent ListVersions operations, which returns results
  in the next page.
"""
function list_versions(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_vpc_endpoint_access(domain_name)
    list_vpc_endpoint_access(domain_name, params::Dict{String,<:Any})

Retrieves information about each Amazon Web Services principal that is allowed to access a
given Amazon OpenSearch Service domain through the use of an interface VPC endpoint.

# Arguments
- `domain_name`: The name of the OpenSearch Service domain to retrieve access information
  for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: If your initial ListVpcEndpointAccess operation returns a nextToken, you
  can include the returned nextToken in subsequent ListVpcEndpointAccess operations, which
  returns results in the next page.
"""
function list_vpc_endpoint_access(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/listVpcEndpointAccess";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_vpc_endpoint_access(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/listVpcEndpointAccess",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_vpc_endpoints()
    list_vpc_endpoints(params::Dict{String,<:Any})

Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current Amazon Web
Services account and Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: If your initial ListVpcEndpoints operation returns a nextToken, you can
  include the returned nextToken in subsequent ListVpcEndpoints operations, which returns
  results in the next page.
"""
function list_vpc_endpoints(; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/vpcEndpoints";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_vpc_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/vpcEndpoints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_vpc_endpoints_for_domain(domain_name)
    list_vpc_endpoints_for_domain(domain_name, params::Dict{String,<:Any})

Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular
domain.

# Arguments
- `domain_name`: The name of the domain to list associated VPC endpoints for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: If your initial ListEndpointsForDomain operation returns a nextToken, you
  can include the returned nextToken in subsequent ListEndpointsForDomain operations, which
  returns results in the next page.
"""
function list_vpc_endpoints_for_domain(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/vpcEndpoints";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_vpc_endpoints_for_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "GET",
        "/2021-01-01/opensearch/domain/$(DomainName)/vpcEndpoints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    purchase_reserved_instance_offering(reservation_name, reserved_instance_offering_id)
    purchase_reserved_instance_offering(reservation_name, reserved_instance_offering_id, params::Dict{String,<:Any})

Allows you to purchase Amazon OpenSearch Service Reserved Instances.

# Arguments
- `reservation_name`: A customer-specified identifier to track this reservation.
- `reserved_instance_offering_id`: The ID of the Reserved Instance offering to purchase.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceCount"`: The number of OpenSearch instances to reserve.
"""
function purchase_reserved_instance_offering(
    ReservationName,
    ReservedInstanceOfferingId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/purchaseReservedInstanceOffering",
        Dict{String,Any}(
            "ReservationName" => ReservationName,
            "ReservedInstanceOfferingId" => ReservedInstanceOfferingId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function purchase_reserved_instance_offering(
    ReservationName,
    ReservedInstanceOfferingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/purchaseReservedInstanceOffering",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ReservationName" => ReservationName,
                    "ReservedInstanceOfferingId" => ReservedInstanceOfferingId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_inbound_connection(connection_id)
    reject_inbound_connection(connection_id, params::Dict{String,<:Any})

Allows the remote Amazon OpenSearch Service domain owner to reject an inbound cross-cluster
connection request.

# Arguments
- `connection_id`: The unique identifier of the inbound connection to reject.

"""
function reject_inbound_connection(
    ConnectionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "PUT",
        "/2021-01-01/opensearch/cc/inboundConnection/$(ConnectionId)/reject";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_inbound_connection(
    ConnectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "PUT",
        "/2021-01-01/opensearch/cc/inboundConnection/$(ConnectionId)/reject",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_tags(arn, tag_keys)
    remove_tags(arn, tag_keys, params::Dict{String,<:Any})

Removes the specified set of tags from an Amazon OpenSearch Service domain. For more
information, see  Tagging Amazon OpenSearch Service domains.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the domain from which you want to delete the
  specified tags.
- `tag_keys`: The list of tag keys to remove from the domain.

"""
function remove_tags(ARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config())
    return opensearch(
        "POST",
        "/2021-01-01/tags-removal",
        Dict{String,Any}("ARN" => ARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_tags(
    ARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/tags-removal",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ARN" => ARN, "TagKeys" => TagKeys), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_vpc_endpoint_access(account, domain_name)
    revoke_vpc_endpoint_access(account, domain_name, params::Dict{String,<:Any})

Revokes access to an Amazon OpenSearch Service domain that was provided through an
interface VPC endpoint.

# Arguments
- `account`: The account ID to revoke access from.
- `domain_name`: The name of the OpenSearch Service domain.

"""
function revoke_vpc_endpoint_access(
    Account, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/revokeVpcEndpointAccess",
        Dict{String,Any}("Account" => Account);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function revoke_vpc_endpoint_access(
    Account,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/revokeVpcEndpointAccess",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Account" => Account), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_domain_maintenance(action, domain_name)
    start_domain_maintenance(action, domain_name, params::Dict{String,<:Any})

Starts the node maintenance process on the data node. These processes can include a node
reboot, an Opensearch or Elasticsearch process restart, or a Dashboard or Kibana restart.

# Arguments
- `action`: The name of the action.
- `domain_name`: The name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NodeId"`: The ID of the data node.
"""
function start_domain_maintenance(
    Action, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/domainMaintenance",
        Dict{String,Any}("Action" => Action);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_domain_maintenance(
    Action,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/domainMaintenance",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Action" => Action), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_service_software_update(domain_name)
    start_service_software_update(domain_name, params::Dict{String,<:Any})

Schedules a service software update for an Amazon OpenSearch Service domain. For more
information, see Service software updates in Amazon OpenSearch Service.

# Arguments
- `domain_name`: The name of the domain that you want to update to the latest service
  software.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DesiredStartTime"`: The Epoch timestamp when you want the service software update to
  start. You only need to specify this parameter if you set ScheduleAt to TIMESTAMP.
- `"ScheduleAt"`: When to start the service software update.    NOW - Immediately schedules
  the update to happen in the current hour if there's capacity available.    TIMESTAMP - Lets
  you specify a custom date and time to apply the update. If you specify this value, you must
  also provide a value for DesiredStartTime.    OFF_PEAK_WINDOW - Marks the update to be
  picked up during an upcoming off-peak window. There's no guarantee that the update will
  happen during the next immediate window. Depending on capacity, it might happen in
  subsequent days.   Default: NOW if you don't specify a value for DesiredStartTime, and
  TIMESTAMP if you do.
"""
function start_service_software_update(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/serviceSoftwareUpdate/start",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_service_software_update(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/serviceSoftwareUpdate/start",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_data_source(data_source_name, data_source_type, domain_name)
    update_data_source(data_source_name, data_source_type, domain_name, params::Dict{String,<:Any})

Updates a direct-query data source. For more information, see Working with Amazon
OpenSearch Service data source integrations with Amazon S3.

# Arguments
- `data_source_name`: The name of the data source to modify.
- `data_source_type`: The type of data source.
- `domain_name`: The name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A new description of the data source.
- `"Status"`: The status of the data source update.
"""
function update_data_source(
    DataSourceName,
    DataSourceType,
    DomainName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "PUT",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource/$(DataSourceName)",
        Dict{String,Any}("DataSourceType" => DataSourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_data_source(
    DataSourceName,
    DataSourceType,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "PUT",
        "/2021-01-01/opensearch/domain/$(DomainName)/dataSource/$(DataSourceName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DataSourceType" => DataSourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_domain_config(domain_name)
    update_domain_config(domain_name, params::Dict{String,<:Any})

Modifies the cluster configuration of the specified Amazon OpenSearch Service domain.

# Arguments
- `domain_name`: The name of the domain that you're updating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessPolicies"`: Identity and Access Management (IAM) access policy as a
  JSON-formatted string.
- `"AdvancedOptions"`: Key-value pairs to specify advanced configuration options. The
  following key-value pairs are supported:    \"rest.action.multi.allow_explicit_index\":
  \"true\" | \"false\" - Note the use of a string rather than a boolean. Specifies whether
  explicit references to indexes are allowed inside the body of HTTP requests. If you want to
  configure access policies for domain sub-resources, such as specific indexes and domain
  APIs, you must disable this property. Default is true.    \"indices.fielddata.cache.size\":
  \"80\"  - Note the use of a string rather than a boolean. Specifies the percentage of heap
  space allocated to field data. Default is unbounded.
  \"indices.query.bool.max_clause_count\": \"1024\" - Note the use of a string rather than a
  boolean. Specifies the maximum number of clauses allowed in a Lucene boolean query. Default
  is 1,024. Queries with more than the permitted number of clauses result in a TooManyClauses
  error.   For more information, see Advanced cluster parameters.
- `"AdvancedSecurityOptions"`: Options for fine-grained access control.
- `"AutoTuneOptions"`: Options for Auto-Tune.
- `"ClusterConfig"`: Changes that you want to make to the cluster configuration, such as
  the instance type and number of EC2 instances.
- `"CognitoOptions"`: Key-value pairs to configure Amazon Cognito authentication for
  OpenSearch Dashboards.
- `"DomainEndpointOptions"`: Additional options for the domain endpoint, such as whether to
  require HTTPS for all traffic.
- `"DryRun"`: This flag, when set to True, specifies whether the UpdateDomain request
  should return the results of a dry run analysis without actually applying the change. A dry
  run determines what type of deployment the update will cause.
- `"DryRunMode"`: The type of dry run to perform.    Basic only returns the type of
  deployment (blue/green or dynamic) that the update will cause.    Verbose runs an
  additional check to validate the changes you're making. For more information, see
  Validating a domain update.
- `"EBSOptions"`: The type and size of the EBS volume to attach to instances in the domain.
- `"EncryptionAtRestOptions"`: Encryption at rest options for the domain.
- `"IPAddressType"`: Specify either dual stack or IPv4 as your IP address type. Dual stack
  allows you to share domain resources across IPv4 and IPv6 address types, and is the
  recommended option. If your IP address type is currently set to dual stack, you can't
  change it.
- `"LogPublishingOptions"`: Options to publish OpenSearch logs to Amazon CloudWatch Logs.
- `"NodeToNodeEncryptionOptions"`: Node-to-node encryption options for the domain.
- `"OffPeakWindowOptions"`: Off-peak window options for the domain.
- `"SnapshotOptions"`: Option to set the time, in UTC format, for the daily automated
  snapshot. Default value is 0 hours.
- `"SoftwareUpdateOptions"`: Service software update options for the domain.
- `"VPCOptions"`: Options to specify the subnets and security groups for a VPC endpoint.
  For more information, see Launching your Amazon OpenSearch Service domains using a VPC.
"""
function update_domain_config(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_domain_config(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/domain/$(DomainName)/config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_package(package_id, package_source)
    update_package(package_id, package_source, params::Dict{String,<:Any})

Updates a package for use with Amazon OpenSearch Service domains. For more information, see
Custom packages for Amazon OpenSearch Service.

# Arguments
- `package_id`: The unique identifier for the package.
- `package_source`: Amazon S3 bucket and key for the package.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CommitMessage"`: Commit message for the updated file, which is shown as part of
  GetPackageVersionHistoryResponse.
- `"PackageDescription"`: A new description of the package.
"""
function update_package(
    PackageID, PackageSource; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/packages/update",
        Dict{String,Any}("PackageID" => PackageID, "PackageSource" => PackageSource);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_package(
    PackageID,
    PackageSource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/packages/update",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PackageID" => PackageID, "PackageSource" => PackageSource
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_scheduled_action(action_id, action_type, domain_name, schedule_at)
    update_scheduled_action(action_id, action_type, domain_name, schedule_at, params::Dict{String,<:Any})

Reschedules a planned domain configuration change for a later time. This change can be a
scheduled service software update or a blue/green Auto-Tune enhancement.

# Arguments
- `action_id`: The unique identifier of the action to reschedule. To retrieve this ID, send
  a ListScheduledActions request.
- `action_type`: The type of action to reschedule. Can be one of SERVICE_SOFTWARE_UPDATE,
  JVM_HEAP_SIZE_TUNING, or JVM_YOUNG_GEN_TUNING. To retrieve this value, send a
  ListScheduledActions request.
- `domain_name`: The name of the domain to reschedule an action for.
- `schedule_at`: When to schedule the action.    NOW - Immediately schedules the update to
  happen in the current hour if there's capacity available.    TIMESTAMP - Lets you specify a
  custom date and time to apply the update. If you specify this value, you must also provide
  a value for DesiredStartTime.    OFF_PEAK_WINDOW - Marks the action to be picked up during
  an upcoming off-peak window. There's no guarantee that the change will be implemented
  during the next immediate window. Depending on capacity, it might happen in subsequent
  days.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DesiredStartTime"`: The time to implement the change, in Coordinated Universal Time
  (UTC). Only specify this parameter if you set ScheduleAt to TIMESTAMP.
"""
function update_scheduled_action(
    ActionID,
    ActionType,
    DomainName,
    ScheduleAt;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "PUT",
        "/2021-01-01/opensearch/domain/$(DomainName)/scheduledAction/update",
        Dict{String,Any}(
            "ActionID" => ActionID, "ActionType" => ActionType, "ScheduleAt" => ScheduleAt
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_scheduled_action(
    ActionID,
    ActionType,
    DomainName,
    ScheduleAt,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "PUT",
        "/2021-01-01/opensearch/domain/$(DomainName)/scheduledAction/update",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ActionID" => ActionID,
                    "ActionType" => ActionType,
                    "ScheduleAt" => ScheduleAt,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_vpc_endpoint(vpc_endpoint_id, vpc_options)
    update_vpc_endpoint(vpc_endpoint_id, vpc_options, params::Dict{String,<:Any})

Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.

# Arguments
- `vpc_endpoint_id`: The unique identifier of the endpoint.
- `vpc_options`: The security groups and/or subnets to add, remove, or modify.

"""
function update_vpc_endpoint(
    VpcEndpointId, VpcOptions; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/vpcEndpoints/update",
        Dict{String,Any}("VpcEndpointId" => VpcEndpointId, "VpcOptions" => VpcOptions);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_vpc_endpoint(
    VpcEndpointId,
    VpcOptions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/vpcEndpoints/update",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VpcEndpointId" => VpcEndpointId, "VpcOptions" => VpcOptions
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    upgrade_domain(domain_name, target_version)
    upgrade_domain(domain_name, target_version, params::Dict{String,<:Any})

Allows you to either upgrade your Amazon OpenSearch Service domain or perform an upgrade
eligibility check to a compatible version of OpenSearch or Elasticsearch.

# Arguments
- `domain_name`: Name of the OpenSearch Service domain that you want to upgrade.
- `target_version`: OpenSearch or Elasticsearch version to which you want to upgrade, in
  the format Opensearch_X.Y or Elasticsearch_X.Y.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdvancedOptions"`: Only supports the override_main_response_version parameter and not
  other advanced options. You can only include this option when upgrading to an OpenSearch
  version. Specifies whether the domain reports its version as 7.10 so that it continues to
  work with Elasticsearch OSS clients and plugins.
- `"PerformCheckOnly"`: When true, indicates that an upgrade eligibility check needs to be
  performed. Does not actually perform the upgrade.
"""
function upgrade_domain(
    DomainName, TargetVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/upgradeDomain",
        Dict{String,Any}("DomainName" => DomainName, "TargetVersion" => TargetVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function upgrade_domain(
    DomainName,
    TargetVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return opensearch(
        "POST",
        "/2021-01-01/opensearch/upgradeDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DomainName" => DomainName, "TargetVersion" => TargetVersion
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
