# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: rekognition
using AWS.Compat
using AWS.UUIDs

"""
    associate_faces(collection_id, face_ids, user_id)
    associate_faces(collection_id, face_ids, user_id, params::Dict{String,<:Any})

Associates one or more faces with an existing UserID. Takes an array of FaceIds. Each
FaceId that are present in the FaceIds list is associated with the provided UserID. The
maximum number of total FaceIds per UserID is 100.  The UserMatchThreshold parameter
specifies the minimum user match confidence required for the face to be associated with a
UserID that has at least one FaceID already associated. This ensures that the FaceIds are
associated with the right UserID. The value ranges from 0-100 and default value is 75.  If
successful, an array of AssociatedFace objects containing the associated FaceIds is
returned. If a given face is already associated with the given UserID, it will be ignored
and will not be returned in the response. If a given face is already associated to a
different UserID, isn't found in the collection, doesn’t meet the UserMatchThreshold, or
there are already 100 faces associated with the UserID, it will be returned as part of an
array of UnsuccessfulFaceAssociations.  The UserStatus reflects the status of an operation
which updates a UserID representation with a list of given faces. The UserStatus can be:
ACTIVE - All associations or disassociations of FaceID(s) for a UserID are complete.
CREATED - A UserID has been created, but has no FaceID(s) associated with it.   UPDATING -
A UserID is being updated and there are current associations or disassociations of
FaceID(s) taking place.

# Arguments
- `collection_id`: The ID of an existing collection containing the UserID.
- `face_ids`: An array of FaceIDs to associate with the UserID.
- `user_id`: The ID for the existing UserID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the request to AssociateFaces.
  If you use the same token with multiple AssociateFaces requests, the same response is
  returned. Use ClientRequestToken to prevent the same request from being processed more than
  once.
- `"UserMatchThreshold"`: An optional value specifying the minimum confidence in the UserID
  match to return. The default value is 75.
"""
function associate_faces(
    CollectionId, FaceIds, UserId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "AssociateFaces",
        Dict{String,Any}(
            "CollectionId" => CollectionId,
            "FaceIds" => FaceIds,
            "UserId" => UserId,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_faces(
    CollectionId,
    FaceIds,
    UserId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "AssociateFaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CollectionId" => CollectionId,
                    "FaceIds" => FaceIds,
                    "UserId" => UserId,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    compare_faces(source_image, target_image)
    compare_faces(source_image, target_image, params::Dict{String,<:Any})

Compares a face in the source input image with each of the 100 largest faces detected in
the target input image.   If the source image contains multiple faces, the service detects
the largest face and compares it with each face detected in the target image.
CompareFaces uses machine learning algorithms, which are probabilistic. A false negative is
an incorrect prediction that a face in the target image has a low similarity confidence
score when compared to the face in the source image. To reduce the probability of false
negatives, we recommend that you compare the target image against multiple source images.
If you plan to use CompareFaces to make a decision that impacts an individual's rights,
privacy, or access to services, we recommend that you pass the result to a human for review
and further validation before taking action.  You pass the input and target images either
as base64-encoded image bytes or as references to images in an Amazon S3 bucket. If you use
the AWS CLI to call Amazon Rekognition operations, passing image bytes isn't supported. The
image must be formatted as a PNG or JPEG file.  In response, the operation returns an array
of face matches ordered by similarity score in descending order. For each face match, the
response provides a bounding box of the face, facial landmarks, pose details (pitch, roll,
and yaw), quality (brightness and sharpness), and confidence value (indicating the level of
confidence that the bounding box contains a face). The response also provides a similarity
score, which indicates how closely the faces match.   By default, only faces with a
similarity score of greater than or equal to 80% are returned in the response. You can
change this value by specifying the SimilarityThreshold parameter.   CompareFaces also
returns an array of faces that don't match the source image. For each face, it returns a
bounding box, confidence value, landmarks, pose details, and quality. The response also
returns information about the face in the source image, including the bounding box of the
face and confidence value. The QualityFilter input parameter allows you to filter out
detected faces that don’t meet a required quality bar. The quality bar is based on a
variety of common use cases. Use QualityFilter to set the quality bar by specifying LOW,
MEDIUM, or HIGH. If you do not want to filter detected faces, specify NONE. The default
value is NONE.  If the image doesn't contain Exif metadata, CompareFaces returns
orientation information for the source and target images. Use these values to display the
images with the correct image orientation. If no faces are detected in the source or target
images, CompareFaces returns an InvalidParameterException error.    This is a stateless API
operation. That is, data returned by this operation doesn't persist.  For an example, see
Comparing Faces in Images in the Amazon Rekognition Developer Guide. This operation
requires permissions to perform the rekognition:CompareFaces action.

# Arguments
- `source_image`: The input image as base64-encoded bytes or an S3 object. If you use the
  AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not
  supported.  If you are using an AWS SDK to call Amazon Rekognition, you might not need to
  base64-encode image bytes passed using the Bytes field. For more information, see Images in
  the Amazon Rekognition developer guide.
- `target_image`: The target image as base64-encoded bytes or an S3 object. If you use the
  AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not
  supported.  If you are using an AWS SDK to call Amazon Rekognition, you might not need to
  base64-encode image bytes passed using the Bytes field. For more information, see Images in
  the Amazon Rekognition developer guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"QualityFilter"`: A filter that specifies a quality bar for how much filtering is done
  to identify faces. Filtered faces aren't compared. If you specify AUTO, Amazon Rekognition
  chooses the quality bar. If you specify LOW, MEDIUM, or HIGH, filtering removes all faces
  that don’t meet the chosen quality bar. The quality bar is based on a variety of common
  use cases. Low-quality detections can occur for a number of reasons. Some examples are an
  object that's misidentified as a face, a face that's too blurry, or a face with a pose
  that's too extreme to use. If you specify NONE, no filtering is performed. The default
  value is NONE.  To use quality filtering, the collection you are using must be associated
  with version 3 of the face model or higher.
- `"SimilarityThreshold"`: The minimum level of confidence in the face matches that a match
  must meet to be included in the FaceMatches array.
"""
function compare_faces(
    SourceImage, TargetImage; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "CompareFaces",
        Dict{String,Any}("SourceImage" => SourceImage, "TargetImage" => TargetImage);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function compare_faces(
    SourceImage,
    TargetImage,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CompareFaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceImage" => SourceImage, "TargetImage" => TargetImage
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_project_version(destination_project_arn, output_config, source_project_arn, source_project_version_arn, version_name)
    copy_project_version(destination_project_arn, output_config, source_project_arn, source_project_version_arn, version_name, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Copies a version of an
Amazon Rekognition Custom Labels model from a source project to a destination project. The
source and destination projects can be in different AWS accounts but must be in the same
AWS Region. You can't copy a model to another AWS service.  To copy a model version to a
different AWS account, you need to create a resource-based policy known as a project
policy. You attach the project policy to the source project by calling PutProjectPolicy.
The project policy gives permission to copy the model version from a trusting AWS account
to a trusted account. For more information creating and attaching a project policy, see
Attaching a project policy (SDK) in the Amazon Rekognition Custom Labels Developer Guide.
If you are copying a model version to a project in the same AWS account, you don't need to
create a project policy.  Copying project versions is supported only for Custom Labels
models.  To copy a model, the destination project, source project, and source model version
must already exist.  Copying a model version takes a while to complete. To get the current
status, call DescribeProjectVersions and check the value of Status in the
ProjectVersionDescription object. The copy operation has finished when the value of Status
is COPYING_COMPLETED. This operation requires permissions to perform the
rekognition:CopyProjectVersion action.

# Arguments
- `destination_project_arn`: The ARN of the project in the trusted AWS account that you
  want to copy the model version to.
- `output_config`: The S3 bucket and folder location where the training output for the
  source model version is placed.
- `source_project_arn`: The ARN of the source project in the trusting AWS account.
- `source_project_version_arn`: The ARN of the model version in the source project that you
  want to copy to a destination project.
- `version_name`: A name for the version of the model that's copied to the destination
  project.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KmsKeyId"`: The identifier for your AWS Key Management Service key (AWS KMS key). You
  can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias
  for your KMS key, or an alias ARN. The key is used to encrypt training results and manifest
  files written to the output Amazon S3 bucket (OutputConfig). If you choose to use your own
  KMS key, you need the following permissions on the KMS key.   kms:CreateGrant
  kms:DescribeKey   kms:GenerateDataKey   kms:Decrypt   If you don't specify a value for
  KmsKeyId, images copied into the service are encrypted using a key that AWS owns and
  manages.
- `"Tags"`: The key-value tags to assign to the model version.
"""
function copy_project_version(
    DestinationProjectArn,
    OutputConfig,
    SourceProjectArn,
    SourceProjectVersionArn,
    VersionName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CopyProjectVersion",
        Dict{String,Any}(
            "DestinationProjectArn" => DestinationProjectArn,
            "OutputConfig" => OutputConfig,
            "SourceProjectArn" => SourceProjectArn,
            "SourceProjectVersionArn" => SourceProjectVersionArn,
            "VersionName" => VersionName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_project_version(
    DestinationProjectArn,
    OutputConfig,
    SourceProjectArn,
    SourceProjectVersionArn,
    VersionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CopyProjectVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationProjectArn" => DestinationProjectArn,
                    "OutputConfig" => OutputConfig,
                    "SourceProjectArn" => SourceProjectArn,
                    "SourceProjectVersionArn" => SourceProjectVersionArn,
                    "VersionName" => VersionName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_collection(collection_id)
    create_collection(collection_id, params::Dict{String,<:Any})

Creates a collection in an AWS Region. You can add faces to the collection using the
IndexFaces operation.  For example, you might create collections, one for each of your
application users. A user can then index faces using the IndexFaces operation and persist
results in a specific collection. Then, a user can search the collection for faces in the
user-specific container.  When you create a collection, it is associated with the latest
version of the face model version.  Collection names are case-sensitive.  This operation
requires permissions to perform the rekognition:CreateCollection action. If you want to tag
your collection, you also require permission to perform the rekognition:TagResource
operation.

# Arguments
- `collection_id`: ID for the collection that you are creating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:  A set of tags (key-value pairs) that you want to attach to the collection.
"""
function create_collection(CollectionId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "CreateCollection",
        Dict{String,Any}("CollectionId" => CollectionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_collection(
    CollectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CreateCollection",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CollectionId" => CollectionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dataset(dataset_type, project_arn)
    create_dataset(dataset_type, project_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Creates a new Amazon
Rekognition Custom Labels dataset. You can create a dataset by using an Amazon Sagemaker
format manifest file or by copying an existing Amazon Rekognition Custom Labels dataset. To
create a training dataset for a project, specify TRAIN for the value of DatasetType. To
create the test dataset for a project, specify TEST for the value of DatasetType.  The
response from CreateDataset is the Amazon Resource Name (ARN) for the dataset. Creating a
dataset takes a while to complete. Use DescribeDataset to check the current status. The
dataset created successfully if the value of Status is CREATE_COMPLETE.  To check if any
non-terminal errors occurred, call ListDatasetEntries and check for the presence of errors
lists in the JSON Lines. Dataset creation fails if a terminal error occurs (Status =
CREATE_FAILED). Currently, you can't access the terminal error information.  For more
information, see Creating dataset in the Amazon Rekognition Custom Labels Developer Guide.
This operation requires permissions to perform the rekognition:CreateDataset action. If you
want to copy an existing dataset, you also require permission to perform the
rekognition:ListDatasetEntries action.

# Arguments
- `dataset_type`:  The type of the dataset. Specify TRAIN to create a training dataset.
  Specify TEST to create a test dataset.
- `project_arn`:  The ARN of the Amazon Rekognition Custom Labels project to which you want
  to asssign the dataset.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DatasetSource"`:  The source files for the dataset. You can specify the ARN of an
  existing dataset or specify the Amazon S3 bucket location of an Amazon Sagemaker format
  manifest file. If you don't specify datasetSource, an empty dataset is created. To add
  labeled images to the dataset, You can use the console or call UpdateDatasetEntries.
"""
function create_dataset(
    DatasetType, ProjectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "CreateDataset",
        Dict{String,Any}("DatasetType" => DatasetType, "ProjectArn" => ProjectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dataset(
    DatasetType,
    ProjectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CreateDataset",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DatasetType" => DatasetType, "ProjectArn" => ProjectArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_face_liveness_session()
    create_face_liveness_session(params::Dict{String,<:Any})

This API operation initiates a Face Liveness session. It returns a SessionId, which you can
use to start streaming Face Liveness video and get the results for a Face Liveness session.
 You can use the OutputConfig option in the Settings parameter to provide an Amazon S3
bucket location. The Amazon S3 bucket stores reference images and audit images. If no
Amazon S3 bucket is defined, raw bytes are sent instead.  You can use AuditImagesLimit to
limit the number of audit images returned when GetFaceLivenessSessionResults is called.
This number is between 0 and 4. By default, it is set to 0. The limit is best effort and
based on the duration of the selfie-video.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token is used to recognize the Face Liveness request.
  If the same token is used with multiple CreateFaceLivenessSession requests, the same
  session is returned. This token is employed to avoid unintentionally creating the same
  session multiple times.
- `"KmsKeyId"`:  The identifier for your AWS Key Management Service key (AWS KMS key). Used
  to encrypt audit images and reference images.
- `"Settings"`: A session settings object. It contains settings for the operation to be
  performed. For Face Liveness, it accepts OutputConfig and AuditImagesLimit.
"""
function create_face_liveness_session(; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "CreateFaceLivenessSession"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_face_liveness_session(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "CreateFaceLivenessSession",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_project(project_name)
    create_project(project_name, params::Dict{String,<:Any})

Creates a new Amazon Rekognition project. A project is a group of resources (datasets,
model versions) that you use to create and manage a Amazon Rekognition Custom Labels Model
or custom adapter. You can specify a feature to create the project with, if no feature is
specified then Custom Labels is used by default. For adapters, you can also choose whether
or not to have the project auto update by using the AutoUpdate argument. This operation
requires permissions to perform the rekognition:CreateProject action.

# Arguments
- `project_name`: The name of the project to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AutoUpdate"`: Specifies whether automatic retraining should be attempted for the
  versions of the project. Automatic retraining is done as a best effort. Required argument
  for Content Moderation. Applicable only to adapters.
- `"Feature"`: Specifies feature that is being customized. If no value is provided
  CUSTOM_LABELS is used as a default.
"""
function create_project(ProjectName; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "CreateProject",
        Dict{String,Any}("ProjectName" => ProjectName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_project(
    ProjectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CreateProject",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProjectName" => ProjectName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_project_version(output_config, project_arn, version_name)
    create_project_version(output_config, project_arn, version_name, params::Dict{String,<:Any})

Creates a new version of Amazon Rekognition project (like a Custom Labels model or a custom
adapter) and begins training. Models and adapters are managed as part of a Rekognition
project. The response from CreateProjectVersion is an Amazon Resource Name (ARN) for the
project version.  The FeatureConfig operation argument allows you to configure specific
model or adapter settings. You can provide a description to the project version by using
the VersionDescription argment. Training can take a while to complete. You can get the
current status by calling DescribeProjectVersions. Training completed successfully if the
value of the Status field is TRAINING_COMPLETED. Once training has successfully completed,
call DescribeProjectVersions to get the training results and evaluate the model. This
operation requires permissions to perform the rekognition:CreateProjectVersion action.
The following applies only to projects with Amazon Rekognition Custom Labels as the chosen
feature:  You can train a model in a project that doesn't have associated datasets by
specifying manifest files in the TrainingData and TestingData fields.  If you open the
console after training a model with manifest files, Amazon Rekognition Custom Labels
creates the datasets for you using the most recent manifest files. You can no longer train
a model version for the project by specifying manifest files.  Instead of training with a
project without associated datasets, we recommend that you use the manifest files to create
training and test datasets for the project.

# Arguments
- `output_config`: The Amazon S3 bucket location to store the results of training. The
  bucket can be any S3 bucket in your AWS account. You need s3:PutObject permission on the
  bucket.
- `project_arn`: The ARN of the Amazon Rekognition project that will manage the project
  version you want to train.
- `version_name`: A name for the version of the project version. This value must be unique.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FeatureConfig"`: Feature-specific configuration of the training job. If the job
  configuration does not match the feature type associated with the project, an
  InvalidParameterException is returned.
- `"KmsKeyId"`: The identifier for your AWS Key Management Service key (AWS KMS key). You
  can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias
  for your KMS key, or an alias ARN. The key is used to encrypt training images, test images,
  and manifest files copied into the service for the project version. Your source images are
  unaffected. The key is also used to encrypt training results and manifest files written to
  the output Amazon S3 bucket (OutputConfig). If you choose to use your own KMS key, you need
  the following permissions on the KMS key.   kms:CreateGrant   kms:DescribeKey
  kms:GenerateDataKey   kms:Decrypt   If you don't specify a value for KmsKeyId, images
  copied into the service are encrypted using a key that AWS owns and manages.
- `"Tags"`:  A set of tags (key-value pairs) that you want to attach to the project
  version.
- `"TestingData"`: Specifies an external manifest that the service uses to test the project
  version. If you specify TestingData you must also specify TrainingData. The project must
  not have any associated datasets.
- `"TrainingData"`: Specifies an external manifest that the services uses to train the
  project version. If you specify TrainingData you must also specify TestingData. The project
  must not have any associated datasets.
- `"VersionDescription"`: A description applied to the project version being created.
"""
function create_project_version(
    OutputConfig,
    ProjectArn,
    VersionName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CreateProjectVersion",
        Dict{String,Any}(
            "OutputConfig" => OutputConfig,
            "ProjectArn" => ProjectArn,
            "VersionName" => VersionName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_project_version(
    OutputConfig,
    ProjectArn,
    VersionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CreateProjectVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OutputConfig" => OutputConfig,
                    "ProjectArn" => ProjectArn,
                    "VersionName" => VersionName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_stream_processor(input, name, output, role_arn, settings)
    create_stream_processor(input, name, output, role_arn, settings, params::Dict{String,<:Any})

Creates an Amazon Rekognition stream processor that you can use to detect and recognize
faces or to detect labels in a streaming video. Amazon Rekognition Video is a consumer of
live video from Amazon Kinesis Video Streams. There are two different settings for stream
processors in Amazon Rekognition: detecting faces and detecting labels.   If you are
creating a stream processor for detecting faces, you provide as input a Kinesis video
stream (Input) and a Kinesis data stream (Output) stream for receiving the output. You must
use the FaceSearch option in Settings, specifying the collection that contains the faces
you want to recognize. After you have finished analyzing a streaming video, use
StopStreamProcessor to stop processing.   If you are creating a stream processor to detect
labels, you provide as input a Kinesis video stream (Input), Amazon S3 bucket information
(Output), and an Amazon SNS topic ARN (NotificationChannel). You can also provide a KMS key
ID to encrypt the data sent to your Amazon S3 bucket. You specify what you want to detect
by using the ConnectedHome option in settings, and selecting one of the following: PERSON,
PET, PACKAGE, ALL You can also specify where in the frame you want Amazon Rekognition to
monitor with RegionsOfInterest. When you run the StartStreamProcessor operation on a label
detection stream processor, you input start and stop information to determine the length of
the processing time.    Use Name to assign an identifier for the stream processor. You use
Name to manage the stream processor. For example, you can start processing the source video
by calling StartStreamProcessor with the Name field.  This operation requires permissions
to perform the rekognition:CreateStreamProcessor action. If you want to tag your stream
processor, you also require permission to perform the rekognition:TagResource operation.

# Arguments
- `input`: Kinesis video stream stream that provides the source streaming video. If you are
  using the AWS CLI, the parameter name is StreamProcessorInput. This is required for both
  face search and label detection stream processors.
- `name`: An identifier you assign to the stream processor. You can use Name to manage the
  stream processor. For example, you can get the current status of the stream processor by
  calling DescribeStreamProcessor. Name is idempotent. This is required for both face search
  and label detection stream processors.
- `output`: Kinesis data stream stream or Amazon S3 bucket location to which Amazon
  Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter
  name is StreamProcessorOutput. This must be a S3Destination of an Amazon S3 bucket that you
  own for a label detection stream processor or a Kinesis data stream ARN for a face search
  stream processor.
- `role_arn`: The Amazon Resource Number (ARN) of the IAM role that allows access to the
  stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream.
  It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification
  Service topic for a label detection stream processor. This is required for both face search
  and label detection stream processors.
- `settings`: Input parameters used in a streaming video analyzed by a stream processor.
  You can use FaceSearch to recognize faces in a streaming video, or you can use
  ConnectedHome to detect labels.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataSharingPreference"`:  Shows whether you are sharing data with Rekognition to
  improve model performance. You can choose this option at the account level or on a
  per-stream basis. Note that if you opt out at the account level this setting is ignored on
  individual streams.
- `"KmsKeyId"`:  The identifier for your AWS Key Management Service key (AWS KMS key). This
  is an optional parameter for label detection stream processors and should not be used to
  create a face search stream processor. You can supply the Amazon Resource Name (ARN) of
  your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key
  is used to encrypt results and data published to your Amazon S3 bucket, which includes
  image frames and hero images. Your source images are unaffected.
- `"NotificationChannel"`:
- `"RegionsOfInterest"`:  Specifies locations in the frames where Amazon Rekognition checks
  for objects or people. You can specify up to 10 regions of interest, and each region has
  either a polygon or a bounding box. This is an optional parameter for label detection
  stream processors and should not be used to create a face search stream processor.
- `"Tags"`:  A set of tags (key-value pairs) that you want to attach to the stream
  processor.
"""
function create_stream_processor(
    Input,
    Name,
    Output,
    RoleArn,
    Settings;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CreateStreamProcessor",
        Dict{String,Any}(
            "Input" => Input,
            "Name" => Name,
            "Output" => Output,
            "RoleArn" => RoleArn,
            "Settings" => Settings,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_stream_processor(
    Input,
    Name,
    Output,
    RoleArn,
    Settings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CreateStreamProcessor",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Input" => Input,
                    "Name" => Name,
                    "Output" => Output,
                    "RoleArn" => RoleArn,
                    "Settings" => Settings,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user(collection_id, user_id)
    create_user(collection_id, user_id, params::Dict{String,<:Any})

Creates a new User within a collection specified by CollectionId. Takes UserId as a
parameter, which is a user provided ID which should be unique within the collection. The
provided UserId will alias the system generated UUID to make the UserId more user friendly.
 Uses a ClientToken, an idempotency token that ensures a call to CreateUser completes only
once. If the value is not supplied, the AWS SDK generates an idempotency token for the
requests. This prevents retries after a network error results from making multiple
CreateUser calls.

# Arguments
- `collection_id`: The ID of an existing collection to which the new UserID needs to be
  created.
- `user_id`: ID for the UserID to be created. This ID needs to be unique within the
  collection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the request to CreateUser. If
  you use the same token with multiple CreateUser requests, the same response is returned.
  Use ClientRequestToken to prevent the same request from being processed more than once.
"""
function create_user(
    CollectionId, UserId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "CreateUser",
        Dict{String,Any}(
            "CollectionId" => CollectionId,
            "UserId" => UserId,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user(
    CollectionId,
    UserId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "CreateUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CollectionId" => CollectionId,
                    "UserId" => UserId,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_collection(collection_id)
    delete_collection(collection_id, params::Dict{String,<:Any})

Deletes the specified collection. Note that this operation removes all faces in the
collection. For an example, see Deleting a collection. This operation requires permissions
to perform the rekognition:DeleteCollection action.

# Arguments
- `collection_id`: ID of the collection to delete.

"""
function delete_collection(CollectionId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DeleteCollection",
        Dict{String,Any}("CollectionId" => CollectionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_collection(
    CollectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DeleteCollection",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CollectionId" => CollectionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dataset(dataset_arn)
    delete_dataset(dataset_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Deletes an existing
Amazon Rekognition Custom Labels dataset. Deleting a dataset might take while. Use
DescribeDataset to check the current status. The dataset is still deleting if the value of
Status is DELETE_IN_PROGRESS. If you try to access the dataset after it is deleted, you get
a ResourceNotFoundException exception.  You can't delete a dataset while it is creating
(Status = CREATE_IN_PROGRESS) or if the dataset is updating (Status = UPDATE_IN_PROGRESS).
This operation requires permissions to perform the rekognition:DeleteDataset action.

# Arguments
- `dataset_arn`:  The ARN of the Amazon Rekognition Custom Labels dataset that you want to
  delete.

"""
function delete_dataset(DatasetArn; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DeleteDataset",
        Dict{String,Any}("DatasetArn" => DatasetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dataset(
    DatasetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DeleteDataset",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DatasetArn" => DatasetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_faces(collection_id, face_ids)
    delete_faces(collection_id, face_ids, params::Dict{String,<:Any})

Deletes faces from a collection. You specify a collection ID and an array of face IDs to
remove from the collection. This operation requires permissions to perform the
rekognition:DeleteFaces action.

# Arguments
- `collection_id`: Collection from which to remove the specific faces.
- `face_ids`: An array of face IDs to delete.

"""
function delete_faces(
    CollectionId, FaceIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DeleteFaces",
        Dict{String,Any}("CollectionId" => CollectionId, "FaceIds" => FaceIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_faces(
    CollectionId,
    FaceIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DeleteFaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CollectionId" => CollectionId, "FaceIds" => FaceIds),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_project(project_arn)
    delete_project(project_arn, params::Dict{String,<:Any})

Deletes a Amazon Rekognition project. To delete a project you must first delete all models
or adapters associated with the project. To delete a model or adapter, see
DeleteProjectVersion.  DeleteProject is an asynchronous operation. To check if the project
is deleted, call DescribeProjects. The project is deleted when the project no longer
appears in the response. Be aware that deleting a given project will also delete any
ProjectPolicies associated with that project. This operation requires permissions to
perform the rekognition:DeleteProject action.

# Arguments
- `project_arn`: The Amazon Resource Name (ARN) of the project that you want to delete.

"""
function delete_project(ProjectArn; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DeleteProject",
        Dict{String,Any}("ProjectArn" => ProjectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_project(
    ProjectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DeleteProject",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProjectArn" => ProjectArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_project_policy(policy_name, project_arn)
    delete_project_policy(policy_name, project_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Deletes an existing
project policy. To get a list of project policies attached to a project, call
ListProjectPolicies. To attach a project policy to a project, call PutProjectPolicy. This
operation requires permissions to perform the rekognition:DeleteProjectPolicy action.

# Arguments
- `policy_name`: The name of the policy that you want to delete.
- `project_arn`: The Amazon Resource Name (ARN) of the project that the project policy you
  want to delete is attached to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PolicyRevisionId"`: The ID of the project policy revision that you want to delete.
"""
function delete_project_policy(
    PolicyName, ProjectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DeleteProjectPolicy",
        Dict{String,Any}("PolicyName" => PolicyName, "ProjectArn" => ProjectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_project_policy(
    PolicyName,
    ProjectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DeleteProjectPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyName" => PolicyName, "ProjectArn" => ProjectArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_project_version(project_version_arn)
    delete_project_version(project_version_arn, params::Dict{String,<:Any})

Deletes a Rekognition project model or project version, like a Amazon Rekognition Custom
Labels model or a custom adapter. You can't delete a project version if it is running or if
it is training. To check the status of a project version, use the Status field returned
from DescribeProjectVersions. To stop a project version call StopProjectVersion. If the
project version is training, wait until it finishes. This operation requires permissions to
perform the rekognition:DeleteProjectVersion action.

# Arguments
- `project_version_arn`: The Amazon Resource Name (ARN) of the project version that you
  want to delete.

"""
function delete_project_version(
    ProjectVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DeleteProjectVersion",
        Dict{String,Any}("ProjectVersionArn" => ProjectVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_project_version(
    ProjectVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DeleteProjectVersion",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ProjectVersionArn" => ProjectVersionArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_stream_processor(name)
    delete_stream_processor(name, params::Dict{String,<:Any})

Deletes the stream processor identified by Name. You assign the value for Name when you
create the stream processor with CreateStreamProcessor. You might not be able to use the
same name for a stream processor for a few seconds after calling DeleteStreamProcessor.

# Arguments
- `name`: The name of the stream processor you want to delete.

"""
function delete_stream_processor(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DeleteStreamProcessor",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_stream_processor(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DeleteStreamProcessor",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user(collection_id, user_id)
    delete_user(collection_id, user_id, params::Dict{String,<:Any})

Deletes the specified UserID within the collection. Faces that are associated with the
UserID are disassociated from the UserID before deleting the specified UserID. If the
specified Collection or UserID is already deleted or not found, a ResourceNotFoundException
will be thrown. If the action is successful with a 200 response, an empty HTTP body is
returned.

# Arguments
- `collection_id`: The ID of an existing collection from which the UserID needs to be
  deleted.
- `user_id`: ID for the UserID to be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the request to DeleteUser. If
  you use the same token with multiple DeleteUser requests, the same response is returned.
  Use ClientRequestToken to prevent the same request from being processed more than once.
"""
function delete_user(
    CollectionId, UserId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DeleteUser",
        Dict{String,Any}(
            "CollectionId" => CollectionId,
            "UserId" => UserId,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user(
    CollectionId,
    UserId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DeleteUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CollectionId" => CollectionId,
                    "UserId" => UserId,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_collection(collection_id)
    describe_collection(collection_id, params::Dict{String,<:Any})

Describes the specified collection. You can use DescribeCollection to get information, such
as the number of faces indexed into a collection and the version of the model used by the
collection for face detection. For more information, see Describing a Collection in the
Amazon Rekognition Developer Guide.

# Arguments
- `collection_id`: The ID of the collection to describe.

"""
function describe_collection(
    CollectionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DescribeCollection",
        Dict{String,Any}("CollectionId" => CollectionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_collection(
    CollectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DescribeCollection",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CollectionId" => CollectionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dataset(dataset_arn)
    describe_dataset(dataset_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.   Describes an Amazon
Rekognition Custom Labels dataset. You can get information such as the current status of a
dataset and statistics about the images and labels in a dataset.  This operation requires
permissions to perform the rekognition:DescribeDataset action.

# Arguments
- `dataset_arn`:  The Amazon Resource Name (ARN) of the dataset that you want to describe.

"""
function describe_dataset(DatasetArn; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DescribeDataset",
        Dict{String,Any}("DatasetArn" => DatasetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dataset(
    DatasetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DescribeDataset",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DatasetArn" => DatasetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_project_versions(project_arn)
    describe_project_versions(project_arn, params::Dict{String,<:Any})

Lists and describes the versions of an Amazon Rekognition project. You can specify up to 10
model or adapter versions in ProjectVersionArns. If you don't specify a value, descriptions
for all model/adapter versions in the project are returned. This operation requires
permissions to perform the rekognition:DescribeProjectVersions action.

# Arguments
- `project_arn`: The Amazon Resource Name (ARN) of the project that contains the
  model/adapter you want to describe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return per paginated call. The largest
  value you can specify is 100. If you specify a value greater than 100, a
  ValidationException error occurs. The default value is 100.
- `"NextToken"`: If the previous response was incomplete (because there is more results to
  retrieve), Amazon Rekognition returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of results.
- `"VersionNames"`: A list of model or project version names that you want to describe. You
  can add up to 10 model or project version names to the list. If you don't specify a value,
  all project version descriptions are returned. A version name is part of a project version
  ARN. For example, my-model.2020-01-21T09.10.15 is the version name in the following ARN.
  arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/my-model.2020-01
  -21T09.10.15/1234567890123.
"""
function describe_project_versions(
    ProjectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DescribeProjectVersions",
        Dict{String,Any}("ProjectArn" => ProjectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_project_versions(
    ProjectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DescribeProjectVersions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProjectArn" => ProjectArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_projects()
    describe_projects(params::Dict{String,<:Any})

Gets information about your Rekognition projects. This operation requires permissions to
perform the rekognition:DescribeProjects action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Features"`: Specifies the type of customization to filter projects by. If no value is
  specified, CUSTOM_LABELS is used as a default.
- `"MaxResults"`: The maximum number of results to return per paginated call. The largest
  value you can specify is 100. If you specify a value greater than 100, a
  ValidationException error occurs. The default value is 100.
- `"NextToken"`: If the previous response was incomplete (because there is more results to
  retrieve), Rekognition returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of results.
- `"ProjectNames"`: A list of the projects that you want Rekognition to describe. If you
  don't specify a value, the response includes descriptions for all the projects in your AWS
  account.
"""
function describe_projects(; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DescribeProjects"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_projects(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DescribeProjects", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_stream_processor(name)
    describe_stream_processor(name, params::Dict{String,<:Any})

Provides information about a stream processor created by CreateStreamProcessor. You can get
information about the input and output streams, the input parameters for the face
recognition being performed, and the current status of the stream processor.

# Arguments
- `name`: Name of the stream processor for which you want information.

"""
function describe_stream_processor(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DescribeStreamProcessor",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_stream_processor(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DescribeStreamProcessor",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detect_custom_labels(image, project_version_arn)
    detect_custom_labels(image, project_version_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Detects custom labels in
a supplied image by using an Amazon Rekognition Custom Labels model.  You specify which
version of a model version to use by using the ProjectVersionArn input parameter.  You pass
the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3
bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes
is not supported. The image must be either a PNG or JPEG formatted file.   For each object
that the model version detects on an image, the API returns a (CustomLabel) object in an
array (CustomLabels). Each CustomLabel object provides the label name (Name), the level of
confidence that the image contains the object (Confidence), and object location
information, if it exists, for the label on the image (Geometry). Note that for the
DetectCustomLabelsLabels operation, Polygons are not returned in the Geometry section of
the response. To filter labels that are returned, specify a value for MinConfidence.
DetectCustomLabelsLabels only returns labels with a confidence that's higher than the
specified value. The value of MinConfidence maps to the assumed threshold values created
during training. For more information, see Assumed threshold in the Amazon Rekognition
Custom Labels Developer Guide. Amazon Rekognition Custom Labels metrics expresses an
assumed threshold as a floating point value between 0-1. The range of MinConfidence
normalizes the threshold value to a percentage value (0-100). Confidence responses from
DetectCustomLabels are also returned as a percentage. You can use MinConfidence to change
the precision and recall or your model. For more information, see Analyzing an image in the
Amazon Rekognition Custom Labels Developer Guide.  If you don't specify a value for
MinConfidence, DetectCustomLabels returns labels based on the assumed threshold of each
label. This is a stateless API operation. That is, the operation does not persist any data.
This operation requires permissions to perform the rekognition:DetectCustomLabels action.
For more information, see Analyzing an image in the Amazon Rekognition Custom Labels
Developer Guide.

# Arguments
- `image`:
- `project_version_arn`: The ARN of the model version that you want to use. Only models
  associated with Custom Labels projects accepted by the operation. If a provided ARN refers
  to a model version associated with a project for a different feature type, then an
  InvalidParameterException is returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results you want the service to return in the response.
  The service returns the specified number of highest confidence labels ranked from highest
  confidence to lowest.
- `"MinConfidence"`: Specifies the minimum confidence level for the labels to return.
  DetectCustomLabels doesn't return any labels with a confidence value that's lower than this
  specified value. If you specify a value of 0, DetectCustomLabels returns all labels,
  regardless of the assumed threshold applied to each label. If you don't specify a value for
  MinConfidence, DetectCustomLabels returns labels based on the assumed threshold of each
  label.
"""
function detect_custom_labels(
    Image, ProjectVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DetectCustomLabels",
        Dict{String,Any}("Image" => Image, "ProjectVersionArn" => ProjectVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detect_custom_labels(
    Image,
    ProjectVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DetectCustomLabels",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Image" => Image, "ProjectVersionArn" => ProjectVersionArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detect_faces(image)
    detect_faces(image, params::Dict{String,<:Any})

Detects faces within an image that is provided as input.  DetectFaces detects the 100
largest faces in the image. For each face detected, the operation returns face details.
These details include a bounding box of the face, a confidence value (that the bounding box
contains a face), and a fixed set of attributes such as facial landmarks (for example,
coordinates of eye and mouth), pose, presence of facial occlusion, and so on. The
face-detection algorithm is most effective on frontal faces. For non-frontal or obscured
faces, the algorithm might not detect the faces or might detect faces with lower
confidence.  You pass the input image either as base64-encoded image bytes or as a
reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
Rekognition operations, passing image bytes is not supported. The image must be either a
PNG or JPEG formatted file.   This is a stateless API operation. That is, the operation
does not persist any data.  This operation requires permissions to perform the
rekognition:DetectFaces action.

# Arguments
- `image`: The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI
  to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
   If you are using an AWS SDK to call Amazon Rekognition, you might not need to
  base64-encode image bytes passed using the Bytes field. For more information, see Images in
  the Amazon Rekognition developer guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Attributes"`: An array of facial attributes you want to be returned. A DEFAULT subset
  of facial attributes - BoundingBox, Confidence, Pose, Quality, and Landmarks - will always
  be returned. You can request for specific facial attributes (in addition to the default
  list) - by using [\"DEFAULT\", \"FACE_OCCLUDED\"] or just [\"FACE_OCCLUDED\"]. You can
  request for all facial attributes by using [\"ALL\"]. Requesting more attributes may
  increase response time. If you provide both, [\"ALL\", \"DEFAULT\"], the service uses a
  logical \"AND\" operator to determine which attributes to return (in this case, all
  attributes).  Note that while the FaceOccluded and EyeDirection attributes are supported
  when using DetectFaces, they aren't supported when analyzing videos with StartFaceDetection
  and GetFaceDetection.
"""
function detect_faces(Image; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DetectFaces",
        Dict{String,Any}("Image" => Image);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detect_faces(
    Image, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DetectFaces",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Image" => Image), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detect_labels(image)
    detect_labels(image, params::Dict{String,<:Any})

Detects instances of real-world entities within an image (JPEG or PNG) provided as input.
This includes objects like flower, tree, and table; events like wedding, graduation, and
birthday party; and concepts like landscape, evening, and nature.  For an example, see
Analyzing images stored in an Amazon S3 bucket in the Amazon Rekognition Developer Guide.
You pass the input image as base64-encoded image bytes or as a reference to an image in an
Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing
image bytes is not supported. The image must be either a PNG or JPEG formatted file.
Optional Parameters  You can specify one or both of the GENERAL_LABELS and IMAGE_PROPERTIES
feature types when calling the DetectLabels API. Including GENERAL_LABELS will ensure the
response includes the labels detected in the input image, while including IMAGE_PROPERTIES
will ensure the response includes information about the image quality and color. When using
GENERAL_LABELS and/or IMAGE_PROPERTIES you can provide filtering criteria to the Settings
parameter. You can filter with sets of individual labels or with label categories. You can
specify inclusive filters, exclusive filters, or a combination of inclusive and exclusive
filters. For more information on filtering see Detecting Labels in an Image. When getting
labels, you can specify MinConfidence to control the confidence threshold for the labels
returned. The default is 55%. You can also add the MaxLabels parameter to limit the number
of labels returned. The default and upper limit is 1000 labels. These arguments are only
valid when supplying GENERAL_LABELS as a feature type.  Response Elements   For each
object, scene, and concept the API returns one or more labels. The API returns the
following types of information about labels:    Name - The name of the detected label.
Confidence - The level of confidence in the label assigned to a detected object.
Parents - The ancestor labels for a detected label. DetectLabels returns a hierarchical
taxonomy of detected labels. For example, a detected car might be assigned the label car.
The label car has two parent labels: Vehicle (its parent) and Transportation (its
grandparent). The response includes the all ancestors for a label, where every ancestor is
a unique label. In the previous example, Car, Vehicle, and Transportation are returned as
unique labels in the response.     Aliases - Possible Aliases for the label.     Categories
- The label categories that the detected label belongs to.     BoundingBox — Bounding
boxes are described for all instances of detected common object labels, returned in an
array of Instance objects. An Instance object contains a BoundingBox object, describing the
location of the label on the input image. It also includes the confidence for the accuracy
of the detected bounding box.     The API returns the following information regarding the
image, as part of the ImageProperties structure:   Quality - Information about the
Sharpness, Brightness, and Contrast of the input image, scored between 0 to 100. Image
quality is returned for the entire image, as well as the background and the foreground.
Dominant Color - An array of the dominant colors in the image.    Foreground - Information
about the sharpness, brightness, and dominant colors of the input image’s foreground.
Background - Information about the sharpness, brightness, and dominant colors of the input
image’s background.   The list of returned labels will include at least one label for
every detected object, along with information about that label. In the following example,
suppose the input image has a lighthouse, the sea, and a rock. The response includes all
three labels, one for each object, as well as the confidence in the label:  {Name:
lighthouse, Confidence: 98.4629}   {Name: rock,Confidence: 79.2097}    {Name:
sea,Confidence: 75.061}  The list of labels can include multiple labels for the same
object. For example, if the input image shows a flower (for example, a tulip), the
operation might return the following three labels.   {Name: flower,Confidence: 99.0562}
{Name: plant,Confidence: 99.0562}   {Name: tulip,Confidence: 99.0562}  In this example, the
detection algorithm more precisely identifies the flower as a tulip.  If the object
detected is a person, the operation doesn't provide the same facial details that the
DetectFaces operation provides.  This is a stateless API operation that doesn't return any
data. This operation requires permissions to perform the rekognition:DetectLabels action.

# Arguments
- `image`: The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI
  to call Amazon Rekognition operations, passing image bytes is not supported. Images stored
  in an S3 Bucket do not need to be base64-encoded. If you are using an AWS SDK to call
  Amazon Rekognition, you might not need to base64-encode image bytes passed using the Bytes
  field. For more information, see Images in the Amazon Rekognition developer guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Features"`: A list of the types of analysis to perform. Specifying GENERAL_LABELS uses
  the label detection feature, while specifying IMAGE_PROPERTIES returns information
  regarding image color and quality. If no option is specified GENERAL_LABELS is used by
  default.
- `"MaxLabels"`: Maximum number of labels you want the service to return in the response.
  The service returns the specified number of highest confidence labels. Only valid when
  GENERAL_LABELS is specified as a feature type in the Feature input parameter.
- `"MinConfidence"`: Specifies the minimum confidence level for the labels to return.
  Amazon Rekognition doesn't return any labels with confidence lower than this specified
  value. If MinConfidence is not specified, the operation returns labels with a confidence
  values greater than or equal to 55 percent. Only valid when GENERAL_LABELS is specified as
  a feature type in the Feature input parameter.
- `"Settings"`: A list of the filters to be applied to returned detected labels and image
  properties. Specified filters can be inclusive, exclusive, or a combination of both.
  Filters can be used for individual labels or label categories. The exact label names or
  label categories must be supplied. For a full list of labels and label categories, see
  Detecting labels.
"""
function detect_labels(Image; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DetectLabels",
        Dict{String,Any}("Image" => Image);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detect_labels(
    Image, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DetectLabels",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Image" => Image), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detect_moderation_labels(image)
    detect_moderation_labels(image, params::Dict{String,<:Any})

Detects unsafe content in a specified JPEG or PNG format image. Use DetectModerationLabels
to moderate images depending on your requirements. For example, you might want to filter
images that contain nudity, but not images containing suggestive content. To filter images,
use the labels returned by DetectModerationLabels to determine which types of content are
appropriate. For information about moderation labels, see Detecting Unsafe Content in the
Amazon Rekognition Developer Guide. You pass the input image either as base64-encoded image
bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call
Amazon Rekognition operations, passing image bytes is not supported. The image must be
either a PNG or JPEG formatted file.  You can specify an adapter to use when retrieving
label predictions by providing a ProjectVersionArn to the ProjectVersion argument.

# Arguments
- `image`: The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI
  to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
   If you are using an AWS SDK to call Amazon Rekognition, you might not need to
  base64-encode image bytes passed using the Bytes field. For more information, see Images in
  the Amazon Rekognition developer guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HumanLoopConfig"`: Sets up the configuration for human evaluation, including the
  FlowDefinition the image will be sent to.
- `"MinConfidence"`: Specifies the minimum confidence level for the labels to return.
  Amazon Rekognition doesn't return any labels with a confidence level lower than this
  specified value. If you don't specify MinConfidence, the operation returns labels with
  confidence values greater than or equal to 50 percent.
- `"ProjectVersion"`: Identifier for the custom adapter. Expects the ProjectVersionArn as a
  value. Use the CreateProject or CreateProjectVersion APIs to create a custom adapter.
"""
function detect_moderation_labels(Image; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DetectModerationLabels",
        Dict{String,Any}("Image" => Image);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detect_moderation_labels(
    Image, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DetectModerationLabels",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Image" => Image), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detect_protective_equipment(image)
    detect_protective_equipment(image, params::Dict{String,<:Any})

Detects Personal Protective Equipment (PPE) worn by people detected in an image. Amazon
Rekognition can detect the following types of PPE.   Face cover   Hand cover   Head cover
You pass the input image as base64-encoded image bytes or as a reference to an image in an
Amazon S3 bucket. The image must be either a PNG or JPG formatted file.
DetectProtectiveEquipment detects PPE worn by up to 15 persons detected in an image. For
each person detected in the image the API returns an array of body parts (face, head,
left-hand, right-hand). For each body part, an array of detected items of PPE is returned,
including an indicator of whether or not the PPE covers the body part. The API returns the
confidence it has in each detection (person, PPE, body part and body part coverage). It
also returns a bounding box (BoundingBox) for each detected person and each detected item
of PPE.  You can optionally request a summary of detected PPE items with the
SummarizationAttributes input parameter. The summary provides the following information.
The persons detected as wearing all of the types of PPE that you specify.   The persons
detected as not wearing all of the types PPE that you specify.   The persons detected where
PPE adornment could not be determined.    This is a stateless API operation. That is, the
operation does not persist any data. This operation requires permissions to perform the
rekognition:DetectProtectiveEquipment action.

# Arguments
- `image`: The image in which you want to detect PPE on detected persons. The image can be
  passed as image bytes or you can reference an image stored in an Amazon S3 bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SummarizationAttributes"`: An array of PPE types that you want to summarize.
"""
function detect_protective_equipment(
    Image; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DetectProtectiveEquipment",
        Dict{String,Any}("Image" => Image);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detect_protective_equipment(
    Image, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DetectProtectiveEquipment",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Image" => Image), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detect_text(image)
    detect_text(image, params::Dict{String,<:Any})

Detects text in the input image and converts it into machine-readable text. Pass the input
image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket.
If you use the AWS CLI to call Amazon Rekognition operations, you must pass it as a
reference to an image in an Amazon S3 bucket. For the AWS CLI, passing image bytes is not
supported. The image must be either a .png or .jpeg formatted file.  The DetectText
operation returns text in an array of TextDetection elements, TextDetections. Each
TextDetection element provides information about a single word or line of text that was
detected in the image.  A word is one or more script characters that are not separated by
spaces. DetectText can detect up to 100 words in an image. A line is a string of equally
spaced words. A line isn't necessarily a complete sentence. For example, a driver's license
number is detected as a line. A line ends when there is no aligned text after it. Also, a
line ends when there is a large gap between words, relative to the length of the words.
This means, depending on the gap between words, Amazon Rekognition may detect multiple
lines in text aligned in the same direction. Periods don't represent the end of a line. If
a sentence spans multiple lines, the DetectText operation returns multiple lines. To
determine whether a TextDetection element is a line of text or a word, use the
TextDetection object Type field.  To be detected, text must be within +/- 90 degrees
orientation of the horizontal axis. For more information, see Detecting text in the Amazon
Rekognition Developer Guide.

# Arguments
- `image`: The input image as base64-encoded bytes or an Amazon S3 object. If you use the
  AWS CLI to call Amazon Rekognition operations, you can't pass image bytes.  If you are
  using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image
  bytes passed using the Bytes field. For more information, see Images in the Amazon
  Rekognition developer guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Optional parameters that let you set the criteria that the text must meet to
  be included in your response.
"""
function detect_text(Image; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "DetectText",
        Dict{String,Any}("Image" => Image);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detect_text(
    Image, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DetectText",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Image" => Image), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_faces(collection_id, face_ids, user_id)
    disassociate_faces(collection_id, face_ids, user_id, params::Dict{String,<:Any})

Removes the association between a Face supplied in an array of FaceIds and the User. If the
User is not present already, then a ResourceNotFound exception is thrown. If successful, an
array of faces that are disassociated from the User is returned. If a given face is already
disassociated from the given UserID, it will be ignored and not be returned in the
response. If a given face is already associated with a different User or not found in the
collection it will be returned as part of UnsuccessfulDisassociations. You can remove 1 -
100 face IDs from a user at one time.

# Arguments
- `collection_id`: The ID of an existing collection containing the UserID.
- `face_ids`: An array of face IDs to disassociate from the UserID.
- `user_id`: ID for the existing UserID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the request to
  DisassociateFaces. If you use the same token with multiple DisassociateFaces requests, the
  same response is returned. Use ClientRequestToken to prevent the same request from being
  processed more than once.
"""
function disassociate_faces(
    CollectionId, FaceIds, UserId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DisassociateFaces",
        Dict{String,Any}(
            "CollectionId" => CollectionId,
            "FaceIds" => FaceIds,
            "UserId" => UserId,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_faces(
    CollectionId,
    FaceIds,
    UserId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DisassociateFaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CollectionId" => CollectionId,
                    "FaceIds" => FaceIds,
                    "UserId" => UserId,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    distribute_dataset_entries(datasets)
    distribute_dataset_entries(datasets, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Distributes the entries
(images) in a training dataset across the training dataset and the test dataset for a
project. DistributeDatasetEntries moves 20% of the training dataset images to the test
dataset. An entry is a JSON Line that describes an image.  You supply the Amazon Resource
Names (ARN) of a project's training dataset and test dataset. The training dataset must
contain the images that you want to split. The test dataset must be empty. The datasets
must belong to the same project. To create training and test datasets for a project, call
CreateDataset. Distributing a dataset takes a while to complete. To check the status call
DescribeDataset. The operation is complete when the Status field for the training dataset
and the test dataset is UPDATE_COMPLETE. If the dataset split fails, the value of Status is
UPDATE_FAILED. This operation requires permissions to perform the
rekognition:DistributeDatasetEntries action.

# Arguments
- `datasets`: The ARNS for the training dataset and test dataset that you want to use. The
  datasets must belong to the same project. The test dataset must be empty.

"""
function distribute_dataset_entries(
    Datasets; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "DistributeDatasetEntries",
        Dict{String,Any}("Datasets" => Datasets);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function distribute_dataset_entries(
    Datasets,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "DistributeDatasetEntries",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Datasets" => Datasets), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_celebrity_info(id)
    get_celebrity_info(id, params::Dict{String,<:Any})

Gets the name and additional information about a celebrity based on their Amazon
Rekognition ID. The additional information is returned as an array of URLs. If there is no
additional information about the celebrity, this list is empty. For more information, see
Getting information about a celebrity in the Amazon Rekognition Developer Guide. This
operation requires permissions to perform the rekognition:GetCelebrityInfo action.

# Arguments
- `id`: The ID for the celebrity. You get the celebrity ID from a call to the
  RecognizeCelebrities operation, which recognizes celebrities in an image.

"""
function get_celebrity_info(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "GetCelebrityInfo",
        Dict{String,Any}("Id" => Id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_celebrity_info(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetCelebrityInfo",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Id" => Id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_celebrity_recognition(job_id)
    get_celebrity_recognition(job_id, params::Dict{String,<:Any})

Gets the celebrity recognition results for a Amazon Rekognition Video analysis started by
StartCelebrityRecognition. Celebrity recognition in a video is an asynchronous operation.
Analysis is started by a call to StartCelebrityRecognition which returns a job identifier
(JobId).  When the celebrity recognition operation finishes, Amazon Rekognition Video
publishes a completion status to the Amazon Simple Notification Service topic registered in
the initial call to StartCelebrityRecognition. To get the results of the celebrity
recognition analysis, first check that the status value published to the Amazon SNS topic
is SUCCEEDED. If so, call GetCelebrityDetection and pass the job identifier (JobId) from
the initial call to StartCelebrityDetection.  For more information, see Working With Stored
Videos in the Amazon Rekognition Developer Guide.  GetCelebrityRecognition returns detected
celebrities and the time(s) they are detected in an array (Celebrities) of
CelebrityRecognition objects. Each CelebrityRecognition contains information about the
celebrity in a CelebrityDetail object and the time, Timestamp, the celebrity was detected.
This CelebrityDetail object stores information about the detected celebrity's face
attributes, a face bounding box, known gender, the celebrity's name, and a confidence
estimate.   GetCelebrityRecognition only returns the default facial attributes
(BoundingBox, Confidence, Landmarks, Pose, and Quality). The BoundingBox field only applies
to the detected face instance. The other facial attributes listed in the Face object of the
following response syntax are not returned. For more information, see FaceDetail in the
Amazon Rekognition Developer Guide.   By default, the Celebrities array is sorted by time
(milliseconds from the start of the video). You can also sort the array by celebrity by
specifying the value ID in the SortBy input parameter. The CelebrityDetail object includes
the celebrity identifer and additional information urls. If you don't store the additional
information urls, you can get them later by calling GetCelebrityInfo with the celebrity
identifer. No information is returned for faces not recognized as celebrities. Use
MaxResults parameter to limit the number of labels returned. If there are more results than
specified in MaxResults, the value of NextToken in the operation response contains a
pagination token for getting the next set of results. To get the next page of results, call
GetCelebrityDetection and populate the NextToken request parameter with the token value
returned from the previous call to GetCelebrityRecognition.

# Arguments
- `job_id`: Job identifier for the required celebrity recognition analysis. You can get the
  job identifer from a call to StartCelebrityRecognition.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return per paginated call. The largest value
  you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000
  results is returned. The default value is 1000.
- `"NextToken"`: If the previous response was incomplete (because there is more recognized
  celebrities to retrieve), Amazon Rekognition Video returns a pagination token in the
  response. You can use this pagination token to retrieve the next set of celebrities.
- `"SortBy"`: Sort to use for celebrities returned in Celebrities field. Specify ID to sort
  by the celebrity identifier, specify TIMESTAMP to sort by the time the celebrity was
  recognized.
"""
function get_celebrity_recognition(
    JobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetCelebrityRecognition",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_celebrity_recognition(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetCelebrityRecognition",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_content_moderation(job_id)
    get_content_moderation(job_id, params::Dict{String,<:Any})

Gets the inappropriate, unwanted, or offensive content analysis results for a Amazon
Rekognition Video analysis started by StartContentModeration. For a list of moderation
labels in Amazon Rekognition, see Using the image and video moderation APIs. Amazon
Rekognition Video inappropriate or offensive content detection in a stored video is an
asynchronous operation. You start analysis by calling StartContentModeration which returns
a job identifier (JobId). When analysis finishes, Amazon Rekognition Video publishes a
completion status to the Amazon Simple Notification Service topic registered in the initial
call to StartContentModeration. To get the results of the content analysis, first check
that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call
GetContentModeration and pass the job identifier (JobId) from the initial call to
StartContentModeration.  For more information, see Working with Stored Videos in the Amazon
Rekognition Devlopers Guide.  GetContentModeration returns detected inappropriate,
unwanted, or offensive content moderation labels, and the time they are detected, in an
array, ModerationLabels, of ContentModerationDetection objects.  By default, the moderated
labels are returned sorted by time, in milliseconds from the start of the video. You can
also sort them by moderated label by specifying NAME for the SortBy input parameter.  Since
video analysis can return a large number of results, use the MaxResults parameter to limit
the number of labels returned in a single call to GetContentModeration. If there are more
results than specified in MaxResults, the value of NextToken in the operation response
contains a pagination token for getting the next set of results. To get the next page of
results, call GetContentModeration and populate the NextToken request parameter with the
value of NextToken returned from the previous call to GetContentModeration. For more
information, see moderating content in the Amazon Rekognition Developer Guide.

# Arguments
- `job_id`: The identifier for the inappropriate, unwanted, or offensive content moderation
  job. Use JobId to identify the job in a subsequent call to GetContentModeration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AggregateBy"`: Defines how to aggregate results of the StartContentModeration request.
  Default aggregation option is TIMESTAMPS. SEGMENTS mode aggregates moderation labels over
  time.
- `"MaxResults"`: Maximum number of results to return per paginated call. The largest value
  you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000
  results is returned. The default value is 1000.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Rekognition returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of content moderation labels.
- `"SortBy"`: Sort to use for elements in the ModerationLabelDetections array. Use
  TIMESTAMP to sort array elements by the time labels are detected. Use NAME to
  alphabetically group elements for a label together. Within each label group, the array
  element are sorted by detection confidence. The default sort is by TIMESTAMP.
"""
function get_content_moderation(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "GetContentModeration",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_content_moderation(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetContentModeration",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_face_detection(job_id)
    get_face_detection(job_id, params::Dict{String,<:Any})

Gets face detection results for a Amazon Rekognition Video analysis started by
StartFaceDetection. Face detection with Amazon Rekognition Video is an asynchronous
operation. You start face detection by calling StartFaceDetection which returns a job
identifier (JobId). When the face detection operation finishes, Amazon Rekognition Video
publishes a completion status to the Amazon Simple Notification Service topic registered in
the initial call to StartFaceDetection. To get the results of the face detection operation,
first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so,
call GetFaceDetection and pass the job identifier (JobId) from the initial call to
StartFaceDetection.  GetFaceDetection returns an array of detected faces (Faces) sorted by
the time the faces were detected.  Use MaxResults parameter to limit the number of labels
returned. If there are more results than specified in MaxResults, the value of NextToken in
the operation response contains a pagination token for getting the next set of results. To
get the next page of results, call GetFaceDetection and populate the NextToken request
parameter with the token value returned from the previous call to GetFaceDetection. Note
that for the GetFaceDetection operation, the returned values for FaceOccluded and
EyeDirection will always be \"null\".

# Arguments
- `job_id`: Unique identifier for the face detection job. The JobId is returned from
  StartFaceDetection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return per paginated call. The largest value
  you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000
  results is returned. The default value is 1000.
- `"NextToken"`: If the previous response was incomplete (because there are more faces to
  retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use
  this pagination token to retrieve the next set of faces.
"""
function get_face_detection(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "GetFaceDetection",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_face_detection(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetFaceDetection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_face_liveness_session_results(session_id)
    get_face_liveness_session_results(session_id, params::Dict{String,<:Any})

Retrieves the results of a specific Face Liveness session. It requires the sessionId as
input, which was created using CreateFaceLivenessSession. Returns the corresponding Face
Liveness confidence score, a reference image that includes a face bounding box, and audit
images that also contain face bounding boxes. The Face Liveness confidence score ranges
from 0 to 100.  The number of audit images returned by GetFaceLivenessSessionResults is
defined by the AuditImagesLimit paramater when calling CreateFaceLivenessSession. Reference
images are always returned when possible.

# Arguments
- `session_id`: A unique 128-bit UUID. This is used to uniquely identify the session and
  also acts as an idempotency token for all operations associated with the session.

"""
function get_face_liveness_session_results(
    SessionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetFaceLivenessSessionResults",
        Dict{String,Any}("SessionId" => SessionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_face_liveness_session_results(
    SessionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "GetFaceLivenessSessionResults",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SessionId" => SessionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_face_search(job_id)
    get_face_search(job_id, params::Dict{String,<:Any})

Gets the face search results for Amazon Rekognition Video face search started by
StartFaceSearch. The search returns faces in a collection that match the faces of persons
detected in a video. It also includes the time(s) that faces are matched in the video. Face
search in a video is an asynchronous operation. You start face search by calling to
StartFaceSearch which returns a job identifier (JobId). When the search operation finishes,
Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification
Service topic registered in the initial call to StartFaceSearch. To get the search results,
first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so,
call GetFaceSearch and pass the job identifier (JobId) from the initial call to
StartFaceSearch. For more information, see Searching Faces in a Collection in the Amazon
Rekognition Developer Guide. The search results are retured in an array, Persons, of
PersonMatch objects. EachPersonMatch element contains details about the matching faces in
the input collection, person information (facial attributes, bounding boxes, and person
identifer) for the matched person, and the time the person was matched in the video.
GetFaceSearch only returns the default facial attributes (BoundingBox, Confidence,
Landmarks, Pose, and Quality). The other facial attributes listed in the Face object of the
following response syntax are not returned. For more information, see FaceDetail in the
Amazon Rekognition Developer Guide.   By default, the Persons array is sorted by the time,
in milliseconds from the start of the video, persons are matched. You can also sort by
persons by specifying INDEX for the SORTBY input parameter.

# Arguments
- `job_id`: The job identifer for the search request. You get the job identifier from an
  initial call to StartFaceSearch.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return per paginated call. The largest value
  you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000
  results is returned. The default value is 1000.
- `"NextToken"`: If the previous response was incomplete (because there is more search
  results to retrieve), Amazon Rekognition Video returns a pagination token in the response.
  You can use this pagination token to retrieve the next set of search results.
- `"SortBy"`: Sort to use for grouping faces in the response. Use TIMESTAMP to group faces
  by the time that they are recognized. Use INDEX to sort by recognized faces.
"""
function get_face_search(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "GetFaceSearch",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_face_search(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetFaceSearch",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_label_detection(job_id)
    get_label_detection(job_id, params::Dict{String,<:Any})

Gets the label detection results of a Amazon Rekognition Video analysis started by
StartLabelDetection.  The label detection operation is started by a call to
StartLabelDetection which returns a job identifier (JobId). When the label detection
operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple
Notification Service topic registered in the initial call to StartlabelDetection.  To get
the results of the label detection operation, first check that the status value published
to the Amazon SNS topic is SUCCEEDED. If so, call GetLabelDetection and pass the job
identifier (JobId) from the initial call to StartLabelDetection.  GetLabelDetection returns
an array of detected labels (Labels) sorted by the time the labels were detected. You can
also sort by the label name by specifying NAME for the SortBy input parameter. If there is
no NAME specified, the default sort is by timestamp. You can select how results are
aggregated by using the AggregateBy input parameter. The default aggregation method is
TIMESTAMPS. You can also aggregate by SEGMENTS, which aggregates all instances of labels
detected in a given segment.  The returned Labels array may include the following
attributes:   Name - The name of the detected label.   Confidence - The level of confidence
in the label assigned to a detected object.    Parents - The ancestor labels for a detected
label. GetLabelDetection returns a hierarchical taxonomy of detected labels. For example, a
detected car might be assigned the label car. The label car has two parent labels: Vehicle
(its parent) and Transportation (its grandparent). The response includes the all ancestors
for a label, where every ancestor is a unique label. In the previous example, Car, Vehicle,
and Transportation are returned as unique labels in the response.     Aliases - Possible
Aliases for the label.    Categories - The label categories that the detected label belongs
to.   BoundingBox — Bounding boxes are described for all instances of detected common
object labels, returned in an array of Instance objects. An Instance object contains a
BoundingBox object, describing the location of the label on the input image. It also
includes the confidence for the accuracy of the detected bounding box.   Timestamp - Time,
in milliseconds from the start of the video, that the label was detected. For aggregation
by SEGMENTS, the StartTimestampMillis, EndTimestampMillis, and DurationMillis structures
are what define a segment. Although the “Timestamp” structure is still returned with
each label, its value is set to be the same as StartTimestampMillis.   Timestamp and
Bounding box information are returned for detected Instances, only if aggregation is done
by TIMESTAMPS. If aggregating by SEGMENTS, information about detected instances isn’t
returned.  The version of the label model used for the detection is also returned.  Note
DominantColors isn't returned for Instances, although it is shown as part of the response
in the sample seen below.  Use MaxResults parameter to limit the number of labels returned.
If there are more results than specified in MaxResults, the value of NextToken in the
operation response contains a pagination token for getting the next set of results. To get
the next page of results, call GetlabelDetection and populate the NextToken request
parameter with the token value returned from the previous call to GetLabelDetection.

# Arguments
- `job_id`: Job identifier for the label detection operation for which you want results
  returned. You get the job identifer from an initial call to StartlabelDetection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AggregateBy"`: Defines how to aggregate the returned results. Results can be aggregated
  by timestamps or segments.
- `"MaxResults"`: Maximum number of results to return per paginated call. The largest value
  you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000
  results is returned. The default value is 1000.
- `"NextToken"`: If the previous response was incomplete (because there are more labels to
  retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use
  this pagination token to retrieve the next set of labels.
- `"SortBy"`: Sort to use for elements in the Labels array. Use TIMESTAMP to sort array
  elements by the time labels are detected. Use NAME to alphabetically group elements for a
  label together. Within each label group, the array element are sorted by detection
  confidence. The default sort is by TIMESTAMP.
"""
function get_label_detection(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "GetLabelDetection",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_label_detection(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetLabelDetection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_media_analysis_job(job_id)
    get_media_analysis_job(job_id, params::Dict{String,<:Any})

Retrieves the results for a given media analysis job. Takes a JobId returned by
StartMediaAnalysisJob.

# Arguments
- `job_id`: Unique identifier for the media analysis job for which you want to retrieve
  results.

"""
function get_media_analysis_job(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "GetMediaAnalysisJob",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_media_analysis_job(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetMediaAnalysisJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_person_tracking(job_id)
    get_person_tracking(job_id, params::Dict{String,<:Any})

Gets the path tracking results of a Amazon Rekognition Video analysis started by
StartPersonTracking. The person path tracking operation is started by a call to
StartPersonTracking which returns a job identifier (JobId). When the operation finishes,
Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification
Service topic registered in the initial call to StartPersonTracking. To get the results of
the person path tracking operation, first check that the status value published to the
Amazon SNS topic is SUCCEEDED. If so, call GetPersonTracking and pass the job identifier
(JobId) from the initial call to StartPersonTracking.  GetPersonTracking returns an array,
Persons, of tracked persons and the time(s) their paths were tracked in the video.
GetPersonTracking only returns the default facial attributes (BoundingBox, Confidence,
Landmarks, Pose, and Quality). The other facial attributes listed in the Face object of the
following response syntax are not returned.  For more information, see FaceDetail in the
Amazon Rekognition Developer Guide.  By default, the array is sorted by the time(s) a
person's path is tracked in the video. You can sort by tracked persons by specifying INDEX
for the SortBy input parameter. Use the MaxResults parameter to limit the number of items
returned. If there are more results than specified in MaxResults, the value of NextToken in
the operation response contains a pagination token for getting the next set of results. To
get the next page of results, call GetPersonTracking and populate the NextToken request
parameter with the token value returned from the previous call to GetPersonTracking.

# Arguments
- `job_id`: The identifier for a job that tracks persons in a video. You get the JobId from
  a call to StartPersonTracking.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return per paginated call. The largest value
  you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000
  results is returned. The default value is 1000.
- `"NextToken"`: If the previous response was incomplete (because there are more persons to
  retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use
  this pagination token to retrieve the next set of persons.
- `"SortBy"`: Sort to use for elements in the Persons array. Use TIMESTAMP to sort array
  elements by the time persons are detected. Use INDEX to sort by the tracked persons. If you
  sort by INDEX, the array elements for each person are sorted by detection confidence. The
  default sort is by TIMESTAMP.
"""
function get_person_tracking(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "GetPersonTracking",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_person_tracking(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetPersonTracking",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_segment_detection(job_id)
    get_segment_detection(job_id, params::Dict{String,<:Any})

Gets the segment detection results of a Amazon Rekognition Video analysis started by
StartSegmentDetection. Segment detection with Amazon Rekognition Video is an asynchronous
operation. You start segment detection by calling StartSegmentDetection which returns a job
identifier (JobId). When the segment detection operation finishes, Amazon Rekognition
publishes a completion status to the Amazon Simple Notification Service topic registered in
the initial call to StartSegmentDetection. To get the results of the segment detection
operation, first check that the status value published to the Amazon SNS topic is
SUCCEEDED. if so, call GetSegmentDetection and pass the job identifier (JobId) from the
initial call of StartSegmentDetection.  GetSegmentDetection returns detected segments in an
array (Segments) of SegmentDetection objects. Segments is sorted by the segment types
specified in the SegmentTypes input parameter of StartSegmentDetection. Each element of the
array includes the detected segment, the precentage confidence in the acuracy of the
detected segment, the type of the segment, and the frame in which the segment was detected.
Use SelectedSegmentTypes to find out the type of segment detection requested in the call to
StartSegmentDetection. Use the MaxResults parameter to limit the number of segment
detections returned. If there are more results than specified in MaxResults, the value of
NextToken in the operation response contains a pagination token for getting the next set of
results. To get the next page of results, call GetSegmentDetection and populate the
NextToken request parameter with the token value returned from the previous call to
GetSegmentDetection. For more information, see Detecting video segments in stored video in
the Amazon Rekognition Developer Guide.

# Arguments
- `job_id`: Job identifier for the text detection operation for which you want results
  returned. You get the job identifer from an initial call to StartSegmentDetection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return per paginated call. The largest value
  you can specify is 1000.
- `"NextToken"`: If the response is truncated, Amazon Rekognition Video returns this token
  that you can use in the subsequent request to retrieve the next set of text.
"""
function get_segment_detection(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "GetSegmentDetection",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_segment_detection(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetSegmentDetection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_text_detection(job_id)
    get_text_detection(job_id, params::Dict{String,<:Any})

Gets the text detection results of a Amazon Rekognition Video analysis started by
StartTextDetection. Text detection with Amazon Rekognition Video is an asynchronous
operation. You start text detection by calling StartTextDetection which returns a job
identifier (JobId) When the text detection operation finishes, Amazon Rekognition publishes
a completion status to the Amazon Simple Notification Service topic registered in the
initial call to StartTextDetection. To get the results of the text detection operation,
first check that the status value published to the Amazon SNS topic is SUCCEEDED. if so,
call GetTextDetection and pass the job identifier (JobId) from the initial call of
StartLabelDetection.  GetTextDetection returns an array of detected text (TextDetections)
sorted by the time the text was detected, up to 100 words per frame of video. Each element
of the array includes the detected text, the precentage confidence in the acuracy of the
detected text, the time the text was detected, bounding box information for where the text
was located, and unique identifiers for words and their lines. Use MaxResults parameter to
limit the number of text detections returned. If there are more results than specified in
MaxResults, the value of NextToken in the operation response contains a pagination token
for getting the next set of results. To get the next page of results, call GetTextDetection
and populate the NextToken request parameter with the token value returned from the
previous call to GetTextDetection.

# Arguments
- `job_id`: Job identifier for the text detection operation for which you want results
  returned. You get the job identifer from an initial call to StartTextDetection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return per paginated call. The largest value
  you can specify is 1000.
- `"NextToken"`: If the previous response was incomplete (because there are more labels to
  retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use
  this pagination token to retrieve the next set of text.
"""
function get_text_detection(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "GetTextDetection",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_text_detection(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "GetTextDetection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    index_faces(collection_id, image)
    index_faces(collection_id, image, params::Dict{String,<:Any})

Detects faces in the input image and adds them to the specified collection.  Amazon
Rekognition doesn't save the actual faces that are detected. Instead, the underlying
detection algorithm first detects the faces in the input image. For each face, the
algorithm extracts facial features into a feature vector, and stores it in the backend
database. Amazon Rekognition uses feature vectors when it performs face match and search
operations using the SearchFaces and SearchFacesByImage operations. For more information,
see Adding faces to a collection in the Amazon Rekognition Developer Guide. To get the
number of faces in a collection, call DescribeCollection.  If you're using version 1.0 of
the face detection model, IndexFaces indexes the 15 largest faces in the input image. Later
versions of the face detection model index the 100 largest faces in the input image.  If
you're using version 4 or later of the face model, image orientation information is not
returned in the OrientationCorrection field.  To determine which version of the model
you're using, call DescribeCollection and supply the collection ID. You can also get the
model version from the value of FaceModelVersion in the response from IndexFaces  For more
information, see Model Versioning in the Amazon Rekognition Developer Guide. If you provide
the optional ExternalImageId for the input image you provided, Amazon Rekognition
associates this ID with all faces that it detects. When you call the ListFaces operation,
the response returns the external ID. You can use this external image ID to create a
client-side index to associate the faces with each image. You can then use the index to
find all faces in an image. You can specify the maximum number of faces to index with the
MaxFaces input parameter. This is useful when you want to index the largest faces in an
image and don't want to index smaller faces, such as those belonging to people standing in
the background. The QualityFilter input parameter allows you to filter out detected faces
that don’t meet a required quality bar. The quality bar is based on a variety of common
use cases. By default, IndexFaces chooses the quality bar that's used to filter faces. You
can also explicitly choose the quality bar. Use QualityFilter, to set the quality bar by
specifying LOW, MEDIUM, or HIGH. If you do not want to filter detected faces, specify NONE.
  To use quality filtering, you need a collection associated with version 3 of the face
model or higher. To get the version of the face model associated with a collection, call
DescribeCollection.   Information about faces detected in an image, but not indexed, is
returned in an array of UnindexedFace objects, UnindexedFaces. Faces aren't indexed for
reasons such as:   The number of faces detected exceeds the value of the MaxFaces request
parameter.   The face is too small compared to the image dimensions.   The face is too
blurry.   The image is too dark.   The face has an extreme pose.   The face doesn’t have
enough detail to be suitable for face search.   In response, the IndexFaces operation
returns an array of metadata for all detected faces, FaceRecords. This includes:    The
bounding box, BoundingBox, of the detected face.    A confidence value, Confidence, which
indicates the confidence that the bounding box contains a face.   A face ID, FaceId,
assigned by the service for each face that's detected and stored.   An image ID, ImageId,
assigned by the service for the input image.   If you request ALL or specific facial
attributes (e.g., FACE_OCCLUDED) by using the detectionAttributes parameter, Amazon
Rekognition returns detailed facial attributes, such as facial landmarks (for example,
location of eye and mouth), facial occlusion, and other facial attributes. If you provide
the same image, specify the same collection, and use the same external ID in the IndexFaces
operation, Amazon Rekognition doesn't save duplicate face metadata.  The input image is
passed either as base64-encoded image bytes, or as a reference to an image in an Amazon S3
bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes
isn't supported. The image must be formatted as a PNG or JPEG file.  This operation
requires permissions to perform the rekognition:IndexFaces action.

# Arguments
- `collection_id`: The ID of an existing collection to which you want to add the faces that
  are detected in the input images.
- `image`: The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI
  to call Amazon Rekognition operations, passing base64-encoded image bytes isn't supported.
  If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode
  image bytes passed using the Bytes field. For more information, see Images in the Amazon
  Rekognition developer guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DetectionAttributes"`: An array of facial attributes you want to be returned. A DEFAULT
  subset of facial attributes - BoundingBox, Confidence, Pose, Quality, and Landmarks - will
  always be returned. You can request for specific facial attributes (in addition to the
  default list) - by using [\"DEFAULT\", \"FACE_OCCLUDED\"] or just [\"FACE_OCCLUDED\"]. You
  can request for all facial attributes by using [\"ALL\"]. Requesting more attributes may
  increase response time. If you provide both, [\"ALL\", \"DEFAULT\"], the service uses a
  logical AND operator to determine which attributes to return (in this case, all
  attributes).
- `"ExternalImageId"`: The ID you want to assign to all the faces detected in the image.
- `"MaxFaces"`: The maximum number of faces to index. The value of MaxFaces must be greater
  than or equal to 1. IndexFaces returns no more than 100 detected faces in an image, even if
  you specify a larger value for MaxFaces. If IndexFaces detects more faces than the value of
  MaxFaces, the faces with the lowest quality are filtered out first. If there are still more
  faces than the value of MaxFaces, the faces with the smallest bounding boxes are filtered
  out (up to the number that's needed to satisfy the value of MaxFaces). Information about
  the unindexed faces is available in the UnindexedFaces array.  The faces that are returned
  by IndexFaces are sorted by the largest face bounding box size to the smallest size, in
  descending order.  MaxFaces can be used with a collection associated with any version of
  the face model.
- `"QualityFilter"`: A filter that specifies a quality bar for how much filtering is done
  to identify faces. Filtered faces aren't indexed. If you specify AUTO, Amazon Rekognition
  chooses the quality bar. If you specify LOW, MEDIUM, or HIGH, filtering removes all faces
  that don’t meet the chosen quality bar. The default value is AUTO. The quality bar is
  based on a variety of common use cases. Low-quality detections can occur for a number of
  reasons. Some examples are an object that's misidentified as a face, a face that's too
  blurry, or a face with a pose that's too extreme to use. If you specify NONE, no filtering
  is performed.  To use quality filtering, the collection you are using must be associated
  with version 3 of the face model or higher.
"""
function index_faces(
    CollectionId, Image; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "IndexFaces",
        Dict{String,Any}("CollectionId" => CollectionId, "Image" => Image);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function index_faces(
    CollectionId,
    Image,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "IndexFaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CollectionId" => CollectionId, "Image" => Image),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_collections()
    list_collections(params::Dict{String,<:Any})

Returns list of collection IDs in your account. If the result is truncated, the response
also provides a NextToken that you can use in the subsequent request to fetch the next set
of collection IDs. For an example, see Listing collections in the Amazon Rekognition
Developer Guide. This operation requires permissions to perform the
rekognition:ListCollections action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of collection IDs to return.
- `"NextToken"`: Pagination token from the previous response.
"""
function list_collections(; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "ListCollections"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_collections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "ListCollections", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_dataset_entries(dataset_arn)
    list_dataset_entries(dataset_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.   Lists the entries
(images) within a dataset. An entry is a JSON Line that contains the information for a
single image, including the image location, assigned labels, and object location bounding
boxes. For more information, see Creating a manifest file. JSON Lines in the response
include information about non-terminal errors found in the dataset. Non terminal errors are
reported in errors lists within each JSON Line. The same information is reported in the
training and testing validation result manifests that Amazon Rekognition Custom Labels
creates during model training.  You can filter the response in variety of ways, such as
choosing which labels to return and returning JSON Lines created after a specific date.
This operation requires permissions to perform the rekognition:ListDatasetEntries action.

# Arguments
- `dataset_arn`:  The Amazon Resource Name (ARN) for the dataset that you want to use.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ContainsLabels"`: Specifies a label filter for the response. The response includes an
  entry only if one or more of the labels in ContainsLabels exist in the entry.
- `"HasErrors"`: Specifies an error filter for the response. Specify True to only include
  entries that have errors.
- `"Labeled"`:  Specify true to get only the JSON Lines where the image is labeled. Specify
  false to get only the JSON Lines where the image isn't labeled. If you don't specify
  Labeled, ListDatasetEntries returns JSON Lines for labeled and unlabeled images.
- `"MaxResults"`: The maximum number of results to return per paginated call. The largest
  value you can specify is 100. If you specify a value greater than 100, a
  ValidationException error occurs. The default value is 100.
- `"NextToken"`: If the previous response was incomplete (because there is more results to
  retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You
  can use this pagination token to retrieve the next set of results.
- `"SourceRefContains"`: If specified, ListDatasetEntries only returns JSON Lines where the
  value of SourceRefContains is part of the source-ref field. The source-ref field contains
  the Amazon S3 location of the image. You can use SouceRefContains for tasks such as getting
  the JSON Line for a single image, or gettting JSON Lines for all images within a specific
  folder.
"""
function list_dataset_entries(
    DatasetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "ListDatasetEntries",
        Dict{String,Any}("DatasetArn" => DatasetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_dataset_entries(
    DatasetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "ListDatasetEntries",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DatasetArn" => DatasetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_dataset_labels(dataset_arn)
    list_dataset_labels(dataset_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Lists the labels in a
dataset. Amazon Rekognition Custom Labels uses labels to describe images. For more
information, see Labeling images.   Lists the labels in a dataset. Amazon Rekognition
Custom Labels uses labels to describe images. For more information, see Labeling images in
the Amazon Rekognition Custom Labels Developer Guide.

# Arguments
- `dataset_arn`:  The Amazon Resource Name (ARN) of the dataset that you want to use.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return per paginated call. The largest
  value you can specify is 100. If you specify a value greater than 100, a
  ValidationException error occurs. The default value is 100.
- `"NextToken"`: If the previous response was incomplete (because there is more results to
  retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You
  can use this pagination token to retrieve the next set of results.
"""
function list_dataset_labels(DatasetArn; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "ListDatasetLabels",
        Dict{String,Any}("DatasetArn" => DatasetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_dataset_labels(
    DatasetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "ListDatasetLabels",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DatasetArn" => DatasetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_faces(collection_id)
    list_faces(collection_id, params::Dict{String,<:Any})

Returns metadata for faces in the specified collection. This metadata includes information
such as the bounding box coordinates, the confidence (that the bounding box contains a
face), and face ID. For an example, see Listing Faces in a Collection in the Amazon
Rekognition Developer Guide. This operation requires permissions to perform the
rekognition:ListFaces action.

# Arguments
- `collection_id`: ID of the collection from which to list the faces.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FaceIds"`: An array of face IDs to filter results with when listing faces in a
  collection.
- `"MaxResults"`: Maximum number of faces to return.
- `"NextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Rekognition returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of faces.
- `"UserId"`: An array of user IDs to filter results with when listing faces in a
  collection.
"""
function list_faces(CollectionId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "ListFaces",
        Dict{String,Any}("CollectionId" => CollectionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_faces(
    CollectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "ListFaces",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CollectionId" => CollectionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_media_analysis_jobs()
    list_media_analysis_jobs(params::Dict{String,<:Any})

Returns a list of media analysis jobs. Results are sorted by CreationTimestamp in
descending order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return per paginated call. The largest
  value user can specify is 100. If user specifies a value greater than 100, an
  InvalidParameterException error occurs. The default value is 100.
- `"NextToken"`: Pagination token, if the previous response was incomplete.
"""
function list_media_analysis_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "ListMediaAnalysisJobs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_media_analysis_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "ListMediaAnalysisJobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_project_policies(project_arn)
    list_project_policies(project_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Gets a list of the
project policies attached to a project. To attach a project policy to a project, call
PutProjectPolicy. To remove a project policy from a project, call DeleteProjectPolicy. This
operation requires permissions to perform the rekognition:ListProjectPolicies action.

# Arguments
- `project_arn`: The ARN of the project for which you want to list the project policies.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return per paginated call. The largest
  value you can specify is 5. If you specify a value greater than 5, a ValidationException
  error occurs. The default value is 5.
- `"NextToken"`: If the previous response was incomplete (because there is more results to
  retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You
  can use this pagination token to retrieve the next set of results.
"""
function list_project_policies(
    ProjectArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "ListProjectPolicies",
        Dict{String,Any}("ProjectArn" => ProjectArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_project_policies(
    ProjectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "ListProjectPolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProjectArn" => ProjectArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_stream_processors()
    list_stream_processors(params::Dict{String,<:Any})

Gets a list of stream processors that you have created with CreateStreamProcessor.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of stream processors you want Amazon Rekognition Video to
  return in the response. The default is 1000.
- `"NextToken"`: If the previous response was incomplete (because there are more stream
  processors to retrieve), Amazon Rekognition Video returns a pagination token in the
  response. You can use this pagination token to retrieve the next set of stream processors.
"""
function list_stream_processors(; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "ListStreamProcessors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_stream_processors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "ListStreamProcessors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

 Returns a list of tags in an Amazon Rekognition collection, stream processor, or Custom
Labels model.  This operation requires permissions to perform the
rekognition:ListTagsForResource action.

# Arguments
- `resource_arn`:  Amazon Resource Name (ARN) of the model, collection, or stream processor
  that contains the tags that you want a list of.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_users(collection_id)
    list_users(collection_id, params::Dict{String,<:Any})

Returns metadata of the User such as UserID in the specified collection. Anonymous User (to
reserve faces without any identity) is not returned as part of this request. The results
are sorted by system generated primary key ID. If the response is truncated, NextToken is
returned in the response that can be used in the subsequent request to retrieve the next
set of identities.

# Arguments
- `collection_id`: The ID of an existing collection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of UsersID to return.
- `"NextToken"`: Pagingation token to receive the next set of UsersID.
"""
function list_users(CollectionId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "ListUsers",
        Dict{String,Any}("CollectionId" => CollectionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_users(
    CollectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "ListUsers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CollectionId" => CollectionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_project_policy(policy_document, policy_name, project_arn)
    put_project_policy(policy_document, policy_name, project_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Attaches a project
policy to a Amazon Rekognition Custom Labels project in a trusting AWS account. A project
policy specifies that a trusted AWS account can copy a model version from a trusting AWS
account to a project in the trusted AWS account. To copy a model version you use the
CopyProjectVersion operation. Only applies to Custom Labels projects. For more information
about the format of a project policy document, see Attaching a project policy (SDK) in the
Amazon Rekognition Custom Labels Developer Guide.  The response from PutProjectPolicy is a
revision ID for the project policy. You can attach multiple project policies to a project.
You can also update an existing project policy by specifying the policy revision ID of the
existing policy. To remove a project policy from a project, call DeleteProjectPolicy. To
get a list of project policies attached to a project, call ListProjectPolicies.  You copy a
model version by calling CopyProjectVersion. This operation requires permissions to perform
the rekognition:PutProjectPolicy action.

# Arguments
- `policy_document`: A resource policy to add to the model. The policy is a JSON structure
  that contains one or more statements that define the policy. The policy must follow the IAM
  syntax. For more information about the contents of a JSON policy document, see IAM JSON
  policy reference.
- `policy_name`: A name for the policy.
- `project_arn`: The Amazon Resource Name (ARN) of the project that the project policy is
  attached to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PolicyRevisionId"`: The revision ID for the Project Policy. Each time you modify a
  policy, Amazon Rekognition Custom Labels generates and assigns a new PolicyRevisionId and
  then deletes the previous version of the policy.
"""
function put_project_policy(
    PolicyDocument,
    PolicyName,
    ProjectArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "PutProjectPolicy",
        Dict{String,Any}(
            "PolicyDocument" => PolicyDocument,
            "PolicyName" => PolicyName,
            "ProjectArn" => ProjectArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_project_policy(
    PolicyDocument,
    PolicyName,
    ProjectArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "PutProjectPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyDocument" => PolicyDocument,
                    "PolicyName" => PolicyName,
                    "ProjectArn" => ProjectArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    recognize_celebrities(image)
    recognize_celebrities(image, params::Dict{String,<:Any})

Returns an array of celebrities recognized in the input image. For more information, see
Recognizing celebrities in the Amazon Rekognition Developer Guide.   RecognizeCelebrities
returns the 64 largest faces in the image. It lists the recognized celebrities in the
CelebrityFaces array and any unrecognized faces in the UnrecognizedFaces array.
RecognizeCelebrities doesn't return celebrities whose faces aren't among the largest 64
faces in the image. For each celebrity recognized, RecognizeCelebrities returns a Celebrity
object. The Celebrity object contains the celebrity name, ID, URL links to additional
information, match confidence, and a ComparedFace object that you can use to locate the
celebrity's face on the image. Amazon Rekognition doesn't retain information about which
images a celebrity has been recognized in. Your application must store this information and
use the Celebrity ID property as a unique identifier for the celebrity. If you don't store
the celebrity name or additional information URLs returned by RecognizeCelebrities, you
will need the ID to identify the celebrity in a call to the GetCelebrityInfo operation. You
pass the input image either as base64-encoded image bytes or as a reference to an image in
an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing
image bytes is not supported. The image must be either a PNG or JPEG formatted file.  For
an example, see Recognizing celebrities in an image in the Amazon Rekognition Developer
Guide. This operation requires permissions to perform the rekognition:RecognizeCelebrities
operation.

# Arguments
- `image`: The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI
  to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
   If you are using an AWS SDK to call Amazon Rekognition, you might not need to
  base64-encode image bytes passed using the Bytes field. For more information, see Images in
  the Amazon Rekognition developer guide.

"""
function recognize_celebrities(Image; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "RecognizeCelebrities",
        Dict{String,Any}("Image" => Image);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function recognize_celebrities(
    Image, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "RecognizeCelebrities",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Image" => Image), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_faces(collection_id, face_id)
    search_faces(collection_id, face_id, params::Dict{String,<:Any})

For a given input face ID, searches for matching faces in the collection the face belongs
to. You get a face ID when you add a face to the collection using the IndexFaces operation.
The operation compares the features of the input face with faces in the specified
collection.   You can also search faces without indexing faces by using the
SearchFacesByImage operation.   The operation response returns an array of faces that
match, ordered by similarity score with the highest similarity first. More specifically, it
is an array of metadata for each face match that is found. Along with the metadata, the
response also includes a confidence value for each face match, indicating the confidence
that the specific face matches the input face.  For an example, see Searching for a face
using its face ID in the Amazon Rekognition Developer Guide. This operation requires
permissions to perform the rekognition:SearchFaces action.

# Arguments
- `collection_id`: ID of the collection the face belongs to.
- `face_id`: ID of a face to find matches for in the collection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FaceMatchThreshold"`: Optional value specifying the minimum confidence in the face
  match to return. For example, don't return any matches where confidence in matches is less
  than 70%. The default value is 80%.
- `"MaxFaces"`: Maximum number of faces to return. The operation returns the maximum number
  of faces with the highest confidence in the match.
"""
function search_faces(
    CollectionId, FaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "SearchFaces",
        Dict{String,Any}("CollectionId" => CollectionId, "FaceId" => FaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_faces(
    CollectionId,
    FaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "SearchFaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CollectionId" => CollectionId, "FaceId" => FaceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_faces_by_image(collection_id, image)
    search_faces_by_image(collection_id, image, params::Dict{String,<:Any})

For a given input image, first detects the largest face in the image, and then searches the
specified collection for matching faces. The operation compares the features of the input
face with faces in the specified collection.   To search for all faces in an input image,
you might first call the IndexFaces operation, and then use the face IDs returned in
subsequent calls to the SearchFaces operation.   You can also call the DetectFaces
operation and use the bounding boxes in the response to make face crops, which then you can
pass in to the SearchFacesByImage operation.   You pass the input image either as
base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use
the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported.
The image must be either a PNG or JPEG formatted file.   The response returns an array of
faces that match, ordered by similarity score with the highest similarity first. More
specifically, it is an array of metadata for each face match found. Along with the
metadata, the response also includes a similarity indicating how similar the face is to the
input face. In the response, the operation also returns the bounding box (and a confidence
level that the bounding box contains a face) of the face that Amazon Rekognition used for
the input image.  If no faces are detected in the input image, SearchFacesByImage returns
an InvalidParameterException error.  For an example, Searching for a Face Using an Image in
the Amazon Rekognition Developer Guide. The QualityFilter input parameter allows you to
filter out detected faces that don’t meet a required quality bar. The quality bar is
based on a variety of common use cases. Use QualityFilter to set the quality bar for
filtering by specifying LOW, MEDIUM, or HIGH. If you do not want to filter detected faces,
specify NONE. The default value is NONE.  To use quality filtering, you need a collection
associated with version 3 of the face model or higher. To get the version of the face model
associated with a collection, call DescribeCollection.   This operation requires
permissions to perform the rekognition:SearchFacesByImage action.

# Arguments
- `collection_id`: ID of the collection to search.
- `image`: The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI
  to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
   If you are using an AWS SDK to call Amazon Rekognition, you might not need to
  base64-encode image bytes passed using the Bytes field. For more information, see Images in
  the Amazon Rekognition developer guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FaceMatchThreshold"`: (Optional) Specifies the minimum confidence in the face match to
  return. For example, don't return any matches where confidence in matches is less than 70%.
  The default value is 80%.
- `"MaxFaces"`: Maximum number of faces to return. The operation returns the maximum number
  of faces with the highest confidence in the match.
- `"QualityFilter"`: A filter that specifies a quality bar for how much filtering is done
  to identify faces. Filtered faces aren't searched for in the collection. If you specify
  AUTO, Amazon Rekognition chooses the quality bar. If you specify LOW, MEDIUM, or HIGH,
  filtering removes all faces that don’t meet the chosen quality bar. The quality bar is
  based on a variety of common use cases. Low-quality detections can occur for a number of
  reasons. Some examples are an object that's misidentified as a face, a face that's too
  blurry, or a face with a pose that's too extreme to use. If you specify NONE, no filtering
  is performed. The default value is NONE.  To use quality filtering, the collection you are
  using must be associated with version 3 of the face model or higher.
"""
function search_faces_by_image(
    CollectionId, Image; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "SearchFacesByImage",
        Dict{String,Any}("CollectionId" => CollectionId, "Image" => Image);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_faces_by_image(
    CollectionId,
    Image,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "SearchFacesByImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CollectionId" => CollectionId, "Image" => Image),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_users(collection_id)
    search_users(collection_id, params::Dict{String,<:Any})

Searches for UserIDs within a collection based on a FaceId or UserId. This API can be used
to find the closest UserID (with a highest similarity) to associate a face. The request
must be provided with either FaceId or UserId. The operation returns an array of UserID
that match the FaceId or UserId, ordered by similarity score with the highest similarity
first.

# Arguments
- `collection_id`: The ID of an existing collection containing the UserID, used with a
  UserId or FaceId. If a FaceId is provided, UserId isn’t required to be present in the
  Collection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FaceId"`: ID for the existing face.
- `"MaxUsers"`: Maximum number of identities to return.
- `"UserId"`: ID for the existing User.
- `"UserMatchThreshold"`: Optional value that specifies the minimum confidence in the
  matched UserID to return. Default value of 80.
"""
function search_users(CollectionId; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "SearchUsers",
        Dict{String,Any}("CollectionId" => CollectionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_users(
    CollectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "SearchUsers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CollectionId" => CollectionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_users_by_image(collection_id, image)
    search_users_by_image(collection_id, image, params::Dict{String,<:Any})

Searches for UserIDs using a supplied image. It first detects the largest face in the
image, and then searches a specified collection for matching UserIDs.  The operation
returns an array of UserIDs that match the face in the supplied image, ordered by
similarity score with the highest similarity first. It also returns a bounding box for the
face found in the input image.  Information about faces detected in the supplied image, but
not used for the search, is returned in an array of UnsearchedFace objects. If no valid
face is detected in the image, the response will contain an empty UserMatches list and no
SearchedFace object.

# Arguments
- `collection_id`: The ID of an existing collection containing the UserID.
- `image`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxUsers"`: Maximum number of UserIDs to return.
- `"QualityFilter"`: A filter that specifies a quality bar for how much filtering is done
  to identify faces. Filtered faces aren't searched for in the collection. The default value
  is NONE.
- `"UserMatchThreshold"`: Specifies the minimum confidence in the UserID match to return.
  Default value is 80.
"""
function search_users_by_image(
    CollectionId, Image; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "SearchUsersByImage",
        Dict{String,Any}("CollectionId" => CollectionId, "Image" => Image);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_users_by_image(
    CollectionId,
    Image,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "SearchUsersByImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CollectionId" => CollectionId, "Image" => Image),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_celebrity_recognition(video)
    start_celebrity_recognition(video, params::Dict{String,<:Any})

Starts asynchronous recognition of celebrities in a stored video. Amazon Rekognition Video
can detect celebrities in a video must be stored in an Amazon S3 bucket. Use Video to
specify the bucket name and the filename of the video. StartCelebrityRecognition returns a
job identifier (JobId) which you use to get the results of the analysis. When celebrity
recognition analysis is finished, Amazon Rekognition Video publishes a completion status to
the Amazon Simple Notification Service topic that you specify in NotificationChannel. To
get the results of the celebrity recognition analysis, first check that the status value
published to the Amazon SNS topic is SUCCEEDED. If so, call GetCelebrityRecognition and
pass the job identifier (JobId) from the initial call to StartCelebrityRecognition.  For
more information, see Recognizing celebrities in the Amazon Rekognition Developer Guide.

# Arguments
- `video`: The video in which you want to recognize celebrities. The video must be stored
  in an Amazon S3 bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the start request. If you use
  the same token with multiple StartCelebrityRecognition requests, the same JobId is
  returned. Use ClientRequestToken to prevent the same job from being accidently started more
  than once.
- `"JobTag"`: An identifier you specify that's returned in the completion notification
  that's published to your Amazon Simple Notification Service topic. For example, you can use
  JobTag to group related jobs and identify them in the completion notification.
- `"NotificationChannel"`: The Amazon SNS topic ARN that you want Amazon Rekognition Video
  to publish the completion status of the celebrity recognition analysis to. The Amazon SNS
  topic must have a topic name that begins with AmazonRekognition if you are using the
  AmazonRekognitionServiceRole permissions policy.
"""
function start_celebrity_recognition(
    Video; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartCelebrityRecognition",
        Dict{String,Any}("Video" => Video);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_celebrity_recognition(
    Video, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartCelebrityRecognition",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Video" => Video), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_content_moderation(video)
    start_content_moderation(video, params::Dict{String,<:Any})

 Starts asynchronous detection of inappropriate, unwanted, or offensive content in a stored
video. For a list of moderation labels in Amazon Rekognition, see Using the image and video
moderation APIs. Amazon Rekognition Video can moderate content in a video stored in an
Amazon S3 bucket. Use Video to specify the bucket name and the filename of the video.
StartContentModeration returns a job identifier (JobId) which you use to get the results of
the analysis. When content analysis is finished, Amazon Rekognition Video publishes a
completion status to the Amazon Simple Notification Service topic that you specify in
NotificationChannel. To get the results of the content analysis, first check that the
status value published to the Amazon SNS topic is SUCCEEDED. If so, call
GetContentModeration and pass the job identifier (JobId) from the initial call to
StartContentModeration.  For more information, see Moderating content in the Amazon
Rekognition Developer Guide.

# Arguments
- `video`: The video in which you want to detect inappropriate, unwanted, or offensive
  content. The video must be stored in an Amazon S3 bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the start request. If you use
  the same token with multiple StartContentModeration requests, the same JobId is returned.
  Use ClientRequestToken to prevent the same job from being accidently started more than
  once.
- `"JobTag"`: An identifier you specify that's returned in the completion notification
  that's published to your Amazon Simple Notification Service topic. For example, you can use
  JobTag to group related jobs and identify them in the completion notification.
- `"MinConfidence"`: Specifies the minimum confidence that Amazon Rekognition must have in
  order to return a moderated content label. Confidence represents how certain Amazon
  Rekognition is that the moderated content is correctly identified. 0 is the lowest
  confidence. 100 is the highest confidence. Amazon Rekognition doesn't return any moderated
  content labels with a confidence level lower than this specified value. If you don't
  specify MinConfidence, GetContentModeration returns labels with confidence values greater
  than or equal to 50 percent.
- `"NotificationChannel"`: The Amazon SNS topic ARN that you want Amazon Rekognition Video
  to publish the completion status of the content analysis to. The Amazon SNS topic must have
  a topic name that begins with AmazonRekognition if you are using the
  AmazonRekognitionServiceRole permissions policy to access the topic.
"""
function start_content_moderation(Video; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "StartContentModeration",
        Dict{String,Any}("Video" => Video);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_content_moderation(
    Video, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartContentModeration",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Video" => Video), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_face_detection(video)
    start_face_detection(video, params::Dict{String,<:Any})

Starts asynchronous detection of faces in a stored video. Amazon Rekognition Video can
detect faces in a video stored in an Amazon S3 bucket. Use Video to specify the bucket name
and the filename of the video. StartFaceDetection returns a job identifier (JobId) that you
use to get the results of the operation. When face detection is finished, Amazon
Rekognition Video publishes a completion status to the Amazon Simple Notification Service
topic that you specify in NotificationChannel. To get the results of the face detection
operation, first check that the status value published to the Amazon SNS topic is
SUCCEEDED. If so, call GetFaceDetection and pass the job identifier (JobId) from the
initial call to StartFaceDetection. For more information, see Detecting faces in a stored
video in the Amazon Rekognition Developer Guide.

# Arguments
- `video`: The video in which you want to detect faces. The video must be stored in an
  Amazon S3 bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the start request. If you use
  the same token with multiple StartFaceDetection requests, the same JobId is returned. Use
  ClientRequestToken to prevent the same job from being accidently started more than once.
- `"FaceAttributes"`: The face attributes you want returned.  DEFAULT - The following
  subset of facial attributes are returned: BoundingBox, Confidence, Pose, Quality and
  Landmarks.   ALL - All facial attributes are returned.
- `"JobTag"`: An identifier you specify that's returned in the completion notification
  that's published to your Amazon Simple Notification Service topic. For example, you can use
  JobTag to group related jobs and identify them in the completion notification.
- `"NotificationChannel"`: The ARN of the Amazon SNS topic to which you want Amazon
  Rekognition Video to publish the completion status of the face detection operation. The
  Amazon SNS topic must have a topic name that begins with AmazonRekognition if you are using
  the AmazonRekognitionServiceRole permissions policy.
"""
function start_face_detection(Video; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "StartFaceDetection",
        Dict{String,Any}("Video" => Video);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_face_detection(
    Video, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartFaceDetection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Video" => Video), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_face_search(collection_id, video)
    start_face_search(collection_id, video, params::Dict{String,<:Any})

Starts the asynchronous search for faces in a collection that match the faces of persons
detected in a stored video. The video must be stored in an Amazon S3 bucket. Use Video to
specify the bucket name and the filename of the video. StartFaceSearch returns a job
identifier (JobId) which you use to get the search results once the search has completed.
When searching is finished, Amazon Rekognition Video publishes a completion status to the
Amazon Simple Notification Service topic that you specify in NotificationChannel. To get
the search results, first check that the status value published to the Amazon SNS topic is
SUCCEEDED. If so, call GetFaceSearch and pass the job identifier (JobId) from the initial
call to StartFaceSearch. For more information, see Searching stored videos for faces.

# Arguments
- `collection_id`: ID of the collection that contains the faces you want to search for.
- `video`: The video you want to search. The video must be stored in an Amazon S3 bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the start request. If you use
  the same token with multiple StartFaceSearch requests, the same JobId is returned. Use
  ClientRequestToken to prevent the same job from being accidently started more than once.
- `"FaceMatchThreshold"`: The minimum confidence in the person match to return. For
  example, don't return any matches where confidence in matches is less than 70%. The default
  value is 80%.
- `"JobTag"`: An identifier you specify that's returned in the completion notification
  that's published to your Amazon Simple Notification Service topic. For example, you can use
  JobTag to group related jobs and identify them in the completion notification.
- `"NotificationChannel"`: The ARN of the Amazon SNS topic to which you want Amazon
  Rekognition Video to publish the completion status of the search. The Amazon SNS topic must
  have a topic name that begins with AmazonRekognition if you are using the
  AmazonRekognitionServiceRole permissions policy to access the topic.
"""
function start_face_search(
    CollectionId, Video; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartFaceSearch",
        Dict{String,Any}("CollectionId" => CollectionId, "Video" => Video);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_face_search(
    CollectionId,
    Video,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "StartFaceSearch",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CollectionId" => CollectionId, "Video" => Video),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_label_detection(video)
    start_label_detection(video, params::Dict{String,<:Any})

Starts asynchronous detection of labels in a stored video. Amazon Rekognition Video can
detect labels in a video. Labels are instances of real-world entities. This includes
objects like flower, tree, and table; events like wedding, graduation, and birthday party;
concepts like landscape, evening, and nature; and activities like a person getting out of a
car or a person skiing. The video must be stored in an Amazon S3 bucket. Use Video to
specify the bucket name and the filename of the video. StartLabelDetection returns a job
identifier (JobId) which you use to get the results of the operation. When label detection
is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple
Notification Service topic that you specify in NotificationChannel. To get the results of
the label detection operation, first check that the status value published to the Amazon
SNS topic is SUCCEEDED. If so, call GetLabelDetection and pass the job identifier (JobId)
from the initial call to StartLabelDetection.  Optional Parameters   StartLabelDetection
has the GENERAL_LABELS Feature applied by default. This feature allows you to provide
filtering criteria to the Settings parameter. You can filter with sets of individual labels
or with label categories. You can specify inclusive filters, exclusive filters, or a
combination of inclusive and exclusive filters. For more information on filtering, see
Detecting labels in a video. You can specify MinConfidence to control the confidence
threshold for the labels returned. The default is 50.

# Arguments
- `video`: The video in which you want to detect labels. The video must be stored in an
  Amazon S3 bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the start request. If you use
  the same token with multiple StartLabelDetection requests, the same JobId is returned. Use
  ClientRequestToken to prevent the same job from being accidently started more than once.
- `"Features"`: The features to return after video analysis. You can specify that
  GENERAL_LABELS are returned.
- `"JobTag"`: An identifier you specify that's returned in the completion notification
  that's published to your Amazon Simple Notification Service topic. For example, you can use
  JobTag to group related jobs and identify them in the completion notification.
- `"MinConfidence"`: Specifies the minimum confidence that Amazon Rekognition Video must
  have in order to return a detected label. Confidence represents how certain Amazon
  Rekognition is that a label is correctly identified.0 is the lowest confidence. 100 is the
  highest confidence. Amazon Rekognition Video doesn't return any labels with a confidence
  level lower than this specified value. If you don't specify MinConfidence, the operation
  returns labels and bounding boxes (if detected) with confidence values greater than or
  equal to 50 percent.
- `"NotificationChannel"`: The Amazon SNS topic ARN you want Amazon Rekognition Video to
  publish the completion status of the label detection operation to. The Amazon SNS topic
  must have a topic name that begins with AmazonRekognition if you are using the
  AmazonRekognitionServiceRole permissions policy.
- `"Settings"`: The settings for a StartLabelDetection request.Contains the specified
  parameters for the label detection request of an asynchronous label analysis operation.
  Settings can include filters for GENERAL_LABELS.
"""
function start_label_detection(Video; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "StartLabelDetection",
        Dict{String,Any}("Video" => Video);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_label_detection(
    Video, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartLabelDetection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Video" => Video), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_media_analysis_job(input, operations_config, output_config)
    start_media_analysis_job(input, operations_config, output_config, params::Dict{String,<:Any})

Initiates a new media analysis job. Accepts a manifest file in an Amazon S3 bucket. The
output is a manifest file and a summary of the manifest stored in the Amazon S3 bucket.

# Arguments
- `input`: Input data to be analyzed by the job.
- `operations_config`: Configuration options for the media analysis job to be created.
- `output_config`: The Amazon S3 bucket location to store the results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotency token used to prevent the accidental creation of
  duplicate versions. If you use the same token with multiple StartMediaAnalysisJobRequest
  requests, the same response is returned. Use ClientRequestToken to prevent the same request
  from being processed more than once.
- `"JobName"`: The name of the job. Does not have to be unique.
- `"KmsKeyId"`: The identifier of customer managed AWS KMS key (name or ARN). The key is
  used to encrypt images copied into the service. The key is also used to encrypt results and
  manifest files written to the output Amazon S3 bucket.
"""
function start_media_analysis_job(
    Input,
    OperationsConfig,
    OutputConfig;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "StartMediaAnalysisJob",
        Dict{String,Any}(
            "Input" => Input,
            "OperationsConfig" => OperationsConfig,
            "OutputConfig" => OutputConfig,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_media_analysis_job(
    Input,
    OperationsConfig,
    OutputConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "StartMediaAnalysisJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Input" => Input,
                    "OperationsConfig" => OperationsConfig,
                    "OutputConfig" => OutputConfig,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_person_tracking(video)
    start_person_tracking(video, params::Dict{String,<:Any})

Starts the asynchronous tracking of a person's path in a stored video. Amazon Rekognition
Video can track the path of people in a video stored in an Amazon S3 bucket. Use Video to
specify the bucket name and the filename of the video. StartPersonTracking returns a job
identifier (JobId) which you use to get the results of the operation. When label detection
is finished, Amazon Rekognition publishes a completion status to the Amazon Simple
Notification Service topic that you specify in NotificationChannel.  To get the results of
the person detection operation, first check that the status value published to the Amazon
SNS topic is SUCCEEDED. If so, call GetPersonTracking and pass the job identifier (JobId)
from the initial call to StartPersonTracking.

# Arguments
- `video`: The video in which you want to detect people. The video must be stored in an
  Amazon S3 bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the start request. If you use
  the same token with multiple StartPersonTracking requests, the same JobId is returned. Use
  ClientRequestToken to prevent the same job from being accidently started more than once.
- `"JobTag"`: An identifier you specify that's returned in the completion notification
  that's published to your Amazon Simple Notification Service topic. For example, you can use
  JobTag to group related jobs and identify them in the completion notification.
- `"NotificationChannel"`: The Amazon SNS topic ARN you want Amazon Rekognition Video to
  publish the completion status of the people detection operation to. The Amazon SNS topic
  must have a topic name that begins with AmazonRekognition if you are using the
  AmazonRekognitionServiceRole permissions policy.
"""
function start_person_tracking(Video; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "StartPersonTracking",
        Dict{String,Any}("Video" => Video);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_person_tracking(
    Video, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartPersonTracking",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Video" => Video), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_project_version(min_inference_units, project_version_arn)
    start_project_version(min_inference_units, project_version_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Starts the running of
the version of a model. Starting a model takes a while to complete. To check the current
state of the model, use DescribeProjectVersions.  Once the model is running, you can detect
custom labels in new images by calling DetectCustomLabels.  You are charged for the amount
of time that the model is running. To stop a running model, call StopProjectVersion.  This
operation requires permissions to perform the rekognition:StartProjectVersion action.

# Arguments
- `min_inference_units`: The minimum number of inference units to use. A single inference
  unit represents 1 hour of processing.  Use a higher number to increase the TPS throughput
  of your model. You are charged for the number of inference units that you use.
- `project_version_arn`: The Amazon Resource Name(ARN) of the model version that you want
  to start.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxInferenceUnits"`: The maximum number of inference units to use for auto-scaling the
  model. If you don't specify a value, Amazon Rekognition Custom Labels doesn't auto-scale
  the model.
"""
function start_project_version(
    MinInferenceUnits, ProjectVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartProjectVersion",
        Dict{String,Any}(
            "MinInferenceUnits" => MinInferenceUnits,
            "ProjectVersionArn" => ProjectVersionArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_project_version(
    MinInferenceUnits,
    ProjectVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "StartProjectVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MinInferenceUnits" => MinInferenceUnits,
                    "ProjectVersionArn" => ProjectVersionArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_segment_detection(segment_types, video)
    start_segment_detection(segment_types, video, params::Dict{String,<:Any})

Starts asynchronous detection of segment detection in a stored video. Amazon Rekognition
Video can detect segments in a video stored in an Amazon S3 bucket. Use Video to specify
the bucket name and the filename of the video. StartSegmentDetection returns a job
identifier (JobId) which you use to get the results of the operation. When segment
detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon
Simple Notification Service topic that you specify in NotificationChannel. You can use the
Filters (StartSegmentDetectionFilters) input parameter to specify the minimum detection
confidence returned in the response. Within Filters, use ShotFilter
(StartShotDetectionFilter) to filter detected shots. Use TechnicalCueFilter
(StartTechnicalCueDetectionFilter) to filter technical cues.  To get the results of the
segment detection operation, first check that the status value published to the Amazon SNS
topic is SUCCEEDED. if so, call GetSegmentDetection and pass the job identifier (JobId)
from the initial call to StartSegmentDetection.  For more information, see Detecting video
segments in stored video in the Amazon Rekognition Developer Guide.

# Arguments
- `segment_types`: An array of segment types to detect in the video. Valid values are
  TECHNICAL_CUE and SHOT.
- `video`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the start request. If you use
  the same token with multiple StartSegmentDetection requests, the same JobId is returned.
  Use ClientRequestToken to prevent the same job from being accidently started more than
  once.
- `"Filters"`: Filters for technical cue or shot detection.
- `"JobTag"`: An identifier you specify that's returned in the completion notification
  that's published to your Amazon Simple Notification Service topic. For example, you can use
  JobTag to group related jobs and identify them in the completion notification.
- `"NotificationChannel"`: The ARN of the Amazon SNS topic to which you want Amazon
  Rekognition Video to publish the completion status of the segment detection operation. Note
  that the Amazon SNS topic must have a topic name that begins with AmazonRekognition if you
  are using the AmazonRekognitionServiceRole permissions policy to access the topic.
"""
function start_segment_detection(
    SegmentTypes, Video; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartSegmentDetection",
        Dict{String,Any}("SegmentTypes" => SegmentTypes, "Video" => Video);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_segment_detection(
    SegmentTypes,
    Video,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "StartSegmentDetection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SegmentTypes" => SegmentTypes, "Video" => Video),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_stream_processor(name)
    start_stream_processor(name, params::Dict{String,<:Any})

Starts processing a stream processor. You create a stream processor by calling
CreateStreamProcessor. To tell StartStreamProcessor which stream processor to start, use
the value of the Name field specified in the call to CreateStreamProcessor. If you are
using a label detection stream processor to detect labels, you need to provide a Start
selector and a Stop selector to determine the length of the stream processing time.

# Arguments
- `name`: The name of the stream processor to start processing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"StartSelector"`:  Specifies the starting point in the Kinesis stream to start
  processing. You can use the producer timestamp or the fragment number. If you use the
  producer timestamp, you must put the time in milliseconds. For more information about
  fragment numbers, see Fragment.  This is a required parameter for label detection stream
  processors and should not be used to start a face search stream processor.
- `"StopSelector"`:  Specifies when to stop processing the stream. You can specify a
  maximum amount of time to process the video.  This is a required parameter for label
  detection stream processors and should not be used to start a face search stream processor.
"""
function start_stream_processor(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "StartStreamProcessor",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_stream_processor(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartStreamProcessor",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_text_detection(video)
    start_text_detection(video, params::Dict{String,<:Any})

Starts asynchronous detection of text in a stored video. Amazon Rekognition Video can
detect text in a video stored in an Amazon S3 bucket. Use Video to specify the bucket name
and the filename of the video. StartTextDetection returns a job identifier (JobId) which
you use to get the results of the operation. When text detection is finished, Amazon
Rekognition Video publishes a completion status to the Amazon Simple Notification Service
topic that you specify in NotificationChannel. To get the results of the text detection
operation, first check that the status value published to the Amazon SNS topic is
SUCCEEDED. if so, call GetTextDetection and pass the job identifier (JobId) from the
initial call to StartTextDetection.

# Arguments
- `video`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Idempotent token used to identify the start request. If you use
  the same token with multiple StartTextDetection requests, the same JobId is returned. Use
  ClientRequestToken to prevent the same job from being accidentaly started more than once.
- `"Filters"`: Optional parameters that let you set criteria the text must meet to be
  included in your response.
- `"JobTag"`: An identifier returned in the completion status published by your Amazon
  Simple Notification Service topic. For example, you can use JobTag to group related jobs
  and identify them in the completion notification.
- `"NotificationChannel"`:
"""
function start_text_detection(Video; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "StartTextDetection",
        Dict{String,Any}("Video" => Video);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_text_detection(
    Video, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StartTextDetection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Video" => Video), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_project_version(project_version_arn)
    stop_project_version(project_version_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Stops a running model.
The operation might take a while to complete. To check the current status, call
DescribeProjectVersions. Only applies to Custom Labels projects. This operation requires
permissions to perform the rekognition:StopProjectVersion action.

# Arguments
- `project_version_arn`: The Amazon Resource Name (ARN) of the model version that you want
  to stop. This operation requires permissions to perform the rekognition:StopProjectVersion
  action.

"""
function stop_project_version(
    ProjectVersionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StopProjectVersion",
        Dict{String,Any}("ProjectVersionArn" => ProjectVersionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_project_version(
    ProjectVersionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "StopProjectVersion",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ProjectVersionArn" => ProjectVersionArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_stream_processor(name)
    stop_stream_processor(name, params::Dict{String,<:Any})

Stops a running stream processor that was created by CreateStreamProcessor.

# Arguments
- `name`: The name of a stream processor created by CreateStreamProcessor.

"""
function stop_stream_processor(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "StopStreamProcessor",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_stream_processor(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "StopStreamProcessor",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

 Adds one or more key-value tags to an Amazon Rekognition collection, stream processor, or
Custom Labels model. For more information, see Tagging AWS Resources.  This operation
requires permissions to perform the rekognition:TagResource action.

# Arguments
- `resource_arn`:  Amazon Resource Name (ARN) of the model, collection, or stream processor
  that you want to assign the tags to.
- `tags`:  The key-value tags to assign to the resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

 Removes one or more tags from an Amazon Rekognition collection, stream processor, or
Custom Labels model.  This operation requires permissions to perform the
rekognition:UntagResource action.

# Arguments
- `resource_arn`:  Amazon Resource Name (ARN) of the model, collection, or stream processor
  that you want to remove the tags from.
- `tag_keys`:  A list of the tags that you want to remove.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_dataset_entries(changes, dataset_arn)
    update_dataset_entries(changes, dataset_arn, params::Dict{String,<:Any})

 This operation applies only to Amazon Rekognition Custom Labels.  Adds or updates one or
more entries (images) in a dataset. An entry is a JSON Line which contains the information
for a single image, including the image location, assigned labels, and object location
bounding boxes. For more information, see Image-Level labels in manifest files and Object
localization in manifest files in the Amazon Rekognition Custom Labels Developer Guide.  If
the source-ref field in the JSON line references an existing image, the existing image in
the dataset is updated. If source-ref field doesn't reference an existing image, the image
is added as a new image to the dataset.  You specify the changes that you want to make in
the Changes input parameter. There isn't a limit to the number JSON Lines that you can
change, but the size of Changes must be less than 5MB.  UpdateDatasetEntries returns
immediatly, but the dataset update might take a while to complete. Use DescribeDataset to
check the current status. The dataset updated successfully if the value of Status is
UPDATE_COMPLETE.  To check if any non-terminal errors occured, call ListDatasetEntries and
check for the presence of errors lists in the JSON Lines. Dataset update fails if a
terminal error occurs (Status = UPDATE_FAILED). Currently, you can't access the terminal
error information from the Amazon Rekognition Custom Labels SDK.  This operation requires
permissions to perform the rekognition:UpdateDatasetEntries action.

# Arguments
- `changes`:  The changes that you want to make to the dataset.
- `dataset_arn`:  The Amazon Resource Name (ARN) of the dataset that you want to update.

"""
function update_dataset_entries(
    Changes, DatasetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "UpdateDatasetEntries",
        Dict{String,Any}("Changes" => Changes, "DatasetArn" => DatasetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_dataset_entries(
    Changes,
    DatasetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rekognition(
        "UpdateDatasetEntries",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Changes" => Changes, "DatasetArn" => DatasetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_stream_processor(name)
    update_stream_processor(name, params::Dict{String,<:Any})

 Allows you to update a stream processor. You can change some settings and regions of
interest and delete certain parameters.

# Arguments
- `name`:  Name of the stream processor that you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataSharingPreferenceForUpdate"`:  Shows whether you are sharing data with Rekognition
  to improve model performance. You can choose this option at the account level or on a
  per-stream basis. Note that if you opt out at the account level this setting is ignored on
  individual streams.
- `"ParametersToDelete"`:  A list of parameters you want to delete from the stream
  processor.
- `"RegionsOfInterestForUpdate"`:  Specifies locations in the frames where Amazon
  Rekognition checks for objects or people. This is an optional parameter for label detection
  stream processors.
- `"SettingsForUpdate"`:  The stream processor settings that you want to update. Label
  detection settings can be updated to detect different labels with a different minimum
  confidence.
"""
function update_stream_processor(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return rekognition(
        "UpdateStreamProcessor",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_stream_processor(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rekognition(
        "UpdateStreamProcessor",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
