# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: sso_oidc
using AWS.Compat
using AWS.UUIDs

"""
    create_token(client_id, client_secret, grant_type)
    create_token(client_id, client_secret, grant_type, params::Dict{String,<:Any})

Creates and returns access and refresh tokens for clients that are authenticated using
client secrets. The access token can be used to fetch short-term credentials for the
assigned AWS accounts or to access application APIs using bearer authentication.

# Arguments
- `client_id`: The unique identifier string for the client or application. This value comes
  from the result of the RegisterClient API.
- `client_secret`: A secret string generated for the client. This value should come from
  the persisted result of the RegisterClient API.
- `grant_type`: Supports the following OAuth grant types: Device Code and Refresh Token.
  Specify either of the following values, depending on the grant type that you want: * Device
  Code - urn:ietf:params:oauth:grant-type:device_code  * Refresh Token - refresh_token  For
  information about how to obtain the device code, see the StartDeviceAuthorization topic.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"code"`: Used only when calling this API for the Authorization Code grant type. The
  short-term code is used to identify this authorization request. This grant type is
  currently unsupported for the CreateToken API.
- `"codeVerifier"`: Used only when calling this API for the Authorization Code grant type.
  This value is generated by the client and presented to validate the original code challenge
  value the client passed at authorization time.
- `"deviceCode"`: Used only when calling this API for the Device Code grant type. This
  short-term code is used to identify this authorization request. This comes from the result
  of the StartDeviceAuthorization API.
- `"redirectUri"`: Used only when calling this API for the Authorization Code grant type.
  This value specifies the location of the client or application that has registered to
  receive the authorization code.
- `"refreshToken"`: Used only when calling this API for the Refresh Token grant type. This
  token is used to refresh short-term tokens, such as the access token, that might expire.
  For more information about the features and limitations of the current IAM Identity Center
  OIDC implementation, see Considerations for Using this Guide in the IAM Identity Center
  OIDC API Reference.
- `"scope"`: The list of scopes for which authorization is requested. The access token that
  is issued is limited to the scopes that are granted. If this value is not specified, IAM
  Identity Center authorizes all scopes that are configured for the client during the call to
  RegisterClient.
"""
function create_token(
    clientId, clientSecret, grantType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sso_oidc(
        "POST",
        "/token",
        Dict{String,Any}(
            "clientId" => clientId, "clientSecret" => clientSecret, "grantType" => grantType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_token(
    clientId,
    clientSecret,
    grantType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sso_oidc(
        "POST",
        "/token",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientId" => clientId,
                    "clientSecret" => clientSecret,
                    "grantType" => grantType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_token_with_iam(client_id, grant_type)
    create_token_with_iam(client_id, grant_type, params::Dict{String,<:Any})

Creates and returns access and refresh tokens for clients and applications that are
authenticated using IAM entities. The access token can be used to fetch short-term
credentials for the assigned Amazon Web Services accounts or to access application APIs
using bearer authentication.

# Arguments
- `client_id`: The unique identifier string for the client or application. This value is an
  application ARN that has OAuth grants configured.
- `grant_type`: Supports the following OAuth grant types: Authorization Code, Refresh
  Token, JWT Bearer, and Token Exchange. Specify one of the following values, depending on
  the grant type that you want: * Authorization Code - authorization_code  * Refresh Token -
  refresh_token  * JWT Bearer - urn:ietf:params:oauth:grant-type:jwt-bearer  * Token Exchange
  - urn:ietf:params:oauth:grant-type:token-exchange

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"assertion"`: Used only when calling this API for the JWT Bearer grant type. This value
  specifies the JSON Web Token (JWT) issued by a trusted token issuer. To authorize a trusted
  token issuer, configure the JWT Bearer GrantOptions for the application.
- `"code"`: Used only when calling this API for the Authorization Code grant type. This
  short-term code is used to identify this authorization request. The code is obtained
  through a redirect from IAM Identity Center to a redirect URI persisted in the
  Authorization Code GrantOptions for the application.
- `"codeVerifier"`: Used only when calling this API for the Authorization Code grant type.
  This value is generated by the client and presented to validate the original code challenge
  value the client passed at authorization time.
- `"redirectUri"`: Used only when calling this API for the Authorization Code grant type.
  This value specifies the location of the client or application that has registered to
  receive the authorization code.
- `"refreshToken"`: Used only when calling this API for the Refresh Token grant type. This
  token is used to refresh short-term tokens, such as the access token, that might expire.
  For more information about the features and limitations of the current IAM Identity Center
  OIDC implementation, see Considerations for Using this Guide in the IAM Identity Center
  OIDC API Reference.
- `"requestedTokenType"`: Used only when calling this API for the Token Exchange grant
  type. This value specifies the type of token that the requester can receive. The following
  values are supported: * Access Token - urn:ietf:params:oauth:token-type:access_token  *
  Refresh Token - urn:ietf:params:oauth:token-type:refresh_token
- `"scope"`: The list of scopes for which authorization is requested. The access token that
  is issued is limited to the scopes that are granted. If the value is not specified, IAM
  Identity Center authorizes all scopes configured for the application, including the
  following default scopes: openid, aws, sts:identity_context.
- `"subjectToken"`: Used only when calling this API for the Token Exchange grant type. This
  value specifies the subject of the exchange. The value of the subject token must be an
  access token issued by IAM Identity Center to a different client or application. The access
  token must have authorized scopes that indicate the requested application as a target
  audience.
- `"subjectTokenType"`: Used only when calling this API for the Token Exchange grant type.
  This value specifies the type of token that is passed as the subject of the exchange. The
  following value is supported: * Access Token -
  urn:ietf:params:oauth:token-type:access_token
"""
function create_token_with_iam(
    clientId, grantType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sso_oidc(
        "POST",
        "/token?aws_iam=t",
        Dict{String,Any}("clientId" => clientId, "grantType" => grantType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_token_with_iam(
    clientId,
    grantType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sso_oidc(
        "POST",
        "/token?aws_iam=t",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("clientId" => clientId, "grantType" => grantType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_client(client_name, client_type)
    register_client(client_name, client_type, params::Dict{String,<:Any})

Registers a client with IAM Identity Center. This allows clients to initiate device
authorization. The output should be persisted for reuse through many authentication
requests.

# Arguments
- `client_name`: The friendly name of the client.
- `client_type`: The type of client. The service supports only public as a client type.
  Anything other than public will be rejected by the service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"entitledApplicationArn"`: This IAM Identity Center application ARN is used to define
  administrator-managed configuration for public client access to resources. At
  authorization, the scopes, grants, and redirect URI available to this client will be
  restricted by this application resource.
- `"grantTypes"`: The list of OAuth 2.0 grant types that are defined by the client. This
  list is used to restrict the token granting flows available to the client.
- `"issuerUrl"`: The IAM Identity Center Issuer URL associated with an instance of IAM
  Identity Center. This value is needed for user access to resources through the client.
- `"redirectUris"`: The list of redirect URI that are defined by the client. At completion
  of authorization, this list is used to restrict what locations the user agent can be
  redirected back to.
- `"scopes"`: The list of scopes that are defined by the client. Upon authorization, this
  list is used to restrict permissions when granting an access token.
"""
function register_client(
    clientName, clientType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sso_oidc(
        "POST",
        "/client/register",
        Dict{String,Any}("clientName" => clientName, "clientType" => clientType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_client(
    clientName,
    clientType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sso_oidc(
        "POST",
        "/client/register",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("clientName" => clientName, "clientType" => clientType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_device_authorization(client_id, client_secret, start_url)
    start_device_authorization(client_id, client_secret, start_url, params::Dict{String,<:Any})

Initiates device authorization by requesting a pair of verification codes from the
authorization service.

# Arguments
- `client_id`: The unique identifier string for the client that is registered with IAM
  Identity Center. This value should come from the persisted result of the RegisterClient API
  operation.
- `client_secret`: A secret string that is generated for the client. This value should come
  from the persisted result of the RegisterClient API operation.
- `start_url`: The URL for the Amazon Web Services access portal. For more information, see
  Using the Amazon Web Services access portal in the IAM Identity Center User Guide.

"""
function start_device_authorization(
    clientId, clientSecret, startUrl; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sso_oidc(
        "POST",
        "/device_authorization",
        Dict{String,Any}(
            "clientId" => clientId, "clientSecret" => clientSecret, "startUrl" => startUrl
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_device_authorization(
    clientId,
    clientSecret,
    startUrl,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sso_oidc(
        "POST",
        "/device_authorization",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientId" => clientId,
                    "clientSecret" => clientSecret,
                    "startUrl" => startUrl,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
