# DataStructures.jl

This package implements a variety of data structures, including

-   Deque (implemented with an [unrolled linked list](https://en.wikipedia.org/wiki/Unrolled_linked_list))
-   CircularBuffer
-   CircularDeque (based on a circular buffer)
-   Stack
-   Queue
-   Priority Queue
-   Fenwick Tree
-   Accumulators and Counters (i.e. Multisets / Bags)
-   Disjoint Sets
-   Binary Heap
-   Mutable Binary Heap
-   Ordered Dicts and Sets
-   RobinDict and OrderedRobinDict (implemented with [Robin Hood Hashing](https://cs.uwaterloo.ca/research/tr/1986/CS-86-14.pdf))
-   SwissDict (inspired from [SwissTables](https://abseil.io/blog/20180927-swisstables))
-   Dictionaries with Defaults
-   Trie
-   Linked List and Mutable Linked List
-   Sorted Dict, Sorted Multi-Dict and Sorted Set
-   DataStructures.IntSet
-   SparseIntSet
-   DiBitVector
-   Red Black Tree
-   AVL Tree
-   Splay Tree

## Contents

```@contents
Pages = [
    "index.md",
    "deque.md",
    "circ_buffer.md",
    "circ_deque.md",
    "stack_and_queue.md",
    "priority-queue.md",
    "fenwick.md",
    "accumulators.md",
    "disjoint_sets.md",
    "heaps.md",
    "ordered_containers.md",
    "default_dict.md",
    "robin_dict.md",
    "trie.md",
    "linked_list.md",
    "mutable_linked_list.md",
    "intset.md",
    "sorted_containers.md",
    "sparse_int_set.md",
    "dibit_vector.md",
    "red_black_tree.md",
    "avl_tree.md",
    "splay_tree.md",
]
```
