
    #= none:1 =# Core.@doc "    is_valid_typevar(typevar)\n\nCheck if the given typevar is a valid typevar.\n\n!!! note\n    This function is based on [this discourse post](https://discourse.julialang.org/t/what-are-valid-type-parameters/471).\n" function is_valid_typevar(typevar)
            let
                true
                var"##return#230" = nothing
                var"##232" = typevar
                if var"##232" isa TypeVar
                    begin
                        var"##return#230" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#231#233")))
                    end
                end
                if var"##232" isa QuoteNode
                    begin
                        var"##return#230" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#231#233")))
                    end
                end
                if var"##232" isa Type
                    begin
                        var"##return#230" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#231#233")))
                    end
                end
                if isbitstype(typeof(typevar))
                    var"##return#230" = let
                            true
                        end
                    $(Expr(:symbolicgoto, Symbol("####final#231#233")))
                end
                if var"##232" isa Tuple
                    var"##return#230" = let
                            all((x->begin
                                        x isa Symbol || isbitstype(typeof(x))
                                    end), typevar)
                        end
                    $(Expr(:symbolicgoto, Symbol("####final#231#233")))
                end
                begin
                    var"##return#230" = let
                            false
                        end
                    $(Expr(:symbolicgoto, Symbol("####final#231#233")))
                end
                error("matching non-exhaustive, at #= none:10 =#")
                $(Expr(:symboliclabel, Symbol("####final#231#233")))
                var"##return#230"
            end
        end
    #= none:20 =# Core.@doc "    is_literal(x)\n\nCheck if `x` is a literal value.\n" function is_literal(x)
            !(x isa Expr || (x isa Symbol || x isa GlobalRef))
        end
    #= none:29 =# Core.@doc "    is_tuple(ex)\n\nCheck if `ex` is a tuple expression, i.e. `:((a,b,c))`\n" is_tuple(x) = begin
                Meta.isexpr(x, :tuple)
            end
    #= none:36 =# Core.@doc "    is_splat(ex)\n\nCheck if `ex` is a splat expression, i.e. `:(f(x)...)`\n" is_splat(x) = begin
                Meta.isexpr(x, :...)
            end
    #= none:43 =# Core.@doc "    is_gensym(s)\n\nCheck if `s` is generated by `gensym`.\n\n!!! note\n    Borrowed from [MacroTools](https://github.com/FluxML/MacroTools.jl).\n" is_gensym(s::Symbol) = begin
                occursin("#", string(s))
            end
    is_gensym(s) = begin
            false
        end
    #= none:54 =# Core.@doc "    support_default(f)\n\nCheck if field type `f` supports default value.\n" support_default(f) = begin
                false
            end
    support_default(f::JLKwField) = begin
            true
        end
    #= none:62 =# Core.@doc "    has_symbol(ex, name::Symbol)\n\nCheck if `ex` contains symbol `name`.\n" function has_symbol(#= none:67 =# @nospecialize(ex), name::Symbol)
            ex isa Symbol && return ex === name
            ex isa Expr || return false
            return any((x->begin
                            has_symbol(x, name)
                        end), ex.args)
        end
    #= none:73 =# Core.@doc "    has_kwfn_constructor(def[, name = struct_name_plain(def)])\n\nCheck if the struct definition contains keyword function constructor of `name`.\nThe constructor name to check by default is the plain constructor which does\nnot infer any type variables and requires user to input all type variables.\nSee also [`struct_name_plain`](@ref).\n" function has_kwfn_constructor(def, name = struct_name_plain(def))
            any(def.constructors) do fn::JLFunction
                isempty(fn.args) && fn.name == name
            end
        end
    #= none:87 =# Core.@doc "    has_plain_constructor(def, name = struct_name_plain(def))\n\nCheck if the struct definition contains the plain constructor of `name`.\nBy default the name is the inferable name [`struct_name_plain`](@ref).\n\n# Example\n\n```julia\ndef = @expr JLKwStruct struct Foo{T, N}\n    x::Int\n    y::N\n\n    Foo{T, N}(x, y) where {T, N} = new{T, N}(x, y)\nend\n\nhas_plain_constructor(def) # true\n\ndef = @expr JLKwStruct struct Foo{T, N}\n    x::T\n    y::N\n\n    Foo(x, y) = new{typeof(x), typeof(y)}(x, y)\nend\n\nhas_plain_constructor(def) # false\n```\n\nthe arguments must have no type annotations.\n\n```julia\ndef = @expr JLKwStruct struct Foo{T, N}\n    x::T\n    y::N\n\n    Foo{T, N}(x::T, y::N) where {T, N} = new{T, N}(x, y)\nend\n\nhas_plain_constructor(def) # false\n```\n" function has_plain_constructor(def, name = struct_name_plain(def))
            any(def.constructors) do fn::JLFunction
                fn.name == name || return false
                fn.kwargs === nothing || return false
                length(def.fields) == length(fn.args) || return false
                for (f, x) = zip(def.fields, fn.args)
                    f.name === x || return false
                end
                return true
            end
        end
    #= none:140 =# Core.@doc "    is_function(def)\n\nCheck if given object is a function expression.\n" function is_function(#= none:145 =# @nospecialize(def))
            let
                true
                var"##return#234" = nothing
                var"##236" = def
                if var"##236" isa JLFunction
                    begin
                        var"##return#234" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#235#237")))
                    end
                end
                if var"##236" isa Expr
                    begin
                        var"##return#234" = let
                                (line, doc, expr) = split_doc(def)
                                if !(isnothing(doc))
                                    source = line
                                end
                                split_function_tuple = split_function_nothrow(expr)
                                isnothing(split_function_tuple) && return false
                                (head, call, body) = split_function_tuple
                                split_head_tuple = let
                                        true
                                        var"##return#238" = nothing
                                        var"##240" = head
                                        if var"##240" == :->
                                            var"##return#238" = let
                                                    split_anonymous_function_head_nothrow(call)
                                                end
                                            $(Expr(:symbolicgoto, Symbol("####final#239#241")))
                                        end
                                        begin
                                            var"##return#238" = let h = var"##240"
                                                    split_function_head_nothrow(call)
                                                end
                                            $(Expr(:symbolicgoto, Symbol("####final#239#241")))
                                        end
                                        error("matching non-exhaustive, at #= none:157 =#")
                                        $(Expr(:symboliclabel, Symbol("####final#239#241")))
                                        var"##return#238"
                                    end
                                isnothing(split_head_tuple) && return false
                                (name, args, kw, whereparams, rettype) = split_head_tuple
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#235#237")))
                    end
                end
                begin
                    var"##return#234" = let
                            false
                        end
                    $(Expr(:symbolicgoto, Symbol("####final#235#237")))
                end
                error("matching non-exhaustive, at #= none:146 =#")
                $(Expr(:symboliclabel, Symbol("####final#235#237")))
                var"##return#234"
            end
        end
    #= none:170 =# Core.@doc "    is_kw_function(def)\n\nCheck if a given function definition supports keyword arguments.\n" function is_kw_function(#= none:175 =# @nospecialize(def))
            is_function(def) || return false
            if def isa JLFunction
                return def.kwargs !== nothing
            end
            (_, call, _) = split_function(def)
            let
                begin
                    var"##cache#245" = nothing
                end
                var"##return#242" = nothing
                var"##244" = call
                if var"##244" isa Expr
                    if begin
                                if var"##cache#245" === nothing
                                    var"##cache#245" = Some(((var"##244").head, (var"##244").args))
                                end
                                var"##246" = (var"##cache#245").value
                                var"##246" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##246"[1] == :tuple && (begin
                                        var"##247" = var"##246"[2]
                                        var"##247" isa AbstractArray
                                    end && ((ndims(var"##247") === 1 && length(var"##247") >= 1) && (begin
                                                begin
                                                    var"##cache#249" = nothing
                                                end
                                                var"##248" = var"##247"[1]
                                                var"##248" isa Expr
                                            end && (begin
                                                    if var"##cache#249" === nothing
                                                        var"##cache#249" = Some(((var"##248").head, (var"##248").args))
                                                    end
                                                    var"##250" = (var"##cache#249").value
                                                    var"##250" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                                                end && (var"##250"[1] == :parameters && (begin
                                                            var"##251" = var"##250"[2]
                                                            var"##251" isa AbstractArray
                                                        end && (ndims(var"##251") === 1 && length(var"##251") >= 0))))))))
                        var"##return#242" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#243#261")))
                    end
                    if begin
                                var"##252" = (var"##cache#245").value
                                var"##252" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##252"[1] == :call && (begin
                                        var"##253" = var"##252"[2]
                                        var"##253" isa AbstractArray
                                    end && ((ndims(var"##253") === 1 && length(var"##253") >= 2) && (begin
                                                begin
                                                    var"##cache#255" = nothing
                                                end
                                                var"##254" = var"##253"[2]
                                                var"##254" isa Expr
                                            end && (begin
                                                    if var"##cache#255" === nothing
                                                        var"##cache#255" = Some(((var"##254").head, (var"##254").args))
                                                    end
                                                    var"##256" = (var"##cache#255").value
                                                    var"##256" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                                                end && (var"##256"[1] == :parameters && (begin
                                                            var"##257" = var"##256"[2]
                                                            var"##257" isa AbstractArray
                                                        end && (ndims(var"##257") === 1 && length(var"##257") >= 0))))))))
                        var"##return#242" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#243#261")))
                    end
                    if begin
                                var"##258" = (var"##cache#245").value
                                var"##258" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##258"[1] == :block && (begin
                                        var"##259" = var"##258"[2]
                                        var"##259" isa AbstractArray
                                    end && (length(var"##259") === 3 && begin
                                            var"##260" = var"##259"[2]
                                            var"##260" isa LineNumberNode
                                        end)))
                        var"##return#242" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#243#261")))
                    end
                end
                begin
                    var"##return#242" = let
                            false
                        end
                    $(Expr(:symbolicgoto, Symbol("####final#243#261")))
                end
                error("matching non-exhaustive, at #= none:183 =#")
                $(Expr(:symboliclabel, Symbol("####final#243#261")))
                var"##return#242"
            end
        end
    #= none:191 =# @deprecate is_kw_fn(def) is_kw_function(def)
    #= none:192 =# @deprecate is_fn(def) is_function(def)
    #= none:194 =# Core.@doc "    is_struct(ex)\n\nCheck if `ex` is a struct expression.\n" function is_struct(#= none:199 =# @nospecialize(ex))
            ex isa Expr || return false
            return ex.head === :struct
        end
    #= none:204 =# Core.@doc "    is_struct_not_kw_struct(ex)\n\nCheck if `ex` is a struct expression excluding keyword struct syntax.\n" function is_struct_not_kw_struct(ex)
            is_struct(ex) || return false
            body = ex.args[3]
            body isa Expr && body.head === :block || return false
            any(is_field_default, body.args) && return false
            return true
        end
    #= none:217 =# Core.@doc "    is_ifelse(ex)\n\nCheck if `ex` is an `if ... elseif ... else ... end` expression.\n" function is_ifelse(#= none:222 =# @nospecialize(ex))
            ex isa Expr || return false
            return ex.head === :if
        end
    #= none:227 =# Core.@doc "    is_for(ex)\n\nCheck if `ex` is a `for` loop expression.\n" function is_for(#= none:232 =# @nospecialize(ex))
            ex isa Expr || return false
            return ex.head === :for
        end
    #= none:237 =# Core.@doc "    is_field(ex)\n\nCheck if `ex` is a valid field expression.\n" function is_field(#= none:242 =# @nospecialize(ex))
            let
                begin
                    var"##cache#265" = nothing
                end
                var"##return#262" = nothing
                var"##264" = ex
                if var"##264" isa Expr
                    if begin
                                if var"##cache#265" === nothing
                                    var"##cache#265" = Some(((var"##264").head, (var"##264").args))
                                end
                                var"##266" = (var"##cache#265").value
                                var"##266" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##266"[1] == :(=) && (begin
                                        var"##267" = var"##266"[2]
                                        var"##267" isa AbstractArray
                                    end && (length(var"##267") === 2 && (begin
                                                begin
                                                    var"##cache#269" = nothing
                                                end
                                                var"##268" = var"##267"[1]
                                                var"##268" isa Expr
                                            end && (begin
                                                    if var"##cache#269" === nothing
                                                        var"##cache#269" = Some(((var"##268").head, (var"##268").args))
                                                    end
                                                    var"##270" = (var"##cache#269").value
                                                    var"##270" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                                                end && (var"##270"[1] == :(::) && (begin
                                                            var"##271" = var"##270"[2]
                                                            var"##271" isa AbstractArray
                                                        end && (length(var"##271") === 2 && begin
                                                                var"##272" = var"##271"[1]
                                                                var"##273" = var"##271"[2]
                                                                var"##274" = var"##267"[2]
                                                                true
                                                            end))))))))
                        var"##return#262" = let default = var"##274", type = var"##273", name = var"##272"
                                false
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#263#283")))
                    end
                    if begin
                                var"##275" = (var"##cache#265").value
                                var"##275" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##275"[1] == :(=) && (begin
                                        var"##276" = var"##275"[2]
                                        var"##276" isa AbstractArray
                                    end && (length(var"##276") === 2 && (begin
                                                var"##277" = var"##276"[1]
                                                var"##277" isa Symbol
                                            end && begin
                                                var"##278" = var"##276"[2]
                                                true
                                            end))))
                        var"##return#262" = let default = var"##278", name = var"##277"
                                false
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#263#283")))
                    end
                    if begin
                                var"##279" = (var"##cache#265").value
                                var"##279" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##279"[1] == :(::) && (begin
                                        var"##280" = var"##279"[2]
                                        var"##280" isa AbstractArray
                                    end && (length(var"##280") === 2 && begin
                                            var"##281" = var"##280"[1]
                                            var"##282" = var"##280"[2]
                                            true
                                        end)))
                        var"##return#262" = let type = var"##282", name = var"##281"
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#263#283")))
                    end
                end
                if var"##264" isa Symbol
                    begin
                        var"##return#262" = let name = var"##264"
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#263#283")))
                    end
                end
                begin
                    var"##return#262" = let
                            false
                        end
                    $(Expr(:symbolicgoto, Symbol("####final#263#283")))
                end
                error("matching non-exhaustive, at #= none:243 =#")
                $(Expr(:symboliclabel, Symbol("####final#263#283")))
                var"##return#262"
            end
        end
    #= none:252 =# Core.@doc "    is_field_default(ex)\n\nCheck if `ex` is a `<field expr> = <default expr>` expression.\n" function is_field_default(#= none:257 =# @nospecialize(ex))
            let
                begin
                    var"##cache#287" = nothing
                end
                var"##return#284" = nothing
                var"##286" = ex
                if var"##286" isa Expr
                    if begin
                                if var"##cache#287" === nothing
                                    var"##cache#287" = Some(((var"##286").head, (var"##286").args))
                                end
                                var"##288" = (var"##cache#287").value
                                var"##288" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##288"[1] == :(=) && (begin
                                        var"##289" = var"##288"[2]
                                        var"##289" isa AbstractArray
                                    end && (length(var"##289") === 2 && (begin
                                                begin
                                                    var"##cache#291" = nothing
                                                end
                                                var"##290" = var"##289"[1]
                                                var"##290" isa Expr
                                            end && (begin
                                                    if var"##cache#291" === nothing
                                                        var"##cache#291" = Some(((var"##290").head, (var"##290").args))
                                                    end
                                                    var"##292" = (var"##cache#291").value
                                                    var"##292" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                                                end && (var"##292"[1] == :(::) && (begin
                                                            var"##293" = var"##292"[2]
                                                            var"##293" isa AbstractArray
                                                        end && (length(var"##293") === 2 && begin
                                                                var"##294" = var"##293"[1]
                                                                var"##295" = var"##293"[2]
                                                                var"##296" = var"##289"[2]
                                                                true
                                                            end))))))))
                        var"##return#284" = let default = var"##296", type = var"##295", name = var"##294"
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#285#301")))
                    end
                    if begin
                                var"##297" = (var"##cache#287").value
                                var"##297" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##297"[1] == :(=) && (begin
                                        var"##298" = var"##297"[2]
                                        var"##298" isa AbstractArray
                                    end && (length(var"##298") === 2 && (begin
                                                var"##299" = var"##298"[1]
                                                var"##299" isa Symbol
                                            end && begin
                                                var"##300" = var"##298"[2]
                                                true
                                            end))))
                        var"##return#284" = let default = var"##300", name = var"##299"
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#285#301")))
                    end
                end
                begin
                    var"##return#284" = let
                            false
                        end
                    $(Expr(:symbolicgoto, Symbol("####final#285#301")))
                end
                error("matching non-exhaustive, at #= none:258 =#")
                $(Expr(:symboliclabel, Symbol("####final#285#301")))
                var"##return#284"
            end
        end
    #= none:265 =# Core.@doc "    is_datatype_expr(ex)\n\nCheck if `ex` is an expression for a concrete `DataType`, e.g\n`where` is not allowed in the expression.\n" function is_datatype_expr(#= none:271 =# @nospecialize(ex))
            let
                begin
                    var"##cache#305" = nothing
                end
                var"##return#302" = nothing
                var"##304" = ex
                if var"##304" isa GlobalRef
                    begin
                        var"##return#302" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#303#319")))
                    end
                end
                if var"##304" isa Expr
                    if begin
                                if var"##cache#305" === nothing
                                    var"##cache#305" = Some(((var"##304").head, (var"##304").args))
                                end
                                var"##306" = (var"##cache#305").value
                                var"##306" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##306"[1] == :curly && (begin
                                        var"##307" = var"##306"[2]
                                        var"##307" isa AbstractArray
                                    end && (length(var"##307") === 2 && (begin
                                                begin
                                                    var"##cache#309" = nothing
                                                end
                                                var"##308" = var"##307"[2]
                                                var"##308" isa Expr
                                            end && (begin
                                                    if var"##cache#309" === nothing
                                                        var"##cache#309" = Some(((var"##308").head, (var"##308").args))
                                                    end
                                                    var"##310" = (var"##cache#309").value
                                                    var"##310" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                                                end && (var"##310"[1] == :... && (begin
                                                            var"##311" = var"##310"[2]
                                                            var"##311" isa AbstractArray
                                                        end && length(var"##311") === 1)))))))
                        var"##return#302" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#303#319")))
                    end
                    if begin
                                var"##312" = (var"##cache#305").value
                                var"##312" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##312"[1] == :. && (begin
                                        var"##313" = var"##312"[2]
                                        var"##313" isa AbstractArray
                                    end && (length(var"##313") === 2 && (begin
                                                var"##314" = var"##313"[2]
                                                var"##314" isa QuoteNode
                                            end && begin
                                                var"##315" = (var"##314").value
                                                true
                                            end))))
                        var"##return#302" = let b = var"##315"
                                is_datatype_expr(b)
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#303#319")))
                    end
                    if begin
                                var"##316" = (var"##cache#305").value
                                var"##316" isa (Tuple{Symbol, var2} where var2 <: AbstractArray)
                            end && (var"##316"[1] == :curly && (begin
                                        var"##317" = var"##316"[2]
                                        var"##317" isa AbstractArray
                                    end && ((ndims(var"##317") === 1 && length(var"##317") >= 0) && begin
                                            var"##318" = SubArray(var"##317", (1:length(var"##317"),))
                                            true
                                        end)))
                        var"##return#302" = let args = var"##318"
                                all(is_datatype_expr, args)
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#303#319")))
                    end
                end
                if var"##304" isa Symbol
                    begin
                        var"##return#302" = let
                                true
                            end
                        $(Expr(:symbolicgoto, Symbol("####final#303#319")))
                    end
                end
                begin
                    var"##return#302" = let
                            false
                        end
                    $(Expr(:symbolicgoto, Symbol("####final#303#319")))
                end
                error("matching non-exhaustive, at #= none:272 =#")
                $(Expr(:symboliclabel, Symbol("####final#303#319")))
                var"##return#302"
            end
        end
    #= none:282 =# Core.@doc "    is_matrix_expr(ex)\n\nCheck if `ex` is an expression for a `Matrix`.\n" function is_matrix_expr(#= none:287 =# @nospecialize(ex))
            Meta.isexpr(ex, :hcat) && return true
            if Meta.isexpr(ex, :typed_vcat)
                args = ex.args[2:end]
            elseif Meta.isexpr(ex, :vcat)
                args = ex.args
            else
                return false
            end
            for row = args
                Meta.isexpr(row, :row) || return false
            end
            return true
        end
