#! format: off
#! source: https://github.com/alexeyovchinnikov/SIAN-Julia

import AbstractAlgebra

function Cholera_with_weights(; np=AbstractAlgebra, internal_ordering=:degrevlex, k=np.QQ)
    R, (i_9,i_8,w_8,s_8,i_7,w_7,r_7,s_7,i_6,w_6,r_6,s_6,i_5,w_5,r_5,s_5,i_4,w_4,r_4,s_4,i_3,w_3,r_3,s_3,i_2,w_2,r_2,s_2,i_1,w_1,r_1,s_1,i_0,w_0,r_0,s_0,z_aux,mu_0,bi_0,bw_0,al_0,g_0,dz_0,k_0) = np.polynomial_ring(k, [:i_9,:i_8,:w_8,:s_8,:i_7,:w_7,:r_7,:s_7,:i_6,:w_6,:r_6,:s_6,:i_5,:w_5,:r_5,:s_5,:i_4,:w_4,:r_4,:s_4,:i_3,:w_3,:r_3,:s_3,:i_2,:w_2,:r_2,:s_2,:i_1,:w_1,:r_1,:s_1,:i_0,:w_0,:r_0,:s_0,:z_aux,:mu_0,:bi_0,:bw_0,:al_0,:g_0,:dz_0,:k_0], internal_ordering=internal_ordering)
    sys = [
    		-i_0 - r_0 - s_0 + 2911528469008759170608,
		r_0*al_0^3 + r_0*mu_0 - i_0*g_0 + r_1,
		-w_0^2*s_0*bw_0 - i_0*s_0*bi_0 + i_0*mu_0 + i_0*g_0 + i_1,
		w_0^2*s_0*bw_0 - r_0*al_0^3 + i_0*s_0*bi_0 + s_0*mu_0 + s_1 - mu_0,
		-i_0*k_0 + 343403474353984419506628273026756373105480,
		-i_1 - r_1 - s_1 - 3232647073315897594023014175328767065134235,
		r_1*al_0^3 + r_1*mu_0 - i_1*g_0 + r_2,
		-s_1*w_0^2*bw_0 - w_1^2*s_0*bw_0 - s_1*i_0*bi_0 - i_1*s_0*bi_0 + i_1*mu_0 + i_1*g_0 + i_2,
		s_1*w_0^2*bw_0 + w_1^2*s_0*bw_0 - r_1*al_0^3 + s_1*i_0*bi_0 + i_1*s_0*bi_0 + s_1*mu_0 + s_2,
		w_0^2*dz_0^3 - i_0*dz_0^3 + w_1^2,
		-i_1*k_0 + 150804111950144330570726358359863599455329213258224566340571843035038626269937014560,
		-i_2*k_0 - 236573785177527367584405073265889981839320522711607262454657484484334648553270432236672856707656167203683982574661666245925280,
		-2*w_1^2*s_1*bw_0 - s_2*w_0^2*bw_0 - w_2^2*s_0*bw_0 - 2*i_1*s_1*bi_0 - s_2*i_0*bi_0 - i_2*s_0*bi_0 + i_2*mu_0 + i_2*g_0 + i_3,
		w_1^2*dz_0^3 - i_1*dz_0^3 + w_2^2,
		-i_3*k_0 + 262111943245299654395808043824315671691293502427930530368769537555600448490099470636525530336259644838938995226425441004475128523852122366601706936117433530274364551840,
		-3*s_2*w_1^2*bw_0 - 3*w_2^2*s_1*bw_0 - s_3*w_0^2*bw_0 - w_3^2*s_0*bw_0 - 3*s_2*i_1*bi_0 - 3*i_2*s_1*bi_0 - s_3*i_0*bi_0 - i_3*s_0*bi_0 + i_3*mu_0 + i_3*g_0 + i_4,
		w_2^2*dz_0^3 - i_2*dz_0^3 + w_3^2,
		2*w_1^2*s_1*bw_0 + s_2*w_0^2*bw_0 + w_2^2*s_0*bw_0 - r_2*al_0^3 + 2*i_1*s_1*bi_0 + s_2*i_0*bi_0 + i_2*s_0*bi_0 + s_2*mu_0 + s_3,
		-i_4*k_0 + 101853885314704655213417493581734024182517987887742368056803917305989232608948365941833667624636920163167193753822008294258442196505977523352582516995686623835054656043100169481140414695181689703099157547286880,
		-6*w_2^2*s_2*bw_0 - 4*s_3*w_1^2*bw_0 - 4*w_3^2*s_1*bw_0 - s_4*w_0^2*bw_0 - w_4^2*s_0*bw_0 - 6*i_2*s_2*bi_0 - 4*s_3*i_1*bi_0 - 4*i_3*s_1*bi_0 - s_4*i_0*bi_0 - i_4*s_0*bi_0 + i_4*mu_0 + i_4*g_0 + i_5,
		3*s_2*w_1^2*bw_0 + 3*w_2^2*s_1*bw_0 + s_3*w_0^2*bw_0 + w_3^2*s_0*bw_0 - r_3*al_0^3 + 3*s_2*i_1*bi_0 + 3*i_2*s_1*bi_0 + s_3*i_0*bi_0 + i_3*s_0*bi_0 + s_3*mu_0 + s_4,
		w_3^2*dz_0^3 - i_3*dz_0^3 + w_4^2,
		r_2*al_0^3 + r_2*mu_0 - i_2*g_0 + r_3,
		-i_5*k_0 - 1722516255387709116999223456183192106201816125853101519968635741540843959513761072268659715887973981805608962572464884782467443120315737867817060920649722167244247125145626076456906699260797434983043816285219692082083649961564013978517247884235571295840,
		-10*s_3*w_2^2*bw_0 - 10*w_3^2*s_2*bw_0 - 5*s_4*w_1^2*bw_0 - 5*w_4^2*s_1*bw_0 - s_5*w_0^2*bw_0 - w_5^2*s_0*bw_0 - 10*s_3*i_2*bi_0 - 10*i_3*s_2*bi_0 - 5*s_4*i_1*bi_0 - 5*i_4*s_1*bi_0 - s_5*i_0*bi_0 - i_5*s_0*bi_0 + i_5*mu_0 + i_5*g_0 + i_6,
		6*w_2^2*s_2*bw_0 + 4*s_3*w_1^2*bw_0 + 4*w_3^2*s_1*bw_0 + s_4*w_0^2*bw_0 + w_4^2*s_0*bw_0 - r_4*al_0^3 + 6*i_2*s_2*bi_0 + 4*s_3*i_1*bi_0 + 4*i_3*s_1*bi_0 + s_4*i_0*bi_0 + i_4*s_0*bi_0 + s_4*mu_0 + s_5,
		w_4^2*dz_0^3 - i_4*dz_0^3 + w_5^2,
		r_3*al_0^3 + r_3*mu_0 - i_3*g_0 + r_4,
		-i_6*k_0 + 5306440890178569513390200806484678242231047460635175956877086308140235056883228207244842736300709342059416283469250510761922493970193654534449633457515867455140211893525491246543938298576928659108713444940330864183190004945131325865708604627953270117775919881206279498436530716428927385279239520,
		-20*w_3^2*s_3*bw_0 - 15*s_4*w_2^2*bw_0 - 15*w_4^2*s_2*bw_0 - 6*s_5*w_1^2*bw_0 - 6*w_5^2*s_1*bw_0 - s_6*w_0^2*bw_0 - w_6^2*s_0*bw_0 - 20*i_3*s_3*bi_0 - 15*s_4*i_2*bi_0 - 15*i_4*s_2*bi_0 - 6*s_5*i_1*bi_0 - 6*i_5*s_1*bi_0 - s_6*i_0*bi_0 - i_6*s_0*bi_0 + i_6*mu_0 + i_6*g_0 + i_7,
		w_5^2*dz_0^3 - i_5*dz_0^3 + w_6^2,
		10*s_3*w_2^2*bw_0 + 10*w_3^2*s_2*bw_0 + 5*s_4*w_1^2*bw_0 + 5*w_4^2*s_1*bw_0 + s_5*w_0^2*bw_0 + w_5^2*s_0*bw_0 - r_5*al_0^3 + 10*s_3*i_2*bi_0 + 10*i_3*s_2*bi_0 + 5*s_4*i_1*bi_0 + 5*i_4*s_1*bi_0 + s_5*i_0*bi_0 + i_5*s_0*bi_0 + s_5*mu_0 + s_6,
		r_4*al_0^3 + r_4*mu_0 - i_4*g_0 + r_5,
		-i_7*k_0 - 2414161074757371864865959438420484791285131838109340542276352674176784202376510793074880805384654405106397552247338544908460210731833867453292683784814168301684005077221685231059304535963050843827882532609079747526866837481764198702291098600065838708466171144092271698043130207866830105765640050320938195729842054351657131007380200676960,
		-35*s_4*w_3^2*bw_0 - 35*w_4^2*s_3*bw_0 - 21*s_5*w_2^2*bw_0 - 21*w_5^2*s_2*bw_0 - 7*s_6*w_1^2*bw_0 - 7*w_6^2*s_1*bw_0 - s_7*w_0^2*bw_0 - w_7^2*s_0*bw_0 - 35*s_4*i_3*bi_0 - 35*i_4*s_3*bi_0 - 21*s_5*i_2*bi_0 - 21*i_5*s_2*bi_0 - 7*s_6*i_1*bi_0 - 7*i_6*s_1*bi_0 - s_7*i_0*bi_0 - i_7*s_0*bi_0 + i_7*mu_0 + i_7*g_0 + i_8,
		w_6^2*dz_0^3 - i_6*dz_0^3 + w_7^2,
		20*w_3^2*s_3*bw_0 + 15*s_4*w_2^2*bw_0 + 15*w_4^2*s_2*bw_0 + 6*s_5*w_1^2*bw_0 + 6*w_5^2*s_1*bw_0 + s_6*w_0^2*bw_0 + w_6^2*s_0*bw_0 - r_6*al_0^3 + 20*i_3*s_3*bi_0 + 15*s_4*i_2*bi_0 + 15*i_4*s_2*bi_0 + 6*s_5*i_1*bi_0 + 6*i_5*s_1*bi_0 + s_6*i_0*bi_0 + i_6*s_0*bi_0 + s_6*mu_0 + s_7,
		r_5*al_0^3 + r_5*mu_0 - i_5*g_0 + r_6,
		-i_8*k_0 - 68563662721408302852529796150091442095966635454687143570585833481746709593093751881483387301107212560597948512602020059259127291211370481228932742622615846001707440258093254371787212189858677200082846422481818827789069757584855045929022822247169076841627370928871598203444381586480450220996327696632162661241636807504006848904762777826154754356595341137871044964984517072159413920,
		-70*w_4^2*s_4*bw_0 - 56*s_5*w_3^2*bw_0 - 56*w_5^2*s_3*bw_0 - 28*s_6*w_2^2*bw_0 - 28*w_6^2*s_2*bw_0 - 8*s_7*w_1^2*bw_0 - 8*w_7^2*s_1*bw_0 - s_8*w_0^2*bw_0 - w_8^2*s_0*bw_0 - 70*i_4*s_4*bi_0 - 56*s_5*i_3*bi_0 - 56*i_5*s_3*bi_0 - 28*s_6*i_2*bi_0 - 28*i_6*s_2*bi_0 - 8*s_7*i_1*bi_0 - 8*i_7*s_1*bi_0 - s_8*i_0*bi_0 - i_8*s_0*bi_0 + i_8*mu_0 + i_8*g_0 + i_9,
		35*s_4*w_3^2*bw_0 + 35*w_4^2*s_3*bw_0 + 21*s_5*w_2^2*bw_0 + 21*w_5^2*s_2*bw_0 + 7*s_6*w_1^2*bw_0 + 7*w_6^2*s_1*bw_0 + s_7*w_0^2*bw_0 + w_7^2*s_0*bw_0 - r_7*al_0^3 + 35*s_4*i_3*bi_0 + 35*i_4*s_3*bi_0 + 21*s_5*i_2*bi_0 + 21*i_5*s_2*bi_0 + 7*s_6*i_1*bi_0 + 7*i_6*s_1*bi_0 + s_7*i_0*bi_0 + i_7*s_0*bi_0 + s_7*mu_0 + s_8,
		w_7^2*dz_0^3 - i_7*dz_0^3 + w_8^2,
		r_6*al_0^3 + r_6*mu_0 - i_6*g_0 + r_7,
		-i_2 - r_2 - s_2 + 3589182524523135594454085456839545234511800385883735898917997175,
		-i_3 - r_3 - s_3 - 3985041021235974550252464517935915769190752731616986548971842781748807367555853215875,
		-i_4 - r_4 - s_4 + 4424559584927594046686397910804687288769448034192890107642358851351536094546952853285969329180412650229375,
		-i_5 - r_5 - s_5 - 4912553576299912746809642767509763627279490167202801557920172532296934406926790487140129084180083310638898125498886614311896875,
		-i_6 - r_6 - s_6 + 5454369452324143911300824611591932155984233521456922664158032847204985212096830372757000766828663018887934916110930971776191108314968613571563234375,
		-i_7 - r_7 - s_7 - 6055943341966419909349886996715938059581713544301648630055189920942998885027131277349200949187573874111989436088572919217182255751339998834318836709849110001601334921875,
		-i_9*k_0 + 409468350674131235997437996028332000706024158201618295079500845098942278305086264765053539754070467875773609199083326737177303315009678175204945583686859318269397347120348832013147074926918152532611172003947376735403453543894678262427490703133558770106446840072906533684919073734702694126162168995297259732264465801314494698052875709437265864341515406098531877304955108897848385568849881838649198554018662855921232687238560,
		z_aux - 1
    ]
end
